--
-- PostgreSQL database dump
--

-- Dumped from database version 17.4
-- Dumped by pg_dump version 17.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: pgcrypto; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pgcrypto WITH SCHEMA public;


--
-- Name: EXTENSION pgcrypto; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pgcrypto IS 'cryptographic functions';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- Name: permessi; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE public.permessi AS ENUM (
    'USER',
    'ADMIN'
);


ALTER TYPE public.permessi OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: alberi_cz_com; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.alberi_cz_com (
    id integer NOT NULL,
    geom public.geometry(Point,3857),
    "ID" numeric,
    "GNV_KEYS" numeric,
    "IDENTIF" character varying(254),
    "TIPOLOGIA" character varying(254),
    "ESSENZA" character varying(254),
    "UBICAZIONE" character varying(254),
    "RIFCARTO" character varying(254),
    "LUOGO" character varying(254),
    "CIRCOSCR" character varying(254),
    "VIA" character varying(254),
    "DISPOSIZ" character varying(254),
    "INTERFIL" numeric,
    "POSIZ" character varying(254),
    "LARGHDIMOR" numeric,
    "LUNGHDIMOR" numeric,
    "SOLLRADIC" numeric,
    "PAVIMENT" character varying(254),
    "LARGHMARC" numeric,
    "NOTESITO" character varying(254),
    "PORTAMENTO" character varying(254),
    "ESSTORICO" numeric,
    "DATAPIANT" date,
    "DATACENS" date,
    "PRIMOPALCO" numeric,
    "ALTEZZA" character varying(254),
    "DIAMFUSTO" character varying(254),
    "AL_ALTPI" numeric,
    "AL_FUSDM" numeric,
    "AL_CHIDM" numeric,
    "AL_CHIID" numeric,
    "AL_CHIDS" character varying(254),
    "AL_ETAID" numeric,
    "AL_ETA" numeric,
    "AL_ETADS" character varying(254),
    "AL_PEANA" numeric,
    "AL_PEIMP" numeric,
    "AL_PEPER" numeric,
    "AL_PERIC" numeric,
    "SUOLO" character varying(254),
    "VEGETATIVO" character varying(254),
    "BIOMECC" character varying(254),
    "VTA" character varying(254),
    "NOTEGENER" character varying(254),
    "DANNI_CHIO" character varying(254),
    "DANNI_COLL" character varying(254),
    "DANNI_CORO" character varying(254),
    "DANNI_FUST" character varying(254),
    "DANNI_RADI" character varying(254),
    "DANNI_GENE" character varying(254),
    "DANNI_NOTE" character varying(254),
    "INTERF_DD" character varying(254),
    "INTERF_NOT" character varying(254),
    "FOTO" character varying(254),
    "INTERVENTI" character varying(254),
    "PK_ID" numeric,
    "YEARCENS" character varying(254),
    "S_DATACENS" character varying(254),
    "YEARDIMO" character varying(254),
    "S_DATADIMO" character varying(254),
    "TIPOFOGLIA" character varying(254),
    "TIPSTATO" numeric,
    "LO_LOTID" numeric
);


ALTER TABLE public.alberi_cz_com OWNER TO postgres;

--
-- Name: Alberi Catanzaro_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public."Alberi Catanzaro_id_seq"
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public."Alberi Catanzaro_id_seq" OWNER TO postgres;

--
-- Name: Alberi Catanzaro_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public."Alberi Catanzaro_id_seq" OWNED BY public.alberi_cz_com.id;


--
-- Name: matrice_distanze; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.matrice_distanze (
    id integer NOT NULL,
    id_edificio integer,
    id_ingresso integer,
    distanza_car double precision,
    tempo_car double precision,
    distanza_foot double precision,
    tempo_foot double precision,
    distanza_bus double precision,
    tempo_bus double precision,
    distanza_bike double precision,
    tempo_bike double precision,
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.matrice_distanze OWNER TO postgres;

--
-- Name: poligono_popolazione; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.poligono_popolazione (
    id integer NOT NULL,
    incidenza_arborea integer,
    area_verde integer,
    area_blu integer,
    geometria public.geometry,
    data date DEFAULT CURRENT_DATE,
    pop integer,
    sez integer,
    cod_tipo_s integer,
    tipo_loc integer,
    pop_finale integer,
    procom integer,
    centroide_wkt character varying,
    comune character varying(50),
    area double precision
);


ALTER TABLE public.poligono_popolazione OWNER TO postgres;

--
-- Name: accessibilita_edifici_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.accessibilita_edifici_casalecchio AS
 SELECT md.id_edificio,
    min(md.distanza_foot) AS min
   FROM (public.poligono_popolazione pp
     JOIN public.matrice_distanze md ON ((pp.id = md.id_edificio)))
  WHERE ((pp.comune)::text = 'Casalecchio di Reno'::text)
  GROUP BY md.id_edificio;


ALTER VIEW public.accessibilita_edifici_casalecchio OWNER TO postgres;

--
-- Name: accessibilita_edifici_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.accessibilita_edifici_catanzaro AS
 SELECT md.id_edificio,
    min(md.distanza_foot) AS min
   FROM (public.poligono_popolazione pp
     JOIN public.matrice_distanze md ON ((pp.id = md.id_edificio)))
  WHERE ((pp.comune)::text = 'Catanzaro'::text)
  GROUP BY md.id_edificio;


ALTER VIEW public.accessibilita_edifici_catanzaro OWNER TO postgres;

--
-- Name: accessibilita_edifici_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.accessibilita_edifici_pescara AS
 SELECT md.id_edificio,
    min(md.distanza_foot) AS min
   FROM (public.poligono_popolazione pp
     JOIN public.matrice_distanze md ON ((pp.id = md.id_edificio)))
  WHERE ((pp.comune)::text = 'Pescara'::text)
  GROUP BY md.id_edificio;


ALTER VIEW public.accessibilita_edifici_pescara OWNER TO postgres;

--
-- Name: accessibilita_edifici_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.accessibilita_edifici_terracina AS
 SELECT md.id_edificio,
    min(md.distanza_foot) AS min
   FROM (public.poligono_popolazione pp
     JOIN public.matrice_distanze md ON ((pp.id = md.id_edificio)))
  WHERE ((pp.comune)::text = 'Terracina'::text)
  GROUP BY md.id_edificio;


ALTER VIEW public.accessibilita_edifici_terracina OWNER TO postgres;

--
-- Name: area_blu; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.area_blu (
    id integer NOT NULL,
    nome character varying(50),
    geometria public.geometry,
    data date DEFAULT CURRENT_DATE,
    area double precision,
    data_modifica date,
    comune character varying(50),
    tipo1 character varying,
    tipo2 character varying,
    tipo3 character varying
);


ALTER TABLE public.area_blu OWNER TO postgres;

--
-- Name: area_blu_id_area_blu_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.area_blu_id_area_blu_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.area_blu_id_area_blu_seq OWNER TO postgres;

--
-- Name: area_blu_id_area_blu_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.area_blu_id_area_blu_seq OWNED BY public.area_blu.id;


--
-- Name: area_blu_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.area_blu_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.area_blu_id_seq OWNER TO postgres;

--
-- Name: area_blu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.area_blu_id_seq OWNED BY public.area_blu.id;


--
-- Name: area_verde; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.area_verde (
    id integer NOT NULL,
    ubicazione character varying(50),
    densita_alberi double precision,
    geometria public.geometry,
    poligono_area_verde integer,
    area double precision,
    comune character varying(50),
    nome character varying(255),
    fonte_dati character varying(50),
    data date DEFAULT CURRENT_DATE,
    data_modifica date
);


ALTER TABLE public.area_verde OWNER TO postgres;

--
-- Name: area_verde_id_area_verde_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.area_verde_id_area_verde_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.area_verde_id_area_verde_seq OWNER TO postgres;

--
-- Name: area_verde_id_area_verde_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.area_verde_id_area_verde_seq OWNED BY public.area_verde.id;


--
-- Name: area_verde_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.area_verde_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.area_verde_id_seq OWNER TO postgres;

--
-- Name: area_verde_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.area_verde_id_seq OWNED BY public.area_verde.id;


--
-- Name: aree_blu_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_blu_aquila AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    area,
    (data_modifica)::text AS data_modifica,
    comune,
    tipo1,
    tipo2,
    tipo3
   FROM public.area_blu
  WHERE ((comune)::text = 'L''Aquila'::text);


ALTER VIEW public.aree_blu_aquila OWNER TO postgres;

--
-- Name: aree_blu_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_blu_casalecchio AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    area,
    (data_modifica)::text AS data_modifica,
    comune,
    tipo1,
    tipo2,
    tipo3
   FROM public.area_blu
  WHERE ((comune)::text = 'Casalecchio di Reno'::text);


ALTER VIEW public.aree_blu_casalecchio OWNER TO postgres;

--
-- Name: aree_blu_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_blu_catanzaro AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    area,
    (data_modifica)::text AS data_modifica,
    comune,
    tipo1,
    tipo2,
    tipo3
   FROM public.area_blu
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.aree_blu_catanzaro OWNER TO postgres;

--
-- Name: aree_blu_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_blu_pescara AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    area,
    (data_modifica)::text AS data_modifica,
    comune,
    tipo1,
    tipo2,
    tipo3
   FROM public.area_blu
  WHERE ((comune)::text = 'Pescara'::text);


ALTER VIEW public.aree_blu_pescara OWNER TO postgres;

--
-- Name: aree_blu_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_blu_terracina AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    area,
    (data_modifica)::text AS data_modifica,
    comune,
    tipo1,
    tipo2,
    tipo3
   FROM public.area_blu
  WHERE ((comune)::text = 'Terracina'::text);


ALTER VIEW public.aree_blu_terracina OWNER TO postgres;

--
-- Name: aree_verdi_casalecchio_comune; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_verdi_casalecchio_comune AS
 SELECT id,
    ubicazione,
    densita_alberi,
    geometria,
    poligono_area_verde,
    area,
    comune,
    nome,
    (data)::text AS data,
    fonte_dati
   FROM public.area_verde
  WHERE ((fonte_dati)::text = 'Comune di Casalecchio di Reno'::text);


ALTER VIEW public.aree_verdi_casalecchio_comune OWNER TO postgres;

--
-- Name: aree_verdi_catanzaro_comune; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_verdi_catanzaro_comune AS
 SELECT id,
    ubicazione,
    densita_alberi,
    geometria,
    poligono_area_verde,
    area,
    comune,
    nome,
    (data)::text AS data,
    fonte_dati
   FROM public.area_verde
  WHERE ((fonte_dati)::text = 'Comune di Catanzaro'::text);


ALTER VIEW public.aree_verdi_catanzaro_comune OWNER TO postgres;

--
-- Name: aree_verdi_osm; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.aree_verdi_osm AS
 SELECT id,
    ubicazione,
    densita_alberi,
    geometria,
    poligono_area_verde,
    area,
    comune,
    nome,
    (data)::text AS data,
    fonte_dati
   FROM public.area_verde
  WHERE ((fonte_dati)::text = 'OpenStreetMap'::text);


ALTER VIEW public.aree_verdi_osm OWNER TO postgres;

--
-- Name: bagni_pubblici; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bagni_pubblici (
    id character varying NOT NULL,
    geom public.geometry(Point,3857),
    amenity character varying(254),
    wheelchair character varying(254),
    comune character varying,
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.bagni_pubblici OWNER TO postgres;

--
-- Name: bagni_pubblici_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.bagni_pubblici_catanzaro AS
 SELECT id,
    geom,
    amenity,
    wheelchair,
    (data)::text AS data,
    comune
   FROM public.bagni_pubblici
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.bagni_pubblici_catanzaro OWNER TO postgres;

--
-- Name: poligono_comune; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.poligono_comune (
    id integer NOT NULL,
    geometria public.geometry(MultiPolygon,3857),
    cod_reg numeric,
    pro_com numeric,
    pro_com_t character varying(6),
    comune character varying(100),
    shape_leng numeric,
    shape_area numeric,
    area double precision,
    data date DEFAULT CURRENT_DATE,
    geom public.geometry(Polygon,3857)
);


ALTER TABLE public.poligono_comune OWNER TO postgres;

--
-- Name: comune_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.comune_aquila AS
 SELECT id,
    geometria,
    cod_reg,
    pro_com,
    pro_com_t,
    comune,
    shape_leng,
    (data)::text AS data,
    shape_area
   FROM public.poligono_comune pc
  WHERE ((comune)::text = 'L''Aquila'::text);


ALTER VIEW public.comune_aquila OWNER TO postgres;

--
-- Name: comune_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.comune_casalecchio AS
 SELECT id,
    geometria,
    cod_reg,
    pro_com,
    pro_com_t,
    comune,
    shape_leng,
    (data)::text AS data,
    shape_area
   FROM public.poligono_comune pc
  WHERE ((comune)::text = 'Casalecchio di Reno'::text);


ALTER VIEW public.comune_casalecchio OWNER TO postgres;

--
-- Name: comune_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.comune_catanzaro AS
 SELECT id,
    geometria,
    cod_reg,
    pro_com,
    pro_com_t,
    comune,
    shape_leng,
    (data)::text AS data,
    shape_area
   FROM public.poligono_comune pc
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.comune_catanzaro OWNER TO postgres;

--
-- Name: comune_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.comune_pescara AS
 SELECT id,
    geometria,
    cod_reg,
    pro_com,
    pro_com_t,
    comune,
    shape_leng,
    (data)::text AS data,
    shape_area
   FROM public.poligono_comune pc
  WHERE ((comune)::text = 'Pescara'::text);


ALTER VIEW public.comune_pescara OWNER TO postgres;

--
-- Name: comune_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.comune_terracina AS
 SELECT id,
    geometria,
    cod_reg,
    pro_com,
    pro_com_t,
    comune,
    shape_leng,
    (data)::text AS data,
    shape_area
   FROM public.poligono_comune pc
  WHERE ((comune)::text = 'Terracina'::text);


ALTER VIEW public.comune_terracina OWNER TO postgres;

--
-- Name: edifici_casalecchio; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.edifici_casalecchio (
    id integer NOT NULL,
    geom public.geometry(MultiPolygon,3857),
    area numeric,
    fid bigint,
    sez21 bigint,
    sez21_id bigint,
    cod_tipo_s bigint,
    tipo_loc bigint,
    pop21 bigint,
    fam21 bigint,
    abi21 bigint,
    shape_leng numeric,
    shape_area numeric,
    codreg numeric,
    codpro numeric,
    comune character varying(80),
    procom numeric,
    p1 numeric,
    p3 numeric,
    p14 numeric,
    p15 numeric,
    p16 numeric,
    p17 numeric,
    p18 numeric,
    p19 numeric,
    p20 numeric,
    p21 numeric,
    p22 numeric,
    p23 numeric,
    p24 numeric,
    p25 numeric,
    p26 numeric,
    p27 numeric,
    p28 numeric,
    p29 numeric,
    a2 numeric,
    a3 numeric,
    tipo_osm character varying(80),
    tipo_s_mod character varying(80),
    pop_float numeric,
    pop_int numeric,
    errore numeric,
    pop_finale numeric,
    x_centroid numeric,
    y_centroid numeric,
    wkt_geomet character varying(200)
);


ALTER TABLE public.edifici_casalecchio OWNER TO postgres;

--
-- Name: edifici_casalecchio_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.edifici_casalecchio_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.edifici_casalecchio_id_seq OWNER TO postgres;

--
-- Name: edifici_casalecchio_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.edifici_casalecchio_id_seq OWNED BY public.edifici_casalecchio.id;


--
-- Name: edifici_con_accessibilita_minima_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.edifici_con_accessibilita_minima_casalecchio AS
 SELECT pp.id,
    pp.incidenza_arborea,
    pp.area_verde,
    pp.area_blu,
    pp.geometria,
    pp.data,
    pp.pop,
    pp.sez,
    pp.cod_tipo_s,
    pp.tipo_loc,
    pp.pop_finale,
    pp.procom,
    pp.centroide_wkt,
    pp.comune,
    pp.area,
    ae.min
   FROM (public.poligono_popolazione pp
     JOIN public.accessibilita_edifici_casalecchio ae ON ((pp.id = ae.id_edificio)));


ALTER VIEW public.edifici_con_accessibilita_minima_casalecchio OWNER TO postgres;

--
-- Name: edifici_con_accessibilita_minima_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.edifici_con_accessibilita_minima_catanzaro AS
 SELECT pp.id,
    pp.incidenza_arborea,
    pp.area_verde,
    pp.area_blu,
    pp.geometria,
    pp.data,
    pp.pop,
    pp.sez,
    pp.cod_tipo_s,
    pp.tipo_loc,
    pp.pop_finale,
    pp.procom,
    pp.centroide_wkt,
    pp.comune,
    pp.area,
    ae.min
   FROM (public.poligono_popolazione pp
     JOIN public.accessibilita_edifici_catanzaro ae ON ((pp.id = ae.id_edificio)));


ALTER VIEW public.edifici_con_accessibilita_minima_catanzaro OWNER TO postgres;

--
-- Name: edifici_con_accessibilita_minima_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.edifici_con_accessibilita_minima_pescara AS
 SELECT pp.id,
    pp.incidenza_arborea,
    pp.area_verde,
    pp.area_blu,
    pp.geometria,
    pp.data,
    pp.pop,
    pp.sez,
    pp.cod_tipo_s,
    pp.tipo_loc,
    pp.pop_finale,
    pp.procom,
    pp.centroide_wkt,
    pp.comune,
    pp.area,
    ae.min
   FROM (public.poligono_popolazione pp
     JOIN public.accessibilita_edifici_pescara ae ON ((pp.id = ae.id_edificio)));


ALTER VIEW public.edifici_con_accessibilita_minima_pescara OWNER TO postgres;

--
-- Name: edifici_con_accessibilita_minima_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.edifici_con_accessibilita_minima_terracina AS
 SELECT pp.id,
    pp.incidenza_arborea,
    pp.area_verde,
    pp.area_blu,
    pp.geometria,
    pp.data,
    pp.pop,
    pp.sez,
    pp.cod_tipo_s,
    pp.tipo_loc,
    pp.pop_finale,
    pp.procom,
    pp.centroide_wkt,
    pp.comune,
    pp.area,
    ae.min
   FROM (public.poligono_popolazione pp
     JOIN public.accessibilita_edifici_terracina ae ON ((pp.id = ae.id_edificio)));


ALTER VIEW public.edifici_con_accessibilita_minima_terracina OWNER TO postgres;

--
-- Name: fermate_bus; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fermate_bus (
    id integer NOT NULL,
    geom public.geometry(Point,3857),
    fermata character varying(254),
    longitude numeric,
    latitude numeric,
    comune character varying,
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.fermate_bus OWNER TO postgres;

--
-- Name: fermate_bus_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.fermate_bus_catanzaro AS
 SELECT id,
    geom,
    fermata,
    longitude,
    latitude,
    (data)::text AS data,
    comune
   FROM public.fermate_bus
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.fermate_bus_catanzaro OWNER TO postgres;

--
-- Name: fermate_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fermate_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fermate_bus_id_seq OWNER TO postgres;

--
-- Name: fermate_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fermate_bus_id_seq OWNED BY public.fermate_bus.id;


--
-- Name: fontane; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fontane (
    id integer NOT NULL,
    geom public.geometry,
    drinking_water character varying,
    fountain character varying,
    name character varying,
    wetland character varying,
    comune character varying,
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.fontane OWNER TO postgres;

--
-- Name: fontane_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.fontane_catanzaro AS
 SELECT id,
    geom,
    drinking_water,
    fountain,
    name,
    wetland,
    (data)::text AS data,
    comune
   FROM public.fontane
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.fontane_catanzaro OWNER TO postgres;

--
-- Name: fontane_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fontane_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fontane_id_seq OWNER TO postgres;

--
-- Name: fontane_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fontane_id_seq OWNED BY public.fontane.id;


--
-- Name: incidenza_arborea; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.incidenza_arborea (
    id integer NOT NULL,
    data_rilevazione date,
    percentuale integer
);


ALTER TABLE public.incidenza_arborea OWNER TO postgres;

--
-- Name: incidenza_arborea_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.incidenza_arborea_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.incidenza_arborea_id_seq OWNER TO postgres;

--
-- Name: incidenza_arborea_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.incidenza_arborea_id_seq OWNED BY public.incidenza_arborea.id;


--
-- Name: ingresso; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ingresso (
    id integer NOT NULL,
    nome character varying(50),
    geometria public.geometry(Point,3857),
    data date DEFAULT CURRENT_DATE,
    area_blu integer,
    area_verde integer,
    data_modifica date,
    tipo1 character varying,
    tipo2 character varying,
    tipo3 character varying
);


ALTER TABLE public.ingresso OWNER TO postgres;

--
-- Name: ingressi; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi AS
 SELECT id,
    nome,
    geometria,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    area_blu,
    area_verde,
    tipo1,
    tipo2,
    tipo3
   FROM public.ingresso;


ALTER VIEW public.ingressi OWNER TO postgres;

--
-- Name: ingressi_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi_aquila AS
 SELECT i.id,
    i.nome,
    i.geometria,
    (i.data)::text AS data,
    i.area_blu,
    i.area_verde,
    (i.data_modifica)::text AS data_modifica,
    i.tipo1,
    i.tipo2,
    i.tipo3
   FROM ((public.ingresso i
     LEFT JOIN public.area_verde av ON ((i.area_verde = av.id)))
     LEFT JOIN public.area_blu ab ON ((i.area_blu = ab.id)))
  WHERE (((av.comune)::text = 'L''Aquila'::text) OR ((ab.comune)::text = 'L''Aquila'::text));


ALTER VIEW public.ingressi_aquila OWNER TO postgres;

--
-- Name: ingressi_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi_casalecchio AS
 SELECT i.id,
    i.nome,
    i.geometria,
    (i.data)::text AS data,
    i.area_blu,
    i.area_verde,
    (i.data_modifica)::text AS data_modifica,
    i.tipo1,
    i.tipo2,
    i.tipo3
   FROM ((public.ingresso i
     LEFT JOIN public.area_verde av ON ((i.area_verde = av.id)))
     LEFT JOIN public.area_blu ab ON ((i.area_blu = ab.id)))
  WHERE (((av.comune)::text = 'Casalecchio di Reno'::text) OR ((ab.comune)::text = 'Casalecchio di Reno'::text));


ALTER VIEW public.ingressi_casalecchio OWNER TO postgres;

--
-- Name: ingressi_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi_catanzaro AS
 SELECT i.id,
    i.nome,
    i.geometria,
    (i.data)::text AS data,
    i.area_blu,
    i.area_verde,
    (i.data_modifica)::text AS data_modifica,
    i.tipo1,
    i.tipo2,
    i.tipo3
   FROM ((public.ingresso i
     LEFT JOIN public.area_verde av ON ((i.area_verde = av.id)))
     LEFT JOIN public.area_blu ab ON ((i.area_blu = ab.id)))
  WHERE (((av.comune)::text = 'Catanzaro'::text) OR ((ab.comune)::text = 'Catanzaro'::text));


ALTER VIEW public.ingressi_catanzaro OWNER TO postgres;

--
-- Name: ingressi_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi_pescara AS
 SELECT i.id,
    i.nome,
    i.geometria,
    (i.data)::text AS data,
    i.area_blu,
    i.area_verde,
    (i.data_modifica)::text AS data_modifica,
    i.tipo1,
    i.tipo2,
    i.tipo3
   FROM ((public.ingresso i
     LEFT JOIN public.area_verde av ON ((i.area_verde = av.id)))
     LEFT JOIN public.area_blu ab ON ((i.area_blu = ab.id)))
  WHERE (((av.comune)::text = 'Pescara'::text) OR ((ab.comune)::text = 'Pescara'::text));


ALTER VIEW public.ingressi_pescara OWNER TO postgres;

--
-- Name: ingressi_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.ingressi_terracina AS
 SELECT i.id,
    i.nome,
    i.geometria,
    (i.data)::text AS data,
    i.area_blu,
    i.area_verde,
    (i.data_modifica)::text AS data_modifica,
    i.tipo1,
    i.tipo2,
    i.tipo3
   FROM ((public.ingresso i
     LEFT JOIN public.area_verde av ON ((i.area_verde = av.id)))
     LEFT JOIN public.area_blu ab ON ((i.area_blu = ab.id)))
  WHERE (((av.comune)::text = 'Terracina'::text) OR ((ab.comune)::text = 'Terracina'::text));


ALTER VIEW public.ingressi_terracina OWNER TO postgres;

--
-- Name: ingresso_area_verde_id_ingresso_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ingresso_area_verde_id_ingresso_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ingresso_area_verde_id_ingresso_seq OWNER TO postgres;

--
-- Name: ingresso_area_verde_id_ingresso_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ingresso_area_verde_id_ingresso_seq OWNED BY public.ingresso.id;


--
-- Name: ingresso_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ingresso_id_seq
    START WITH 65
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ingresso_id_seq OWNER TO postgres;

--
-- Name: ingresso_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ingresso_id_seq OWNED BY public.ingresso.id;


--
-- Name: matrice_distanze_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.matrice_distanze_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.matrice_distanze_id_seq OWNER TO postgres;

--
-- Name: matrice_distanze_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.matrice_distanze_id_seq OWNED BY public.matrice_distanze.id;


--
-- Name: permesso; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permesso (
    id integer NOT NULL,
    utente_id integer NOT NULL,
    tipo_permesso public.permessi DEFAULT 'USER'::public.permessi,
    data_concessione timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    permessi character varying(255)
);


ALTER TABLE public.permesso OWNER TO postgres;

--
-- Name: permesso_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permesso_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.permesso_id_seq OWNER TO postgres;

--
-- Name: permesso_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permesso_id_seq OWNED BY public.permesso.id;


--
-- Name: piste_ciclabili; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.piste_ciclabili (
    id character varying NOT NULL,
    geom public.geometry(LineString,3857),
    tipo character varying,
    comune character varying,
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.piste_ciclabili OWNER TO postgres;

--
-- Name: piste_ciclabili_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.piste_ciclabili_catanzaro AS
 SELECT id,
    geom,
    tipo,
    (data)::text AS data,
    comune
   FROM public.piste_ciclabili
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.piste_ciclabili_catanzaro OWNER TO postgres;

--
-- Name: poligono_area_verde; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.poligono_area_verde (
    id integer NOT NULL,
    nome character varying(50),
    densita_alberi double precision,
    geometria public.geometry,
    area double precision,
    comune character varying(50),
    data date DEFAULT CURRENT_DATE,
    data_modifica date,
    tipo1 character varying,
    tipo2 character varying,
    tipo3 character varying
);


ALTER TABLE public.poligono_area_verde OWNER TO postgres;

--
-- Name: poligoni_aree_verdi_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_aree_verdi_aquila AS
 SELECT id,
    nome,
    densita_alberi,
    geometria,
    area,
    comune,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    tipo1,
    tipo2,
    tipo3
   FROM public.poligono_area_verde
  WHERE ((comune)::text = 'L''Aquila'::text);


ALTER VIEW public.poligoni_aree_verdi_aquila OWNER TO postgres;

--
-- Name: poligoni_aree_verdi_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_aree_verdi_casalecchio AS
 SELECT id,
    nome,
    densita_alberi,
    geometria,
    area,
    comune,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    tipo1,
    tipo2,
    tipo3
   FROM public.poligono_area_verde
  WHERE ((comune)::text = 'Casalecchio di Reno'::text);


ALTER VIEW public.poligoni_aree_verdi_casalecchio OWNER TO postgres;

--
-- Name: poligoni_aree_verdi_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_aree_verdi_catanzaro AS
 SELECT id,
    nome,
    densita_alberi,
    geometria,
    area,
    comune,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    tipo1,
    tipo2,
    tipo3
   FROM public.poligono_area_verde
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.poligoni_aree_verdi_catanzaro OWNER TO postgres;

--
-- Name: poligoni_aree_verdi_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_aree_verdi_pescara AS
 SELECT id,
    nome,
    densita_alberi,
    geometria,
    area,
    comune,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    tipo1,
    tipo2,
    tipo3
   FROM public.poligono_area_verde
  WHERE ((comune)::text = 'Pescara'::text);


ALTER VIEW public.poligoni_aree_verdi_pescara OWNER TO postgres;

--
-- Name: poligoni_aree_verdi_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_aree_verdi_terracina AS
 SELECT id,
    nome,
    densita_alberi,
    geometria,
    area,
    comune,
    (data)::text AS data,
    (data_modifica)::text AS data_modifica,
    tipo1,
    tipo2,
    tipo3
   FROM public.poligono_area_verde
  WHERE ((comune)::text = 'Terracina'::text);


ALTER VIEW public.poligoni_aree_verdi_terracina OWNER TO postgres;

--
-- Name: poligoni_comuni_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.poligoni_comuni_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.poligoni_comuni_id_seq OWNER TO postgres;

--
-- Name: poligoni_comuni_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.poligoni_comuni_id_seq OWNED BY public.poligono_comune.id;


--
-- Name: poligoni_popolazione_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_popolazione_aquila AS
 SELECT id,
    incidenza_arborea,
    area_verde,
    area_blu,
    geometria,
    (data)::text AS data,
    pop,
    sez,
    cod_tipo_s,
    tipo_loc,
    pop_finale,
    procom,
    centroide_wkt,
    comune,
    area
   FROM public.poligono_popolazione
  WHERE ((comune)::text = 'L''Aquila'::text);


ALTER VIEW public.poligoni_popolazione_aquila OWNER TO postgres;

--
-- Name: poligoni_popolazione_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_popolazione_casalecchio AS
 SELECT id,
    incidenza_arborea,
    area_verde,
    area_blu,
    geometria,
    (data)::text AS data,
    pop,
    sez,
    cod_tipo_s,
    tipo_loc,
    pop_finale,
    procom,
    centroide_wkt,
    comune,
    area
   FROM public.poligono_popolazione
  WHERE ((comune)::text = 'Casalecchio di Reno'::text);


ALTER VIEW public.poligoni_popolazione_casalecchio OWNER TO postgres;

--
-- Name: poligoni_popolazione_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_popolazione_catanzaro AS
 SELECT id,
    incidenza_arborea,
    area_verde,
    area_blu,
    geometria,
    (data)::text AS data,
    pop,
    sez,
    cod_tipo_s,
    tipo_loc,
    pop_finale,
    procom,
    centroide_wkt,
    comune,
    area
   FROM public.poligono_popolazione
  WHERE ((comune)::text = 'Catanzaro'::text);


ALTER VIEW public.poligoni_popolazione_catanzaro OWNER TO postgres;

--
-- Name: poligoni_popolazione_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_popolazione_pescara AS
 SELECT id,
    incidenza_arborea,
    area_verde,
    area_blu,
    geometria,
    (data)::text AS data,
    pop,
    sez,
    cod_tipo_s,
    tipo_loc,
    pop_finale,
    procom,
    centroide_wkt,
    comune,
    area
   FROM public.poligono_popolazione
  WHERE ((comune)::text = 'Pescara'::text);


ALTER VIEW public.poligoni_popolazione_pescara OWNER TO postgres;

--
-- Name: poligoni_popolazione_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.poligoni_popolazione_terracina AS
 SELECT id,
    incidenza_arborea,
    area_verde,
    area_blu,
    geometria,
    (data)::text AS data,
    pop,
    sez,
    cod_tipo_s,
    tipo_loc,
    pop_finale,
    procom,
    centroide_wkt,
    comune,
    area
   FROM public.poligono_popolazione
  WHERE ((comune)::text = 'Terracina'::text);


ALTER VIEW public.poligoni_popolazione_terracina OWNER TO postgres;

--
-- Name: poligono_area_verde_id_poligono_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.poligono_area_verde_id_poligono_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.poligono_area_verde_id_poligono_seq OWNER TO postgres;

--
-- Name: poligono_area_verde_id_poligono_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.poligono_area_verde_id_poligono_seq OWNED BY public.poligono_area_verde.id;


--
-- Name: poligono_area_verde_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.poligono_area_verde_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.poligono_area_verde_id_seq OWNER TO postgres;

--
-- Name: poligono_area_verde_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.poligono_area_verde_id_seq OWNED BY public.poligono_area_verde.id;


--
-- Name: poligono_popolazione_id_poligono_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.poligono_popolazione_id_poligono_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.poligono_popolazione_id_poligono_seq OWNER TO postgres;

--
-- Name: poligono_popolazione_id_poligono_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.poligono_popolazione_id_poligono_seq OWNED BY public.poligono_popolazione.id;


--
-- Name: poligono_popolazione_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.poligono_popolazione_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.poligono_popolazione_id_seq OWNER TO postgres;

--
-- Name: poligono_popolazione_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.poligono_popolazione_id_seq OWNED BY public.poligono_popolazione.id;


--
-- Name: poligono_sezione_censuaria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.poligono_sezione_censuaria (
    id integer NOT NULL,
    geometria public.geometry(MultiPolygon,3857),
    cod_reg bigint,
    cod_uts bigint,
    pro_com bigint,
    sez bigint,
    sez_id bigint,
    cod_tipo_s bigint,
    tipo_loc bigint,
    loc_id bigint,
    cod_zic bigint,
    cod_isam bigint,
    cod_acque bigint,
    cod_isole bigint,
    cod_mont_d bigint,
    cod_area_s bigint,
    com_asc1 bigint,
    com_asc2 bigint,
    com_asc3 bigint,
    pop bigint,
    fam bigint,
    abi bigint,
    edi bigint,
    shape_leng double precision,
    shape_area double precision,
    layer character varying(254),
    path character varying(254),
    data date DEFAULT CURRENT_DATE
);


ALTER TABLE public.poligono_sezione_censuaria OWNER TO postgres;

--
-- Name: sezione_censuaria; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sezione_censuaria (
    id integer NOT NULL,
    abi integer,
    shape_area double precision,
    pro_com integer,
    cod_reg integer,
    sez integer,
    cod_tipo_s integer,
    edi integer,
    fam integer,
    geom public.geometry(Polygon,3857),
    shape_leng double precision,
    pop integer,
    tipo_loc integer,
    abi21 integer,
    sez21 integer,
    edi21 integer,
    fam21 integer,
    pop21 integer,
    data date
);


ALTER TABLE public.sezione_censuaria OWNER TO postgres;

--
-- Name: sezione_censuaria_aquila; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.sezione_censuaria_aquila AS
 SELECT id,
    shape_area,
    pro_com,
    cod_reg,
    sez,
    cod_tipo_s,
    edi,
    fam,
    geometria,
    shape_leng,
    pop,
    (data)::text AS data,
    tipo_loc
   FROM public.poligono_sezione_censuaria
  WHERE (pro_com = 66049);


ALTER VIEW public.sezione_censuaria_aquila OWNER TO postgres;

--
-- Name: sezione_censuaria_casalecchio; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.sezione_censuaria_casalecchio AS
 SELECT id,
    shape_area,
    pro_com,
    cod_reg,
    sez,
    cod_tipo_s,
    edi,
    fam,
    geometria,
    shape_leng,
    pop,
    (data)::text AS data,
    tipo_loc
   FROM public.poligono_sezione_censuaria
  WHERE (pro_com = 37011);


ALTER VIEW public.sezione_censuaria_casalecchio OWNER TO postgres;

--
-- Name: sezione_censuaria_catanzaro; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.sezione_censuaria_catanzaro AS
 SELECT id,
    shape_area,
    pro_com,
    cod_reg,
    sez,
    cod_tipo_s,
    edi,
    fam,
    geometria,
    shape_leng,
    pop,
    (data)::text AS data,
    tipo_loc
   FROM public.poligono_sezione_censuaria
  WHERE (pro_com = 79023);


ALTER VIEW public.sezione_censuaria_catanzaro OWNER TO postgres;

--
-- Name: sezione_censuaria_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sezione_censuaria_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sezione_censuaria_id_seq OWNER TO postgres;

--
-- Name: sezione_censuaria_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sezione_censuaria_id_seq OWNED BY public.poligono_sezione_censuaria.id;


--
-- Name: sezione_censuaria_id_seq1; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sezione_censuaria_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sezione_censuaria_id_seq1 OWNER TO postgres;

--
-- Name: sezione_censuaria_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sezione_censuaria_id_seq1 OWNED BY public.sezione_censuaria.id;


--
-- Name: sezione_censuaria_pescara; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.sezione_censuaria_pescara AS
 SELECT id,
    shape_area,
    pro_com,
    cod_reg,
    sez,
    cod_tipo_s,
    edi,
    fam,
    geometria,
    shape_leng,
    pop,
    (data)::text AS data,
    tipo_loc
   FROM public.poligono_sezione_censuaria
  WHERE (pro_com = 68028);


ALTER VIEW public.sezione_censuaria_pescara OWNER TO postgres;

--
-- Name: sezione_censuaria_terracina; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.sezione_censuaria_terracina AS
 SELECT id,
    shape_area,
    pro_com,
    cod_reg,
    sez,
    cod_tipo_s,
    edi,
    fam,
    geometria,
    shape_leng,
    pop,
    (data)::text AS data,
    tipo_loc
   FROM public.poligono_sezione_censuaria
  WHERE (pro_com = 59032);


ALTER VIEW public.sezione_censuaria_terracina OWNER TO postgres;

--
-- Name: utente; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.utente (
    id integer NOT NULL,
    nome character varying(100) NOT NULL,
    cognome character varying(100) NOT NULL,
    email character varying(150) NOT NULL,
    password character varying(255) NOT NULL,
    data_registrazione date DEFAULT CURRENT_DATE,
    ultimo_accesso timestamp without time zone,
    attivo boolean DEFAULT true,
    token_reset_password character varying(255),
    token_reset_scadenza timestamp without time zone,
    creato timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    aggiornato timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.utente OWNER TO postgres;

--
-- Name: utente_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.utente_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utente_id_seq OWNER TO postgres;

--
-- Name: utente_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.utente_id_seq OWNED BY public.utente.id;


--
-- Name: valori_calcolo_distanze; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.valori_calcolo_distanze (
    id integer NOT NULL,
    distanza_foot double precision,
    tempo_foot double precision,
    data date,
    edificio integer,
    ingresso integer
);


ALTER TABLE public.valori_calcolo_distanze OWNER TO postgres;

--
-- Name: valori_calcolo_distanze_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.valori_calcolo_distanze_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.valori_calcolo_distanze_id_seq OWNER TO postgres;

--
-- Name: valori_calcolo_distanze_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.valori_calcolo_distanze_id_seq OWNED BY public.valori_calcolo_distanze.id;


--
-- Name: alberi_cz_com id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.alberi_cz_com ALTER COLUMN id SET DEFAULT nextval('public."Alberi Catanzaro_id_seq"'::regclass);


--
-- Name: area_blu id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.area_blu ALTER COLUMN id SET DEFAULT nextval('public.area_blu_id_seq'::regclass);


--
-- Name: area_verde id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.area_verde ALTER COLUMN id SET DEFAULT nextval('public.area_verde_id_seq'::regclass);


--
-- Name: edifici_casalecchio id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.edifici_casalecchio ALTER COLUMN id SET DEFAULT nextval('public.edifici_casalecchio_id_seq'::regclass);


--
-- Name: fermate_bus id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fermate_bus ALTER COLUMN id SET DEFAULT nextval('public.fermate_bus_id_seq'::regclass);


--
-- Name: fontane id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fontane ALTER COLUMN id SET DEFAULT nextval('public.fontane_id_seq'::regclass);


--
-- Name: incidenza_arborea id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.incidenza_arborea ALTER COLUMN id SET DEFAULT nextval('public.incidenza_arborea_id_seq'::regclass);


--
-- Name: ingresso id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ingresso ALTER COLUMN id SET DEFAULT nextval('public.ingresso_id_seq'::regclass);


--
-- Name: matrice_distanze id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.matrice_distanze ALTER COLUMN id SET DEFAULT nextval('public.matrice_distanze_id_seq'::regclass);


--
-- Name: permesso id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permesso ALTER COLUMN id SET DEFAULT nextval('public.permesso_id_seq'::regclass);


--
-- Name: poligono_area_verde id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.poligono_area_verde ALTER COLUMN id SET DEFAULT nextval('public.poligono_area_verde_id_seq'::regclass);


--
-- Name: poligono_comune id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.poligono_comune ALTER COLUMN id SET DEFAULT nextval('public.poligoni_comuni_id_seq'::regclass);


--
-- Name: poligono_popolazione id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.poligono_popolazione ALTER COLUMN id SET DEFAULT nextval('public.poligono_popolazione_id_seq'::regclass);


--
-- Name: poligono_sezione_censuaria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.poligono_sezione_censuaria ALTER COLUMN id SET DEFAULT nextval('public.sezione_censuaria_id_seq'::regclass);


--
-- Name: sezione_censuaria id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sezione_censuaria ALTER COLUMN id SET DEFAULT nextval('public.sezione_censuaria_id_seq1'::regclass);


--
-- Name: utente id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.utente ALTER COLUMN id SET DEFAULT nextval('public.utente_id_seq'::regclass);


--
-- Name: valori_calcolo_distanze id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.valori_calcolo_distanze ALTER COLUMN id SET DEFAULT nextval('public.valori_calcolo_distanze_id_seq'::regclass);


--
-- Data for Name: alberi_cz_com; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.alberi_cz_com (id, geom, "ID", "GNV_KEYS", "IDENTIF", "TIPOLOGIA", "ESSENZA", "UBICAZIONE", "RIFCARTO", "LUOGO", "CIRCOSCR", "VIA", "DISPOSIZ", "INTERFIL", "POSIZ", "LARGHDIMOR", "LUNGHDIMOR", "SOLLRADIC", "PAVIMENT", "LARGHMARC", "NOTESITO", "PORTAMENTO", "ESSTORICO", "DATAPIANT", "DATACENS", "PRIMOPALCO", "ALTEZZA", "DIAMFUSTO", "AL_ALTPI", "AL_FUSDM", "AL_CHIDM", "AL_CHIID", "AL_CHIDS", "AL_ETAID", "AL_ETA", "AL_ETADS", "AL_PEANA", "AL_PEIMP", "AL_PEPER", "AL_PERIC", "SUOLO", "VEGETATIVO", "BIOMECC", "VTA", "NOTEGENER", "DANNI_CHIO", "DANNI_COLL", "DANNI_CORO", "DANNI_FUST", "DANNI_RADI", "DANNI_GENE", "DANNI_NOTE", "INTERF_DD", "INTERF_NOT", "FOTO", "INTERVENTI", "PK_ID", "YEARCENS", "S_DATACENS", "YEARDIMO", "S_DATADIMO", "TIPOFOGLIA", "TIPSTATO", "LO_LOTID") FROM stdin;
1	0101000020110F0000E40F06AEA37F2341336DFF5CBA6B5041	81	4149	5363	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5363.JPG	\N	81	2019	11/01/2019	\N	\N	Caduca	2	0
2	0101000020110F00008CB96BA9DC7F2341D0B35947956B5041	82	4150	5375	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5375.JPG	\N	82	2019	11/01/2019	\N	\N	Caduca	2	0
3	0101000020110F00005C1B2A36E07F23414356B77A8F6B5041	83	4151	5377	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5377.JPG	\N	83	2019	11/01/2019	\N	\N	Sempreverde	1	0
4	0101000020110F000021020E31DF7F234126361FF1906B5041	84	4152	5376	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5376.JPG	\N	84	2019	11/01/2019	\N	\N	Caduca	2	0
5	0101000020110F00002922C32AE37F2341A81DFEEE8A6B5041	85	4153	5378	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5378.JPG	\N	85	2019	11/01/2019	\N	\N	Sempreverde	1	0
6	0101000020110F00001FF46C46E67F23413EAE0DFD846B5041	86	4154	5381	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5381.JPG	\N	86	2019	11/01/2019	\N	\N	Caduca	2	0
7	0101000020110F0000BE6A65B2E57F2341C7681D25866B5041	87	4155	5380	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5380.JPG	\N	87	2019	11/01/2019	\N	\N	Sempreverde	1	0
8	0101000020110F000006F52DC33C8B234146D3D93F7B655041	88	261	507	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\507.JPG	\N	88	2018	24/09/2018	\N	\N	Caduca	1	0
9	0101000020110F0000FB57568AE47F23415DF92C4D876B5041	89	4156	5379	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5379.JPG	\N	89	2019	11/01/2019	\N	\N	Caduca	2	0
10	0101000020110F000002F1BA0EEC7F23418EE9093B7B6B5041	90	4157	5384	Ceppaia	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5384.JPG	\N	90	2019	11/01/2019	\N	\N	Sempreverde	2	0
11	0101000020110F0000EFC9C3A2EC7F2341C5387F6F7A6B5041	91	4158	5385	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5385.JPG	\N	91	2019	11/01/2019	\N	\N	Caduca	2	0
12	0101000020110F00002F698C96E87F23419A5FCD37806B5041	92	4159	5382	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; seccume localizzato;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5382.JPG	\N	92	2019	11/01/2019	\N	\N	Sempreverde	1	0
13	0101000020110F0000A167B37AEB7F2341A0A6962B7C6B5041	93	4160	5383	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5383.JPG	\N	93	2019	11/01/2019	\N	\N	Caduca	2	0
14	0101000020110F0000C6BFCF08EF7F2341A089B041766B5041	94	4161	5386	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; seccume localizzato;	\N	\N	ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5386.JPG	\N	94	2019	11/01/2019	\N	\N	Sempreverde	1	0
15	0101000020110F0000335019FFF27F2341B003E7286F6B5041	95	4162	5387	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5387.JPG	\N	95	2019	11/01/2019	\N	\N	Caduca	2	0
16	0101000020110F0000B5C35F33F87F23414CC3F069666B5041	96	4163	5389	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5389.JPG	\N	96	2019	11/01/2019	\N	\N	Caduca	2	0
17	0101000020110F000057EC2FBBF47F2341E23B312F6B6B5041	97	4164	5388	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; branche con ferite; seccume localizzato;	\N	\N	ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5388.JPG	\N	97	2019	11/01/2019	\N	\N	Sempreverde	1	0
18	0101000020110F00004F75C87DF97F234143CA4F68636B5041	98	4165	5390	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5390.JPG	\N	98	2019	11/01/2019	\N	\N	Caduca	2	0
19	0101000020110F00001D3867B4FD7F2341DC63E90F5C6B5041	99	4166	5393	Fallanza	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5393.JPG	\N	99	2019	11/01/2019	\N	\N	Caduca	3	0
20	0101000020110F000027C28617FB7F23416397A810616B5041	100	4167	5391	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; branche con ferite; seccume localizzato;	\N	\N	ferite; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5391.JPG	\N	100	2019	11/01/2019	\N	\N	Sempreverde	1	0
985	0101000020110F0000971C77DA347123412063EE22C3705041	906	4922	7875	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	906	2019	28/01/2019	\N	\N	Caduca	2	0
21	0101000020110F00004A5E9DD3FC7F234182CAF8855D6B5041	101	4168	5392	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5392.JPG	\N	101	2019	11/01/2019	\N	\N	Caduca	2	0
22	0101000020110F0000C408E1A1018023413F355EC0566B5041	102	4169	5395	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5395.JPG	\N	102	2019	11/01/2019	\N	\N	Caduca	2	0
23	0101000020110F00009F591280058023410F9C33EC4E6B5041	103	4170	5398	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5398.JPG	\N	103	2019	11/01/2019	\N	\N	-	3	0
24	0101000020110F0000A835CD4B00802341ADA3AABD576B5041	104	4171	5394	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; branche con ferite; seccume localizzato;	\N	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5394.JPG	\N	104	2019	11/01/2019	\N	\N	Sempreverde	1	0
25	0101000020110F00001AA37544478B23415E11FC577C655041	105	262	509	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\509.JPG	\N	105	2018	24/09/2018	\N	\N	Caduca	1	0
26	0101000020110F0000AFCE31D0078023411C4295AE4C6B5041	106	4172	5399	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; seccume localizzato;	\N	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5399.JPG	\N	106	2019	11/01/2019	\N	\N	Sempreverde	1	0
27	0101000020110F00009F59128005802341D74CBEB74F6B5041	107	4173	5397	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5397.JPG	\N	107	2019	11/01/2019	\N	\N	Caduca	2	0
28	0101000020110F0000895E46B104802341FB575670516B5041	108	4174	5396	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5396.JPG	\N	108	2019	11/01/2019	\N	\N	-	3	0
29	0101000020110F0000630B413E17802341E6AE25B83C6B5041	109	4175	5406	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5406.JPG	\N	109	2019	11/01/2019	\N	\N	Caduca	2	0
30	0101000020110F000027BD6FEC0A802341D578E9244A6B5041	110	4176	5400	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5400.JPG	\N	110	2019	11/01/2019	\N	\N	Caduca	2	0
31	0101000020110F000021CD58B40A8023416C9560C7486B5041	111	4177	5401	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5401.JPG	\N	111	2019	11/01/2019	\N	\N	Caduca	2	0
32	0101000020110F00007FA4882C0E8023410F9C3374456B5041	112	4178	5402	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5402.JPG	\N	112	2019	11/01/2019	\N	\N	-	3	0
33	0101000020110F00007FA4882C0E80234190F7AACD446B5041	113	4179	5403	Ceppaia	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5403.JPG	\N	113	2019	11/01/2019	\N	\N	Sempreverde	2	0
34	0101000020110F00006A183E32108023415AF5B97E436B5041	114	4180	5404	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5404.JPG	\N	114	2019	11/01/2019	\N	\N	-	3	0
35	0101000020110F0000F0A2AF10118023412DCF83E9416B5041	115	4181	5405	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5405.JPG	\N	115	2019	11/01/2019	\N	\N	-	3	0
36	0101000020110F0000EC12D53B238023416896043E326B5041	116	4182	5409	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5409.JPG	\N	116	2019	11/01/2019	\N	\N	-	3	0
37	0101000020110F0000575BB13F19802341A5660F123B6B5041	117	4183	5407	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	2.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Pessimo	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5407.JPG	\N	117	2019	11/01/2019	\N	\N	Sempreverde	1	0
38	0101000020110F00002619398B1F802341E69656F5346B5041	118	4184	5408	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5408.JPG	\N	118	2019	11/01/2019	\N	\N	Caduca	2	0
39	0101000020110F000040FB91C22680234125AFCEFD2E6B5041	119	4185	5410	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	afidi; branche con fratture/incrinature; seccume diffuso;	\N	\N	capitozzatura; cercine di legatura; ferite; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5410.JPG	\N	119	2019	11/01/2019	\N	\N	Sempreverde	1	0
40	0101000020110F000039B4C8F6288023417233DC722D6B5041	120	4186	5411	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5411.JPG	\N	120	2019	11/01/2019	\N	\N	Caduca	2	0
41	0101000020110F0000CA54C118348023419604A8AF246B5041	121	4187	5413	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5413.JPG	\N	121	2019	11/01/2019	\N	\N	Caduca	2	0
42	0101000020110F0000A18499C6588B2341028239507E655041	122	263	511	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\511.JPG	\N	122	2018	24/09/2018	\N	\N	Sempreverde	1	0
43	0101000020110F00009C16BCA833802341D105F557256B5041	123	4188	5412	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	afidi; branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5412.JPG	\N	123	2019	11/01/2019	\N	\N	Sempreverde	1	0
44	0101000020110F000038BEF64C3680234111363C6B236B5041	124	4189	5414	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5414.JPG	\N	124	2019	11/01/2019	\N	\N	Caduca	2	0
45	0101000020110F00001CF0F97147802341E5D53902166B5041	125	4190	5415	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; seccume localizzato;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5415.JPG	\N	125	2019	11/01/2019	\N	\N	Sempreverde	1	0
46	0101000020110F000028F22429498023414356B7B0146B5041	126	4191	5416	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5416.JPG	\N	126	2019	11/01/2019	\N	\N	Caduca	2	0
47	0101000020110F00008048BF1D538023415E9D63160C6B5041	127	4192	5417	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5417.JPG	\N	127	2019	11/01/2019	\N	\N	-	3	0
48	0101000020110F00001349F47259802341E561A198056B5041	128	4193	5420	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5420.JPG	\N	128	2019	11/01/2019	\N	\N	Caduca	2	0
49	0101000020110F00006DA8189754802341F67AF70F0B6B5041	129	4194	5418	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	afidi; branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5418.JPG	\N	129	2019	11/01/2019	\N	\N	Sempreverde	1	0
50	0101000020110F0000C45A7CFA5580234109336D050A6B5041	130	4195	5419	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5419.JPG	\N	130	2019	11/01/2019	\N	\N	Caduca	2	0
51	0101000020110F00006DCA156E5D8023416C04E287FF6A5041	131	4196	5421	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	afidi; branche con ferite;	\N	\N	capitozzatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5421.JPG	\N	131	2019	11/01/2019	\N	\N	Sempreverde	1	0
52	0101000020110F0000A800182F63802341C269C1C9F36A5041	132	4197	5422	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE D	4	seccume diffuso;	carie; cavit�; insetti lignivori; marciume radicale;	\N	ginocchiatura; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5422.JPG	\N	132	2019	11/01/2019	\N	\N	Caduca	1	0
53	0101000020110F0000B610E4A0648023415E11FC11EE6A5041	133	4198	5423	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5423.JPG	\N	133	2019	11/01/2019	\N	\N	Caduca	2	0
54	0101000020110F000039D1AE1266802341D7868ACFE76A5041	134	4199	5425	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE D	4	branche con ferite; branche con fratture/incrinature; seccume localizzato;	polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5425.JPG	\N	134	2019	11/01/2019	\N	\N	Caduca	1	0
55	0101000020110F0000B83B6B9765802341E4BD6ADBE96A5041	135	4200	5424	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5424.JPG	\N	135	2019	11/01/2019	\N	\N	Caduca	2	0
56	0101000020110F0000B3D2A4E46680234122C32A4AE36A5041	136	4201	5426	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5426.JPG	\N	136	2019	11/01/2019	\N	\N	Caduca	2	0
57	0101000020110F00009D6340C6668023418D45D325DC6A5041	137	4202	5427	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5427.JPG	\N	137	2019	11/01/2019	\N	\N	Caduca	2	0
58	0101000020110F00009D6340C66680234172FE2666DB6A5041	138	4203	5428	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5428.JPG	\N	138	2019	11/01/2019	\N	\N	Caduca	2	0
59	0101000020110F0000E7A90EE96C8B2341A1A17F8E80655041	139	264	519	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\519.JPG	\N	139	2018	24/09/2018	\N	\N	Sempreverde	1	0
60	0101000020110F0000C971A7746A8023411C9947DEC76A5041	140	4204	5430	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5430.JPG	\N	140	2019	11/01/2019	\N	\N	-	3	0
98	0101000020110F000094BC3AF71E7323414F3BFC2BA16F5041	178	4240	5936	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	3	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5936.JPG	\N	178	2019	22/01/2019	\N	\N	Sempreverde	1	0
61	0101000020110F0000156F64FE6880234115E3FC4BD06A5041	141	4205	5429	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	2.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE D	4	afidi; branche con ferite; seccume localizzato;	\N	\N	capitozzatura; ferite; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\5429.JPG	\N	141	2019	11/01/2019	\N	\N	Caduca	1	0
62	0101000020110F00003D0AD7236C802341446E864BC06A5041	142	4206	5431	Albero	QUERCUS ILEX	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	2.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Pessimo	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5431.JPG	\N	142	2019	11/01/2019	\N	\N	Sempreverde	1	0
63	0101000020110F00007B3194D36C802341D105F5CBBC6A5041	143	4207	5432	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	2.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con fratture/incrinature;	\N	\N	capitozzatura; ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\5432.JPG	\N	143	2019	11/01/2019	\N	\N	Caduca	1	0
64	0101000020110F0000FD4D28344C7D2341DAFE956D3E705041	144	4208	5885	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	144	2019	21/01/2019	\N	\N	Sempreverde	1	0
65	0101000020110F0000A27F825B4B7D2341C85EEF943D705041	145	4209	5886	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	145	2019	21/01/2019	\N	\N	Sempreverde	1	0
66	0101000020110F0000A27F825B4B7D2341A7E848BC3C705041	146	4210	5887	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Pessimo	CLASSE D	3C	branche con carie; branche con ferite;	carie; insetti lignivori;	\N	carie; insetti lignivori;	\N	\N	\N	Cavi Aerei; Illuminazione pubblica;	\N	\N	\N	146	2019	21/01/2019	\N	\N	Sempreverde	1	0
67	0101000020110F0000D44334AA497D2341D8648DC83B705041	147	4211	5888	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; tagli impropri;	ferite;	\N	ferite; insetti lignivori;	\N	\N	\N	Cavi Aerei;	\N	\N	\N	147	2019	21/01/2019	\N	\N	Sempreverde	1	0
68	0101000020110F00009357E7F8477D2341FA0AD2D43A705041	148	4212	5889	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; tagli impropri;	ferite;	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	148	2019	21/01/2019	\N	\N	Sempreverde	1	0
69	0101000020110F00003C31EB75467D23411C9947A039705041	149	4213	5890	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; tagli impropri;	ferite; strozzatura;	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	\N	\N	149	2019	21/01/2019	\N	\N	Sempreverde	1	0
70	0101000020110F00009F76F8EB437D2341F9BD4D5B38705041	150	4214	5891	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; tagli impropri;	ferite; strozzatura;	\N	ferite;	\N	\N	\N	Lampione; Cavi Aerei;	\N	\N	\N	150	2019	21/01/2019	\N	\N	Sempreverde	1	0
71	0101000020110F00007D3F352E437D23417AE40F4A37705041	151	4215	5892	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Tre Fontane	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; tagli impropri;	\N	\N	\N	\N	\N	\N	Lampione; Cavi Aerei;	\N	\N	\N	151	2019	21/01/2019	\N	\N	Sempreverde	1	0
72	0101000020110F0000C1E270168F722341384A5E8DAA6F5041	152	4216	5913	Albero	PRUNUS PISSARDI NIGRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\5913.JPG	\N	152	2019	22/01/2019	\N	\N	Sempreverde	1	0
73	0101000020110F0000293FA99685722341D769A40FAB6F5041	153	4217	5912	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Cartellonistica; Camminamento; Edificio;	\N	desktop/Foto\\5912.JPG	\N	153	2020	07/12/2020	\N	\N	Caduca	1	0
74	0101000020110F00005986389698722341CEDF8436AA6F5041	154	4218	5914	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Cattivo	CLASSE D	\N	branche con ferite;	ferite;	\N	decorticazione; ferite; insetti lignivori;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5914.JPG	\N	154	2020	07/12/2020	\N	\N	Caduca	1	0
75	0101000020110F0000A1D6345F9F7223412FC03EB4A96F5041	155	4219	5915	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite;	ferite;	\N	carie; decorticazione; ferite; insetti lignivori;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5915.JPG	\N	155	2019	22/01/2019	\N	\N	Caduca	1	0
76	0101000020110F0000AD2F123A758B2341CDE9B23282655041	156	265	520	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	contrafforti scoperti;	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\520.JPG	\N	156	2018	24/09/2018	\N	\N	Sempreverde	1	0
77	0101000020110F0000A5BDC127B97223411DACFF01A86F5041	157	4220	5916	Ceppaia	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-10-15	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5916.JPG	\N	157	2020	15/10/2020	\N	\N	Caduca	2	0
78	0101000020110F0000D19673C9BE7223415BB1BFB2A76F5041	158	4221	5917	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Cattivo	CLASSE D	\N	branche con ferite;	\N	\N	carie; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5917.JPG	\N	158	2020	07/12/2020	\N	\N	Caduca	1	0
79	0101000020110F000002D9EB5DC3722341D61C2078A76F5041	159	4222	5918	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite;	\N	\N	carie; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5918.JPG	\N	159	2019	22/01/2019	\N	\N	Caduca	1	0
80	0101000020110F0000D26F5FC7C9722341CBF3E002A76F5041	160	4223	5919	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C	\N	branche con ferite;	\N	carie; insetti lignivori;	inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5919.JPG	\N	160	2019	22/01/2019	\N	\N	Caduca	1	0
81	0101000020110F0000A306D330D0722341FCA9F1AAA66F5041	161	4224	5920	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Cattivo	CLASSE D	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5920.JPG	\N	161	2020	07/12/2020	\N	\N	Caduca	1	0
82	0101000020110F00003F912739A4722341C47C79E7AA6F5041	162	4225	5921	Ceppaia	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2020-09-19	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	photos/Albero/4225/thb_201_WhatsApp Image 2020-09-19 at 13.10.58 (1).jpeg	\N	162	2020	19/09/2020	\N	\N	Caduca	2	0
83	0101000020110F00003ACC9777AC722341F4328A8FAA6F5041	163	4226	5922	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	\N	branche con carie; branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5922.JPG	\N	163	2020	07/12/2020	\N	\N	Caduca	1	0
84	0101000020110F0000B0558275B77223416475ABDFA96F5041	164	4227	5923	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	carie; carpofori;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5923.JPG	\N	164	2019	22/01/2019	\N	\N	Caduca	1	0
85	0101000020110F0000A7CB62F2C7722341056EDDD7A86F5041	165	4228	5924	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5924.JPG	\N	165	2020	07/12/2020	\N	\N	Caduca	1	0
86	0101000020110F0000C80C5446CF722341FA449E62A86F5041	166	4229	5925	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5925.JPG	\N	166	2019	22/01/2019	\N	\N	Caduca	1	0
87	0101000020110F0000C347C484D7722341E1455FEDA76F5041	167	4230	5926	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5926.JPG	\N	167	2019	22/01/2019	\N	\N	Caduca	1	0
88	0101000020110F00009A7CB3ADE07223418C67D05AA76F5041	168	4231	5927	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5927.JPG	\N	168	2019	22/01/2019	\N	\N	Caduca	1	0
89	0101000020110F0000E561A1D6E9722341465F41C8A66F5041	169	4232	5928	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5928.JPG	\N	169	2019	22/01/2019	\N	\N	Caduca	1	0
90	0101000020110F0000FB3A709EC07223410F971C4DA96F5041	170	4233	5929	Fallanza	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	\N	\N	170	2019	22/01/2019	\N	\N	Caduca	3	0
91	0101000020110F0000868F88A9F67223412237C3DDA56F5041	171	4234	5930	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5930.JPG	\N	171	2019	22/01/2019	\N	\N	Caduca	1	0
92	0101000020110F0000D712F29102732341170E8468A56F5041	172	4235	5931	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5931.JPG	\N	172	2019	22/01/2019	\N	\N	Caduca	1	0
93	0101000020110F0000268DD15A7B8B2341E2E9954481655041	173	266	521	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	contrafforti scoperti;	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\521.JPG	\N	173	2018	24/09/2018	\N	\N	Sempreverde	1	0
94	0101000020110F00004E9CDC8F0D7323418750A5B8A46F5041	174	4236	5932	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5932.JPG	\N	174	2019	22/01/2019	\N	\N	Caduca	1	0
95	0101000020110F00004E9CDC8F0D73234189B5F800A36F5041	175	4237	5933	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Cartellonistica; Camminamento; Edificio;	\N	desktop/Foto\\5933.JPG	\N	175	2019	22/01/2019	\N	\N	Caduca	1	0
96	0101000020110F00001A6EC0371C7323414DD6A8E3A26F5041	176	4238	5934	Albero	ACER NEGUNDO	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	5	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Cartellonistica; Camminamento; Edificio;	\N	desktop/Foto\\5934.JPG	\N	176	2019	22/01/2019	\N	\N	Caduca	1	0
97	0101000020110F000024D1CBB8167323415A643BA1A16F5041	177	4239	5935	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	3	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5935.JPG	\N	177	2019	22/01/2019	\N	\N	Sempreverde	1	0
99	0101000020110F000015A93076247323418FC70CD4A06F5041	179	4241	5937	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	3	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5937.JPG	\N	179	2019	22/01/2019	\N	\N	Sempreverde	1	0
100	0101000020110F0000E63FA4DF2A732341BF7D1D7CA06F5041	180	4242	5938	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	3	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5938.JPG	\N	180	2019	22/01/2019	\N	\N	Sempreverde	1	0
101	0101000020110F000037C30DC83673234126FC529F9D6F5041	181	4243	5940	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	carie; ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5940.JPG	\N	181	2019	22/01/2019	\N	\N	Sempreverde	1	0
102	0101000020110F0000672C9A5E30732341B554DE06A06F5041	182	4244	5939	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	3	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\5939.JPG	\N	182	2019	22/01/2019	\N	\N	Sempreverde	1	0
103	0101000020110F0000DDB5845C3B732341DAE1AF399F6F5041	183	4245	5941	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5941.JPG	\N	183	2019	22/01/2019	\N	\N	Sempreverde	1	0
104	0101000020110F00008D0B07723A732341F0332E24A06F5041	184	4246	5942	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5942.JPG	\N	184	2019	22/01/2019	\N	\N	Sempreverde	1	0
105	0101000020110F0000B2118887397323414F3BFC2BA16F5041	185	4247	5943	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5943.JPG	\N	185	2019	22/01/2019	\N	\N	Sempreverde	1	0
106	0101000020110F0000876D8BB23773234173637A16A26F5041	186	4248	5944	Albero	LAGUNARIA PATERSONII	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\5944.JPG	\N	186	2019	22/01/2019	\N	\N	Sempreverde	1	0
107	0101000020110F000015A930762473234132721626A46F5041	187	4249	5945	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2020-12-07	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	\N	branche codominanti; branche con ferite;	ferite; strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5945.JPG	\N	187	2020	07/12/2020	\N	\N	-	1	0
108	0101000020110F0000BC749308347323416E516643A46F5041	188	4250	5946	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5946.JPG	\N	188	2019	22/01/2019	\N	\N	Sempreverde	1	0
109	0101000020110F0000B8AF03473C7323416E516643A46F5041	189	4251	5947	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5947.JPG	\N	189	2019	22/01/2019	\N	\N	Sempreverde	1	0
110	0101000020110F000085CE6B7C888B234104ADC0A282655041	190	267	522	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\522.JPG	\N	190	2018	24/09/2018	\N	\N	Sempreverde	1	0
111	0101000020110F000045F0BF155F7323410CE544F3A46F5041	191	4252	5949	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5949.JPG	\N	191	2019	22/01/2019	\N	\N	Sempreverde	1	0
112	0101000020110F00001C25AF3E687323419279E42DA56F5041	192	4253	5950	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5950.JPG	\N	192	2019	22/01/2019	\N	\N	Sempreverde	1	0
113	0101000020110F0000B7B41A5272732341170E8468A56F5041	193	4254	5951	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5951.JPG	\N	193	2019	22/01/2019	\N	\N	Sempreverde	1	0
114	0101000020110F00008EE9097B7B73234161C3D385A56F5041	194	4255	5952	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5952.JPG	\N	194	2019	22/01/2019	\N	\N	Sempreverde	1	0
115	0101000020110F0000D9CEF7A384732341E65773C0A56F5041	195	4256	5953	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5953.JPG	\N	195	2019	22/01/2019	\N	\N	Sempreverde	1	0
116	0101000020110F0000D15790D62187234129AE2AAF54655041	1	1	200	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Corace	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\200.JPG	\N	1	2018	24/09/2018	\N	\N	Sempreverde	1	0
117	0101000020110F00007EA99FF7D5862341FB3A70D0F6645041	2	16	226	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\226.JPG	\N	2	2018	24/09/2018	\N	\N	Sempreverde	1	0
118	0101000020110F0000903177ED0D8B2341CC7F489976655041	3	256	502	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\502.JPG	\N	3	2018	24/09/2018	\N	\N	Caduca	1	0
119	0101000020110F0000C3D84260E2702341F6B4C3B325715041	4	4076	5662	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; monconi; seccume diffuso;	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5662.JPG	\N	4	2019	16/01/2019	\N	\N	-	1	0
120	0101000020110F00006002B7DED8702341FB96399F24715041	5	4077	5663	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi; seccume diffuso;	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5663.JPG	\N	5	2019	16/01/2019	\N	\N	-	1	0
121	0101000020110F00009B559FDBC5702341641EF98322715041	6	4078	5665	Fallanza	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5665.JPG	\N	6	2019	16/01/2019	\N	\N	-	3	0
122	0101000020110F0000397F135ABC702341CAC3427D21715041	7	4079	5666	Fallanza	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5666.JPG	\N	7	2019	16/01/2019	\N	\N	-	3	0
123	0101000020110F00000647C9CBCF702341FF78AF8A23715041	8	4080	5664	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; monconi; seccume diffuso; branche codominanti;	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5664.JPG	\N	8	2019	16/01/2019	\N	\N	-	1	0
124	0101000020110F0000DFC32547B3702341CEA5B86820715041	9	4081	5667	Ceppaia	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2020-09-23	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	photos/Albero/4081/thb_209_WhatsApp Image 2020-09-23 at 13.25.16.jpeg	\N	9	2020	23/09/2020	\N	\N	-	2	0
125	0101000020110F000088BA0F80AB702341950ED66F1F715041	10	4082	5668	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi;	carie; ferite; necrosi;	\N	insetti lignivori; lesione aperta; monconi;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5668.JPG	\N	10	2019	16/01/2019	\N	\N	-	1	0
126	0101000020110F0000FD135CAC9D702341605969621D715041	11	4083	5670	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con carie; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi;	strozzatura;	\N	carpofori; cavit�; insetti lignivori;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5670.JPG	\N	11	2019	16/01/2019	\N	\N	-	1	0
127	0101000020110F00003D27BD9F97702341C5FEB25B1C715041	12	4084	5671	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; monconi; seccume localizzato;	\N	\N	ginocchiatura;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5671.JPG	\N	12	2019	16/01/2019	\N	\N	-	1	0
128	0101000020110F0000BD00FBB8A37023415C77F3761E715041	13	4085	5669	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche secche; insetti lignivori; monconi;	strozzatura;	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5669.JPG	\N	13	2019	16/01/2019	\N	\N	-	1	0
129	0101000020110F0000F853E3B590702341CAE028471B715041	14	4086	5672	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; monconi;	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5672.JPG	\N	14	2019	16/01/2019	\N	\N	-	1	0
130	0101000020110F0000F9A0678378702341C9B08A0918715041	15	4087	5675	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi; seccume diffuso;	lesione cicatrizzata;	\N	monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5675.JPG	\N	15	2019	16/01/2019	\N	\N	-	1	0
131	0101000020110F0000D690B82781702341D3A4141E19715041	16	4088	5674	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.4	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche protese; branche secche; monconi;	lesione cicatrizzata;	\N	inclinazione ingiustificata; lesioni cicatrizzate; monconi; necrosi corticale;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5674.JPG	\N	16	2019	16/01/2019	\N	\N	-	1	0
132	0101000020110F0000A14ACDEE88702341FE65F7161A715041	17	4089	5673	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche protese; branche secche; monconi;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5673.JPG	\N	17	2019	16/01/2019	\N	\N	-	1	0
133	0101000020110F000097CADB016F7023413D2CD40217715041	18	4090	5676	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; insetti lignivori; monconi;	\N	\N	carie; ferite; insetti lignivori; lesione aperta; monconi; necrosi corticale;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5676.JPG	\N	18	2019	16/01/2019	\N	\N	-	1	0
134	0101000020110F000034F44F8065702341D4F1982516715041	19	4091	5677	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5677.JPG	\N	19	2019	16/01/2019	\N	\N	-	1	0
135	0101000020110F0000A4DFBE6E188B234148DC637977655041	20	257	503	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\503.JPG	\N	20	2018	24/09/2018	\N	\N	Caduca	1	0
136	0101000020110F0000C90226905B7023410AF4893A15715041	21	4092	5678	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche codominanti; monconi; seccume diffuso;	radici strozzanti; strozzatura;	\N	inclinazione ingiustificata; monconi;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5678.JPG	\N	21	2019	16/01/2019	\N	\N	-	1	0
137	0101000020110F0000D82AC1C25070234132207B4F14715041	22	4093	5679	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	inclinazione ingiustificata; monconi;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5679.JPG	\N	22	2019	16/01/2019	\N	\N	-	1	0
138	0101000020110F000007B133053C7023419E245D7912715041	23	4094	5681	Fallanza	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5681.JPG	\N	23	2019	16/01/2019	\N	\N	-	3	0
139	0101000020110F000022A644F23270234136EA219C11715041	24	4095	5682	Fallanza	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5682.JPG	\N	24	2019	16/01/2019	\N	\N	-	3	0
140	0101000020110F000073A25DF54570234168226C6413715041	25	4096	5680	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	\N	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5680.JPG	\N	25	2019	16/01/2019	\N	\N	-	1	0
141	0101000020110F00003AE97D93287023413D49BACC10715041	26	4097	5683	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche protese; monconi;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Pavimentazione;	\N	desktop/Foto\\5683.JPG	\N	26	2019	16/01/2019	\N	\N	-	1	0
142	0101000020110F0000DA3862DDFE6F2341A3586EAF0F715041	27	4098	5686	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5686.JPG	\N	27	2019	16/01/2019	\N	\N	-	1	0
143	0101000020110F0000A167B35A0D702341A56B260B10715041	28	4099	5685	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	2.4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5685.JPG	\N	28	2019	16/01/2019	\N	\N	-	1	0
144	0101000020110F00003D44A30B1C70234108AC1C5E10715041	29	4100	5684	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	1.9	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; insetti lignivori; monconi;	\N	\N	monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5684.JPG	\N	29	2019	16/01/2019	\N	\N	-	1	0
145	0101000020110F0000349D9D0CDA6F2341BA83D8F30E715041	30	4101	5689	Albero	-	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche codominanti; branche con carie; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi; seccume localizzato;	strozzatura;	\N	inclinazione ingiustificata; monconi; tumori;	\N	\N	\N	Marciapiede; Camminamento; Pavimentazione;	\N	desktop/Foto\\5689.JPG	\N	30	2019	16/01/2019	\N	\N	-	1	0
166	0101000020110F00000BB5A679C66F234167614F4D2B715041	51	4121	5707	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5707.JPG	\N	51	2019	17/01/2019	\N	\N	-	3	0
146	0101000020110F000053CBD6AAF26F2341B2F4A16B0F715041	31	4102	5687	Albero	ACER SP.	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	1.9	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi;	strozzatura;	\N	lesioni cicatrizzate; monconi;	\N	\N	\N	Pavimentazione;	\N	desktop/Foto\\5687.JPG	\N	31	2019	16/01/2019	\N	\N	-	1	0
147	0101000020110F0000946A9FEEE66F2341FC8C0B2D0F715041	32	4103	5688	Albero	-	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Filare	7	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-16	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche codominanti; branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; insetti lignivori; monconi; seccume localizzato;	ferite;	\N	carie; ferite; inclinazione ingiustificata; insetti lignivori; lesioni aperte; monconi; tumori;	\N	\N	\N	Marciapiede; Camminamento; Pavimentazione;	\N	desktop/Foto\\5688.JPG	\N	32	2019	16/01/2019	\N	\N	-	1	0
148	0101000020110F00006DAD2F92C06F2341B34126790E715041	33	4104	5690	Fallanza	-	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Bambinello Ges�	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-16	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5690.JPG	\N	33	2019	16/01/2019	\N	\N	-	3	0
149	0101000020110F0000A306D3109E6F2341488AC86610715041	34	4105	5691	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5691.JPG	\N	34	2019	17/01/2019	\N	\N	-	3	0
150	0101000020110F00004985B195956F2341ACFF732616715041	35	4106	5694	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5694.JPG	\N	35	2019	17/01/2019	\N	\N	-	3	0
151	0101000020110F0000B6847CB0976F234136CD3B5A14715041	36	4107	5693	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5693.JPG	\N	36	2019	17/01/2019	\N	\N	-	3	0
152	0101000020110F00001D3D7E8F1E8B234189247A2F78655041	37	258	504	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\504.JPG	\N	37	2018	24/09/2018	\N	\N	Caduca	1	0
153	0101000020110F000099BB96609B6F2341DAACFA5412715041	38	4108	5692	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5692.JPG	\N	38	2019	17/01/2019	\N	\N	-	3	0
154	0101000020110F000042EC4CE18E6F23411A69A9541C715041	39	4109	5697	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5697.JPG	\N	39	2019	17/01/2019	\N	\N	-	3	0
155	0101000020110F0000596E6945906F2341F5F3A6A21A715041	40	4110	5696	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5696.JPG	\N	40	2019	17/01/2019	\N	\N	-	3	0
156	0101000020110F000040D9945B926F23416458C5FB18715041	41	4111	5695	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5695.JPG	\N	41	2019	17/01/2019	\N	\N	-	3	0
157	0101000020110F0000B6B9317D8D6F2341EE7728DA1D715041	42	4112	5698	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5698.JPG	\N	42	2019	17/01/2019	\N	\N	-	3	0
158	0101000020110F0000598638D68D6F2341EB39E9751F715041	43	4113	5699	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5699.JPG	\N	43	2019	17/01/2019	\N	\N	-	3	0
159	0101000020110F00007008553A8F6F2341F6D1A91121715041	44	4114	5700	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5700.JPG	\N	44	2019	17/01/2019	\N	\N	-	3	0
160	0101000020110F000040D9945B926F2341876D8BB822715041	45	4115	5701	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5701.JPG	\N	45	2019	17/01/2019	\N	\N	-	3	0
161	0101000020110F00006DC5FE92976F234132E6AE7524715041	46	4116	5702	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5702.JPG	\N	46	2019	17/01/2019	\N	\N	-	3	0
162	0101000020110F0000B133852E9E6F23417138F33D26715041	47	4117	5703	Ceppaia	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5703.JPG	\N	47	2019	17/01/2019	\N	\N	-	2	0
163	0101000020110F0000315F5E80A56F2341827346EA27715041	48	4118	5704	Ceppaia	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5704.JPG	\N	48	2019	17/01/2019	\N	\N	-	2	0
164	0101000020110F0000952BBC7BAD6F234150DF325F29715041	49	4119	5705	Ceppaia	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5705.JPG	\N	49	2019	17/01/2019	\N	\N	-	2	0
165	0101000020110F0000910F7A36B96F234132ACE26F2A715041	50	4120	5706	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5706.JPG	\N	50	2019	17/01/2019	\N	\N	-	3	0
167	0101000020110F0000EF552B43EE6F2341FAB836722B715041	52	4122	5709	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5709.JPG	\N	52	2019	17/01/2019	\N	\N	-	3	0
168	0101000020110F0000F0C4AC77D56F234147E691A92B715041	53	4123	5708	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5708.JPG	\N	53	2019	17/01/2019	\N	\N	-	3	0
169	0101000020110F000079E926212C8B23414C1AA37F79655041	54	259	505	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\505.JPG	\N	54	2018	24/09/2018	\N	\N	Caduca	1	0
170	0101000020110F0000F3716D68FE6F2341300DC35F2B715041	55	4124	5710	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5710.JPG	\N	55	2019	17/01/2019	\N	\N	-	3	0
171	0101000020110F0000D88173660D702341FAB836722B715041	56	4125	5711	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5711.JPG	\N	56	2019	17/01/2019	\N	\N	-	3	0
172	0101000020110F000007F016F81C70234102BC05BC2B715041	57	4126	5712	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5712.JPG	\N	57	2019	17/01/2019	\N	\N	-	3	0
173	0101000020110F0000EBFF1CF62B7023411895D4052C715041	58	4127	5713	Fallanza	-	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5713.JPG	\N	58	2019	17/01/2019	\N	\N	-	3	0
174	0101000020110F000049D74C7E83702341E17A1400D4705041	59	4128	5716	Albero	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-17	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con cavit�; branche con fratture/incrinature; branche secche; monconi;	radici strozzanti; strozzatura;	\N	monconi;	\N	\N	\N	Marciapiede; Camminamento; Pavimentazione;	\N	desktop/Foto\\5716.JPG	\N	59	2019	17/01/2019	\N	\N	Sempreverde	1	0
175	0101000020110F00007689EA4D7B70234160C8EA4AD3705041	60	4129	5717	Albero	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-17	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi;	carie; cavit�; marciume radicale; necrosi; strozzatura;	\N	inclinazione ingiustificata; monconi;	\N	\N	\N	Lampione; Camminamento; Pavimentazione;	\N	desktop/Foto\\5717.JPG	\N	60	2019	17/01/2019	\N	\N	Sempreverde	1	0
176	0101000020110F000072BF430173702341AB5B3DA1D2705041	61	4130	5718	Fallanza	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\5718.JPG	\N	61	2019	17/01/2019	\N	\N	Sempreverde	3	0
177	0101000020110F00001F85EBF1617023411765363AD1705041	62	4131	5720	Fallanza	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\5720.JPG	\N	62	2019	17/01/2019	\N	\N	Sempreverde	3	0
178	0101000020110F00001C7C61C26A7023418A592FF0D1705041	63	4132	5719	Fallanza	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\5719.JPG	\N	63	2019	17/01/2019	\N	\N	Sempreverde	3	0
179	0101000020110F00001ADD419C4E702341CBDB11BCCF705041	64	4133	5721	Fallanza	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\5721.JPG	\N	64	2019	17/01/2019	\N	\N	Sempreverde	3	0
180	0101000020110F00000FB402834570234158E71806CF705041	65	4134	5722	Fallanza	SCHINUS MOLLE	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Giovanni Fiore	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-17	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\5722.JPG	\N	65	2019	17/01/2019	\N	\N	Sempreverde	3	0
181	0101000020110F000075594CAC4077234185CE6B4C2E745041	66	4135	6010	Albero	LIGUSTRUM JAPONICA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Aracri	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6010.JPG	\N	66	2019	21/01/2019	\N	\N	Sempreverde	1	0
182	0101000020110F0000C286A7271D77234102F1BAD830745041	67	4136	6011	Albero	LIGUSTRUM JAPONICA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Aracri	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6011.JPG	\N	67	2019	21/01/2019	\N	\N	Sempreverde	1	0
183	0101000020110F00008ECC231F3B7623416666665603745041	68	4137	6012	Albero	PINUS PINEA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Tulelli	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	Tipico	0	\N	2024-11-25	7	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE D	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6012.JPG	\N	68	2024	25/11/2024	\N	\N	Sempreverde	1	0
184	0101000020110F0000DAC9E028DB7F23419C16BCBA976B5041	69	4138	5374	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5374.JPG	\N	69	2019	11/01/2019	\N	\N	Caduca	2	0
185	0101000020110F0000DF32A78BD97F23419E5E291F9A6B5041	70	4139	5373	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5373.JPG	\N	70	2019	11/01/2019	\N	\N	Caduca	2	0
186	0101000020110F00003F6F2A72348B23416458C5977A655041	71	260	506	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\506.JPG	\N	71	2018	24/09/2018	\N	\N	Caduca	1	0
187	0101000020110F000010E9B7DFD87F234146CEC2AC9B6B5041	72	4140	5372	Ceppaia	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5372.JPG	\N	72	2019	11/01/2019	\N	\N	Caduca	2	0
188	0101000020110F000010E9B7DFD87F234168B3EAA39C6B5041	73	4141	5371	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5371.JPG	\N	73	2019	11/01/2019	\N	\N	-	3	0
189	0101000020110F0000959A3D80D37F234190662CB8A16B5041	74	4142	5370	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5370.JPG	\N	74	2019	11/01/2019	\N	\N	-	3	0
190	0101000020110F0000AEF54502CB7F2341E7525C67A66B5041	75	4143	5369	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5369.JPG	\N	75	2019	11/01/2019	\N	\N	-	3	0
191	0101000020110F00002332AC52C47F2341A9D9033DAA6B5041	76	4144	5368	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5368.JPG	\N	76	2019	11/01/2019	\N	\N	Caduca	1	0
192	0101000020110F00001A6EC007BE7F2341183E2230AD6B5041	77	4145	5367	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-11	1.2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	marciume radicale; polloni radicali;	\N	capitozzatura;	\N	\N	\N	\N	\N	desktop/Foto\\5367.JPG	\N	77	2019	11/01/2019	\N	\N	Caduca	1	0
193	0101000020110F0000A1F83186B87F23413480B740AF6B5041	78	4146	5366	Fallanza	-	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5366.JPG	\N	78	2019	11/01/2019	\N	\N	-	3	0
194	0101000020110F00009CBF0955AC7F2341C21726D7B56B5041	79	4147	5365	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con fratture/incrinature;	polloni radicali;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5365.JPG	\N	79	2019	11/01/2019	\N	\N	Caduca	1	0
195	0101000020110F000004ADC040A57F234198A3C715B96B5041	80	4148	5364	Albero	POPULUS NIGRA "ITALICA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Conti Falluc	Filare	15	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-11	0.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con fratture/incrinature;	polloni radicali;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5364.JPG	\N	80	2019	11/01/2019	\N	\N	Caduca	1	0
196	0101000020110F0000DC63E933B575234103B2D72D146F5041	426	4473	7236	Albero	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7236.JPG	\N	426	2019	23/01/2019	\N	\N	Sempreverde	1	0
197	0101000020110F00008D28EDEDAD75234118EC86071A6F5041	427	4474	7237	Albero	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-23	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7237.JPG	\N	427	2019	23/01/2019	\N	\N	Sempreverde	1	0
198	0101000020110F000049809A6AB7752341672C9A621A6F5041	428	4475	7238	Ceppaia	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-12-16	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7238.JPG	\N	428	2019	16/12/2019	\N	\N	Sempreverde	2	0
199	0101000020110F0000C898BBF6DC8B234115E3FCC18C655041	429	281	536	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\536.JPG	\N	429	2018	24/09/2018	\N	\N	Sempreverde	1	0
200	0101000020110F00007BDAE1BFC3752341F44F70A91A6F5041	430	4476	7239	Ceppaia	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2021-05-13	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	photos/Albero/4476/WhatsApp Image 2021-05-13 at 13.10.07 (1)_302.jpeg	\N	430	2021	13/05/2021	\N	\N	Sempreverde	2	0
201	0101000020110F00009C16BCF8CB75234118EC86071A6F5041	431	4477	7240	Albero	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-23	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso; tagli impropri;	ferite;	\N	capitozzatura; ferite;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7240.JPG	\N	431	2019	23/01/2019	\N	\N	Sempreverde	1	0
202	0101000020110F00002159C0B4EF752341439083041B6F5041	432	4478	7241	Ceppaia	LIGUSTRUM JAPONICA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-12-16	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7241.JPG	\N	432	2019	16/12/2019	\N	\N	Sempreverde	2	0
203	0101000020110F00004C1AA3D56E962341FBAE0836C1665041	433	4479	5966	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5966.JPG	\N	433	2019	22/01/2019	\N	\N	Sempreverde	1	0
204	0101000020110F000087E1231267962341E3C7983DC0665041	434	4480	5967	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	lesioni aperte;	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5967.JPG	\N	434	2019	22/01/2019	\N	\N	Sempreverde	1	0
205	0101000020110F00007DAEB6325E9623418121AB21BF665041	435	4481	5968	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5968.JPG	\N	435	2019	22/01/2019	\N	\N	Sempreverde	1	0
206	0101000020110F0000747B49535596234177103B29BE665041	436	4482	5969	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5969.JPG	\N	436	2019	22/01/2019	\N	\N	Sempreverde	1	0
207	0101000020110F0000274EEE574B962341166A4D0DBD665041	437	4483	5970	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	lesioni aperte;	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5970.JPG	\N	437	2019	22/01/2019	\N	\N	Sempreverde	1	0
208	0101000020110F00001E1B81784296234155185B38BC665041	438	4484	5971	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5971.JPG	\N	438	2019	22/01/2019	\N	\N	Sempreverde	1	0
209	0101000020110F0000D0ED257D38962341F3716D1CBB665041	439	4485	5972	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5972.JPG	\N	439	2019	22/01/2019	\N	\N	Sempreverde	1	0
210	0101000020110F0000C7BAB89D2F962341234A7B47BA665041	440	4486	5973	Albero	TILIA CORDATA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Pavimentazione;	\N	desktop/Foto\\5973.JPG	\N	440	2019	22/01/2019	\N	\N	Sempreverde	1	0
211	0101000020110F000019FF3E33237723415760C8A83C745041	441	4487	5893	Albero	LIGUSTRUM JAPONICA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Aracri	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	441	2019	21/01/2019	\N	\N	Sempreverde	1	0
212	0101000020110F0000253B36D21C77234178978B323B745041	442	4488	5894	Albero	LIGUSTRUM JAPONICA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Aracri	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-21	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	442	2019	21/01/2019	\N	\N	Sempreverde	1	0
213	0101000020110F0000D1798D7D2D752341412B3092E0745041	443	4489	5895	Albero	TILIA CORDATA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Filare	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	polloni radicali;	\N	ferite; ginocchiatura; monconi;	\N	\N	\N	\N	\N	\N	\N	443	2019	21/01/2019	\N	\N	Sempreverde	1	0
214	0101000020110F00007901F6D127752341C7F484C3E0745041	444	4490	5896	Albero	TILIA CORDATA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Filare	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	polloni radicali;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	444	2019	21/01/2019	\N	\N	Sempreverde	1	0
215	0101000020110F00004A07EB5F21752341A25D85FAE0745041	445	4491	5897	Albero	TILIA CORDATA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Filare	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	polloni radicali;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	445	2019	21/01/2019	\N	\N	Sempreverde	1	0
216	0101000020110F0000E275FD52BE8B23419548A2DB89655041	446	282	540	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\540.JPG	\N	446	2018	24/09/2018	\N	\N	Sempreverde	1	0
217	0101000020110F000068D0D09F13752341C7630684E1745041	447	4492	5899	Albero	TILIA CORDATA	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Filare	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	polloni radicali;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	447	2019	21/01/2019	\N	\N	Sempreverde	1	0
218	0101000020110F000090BDDEED1A752341B5E0453FE1745041	448	4493	5898	Albero	ACER SP.	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Filare	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	448	2019	21/01/2019	\N	\N	-	1	0
219	0101000020110F0000F1F44A994C73234140187850D0745041	449	4494	5901	Albero	QUERCUS SP.	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Manufatto; Illuminazione pubblica;	\N	\N	\N	449	2019	21/01/2019	\N	\N	-	1	0
220	0101000020110F000062105879537323414087F910D1745041	450	4495	5902	Albero	QUERCUS SP.	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Manufatto; Illuminazione pubblica;	\N	\N	\N	450	2019	21/01/2019	\N	\N	-	1	0
221	0101000020110F0000DCF4677F5C7323418A93FB23D2745041	451	4496	5903	Albero	QUERCUS SP.	SANT'ELIA	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Sila	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-21	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Manufatto; Illuminazione pubblica;	\N	\N	\N	451	2019	21/01/2019	\N	\N	-	1	0
222	0101000020110F0000BADA8A4D918323415726FC0ED2675041	452	4497	5974	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Mediocre	CLASSE C	\N	branche con cavit�; branche con fratture/incrinature;	cavit�; strozzatura;	\N	decorticazione; inclinazione ingiustificata;	\N	\N	\N	\N	\N	photos/Albero/4497/IMG_1560_367.jpeg	\N	452	2024	23/01/2024	\N	\N	Caduca	1	0
223	0101000020110F000003780B642383234149BA66DCDE675041	453	4498	5981	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2021-03-10	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4498/thb_WhatsApp Image 2021-03-10 at 12.53.47_295.jpeg	\N	453	2021	10/03/2021	\N	\N	Caduca	2	0
224	0101000020110F00009FABADE842832341FCE3BDCCD8675041	454	4499	5978	Fallanza	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5978.JPG	\N	454	2019	22/01/2019	\N	\N	Caduca	3	0
225	0101000020110F000066A0320E0E8323415F5E800BF6675041	455	4500	5985	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con fratture/incrinature;	cavit�;	\N	decorticazione; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\5985.JPG	\N	455	2019	22/01/2019	\N	\N	Caduca	1	0
226	0101000020110F000075CDE47B17832341EAB298CCF6675041	456	4501	5986	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature;	cavit�;	\N	decorticazione; ferite;	\N	\N	\N	\N	\N	photos/Albero/4501/IMG_1562_368.jpeg	\N	456	2024	23/01/2024	\N	\N	Caduca	1	0
227	0101000020110F0000B2683A0B22832341AF997C69F7675041	457	4502	5987	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature;	cavit�;	\N	decorticazione; ferite;	\N	\N	\N	\N	\N	photos/Albero/4502/IMG_1564_369.jpeg	\N	457	2024	23/01/2024	\N	\N	Caduca	1	0
228	0101000020110F00000534118634832341249C1634F9675041	458	4503	5988	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-11-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5988.JPG	\N	458	2019	30/11/2019	\N	\N	Caduca	2	0
229	0101000020110F00005E6397C8468323417D91D0AAFA675041	459	4504	5989	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	Presenza di fungo	branche codominanti;	cavit�;	\N	decorticazione; ferite; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4504/IMG_1565_370.jpeg	\N	459	2024	23/01/2024	\N	\N	Caduca	1	0
230	0101000020110F0000BF60374C548323419CC420FCFB675041	460	4505	5990	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Mediocre	CLASSE D	presenza di fungo	branche codominanti;	cavit�;	\N	decorticazione; ferite; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4505/IMG_1568_371.jpeg	\N	460	2024	23/01/2024	\N	\N	Caduca	1	0
231	0101000020110F0000CC7A31B463832341AB21714DFD675041	461	4506	5991	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	presenza di fungo	branche codominanti;	cavit�;	\N	carpofori; decorticazione; ferite; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4506/IMG_1570_372.jpeg	\N	461	2024	23/01/2024	\N	\N	Caduca	1	0
232	0101000020110F0000DE76A1F977832341BD18CA31FF675041	462	4507	5992	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5992.JPG	\N	462	2019	22/01/2019	\N	\N	Caduca	2	0
233	0101000020110F00003C4ED1B1B48B2341BD52967989655041	463	283	542	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\542.JPG	\N	463	2018	24/09/2018	\N	\N	Sempreverde	1	0
234	0101000020110F00003B191CE58A8323411D2098D900685041	464	4508	5993	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5993.JPG	\N	464	2019	22/01/2019	\N	\N	Caduca	2	0
235	0101000020110F0000D9CEF7539783234143CA4F0802685041	465	4509	5994	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Cattivo	CLASSE D	presenza di fungo	branche codominanti;	cavit�;	\N	carpofori; decorticazione; ferite; ginocchiatura; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4509/IMG_1571_373.jpeg	\N	465	2024	23/01/2024	\N	\N	Caduca	1	0
236	0101000020110F000041F1638CED83234173BA2CBCFF675041	466	4510	5995	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti;	cavit�;	\N	decorticazione; ferite; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4510/IMG_1572_374.jpeg	\N	466	2024	23/01/2024	\N	\N	Caduca	1	0
237	0101000020110F000078EE3DEC9B832341FE2B2BB5F8675041	467	4511	5996	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Pessimo	CLASSE D	presenza di fungo	branche codominanti;	cavit�;	\N	decorticazione; ferite; ginocchiatura; insetti lignivori;	\N	\N	\N	\N	\N	photos/Albero/4511/IMG_1573_375.jpeg	\N	467	2024	23/01/2024	\N	\N	Caduca	1	0
238	0101000020110F00007E74EA9A6783234154573EFBD4675041	468	4512	5975	Albero	POPULUS ALBA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con cavit�; branche con fratture/incrinature;	cavit�; strozzatura;	\N	cavit�; decorticazione;	\N	\N	\N	\N	\N	desktop/Foto\\5975.JPG	\N	468	2019	22/01/2019	\N	\N	Caduca	1	0
239	0101000020110F0000836918FE5E83234154573EFBD4675041	469	4513	5976	Ceppaia	POPULUS ALBA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-11-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5976.JPG	\N	469	2019	30/11/2019	\N	\N	Caduca	2	0
240	0101000020110F0000AE47E10A57832341D044D8A4D5675041	470	4514	5977	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2021-03-10	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4514/thb_WhatsApp Image 2021-03-10 at 12.53.50 (1)_293.jpeg	\N	470	2021	10/03/2021	\N	\N	Caduca	2	0
241	0101000020110F00006AF6404B3A832341EBC55062DA675041	471	4515	5979	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2021-03-10	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4515/thb_WhatsApp Image 2021-03-10 at 12.53.50_294.jpeg	\N	471	2021	10/03/2021	\N	\N	Caduca	2	0
242	0101000020110F0000F7AFAC14318323419BE61D35DC675041	472	4516	5980	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2021-03-10	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4516/thb_WhatsApp Image 2021-03-10 at 12.53.49_296.jpeg	\N	472	2021	10/03/2021	\N	\N	Caduca	2	0
243	0101000020110F00002766BDB808832341E86A2BC0E7675041	473	4517	5982	Albero	TILIA SP	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con fratture/incrinature;	cavit�; strozzatura;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\5982.JPG	\N	473	2019	22/01/2019	\N	\N	-	1	0
244	0101000020110F0000EB8B84560A8323418F368E60EA675041	474	4518	5983	Albero	TILIA SP	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con fratture/incrinature;	cavit�; strozzatura;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\5983.JPG	\N	474	2019	22/01/2019	\N	\N	-	1	0
245	0101000020110F0000E4839ECD1083234137C30D32EC675041	475	4519	5984	Ceppaia	TILIA SP	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Brigata Catanzaro	Isolato	0	Terra battuta	0	0	0	-	0	\N	-	0	\N	2019-04-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4519/42_WhatsApp Image 2019-04-10 at 16.56.51 (16).jpeg	\N	475	2019	10/04/2019	\N	\N	-	2	0
246	0101000020110F000014B35E1C0B83234103780BE8C9675041	476	4520	7243	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Marciapiede; Camminamento;	\N	photos/Albero/4520/IMG_1549_357.jpeg	\N	476	2024	23/01/2024	\N	\N	Sempreverde	1	0
247	0101000020110F0000CBD6FA72008323413F3A753DC9675041	477	4521	7244	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Camminamento;	\N	photos/Albero/4521/IMG_1550_358.jpeg	\N	477	2024	23/01/2024	\N	\N	Sempreverde	1	0
248	0101000020110F000070B1A206F58223417AFCDE92C8675041	478	4522	7245	Albero	MAGNOLIA GRANDIFLORA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-24	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Camminamento;	\N	desktop/Foto\\7245.JPG	\N	478	2019	24/01/2019	\N	\N	Sempreverde	1	0
249	0101000020110F0000EBFF1CA6EC8223419335EACFC7675041	479	4523	7246	Albero	MAGNOLIA GRANDIFLORA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Camminamento;	\N	desktop/Foto\\7246.JPG	\N	479	2019	24/01/2019	\N	\N	Sempreverde	1	0
250	0101000020110F0000556AF6B0AD8B23417C0A80C388655041	480	284	543	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\543.JPG	\N	480	2018	24/09/2018	\N	\N	Sempreverde	1	0
251	0101000020110F0000696FF03501832341390B7B4AC2675041	481	4524	7247	Albero	PINUS PINEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	4	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4524/IMG_1577_376.jpeg	\N	481	2024	23/01/2024	\N	\N	Sempreverde	1	0
252	0101000020110F0000F9838147D4822341813E9125C5675041	482	4525	7250	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4525/IMG_1528_339.jpeg	\N	482	2024	23/01/2024	\N	\N	Sempreverde	1	0
253	0101000020110F0000F5BEF125BB8223418C4AEA6EC3675041	483	4526	7254	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4526/IMG_1532_343.jpeg	\N	483	2024	23/01/2024	\N	\N	Sempreverde	1	0
254	0101000020110F00004F401361CA822341499D80B8BF675041	484	4527	7255	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	photos/Albero/4527/IMG_1533_344.jpeg	\N	484	2024	23/01/2024	\N	\N	Sempreverde	1	0
255	0101000020110F00008577B978D0822341A2629C01C0675041	485	4528	7256	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	photos/Albero/4528/IMG_1534_345.jpeg	\N	485	2024	23/01/2024	\N	\N	Sempreverde	1	0
256	0101000020110F000048FE6090D6822341EC51B84AC0675041	486	4529	7257	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	photos/Albero/4529/IMG_1535_346.jpeg	\N	486	2024	23/01/2024	\N	\N	Sempreverde	1	0
257	0101000020110F00002F17F12DDE822341B08F4EF5C0675041	487	4530	7258	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	photos/Albero/4530/IMG_1536_347.jpeg	\N	487	2024	23/01/2024	\N	\N	Sempreverde	1	0
258	0101000020110F0000A323B9FCE1822341975643B8C1675041	488	4531	7259	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	photos/Albero/4531/IMG_1537_348.jpeg	\N	488	2024	23/01/2024	\N	\N	Sempreverde	1	0
259	0101000020110F0000FF21FDE6CB82234175CDE49FC1675041	489	4532	7260	Palma	WASHINGTONIA FILIFERA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7260.JPG	\N	489	2019	24/01/2019	\N	\N	Sempreverde	1	0
260	0101000020110F0000126BF1A9CC822341DF895993C4675041	490	4533	7251	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4533/IMG_1529_340.jpeg	\N	490	2024	23/01/2024	\N	\N	Sempreverde	1	0
261	0101000020110F00003D9B55CFC58223417311DF31C4675041	491	4534	7252	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4534/IMG_1530_341.jpeg	\N	491	2024	23/01/2024	\N	\N	Sempreverde	1	0
262	0101000020110F000019ADA37AC0822341E40F06B8C3675041	492	4535	7253	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	3	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto;	\N	photos/Albero/4535/IMG_1531_342.jpeg	\N	492	2024	23/01/2024	\N	\N	Sempreverde	1	0
263	0101000020110F00008542043C34832341C22FF56DCB675041	493	4536	7263	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	Processionaria e sollevamento zolla	branche con ferite; processionaria - Traumatocampa pityocampa;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Camminamento;	\N	photos/Albero/4536/IMG_1538_349.jpeg	\N	493	2024	23/01/2024	\N	\N	Sempreverde	1	0
264	0101000020110F0000D3872E489A8323417901F627B1675041	494	4537	7264	Ceppaia	-	CORVO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-04-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Camminamento;	\N	photos/Albero/4537/43_WhatsApp Image 2019-04-10 at 16.56.51 (20).jpeg	\N	494	2019	10/04/2019	\N	\N	-	2	0
265	0101000020110F00000ABFD45FA08323416BD44334B0675041	495	4538	7265	Albero	PINUS HALEPENSIS	CORVO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Camminamento;	\N	desktop/Foto\\7265.JPG	\N	495	2019	24/01/2019	\N	\N	Sempreverde	1	0
266	0101000020110F00003A3B195C548223410E32C9C6DC675041	496	4539	7268	Albero	FICUS ELASTICA	CORVO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Camminamento; Edificio;	\N	desktop/Foto\\7268.JPG	\N	496	2019	24/01/2019	\N	\N	Sempreverde	1	0
267	0101000020110F00002B357BC0A98B23419B8F6B1B88655041	497	285	544	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\544.JPG	\N	497	2018	24/09/2018	\N	\N	Sempreverde	1	0
268	0101000020110F00000725CC2425822341ED0DBE28D9675041	498	4540	7269	Albero	FICUS ELASTICA	CORVO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7269.JPG	\N	498	2019	24/01/2019	\N	\N	Sempreverde	1	0
269	0101000020110F00008F53743408822341DB16657ED6675041	499	4541	7270	Albero	FICUS BENJAMINA	CORVO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	capitozzatura;	\N	\N	\N	Sede Stradale; Marciapiede; Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7270.JPG	\N	499	2019	24/01/2019	\N	\N	Sempreverde	1	0
270	0101000020110F0000AB5B3D77D781234160C8EA1CD6675041	500	4542	7274	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	punteruolo - R. ferrugineus;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7274.JPG	\N	500	2019	24/01/2019	\N	\N	Sempreverde	1	0
271	0101000020110F0000C442ADD9CF812341478FDFDFD6675041	501	4543	7275	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	punteruolo - R. ferrugineus;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7275.JPG	\N	501	2019	24/01/2019	\N	\N	Sempreverde	1	0
272	0101000020110F00002C4833B6C6812341ED0DBE28D9675041	502	4544	7277	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	punteruolo - R. ferrugineus;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7277.JPG	\N	502	2019	24/01/2019	\N	\N	Sempreverde	1	0
273	0101000020110F0000B29DEF47CB812341649291D3D7675041	503	4545	7276	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Lampione;	\N	photos/Albero/4545/IMG_1539_350.jpeg	\N	503	2024	23/01/2024	\N	\N	Sempreverde	1	0
274	0101000020110F0000520ABA6DA98223410D1AFA71E1675041	504	4546	7280	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7280.JPG	\N	504	2019	24/01/2019	\N	\N	Sempreverde	1	0
275	0101000020110F0000B003E7CC8D7323412237C3DDA56F5041	196	4257	5954	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5954.JPG	\N	196	2019	22/01/2019	\N	\N	Sempreverde	1	0
276	0101000020110F0000AB3E570B967323416CEC12FBA56F5041	197	4258	5955	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5955.JPG	\N	197	2019	22/01/2019	\N	\N	Sempreverde	1	0
277	0101000020110F0000CC7F485F9D732341A7CB6218A66F5041	198	4259	5956	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5956.JPG	\N	198	2019	22/01/2019	\N	\N	Sempreverde	1	0
278	0101000020110F000098512C07AC73234177155270A66F5041	199	4260	5958	Ceppaia	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	199	2019	22/01/2019	\N	\N	Sempreverde	2	0
279	0101000020110F000077103BB3A4732341F180B235A66F5041	200	4261	5957	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C	\N	branche con ferite;	\N	\N	capitozzatura; carie; decorticazione; ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5957.JPG	\N	200	2019	22/01/2019	\N	\N	Sempreverde	1	0
280	0101000020110F000068E89F70B273234107D33020A76F5041	201	4262	5959	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C	\N	branche con ferite;	\N	\N	capitozzatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\5959.JPG	\N	201	2019	22/01/2019	\N	\N	Sempreverde	1	0
281	0101000020110F0000E9D495EFB7732341E1455FEDA76F5041	202	4263	5960	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C	\N	branche con ferite;	\N	\N	capitozzatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\5960.JPG	\N	202	2019	22/01/2019	\N	\N	Sempreverde	1	0
282	0101000020110F000048A7AE1CAB732341A5660FD0A76F5041	203	4264	5961	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\5961.JPG	\N	203	2019	22/01/2019	\N	\N	Sempreverde	1	0
283	0101000020110F00004AB54FD756732341C22FF5D5A46F5041	204	4265	5948	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5948.JPG	\N	204	2019	22/01/2019	\N	\N	Sempreverde	1	0
284	0101000020110F00000E677EA54673234168D0D031A36F5041	205	4266	5998	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5998.JPG	\N	205	2019	22/01/2019	\N	\N	Sempreverde	1	0
285	0101000020110F0000765435614D732341BBD05C47A36F5041	206	4267	5999	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\5999.JPG	\N	206	2019	22/01/2019	\N	\N	Sempreverde	1	0
286	0101000020110F00008C101E2D8E8B234117B7D12E83655041	207	268	523	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\523.JPG	\N	207	2018	24/09/2018	\N	\N	Sempreverde	1	0
287	0101000020110F00006891ED1C5473234172A77472A36F5041	208	4268	7000	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7000.JPG	\N	208	2019	22/01/2019	\N	\N	Sempreverde	1	0
288	0101000020110F0000508D979E65732341ED2AA4C8A36F5041	209	4269	7001	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7001.JPG	\N	209	2019	22/01/2019	\N	\N	Sempreverde	1	0
289	0101000020110F0000A835CD0B6F732341A301BCF3A36F5041	210	4270	7002	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7002.JPG	\N	210	2019	22/01/2019	\N	\N	Sempreverde	1	0
290	0101000020110F0000758E01797873234168AED31EA46F5041	211	4271	7003	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7003.JPG	\N	211	2019	22/01/2019	\N	\N	Sempreverde	1	0
291	0101000020110F0000A4E4D539817323411F85EB49A46F5041	212	4272	7004	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7004.JPG	\N	212	2019	22/01/2019	\N	\N	Sempreverde	1	0
292	0101000020110F000010406A538B732341D55B0375A46F5041	213	4273	7005	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7005.JPG	\N	213	2019	22/01/2019	\N	\N	Sempreverde	1	0
293	0101000020110F0000C9E53F14947323418B321BA0A46F5041	214	4274	7006	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7006.JPG	\N	214	2019	22/01/2019	\N	\N	Sempreverde	1	0
294	0101000020110F0000963E74819D73234150DF32CBA46F5041	215	4275	7007	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7007.JPG	\N	215	2019	22/01/2019	\N	\N	Sempreverde	1	0
295	0101000020110F0000A31EA251AC73234107B64AF6A46F5041	216	4276	7008	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Cartellonistica; Camminamento; Edificio;	\N	desktop/Foto\\7008.JPG	\N	216	2019	22/01/2019	\N	\N	Sempreverde	1	0
296	0101000020110F0000842A356BB67323412063EE36A56F5041	217	4277	7009	Fallanza	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Camminamento; Edificio;	\N	desktop/Foto\\7009.JPG	\N	217	2019	22/01/2019	\N	\N	Sempreverde	3	0
297	0101000020110F0000DDD26AD8BF7323418C101E8DA56F5041	218	4278	7010	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7010.JPG	\N	218	2019	22/01/2019	\N	\N	Sempreverde	1	0
298	0101000020110F00000B293F99C873234108944DE3A56F5041	219	4279	7011	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7011.JPG	\N	219	2019	22/01/2019	\N	\N	Sempreverde	1	0
299	0101000020110F0000C4CE145AD1732341D717094FA66F5041	220	4280	7012	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Borelli	Filare	4	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7012.JPG	\N	220	2019	22/01/2019	\N	\N	Sempreverde	1	0
300	0101000020110F00001EF983C1DC722341166A4D71736F5041	221	4281	7021	Albero	-	GIARDINI S.LEONARDO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Piazza Montegrappa	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche codominanti;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7021.JPG	\N	221	2019	22/01/2019	\N	\N	-	1	0
301	0101000020110F0000C1A8A41EF07223416B60AB86736F5041	222	4282	7022	Albero	CEDRUS ATLANTICA	GIARDINI S.LEONARDO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Piazza Montegrappa	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	5	5) >23m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	capitozzatura;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7022.JPG	\N	222	2019	22/01/2019	\N	\N	Sempreverde	1	0
302	0101000020110F00002F6EA3D104732341C156099C736F5041	223	4283	7023	Albero	CEDRUS ATLANTICA	GIARDINI S.LEONARDO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Piazza Montegrappa	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	5) >23m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; tagli impropri;	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7023.JPG	\N	223	2019	22/01/2019	\N	\N	Sempreverde	1	0
303	0101000020110F0000BADA8AAD918B23419E98F55484655041	224	269	524	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	carpofori; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\524.JPG	\N	224	2018	24/09/2018	\N	\N	Sempreverde	1	0
304	0101000020110F00009D4B71851B73234198344607756F5041	225	4284	7024	Albero	CEDRUS ATLANTICA	GIARDINI S.LEONARDO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Piazza Montegrappa	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	5) >23m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; tagli impropri;	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7024.JPG	\N	225	2019	22/01/2019	\N	\N	Sempreverde	1	0
305	0101000020110F00008D976E02AA72234154C6BFDD776F5041	226	4285	7026	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	branche con carie; branche con ferite; tagli impropri;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7026.JPG	\N	226	2019	22/01/2019	\N	\N	Sempreverde	1	0
306	0101000020110F000060B01BA69872234154C6BFDD776F5041	227	4286	7027	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7027.JPG	\N	227	2019	22/01/2019	\N	\N	Sempreverde	1	0
307	0101000020110F000069E388F58972234154C6BFDD776F5041	228	4287	7028	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	inclinazione ingiustificata; insetti lignivori; carie; ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7028.JPG	\N	228	2019	22/01/2019	\N	\N	Sempreverde	1	0
308	0101000020110F00002384473B637223416362F35D786F5041	229	4288	7029	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7029.JPG	\N	229	2019	22/01/2019	\N	\N	Sempreverde	1	0
309	0101000020110F0000697407813C7223416362F35D786F5041	230	4289	7031	Ceppaia	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7031.JPG	\N	230	2019	22/01/2019	\N	\N	Sempreverde	2	0
310	0101000020110F0000B29DEF27337223416362F35D786F5041	231	4290	7032	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7032.JPG	\N	231	2019	22/01/2019	\N	\N	Sempreverde	1	0
311	0101000020110F000086E63ACD257223416362F35D786F5041	232	4291	7033	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7033.JPG	\N	232	2019	22/01/2019	\N	\N	Sempreverde	1	0
312	0101000020110F0000244564C8197223416362F35D786F5041	233	4292	7034	Ceppaia	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7034.JPG	\N	233	2019	22/01/2019	\N	\N	Sempreverde	2	0
313	0101000020110F0000613255C0057223416362F35D786F5041	234	4293	7035	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	carie; ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7035.JPG	\N	234	2019	22/01/2019	\N	\N	Sempreverde	1	0
314	0101000020110F0000A167B38A547223416362F35D786F5041	235	4294	7030	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	capitozzatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7030.JPG	\N	235	2019	22/01/2019	\N	\N	Sempreverde	1	0
315	0101000020110F0000FA449E4475732341247F30A6826F5041	236	4295	7036	Fallanza	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	236	2019	22/01/2019	\N	\N	Sempreverde	3	0
316	0101000020110F00000113B8F581732341E15D2E4E846F5041	237	4296	7037	Fallanza	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	237	2019	22/01/2019	\N	\N	Sempreverde	3	0
317	0101000020110F0000F9DA336B9D7323413DF207A9856F5041	238	4297	7040	Fallanza	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7040.JPG	\N	238	2019	22/01/2019	\N	\N	Sempreverde	3	0
318	0101000020110F00008D976E2291732341302AA963856F5041	239	4298	7038	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	capitozzatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7038.JPG	\N	239	2019	22/01/2019	\N	\N	Sempreverde	1	0
319	0101000020110F0000E1D1C6D1B37323416DE2E44A866F5041	240	4299	7039	Albero	NERIUM OLEANDER	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Vittorio Veneto	Filare	6	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7039.JPG	\N	240	2019	22/01/2019	\N	\N	Sempreverde	1	0
320	0101000020110F0000DAFE9575508B234175594CEA7E655041	241	270	526	Albero	FICUS MICROCARPA NITIDA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\526.JPG	\N	241	2018	24/09/2018	\N	\N	Sempreverde	1	0
321	0101000020110F0000948785EA987423418ECC236B8D6F5041	242	4300	7041	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Camminamento;	\N	desktop/Foto\\7041.JPG	\N	242	2019	22/01/2019	\N	\N	Sempreverde	1	0
322	0101000020110F00009C8A5408A37423418ECC236B8D6F5041	243	4301	7042	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7042.JPG	\N	243	2021	02/11/2021	\N	\N	Sempreverde	2	0
323	0101000020110F00004F1E160AB07423417CB8E43C8D6F5041	244	4302	7043	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7043.JPG	\N	244	2019	22/01/2019	\N	\N	Sempreverde	1	0
324	0101000020110F0000E8C1DD99BB742341666666E08C6F5041	245	4303	7044	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7044.JPG	\N	245	2019	22/01/2019	\N	\N	Sempreverde	1	0
325	0101000020110F00008065A529C7742341666666E08C6F5041	246	4304	7045	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7045.JPG	\N	246	2019	22/01/2019	\N	\N	Sempreverde	1	0
326	0101000020110F0000A3586EB9D2742341423EE8838C6F5041	247	4305	7046	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7046.JPG	\N	247	2019	22/01/2019	\N	\N	Sempreverde	1	0
327	0101000020110F0000E78C282DE1742341302AA9558C6F5041	248	4306	7047	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Cartellonistica; Camminamento;	\N	desktop/Foto\\7047.JPG	\N	248	2019	22/01/2019	\N	\N	Sempreverde	1	0
328	0101000020110F0000BB61DB12F17423411BD82AF98B6F5041	249	4307	7048	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7048.JPG	\N	249	2021	02/11/2021	\N	\N	Sempreverde	2	0
329	0101000020110F0000E3A59B14FE74234109C4EBCA8B6F5041	250	4308	7049	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7049.JPG	\N	250	2019	22/01/2019	\N	\N	Sempreverde	1	0
330	0101000020110F00000F9C33C213752341F3716D6E8B6F5041	251	4309	7050	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7050.JPG	\N	251	2021	02/11/2021	\N	\N	Sempreverde	2	0
331	0101000020110F00007311DF1925752341E15D2E408B6F5041	252	4310	7051	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7051.JPG	\N	252	2021	02/11/2021	\N	\N	Sempreverde	2	0
388	0101000020110F0000E0DBF477FC762341CA6C90C7C46F5041	309	4363	7114	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7114.JPG	\N	309	2019	22/01/2019	\N	\N	-	3	0
332	0101000020110F0000D7868A7136752341E15D2E408B6F5041	253	4311	7052	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7052.JPG	\N	253	2019	22/01/2019	\N	\N	Sempreverde	1	0
333	0101000020110F000036AB3E5746752341CC0BB0E38A6F5041	254	4312	7053	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7053.JPG	\N	254	2021	02/11/2021	\N	\N	Sempreverde	2	0
334	0101000020110F00002BC1E22059752341A8E331878A6F5041	255	4313	7054	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7054.JPG	\N	255	2021	02/11/2021	\N	\N	Sempreverde	2	0
335	0101000020110F00008AE59606697523419291B32A8A6F5041	256	4314	7055	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7055.JPG	\N	256	2021	02/11/2021	\N	\N	Sempreverde	2	0
336	0101000020110F00002A8C2DB47E7523417D3F35CE896F5041	257	4315	7056	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7056.JPG	\N	257	2021	02/11/2021	\N	\N	Sempreverde	2	0
337	0101000020110F000010CCD103428B2341EB39E9BD7B655041	258	271	508	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\508.JPG	\N	258	2018	24/09/2018	\N	\N	Caduca	1	0
338	0101000020110F000056B77ACE6E7523411C5F7B8A886F5041	259	4316	7057	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7057.JPG	\N	259	2019	22/01/2019	\N	\N	Sempreverde	3	0
339	0101000020110F00001283C05A607523411F9DBAB8886F5041	260	4317	7058	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	260	2019	22/01/2019	\N	\N	Sempreverde	3	0
340	0101000020110F0000E78C28AD4A75234143C53815896F5041	261	4318	7059	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7059.JPG	\N	261	2019	22/01/2019	\N	\N	Sempreverde	3	0
341	0101000020110F000013B875C73A7523415917B771896F5041	262	4319	7060	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	262	2019	22/01/2019	\N	\N	Sempreverde	3	0
342	0101000020110F00007B14AE372F7523416B2BF69F896F5041	263	4320	7061	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7061.JPG	\N	263	2021	02/11/2021	\N	\N	Sempreverde	2	0
343	0101000020110F0000E370E6A7237523416B2BF69F896F5041	264	4321	7062	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7062.JPG	\N	264	2019	22/01/2019	\N	\N	Sempreverde	1	0
344	0101000020110F0000DB6D178A19752341807D74FC896F5041	265	4322	7063	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7063.JPG	\N	265	2019	22/01/2019	\N	\N	Sempreverde	1	0
345	0101000020110F0000D36A486C0F752341807D74FC896F5041	266	4323	7064	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Camminamento;	\N	desktop/Foto\\7064.JPG	\N	266	2019	22/01/2019	\N	\N	Sempreverde	1	0
346	0101000020110F0000F792C668F5742341A8E331878A6F5041	267	4324	7065	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7065.JPG	\N	267	2019	22/01/2019	\N	\N	Sempreverde	1	0
347	0101000020110F000043FF0467E8742341BAF770B58A6F5041	268	4325	7066	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7066.JPG	\N	268	2019	22/01/2019	\N	\N	Sempreverde	1	0
348	0101000020110F0000906B4365DB742341BAF770B58A6F5041	269	4326	7067	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7067.JPG	\N	269	2019	22/01/2019	\N	\N	Sempreverde	1	0
349	0101000020110F0000F0C4ACB7C5742341CF49EF118B6F5041	270	4327	7068	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7068.JPG	\N	270	2021	02/11/2021	\N	\N	Sempreverde	2	0
350	0101000020110F00005721E527BA742341E15D2E408B6F5041	271	4328	7069	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2021-11-02	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7069.JPG	\N	271	2021	02/11/2021	\N	\N	Sempreverde	2	0
351	0101000020110F0000D8BB3F5EA7742341F3716D6E8B6F5041	272	4329	7070	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7070.JPG	\N	272	2019	22/01/2019	\N	\N	Sempreverde	1	0
352	0101000020110F00005726FCF2717423413E05C05EA16F5041	273	4330	7079	Albero	-	CATANZARO	-	Giardino	II Centro Storico, Stadio, San Leonardo	Via Nasi	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7079.JPG	\N	273	2019	22/01/2019	\N	\N	-	1	0
353	0101000020110F00007FF623353D7523414CFDBCAD9E6F5041	274	4331	7083	Fallanza	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\7083.JPG	\N	274	2019	22/01/2019	\N	\N	Sempreverde	3	0
354	0101000020110F0000AED348ABDA8623416DCA1518F7645041	275	17	227	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\227.JPG	\N	275	2018	24/09/2018	\N	\N	Sempreverde	1	0
355	0101000020110F000085CE6B7C888B23417F130AFD84655041	276	272	528	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\528.JPG	\N	276	2018	24/09/2018	\N	\N	Caduca	1	0
356	0101000020110F00000F0BB586EA742341B459F541A06F5041	277	4332	7082	Ceppaia	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\7082.JPG	\N	277	2019	22/01/2019	\N	\N	Sempreverde	2	0
357	0101000020110F0000D027F2E4DD7423412C4833B0A06F5041	278	4333	7081	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	\N	\N	278	2019	22/01/2019	\N	\N	Sempreverde	1	0
358	0101000020110F0000096D39F7CE742341A4A5F2D4A06F5041	279	4334	7080	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	carie;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7080.JPG	\N	279	2019	22/01/2019	\N	\N	Sempreverde	1	0
359	0101000020110F000039D1AE5255752341D40E7F3F9E6F5041	280	4335	7084	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Lampione; Edificio;	\N	desktop/Foto\\7084.JPG	\N	280	2019	22/01/2019	\N	\N	Sempreverde	1	0
360	0101000020110F0000FD135C8C66752341D47D00F69D6F5041	281	4336	7085	Fallanza	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Lampione; Edificio;	\N	\N	\N	281	2019	22/01/2019	\N	\N	Sempreverde	3	0
361	0101000020110F00003CF71E2E73752341D5EC81AC9D6F5041	282	4337	7086	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7086.JPG	\N	282	2019	22/01/2019	\N	\N	Sempreverde	1	0
362	0101000020110F000091ED7C1F8975234188BA0FD29F6F5041	283	4338	7089	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7089.JPG	\N	283	2019	22/01/2019	\N	\N	Sempreverde	1	0
363	0101000020110F0000522CB754987523414CA60AACA26F5041	284	4339	7090	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	284	2019	22/01/2019	\N	\N	Sempreverde	1	0
364	0101000020110F000005172B9A87752341DAFE9541A46F5041	285	4340	7091	Albero	PRUNUS LAUROCERASUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7091.JPG	\N	285	2019	22/01/2019	\N	\N	Sempreverde	1	0
365	0101000020110F00001FD786AA5A762341EECEDAB3B96F5041	286	4341	7093	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Pessimo	CLASSE D	4	branche con carie; branche con ferite; branche protese; sbrancamento;	\N	\N	capitozzatura; carie; insetti lignivori;	\N	\N	\N	Sede Stradale; Cavi Aerei; Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\7093.JPG	\N	286	2019	22/01/2019	\N	\N	Caduca	1	0
366	0101000020110F000033E1978A5176234175594CD4B96F5041	287	4342	7092	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	capitozzatura;	\N	\N	\N	Sede Stradale; Cavi Aerei; Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\7092.JPG	\N	287	2019	22/01/2019	\N	\N	Caduca	1	0
367	0101000020110F0000971C77CA63762341E0B9F772B96F5041	288	4343	7094	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	ferite;	\N	capitozzatura;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	desktop/Foto\\7094.JPG	\N	288	2019	22/01/2019	\N	\N	Caduca	1	0
368	0101000020110F00004DBED9E66B7623415A2F8652B96F5041	289	4344	7095	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	ferite;	\N	capitozzatura; carie;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	\N	\N	289	2019	22/01/2019	\N	\N	Caduca	1	0
369	0101000020110F0000E84D452A7F7623413E05C0D0B86F5041	290	4345	7096	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	ferite;	\N	capitozzatura; carie;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	\N	\N	290	2019	22/01/2019	\N	\N	Caduca	1	0
370	0101000020110F0000CD3B4E518A762341B77A4EB0B86F5041	291	4346	7097	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	ferite;	\N	capitozzatura; carie;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\7097.JPG	\N	291	2019	22/01/2019	\N	\N	Caduca	1	0
986	0101000020110F0000F4E0EEAC3571234137548C57C3705041	907	4923	7876	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	907	2019	28/01/2019	\N	\N	Caduca	2	0
371	0101000020110F0000CBD6FA829876234123DBF94EB86F5041	292	4347	7098	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Pessimo	CLASSE D	4	branche con carie; branche con ferite; branche protese; sbrancamento;	ferite;	\N	capitozzatura; carie; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	Sede Stradale; Manufatto; Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\7098.JPG	\N	292	2019	22/01/2019	\N	\N	Caduca	1	0
372	0101000020110F000012DA721E998B23413A7AFC8C84655041	293	273	525	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	carpofori; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\525.JPG	\N	293	2018	24/09/2018	\N	\N	Sempreverde	1	0
373	0101000020110F0000431CEBA2A17623419C50882EB86F5041	294	4348	7099	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Pessimo	CLASSE D	4	branche con carie; branche con ferite; branche protese; sbrancamento;	ferite;	\N	capitozzatura; carie; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	Sede Stradale; Manufatto; Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\7099.JPG	\N	294	2019	22/01/2019	\N	\N	Caduca	1	0
374	0101000020110F0000F9BD4DBFA976234115C6160EB86F5041	295	4349	7100	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche protese;	ferite;	\N	carie; insetti lignivori;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	desktop/Foto\\7100.JPG	\N	295	2019	22/01/2019	\N	\N	Caduca	1	0
375	0101000020110F0000E5B33CDFB276234107B133CDB76F5041	296	4350	7101	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Pessimo	CLASSE D	4	branche con carie; branche con ferite; branche protese; tagli impropri;	ferite;	\N	carie; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	desktop/Foto\\7101.JPG	\N	296	2019	22/01/2019	\N	\N	Caduca	1	0
376	0101000020110F00005DF92CFFBB762341FA9B508CB76F5041	297	4351	7102	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Stretto Cappuccini	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2020-05-15	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4351/thb_177_WhatsApp Image 2020-05-15 at 13.19.46.jpeg	\N	297	2020	15/05/2020	\N	\N	Caduca	2	0
377	0101000020110F0000B18A3742367723413E3F8C58B76F5041	298	4352	7103	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche protese; sbrancamento; tagli impropri;	ferite;	\N	carie; insetti lignivori;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	desktop/Foto\\7103.JPG	\N	298	2019	22/01/2019	\N	\N	Caduca	1	0
378	0101000020110F0000417DCB6C42772341FC1D8A7CB86F5041	299	4353	7104	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche protese; tagli impropri;	ferite;	\N	carie; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	desktop/Foto\\7104.JPG	\N	299	2019	22/01/2019	\N	\N	Caduca	1	0
379	0101000020110F00009413ED9A4F772341B83B6BE1B96F5041	300	4354	7105	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-12-21	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Camminamento;	\N	photos/Albero/4354/thb_237_WhatsApp Image 2019-12-21 at 11.45.00.jpeg	\N	300	2019	21/12/2019	\N	\N	Caduca	2	0
380	0101000020110F0000B75D68BE59772341EF8FF7E4BA6F5041	301	4355	7106	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; tagli impropri;	ferite;	\N	carie; ferite;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	desktop/Foto\\7106.JPG	\N	301	2019	22/01/2019	\N	\N	Caduca	1	0
381	0101000020110F000002F1BA1E2C7723410E4FAF62C36F5041	302	4356	7107	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	5	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7107.JPG	\N	302	2019	22/01/2019	\N	\N	Caduca	1	0
382	0101000020110F00004C4F58022477234194D92083C36F5041	303	4357	7108	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	5	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	303	2019	22/01/2019	\N	\N	-	3	0
383	0101000020110F000097ADF5E51B772341931804C4C36F5041	304	4358	7109	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	5	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7109.JPG	\N	304	2019	22/01/2019	\N	\N	Caduca	1	0
384	0101000020110F00008C101ECD14772341A12DE704C46F5041	305	4359	7110	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	5	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7110.JPG	\N	305	2019	22/01/2019	\N	\N	-	3	0
385	0101000020110F00004417D4B70E77234128B85825C46F5041	306	4360	7111	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	5	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7111.JPG	\N	306	2019	22/01/2019	\N	\N	-	3	0
386	0101000020110F0000FC1D8AA20877234136CD3B66C46F5041	307	4361	7112	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7112.JPG	\N	307	2019	22/01/2019	\N	\N	Caduca	1	0
387	0101000020110F000028D53E8D02772341BC57AD86C46F5041	308	4362	7113	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7113.JPG	\N	308	2019	22/01/2019	\N	\N	-	3	0
389	0101000020110F00005F419AF1B28B234114AE47F586655041	310	274	530	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\530.JPG	\N	310	2018	24/09/2018	\N	\N	Sempreverde	1	0
390	0101000020110F000097E2AA62F676234151F701E8C46F5041	311	4364	7115	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	311	2019	22/01/2019	\N	\N	-	3	0
391	0101000020110F0000CD0182E91C772341AEBB799CC16F5041	312	4365	7116	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7116.JPG	\N	312	2019	22/01/2019	\N	\N	-	1	0
392	0101000020110F0000C364AAD015772341BBD05CDDC16F5041	313	4366	7117	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7117.JPG	\N	313	2019	22/01/2019	\N	\N	-	1	0
393	0101000020110F00000DC347B40D772341C9E53F1EC26F5041	314	4367	7118	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7118.JPG	\N	314	2019	22/01/2019	\N	\N	-	1	0
394	0101000020110F00008E75719B067723415070B13EC26F5041	315	4368	7119	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7119.JPG	\N	315	2019	22/01/2019	\N	\N	-	1	0
395	0101000020110F000084D89982FF7623415E85947FC26F5041	316	4369	7120	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7120.JPG	\N	316	2019	22/01/2019	\N	\N	-	1	0
396	0101000020110F0000058BC369F8762341E40F06A0C26F5041	317	4370	7121	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7121.JPG	\N	317	2019	22/01/2019	\N	\N	-	1	0
397	0101000020110F00004FE9604DF0762341F224E9E0C26F5041	318	4371	7122	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7122.JPG	\N	318	2019	22/01/2019	\N	\N	-	1	0
398	0101000020110F00008FAA2618E176234194D92083C36F5041	319	4372	7124	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2021-03-12	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	photos/Albero/4372/thb_WhatsApp Image 2021-03-12 at 13.04.54 (2)_297.jpeg	\N	319	2021	12/03/2021	\N	\N	Sempreverde	2	0
399	0101000020110F00007BA01538EA76234179AF5A01C36F5041	320	4373	7123	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7123.JPG	\N	320	2019	22/01/2019	\N	\N	-	1	0
400	0101000020110F0000D908C4FBD876234194D92083C36F5041	321	4374	7125	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7125.JPG	\N	321	2019	22/01/2019	\N	\N	-	1	0
401	0101000020110F0000088F36AE797623419560712CC66F5041	322	4375	7127	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-11-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7127.JPG	\N	322	2019	22/11/2019	\N	\N	Sempreverde	2	0
402	0101000020110F0000981760DFD0762341931804C4C36F5041	323	4376	7126	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7126.JPG	\N	323	2019	22/01/2019	\N	\N	-	1	0
403	0101000020110F000052EDD39171762341A375546DC66F5041	324	4377	7128	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Edificio;	\N	desktop/Foto\\7128.JPG	\N	324	2019	22/01/2019	\N	\N	-	1	0
404	0101000020110F0000B75D684E5E76234137548C0FC76F5041	325	4378	7130	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Edificio;	\N	desktop/Foto\\7130.JPG	\N	325	2019	22/01/2019	\N	\N	Sempreverde	2	0
405	0101000020110F00009D4B717569762341A2B437AEC66F5041	326	4379	7129	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Edificio;	\N	desktop/Foto\\7129.JPG	\N	326	2019	22/01/2019	\N	\N	-	1	0
406	0101000020110F0000B8408262BA8B2341323D61C787655041	327	275	531	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	carpofori; inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\531.JPG	\N	327	2018	24/09/2018	\N	\N	Sempreverde	1	0
407	0101000020110F000002BC05325676234144696F50C76F5041	328	4380	7131	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7131.JPG	\N	328	2019	22/01/2019	\N	\N	-	1	0
408	0101000020110F00005322890E4C762341527E5291C76F5041	329	4381	7132	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7132.JPG	\N	329	2019	22/01/2019	\N	\N	-	1	0
409	0101000020110F00009D8026F243762341609335D2C76F5041	330	4382	7133	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7133.JPG	\N	330	2019	22/01/2019	\N	\N	-	1	0
410	0101000020110F00007A36ABCE39762341E71DA7F2C76F5041	331	4383	7134	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7134.JPG	\N	331	2019	22/01/2019	\N	\N	-	1	0
411	0101000020110F0000394547B2317623416DA81813C86F5041	332	4384	7135	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7135.JPG	\N	332	2019	22/01/2019	\N	\N	-	1	0
412	0101000020110F0000FAB836641B7623411D7233F6C86F5041	333	4385	7136	Albero	ACER SP.	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Schipani	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7136.JPG	\N	333	2019	22/01/2019	\N	\N	-	1	0
413	0101000020110F00001C99478E7076234164AF7777D26F5041	334	4386	7137	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Plutino	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	ferite;	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	\N	\N	334	2019	22/01/2019	\N	\N	Caduca	1	0
414	0101000020110F0000A67EDEE4FC752341524486A3E76F5041	335	4387	7138	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Plutino	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto;	\N	desktop/Foto\\7138.JPG	\N	335	2019	22/01/2019	\N	\N	Caduca	1	0
415	0101000020110F0000273108CCF575234139622D8AE96F5041	336	4388	7139	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Plutino	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto;	\N	desktop/Foto\\7139.JPG	\N	336	2019	22/01/2019	\N	\N	Caduca	1	0
416	0101000020110F000091442F63D774234168058672B76F5041	337	4389	7141	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Greco	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-22	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Manufatto; Camminamento;	\N	desktop/Foto\\7141.JPG	\N	337	2019	22/01/2019	\N	\N	Sempreverde	1	0
417	0101000020110F0000B476DBF5807523415DFE433E9D6F5041	338	4390	7087	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Cartellonistica; Lampione; Edificio;	\N	desktop/Foto\\7087.JPG	\N	338	2019	22/01/2019	\N	\N	Sempreverde	1	0
418	0101000020110F0000738577A9A67523410E10CCE39C6F5041	339	4391	7142	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7142.JPG	\N	339	2019	22/01/2019	\N	\N	Sempreverde	1	0
419	0101000020110F0000211FF4CCB07523410E10CCE39C6F5041	340	4392	7143	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7143.JPG	\N	340	2019	22/01/2019	\N	\N	Sempreverde	1	0
420	0101000020110F000044696FF0BA7523410E10CCE39C6F5041	341	4393	7144	Ceppaia	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	0	-	0	\N	-	0	\N	2019-11-26	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\7144.JPG	\N	341	2019	26/11/2019	\N	\N	Sempreverde	2	0
421	0101000020110F000066BD186ACB752341BBF2590C9D6F5041	342	4394	7145	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7145.JPG	\N	342	2019	22/01/2019	\N	\N	Sempreverde	1	0
422	0101000020110F000038A110B1DF7523410E10CCE39C6F5041	343	4395	7146	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7146.JPG	\N	343	2019	22/01/2019	\N	\N	Sempreverde	1	0
423	0101000020110F00007689EABD948B23415C3D27EB85655041	344	276	529	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\529.JPG	\N	344	2018	24/09/2018	\N	\N	Caduca	1	0
424	0101000020110F000097CADBA1ED75234158FFE7349D6F5041	345	4396	7147	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7147.JPG	\N	345	2019	22/01/2019	\N	\N	Sempreverde	1	0
425	0101000020110F0000088F364EFA75234158FFE7349D6F5041	346	4397	7148	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7148.JPG	\N	346	2019	22/01/2019	\N	\N	Sempreverde	1	0
426	0101000020110F00007A5391FA0676234158FFE7349D6F5041	347	4398	7149	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7149.JPG	\N	347	2019	22/01/2019	\N	\N	Sempreverde	1	0
427	0101000020110F00008A027D621276234158FFE7349D6F5041	348	4399	7150	Fallanza	PITTOSPORUM TOBIRA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Daniele	Filare	8	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7150.JPG	\N	348	2019	22/01/2019	\N	\N	Sempreverde	3	0
428	0101000020110F00008F19A8AC597623415F984CEF856F5041	349	4400	7151	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	8	Asola	0	0	0	-	0	\N	-	0	\N	2021-09-27	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Cattivo	CLASSE D	\N	branche con ferite; branche protese; branche secche;	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	\N	\N	349	2021	27/09/2021	\N	\N	Sempreverde	1	0
429	0101000020110F00000E4A98F96976234154573E23856F5041	350	4401	7152	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Buccarelli	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Lampione; Recinzione; Edificio;	\N	desktop/Foto\\7152.JPG	\N	350	2019	22/01/2019	\N	\N	Sempreverde	1	0
430	0101000020110F0000D1747632AA76234168791E74836F5041	351	4402	7157	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Recinzione;	\N	\N	\N	351	2019	22/01/2019	\N	\N	Sempreverde	1	0
431	0101000020110F0000A54E4023B8762341145CAC9C836F5041	352	4403	7158	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto; Recinzione;	\N	desktop/Foto\\7158.JPG	\N	352	2019	22/01/2019	\N	\N	Sempreverde	1	0
432	0101000020110F0000A94D9C3C76762341541D7267846F5041	353	4404	7153	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Morto in piedi	Pessimo	CLASSE D	3C	branche con carie; branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7153.JPG	\N	353	2019	22/01/2019	\N	\N	Sempreverde	1	0
433	0101000020110F0000DE3CD571857623415E4BC8ED836F5041	354	4405	7154	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite; branche secche;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7154.JPG	\N	354	2019	22/01/2019	\N	\N	Sempreverde	1	0
434	0101000020110F00005001301E9276234168791E74836F5041	355	4406	7155	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Lampione; Sede Stradale; Manufatto; Illuminazione pubblica; Recinzione; Edificio;	\N	\N	\N	355	2019	22/01/2019	\N	\N	Sempreverde	1	0
435	0101000020110F000060B01B869D762341BC96904B836F5041	356	4407	7156	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Lampione; Sede Stradale; Manufatto; Illuminazione pubblica; Recinzione; Edificio;	\N	desktop/Foto\\7156.JPG	\N	356	2019	22/01/2019	\N	\N	Sempreverde	3	0
436	0101000020110F000020EF55BBAC762341ECA35383856F5041	357	4408	7160	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7160.JPG	\N	357	2019	22/01/2019	\N	\N	Caduca	2	0
437	0101000020110F00007155D997A276234140C1C55A856F5041	358	4409	7159	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7159.JPG	\N	358	2019	22/01/2019	\N	\N	Caduca	1	0
438	0101000020110F0000F2D24D02C1762341E275FDFC856F5041	359	4410	7161	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; seccume diffuso;	ferite;	\N	carie; ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7161.JPG	\N	359	2019	22/01/2019	\N	\N	Caduca	1	0
439	0101000020110F000027C28637D07623412C65194E866F5041	360	4411	7162	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-22	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; seccume diffuso;	ferite;	\N	carie; ferite;	\N	\N	\N	Sede Stradale; Manufatto; Recinzione; Edificio;	\N	desktop/Foto\\7162.JPG	\N	360	2019	22/01/2019	\N	\N	Caduca	1	0
440	0101000020110F00009E245D63C18B2341E128798B88655041	361	277	532	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\532.JPG	\N	361	2018	24/09/2018	\N	\N	Caduca	1	0
441	0101000020110F000085EB5128DE762341842A359F866F5041	362	4412	7163	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7163.JPG	\N	362	2019	22/01/2019	\N	\N	Sempreverde	1	0
442	0101000020110F000057CF496FF27623417AFCDE18876F5041	363	4413	7164	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7164.JPG	\N	363	2019	22/01/2019	\N	\N	Sempreverde	1	0
443	0101000020110F0000DA38622D04772341C4EBFA69876F5041	364	4414	7165	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7165.JPG	\N	364	2019	22/01/2019	\N	\N	Sempreverde	1	0
444	0101000020110F00009C6D6E0C0D7723411CB116BB876F5041	365	4415	7166	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7166.JPG	\N	365	2019	22/01/2019	\N	\N	Sempreverde	1	0
445	0101000020110F00005EA27AEB15772341BABDA4E3876F5041	366	4416	7167	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	\N	\N	366	2019	22/01/2019	\N	\N	Sempreverde	1	0
446	0101000020110F0000BEC117861D77234166A0320C886F5041	367	4417	7168	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7168.JPG	\N	367	2019	22/01/2019	\N	\N	Sempreverde	1	0
447	0101000020110F00007E0052BB2C77234108556AAE886F5041	368	4418	7169	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7169.JPG	\N	368	2019	22/01/2019	\N	\N	Sempreverde	1	0
448	0101000020110F00006E516653217723411283C034886F5041	369	4419	7170	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2021-02-09	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	photos/Albero/4419/thb_WhatsApp Image 2021-02-09 at 12.00.25_280.jpeg	\N	369	2021	09/02/2021	\N	\N	Caduca	2	0
449	0101000020110F000051DA1BAC3A772341FE261428896F5041	370	4420	7171	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Morto in piedi	Pessimo	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio; Manufatto; Edificio;	\N	photos/Albero/4420/thb_WhatsApp Image 2021-02-09 at 12.00.26_281.jpeg	\N	370	2019	22/01/2019	\N	\N	Caduca	1	0
450	0101000020110F000051DA1BAC3A772341FE261428896F5041	370	4420	7171	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-22	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Morto in piedi	Pessimo	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio; Manufatto; Edificio;	\N	photos/Albero/4420/thb_WhatsApp Image 2021-02-09 at 12.00.26_281.jpeg	\N	370	2019	22/01/2019	\N	\N	Caduca	1	0
451	0101000020110F000051DA1BAC3A772341FE261428896F5041	370	4420	7171	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2021-02-09	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio; Manufatto; Edificio;	\N	photos/Albero/4420/thb_WhatsApp Image 2021-02-09 at 12.00.26_281.jpeg	\N	370	2021	09/02/2021	\N	\N	Caduca	2	0
452	0101000020110F000051DA1BAC3A772341FE261428896F5041	370	4420	7171	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	8	Aiuola	0	0	0	-	0	\N	-	0	\N	2021-02-09	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio; Manufatto; Edificio;	\N	photos/Albero/4420/thb_WhatsApp Image 2021-02-09 at 12.00.26_281.jpeg	\N	370	2021	09/02/2021	\N	\N	Caduca	2	0
453	0101000020110F00004E2844503E76234160AB04AF166F5041	371	4421	7178	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7178.JPG	\N	371	2019	23/01/2019	\N	\N	Sempreverde	1	0
454	0101000020110F0000C4CE14DA4176234133FE7D7E166F5041	372	4422	7179	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7179.JPG	\N	372	2019	23/01/2019	\N	\N	Sempreverde	1	0
455	0101000020110F0000C4CE14DA41762341FF0417FD156F5041	373	4423	7180	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7180.JPG	\N	373	2019	23/01/2019	\N	\N	Sempreverde	1	0
456	0101000020110F00002905DDCE3D7623415E9D63BC156F5041	374	4424	7181	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7181.JPG	\N	374	2019	23/01/2019	\N	\N	Sempreverde	1	0
457	0101000020110F0000D88173C63A76234164E9430D166F5041	375	4425	7182	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7182.JPG	\N	375	2019	23/01/2019	\N	\N	Sempreverde	1	0
458	0101000020110F0000FDA4DA473B76234133FE7D7E166F5041	376	4426	7183	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7183.JPG	\N	376	2019	23/01/2019	\N	\N	Sempreverde	1	0
459	0101000020110F00002905DDCE3D7623419296CA3D166F5041	377	4427	7184	Fallanza	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7184.JPG	\N	377	2019	23/01/2019	\N	\N	Sempreverde	3	0
460	0101000020110F000062156F24CA8B2341BD52967989655041	378	278	533	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\533.JPG	\N	378	2018	24/09/2018	\N	\N	Caduca	1	0
461	0101000020110F00009AB168AA30762341CAFD0E89146F5041	379	4428	7185	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	379	2019	23/01/2019	\N	\N	Caduca	1	0
462	0101000020110F00002C4833262F76234132207BF7136F5041	380	4429	7186	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	380	2019	23/01/2019	\N	\N	Caduca	1	0
463	0101000020110F0000492EFFA12D762341FE261476136F5041	381	4430	7187	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7187.JPG	\N	381	2019	23/01/2019	\N	\N	Caduca	1	0
464	0101000020110F0000FFE7309F2C7623413012DA04136F5041	382	4431	7188	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7188.JPG	\N	382	2019	23/01/2019	\N	\N	Caduca	1	0
465	0101000020110F0000E20165232E7623418542048E106F5041	383	4432	7189	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	383	2019	23/01/2019	\N	\N	Caduca	1	0
466	0101000020110F00001058393434762341205ED77D106F5041	384	4433	7190	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	384	2019	23/01/2019	\N	\N	Caduca	1	0
467	0101000020110F000044A852F34A762341F46C565B156F5041	385	4434	7191	Albero	JACARANDA MIMOSIFOLIA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7191.JPG	\N	385	2019	23/01/2019	\N	\N	Sempreverde	1	0
468	0101000020110F00006DC5FE225C762341F9DA3325136F5041	386	4435	7192	Albero	JACARANDA MIMOSIFOLIA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7192.JPG	\N	386	2019	23/01/2019	\N	\N	Sempreverde	1	0
469	0101000020110F0000C18BBE82507623415C8FC2C9146F5041	387	4436	7193	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7193.JPG	\N	387	2019	23/01/2019	\N	\N	Sempreverde	1	0
470	0101000020110F00009E5E298B537623416519E278146F5041	388	4437	7194	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7194.JPG	\N	388	2019	23/01/2019	\N	\N	Sempreverde	1	0
471	0101000020110F0000EFE19293567623419604A807146F5041	389	4438	7195	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7195.JPG	\N	389	2019	23/01/2019	\N	\N	Sempreverde	1	0
472	0101000020110F00004F92AED96F762341F8FC309E106F5041	390	4439	7196	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7196.JPG	\N	390	2019	23/01/2019	\N	\N	Sempreverde	1	0
473	0101000020110F0000A01518E27276234129E8F62C106F5041	391	4440	7197	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7197.JPG	\N	391	2019	23/01/2019	\N	\N	Sempreverde	1	0
474	0101000020110F00003BDF4FED76762341F6EE8FAB0F6F5041	392	4441	7198	Albero	CITRUS LIMONUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Morto in piedi	-	CLASSE D	4	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7198.JPG	\N	392	2019	23/01/2019	\N	\N	Sempreverde	1	0
475	0101000020110F000063450DC66876234152499D0C106F5041	393	4442	7199	Albero	JACARANDA MIMOSIFOLIA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7199.JPG	\N	393	2019	23/01/2019	\N	\N	Sempreverde	1	0
476	0101000020110F0000C03E3AB5627623418126C2A80E6F5041	394	4443	7200	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7200.JPG	\N	394	2019	23/01/2019	\N	\N	Caduca	1	0
477	0101000020110F000014ED2AF4C78B234161C3D3718B655041	395	279	534	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\534.JPG	\N	395	2018	24/09/2018	\N	\N	Caduca	1	0
478	0101000020110F00004BE5EDF84C762341F4E0EEB80E6F5041	396	4444	7201	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7201.JPG	\N	396	2019	23/01/2019	\N	\N	Caduca	1	0
479	0101000020110F0000A9DE1AE846762341BDA948D90E6F5041	397	4445	7202	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7202.JPG	\N	397	2019	23/01/2019	\N	\N	Caduca	1	0
480	0101000020110F00009FABAD5841762341EB56CF090F6F5041	398	4446	7203	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7203.JPG	\N	398	2019	23/01/2019	\N	\N	Caduca	1	0
481	0101000020110F000040FB911228762341BFB7E9CB0F6F5041	399	4447	7204	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7204.JPG	\N	399	2019	23/01/2019	\N	\N	Caduca	1	0
482	0101000020110F0000EE77280A257623418ECC233D106F5041	400	4448	7205	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7205.JPG	\N	400	2019	23/01/2019	\N	\N	Caduca	1	0
483	0101000020110F000036C824832276234154573EFF106F5041	401	4449	7206	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7206.JPG	\N	401	2019	23/01/2019	\N	\N	Caduca	1	0
484	0101000020110F000053AEF0FE20762341226C7870116F5041	402	4450	7207	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7207.JPG	\N	402	2019	23/01/2019	\N	\N	Caduca	1	0
485	0101000020110F000036C8248322762341F38E53D4126F5041	403	4451	7208	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7208.JPG	\N	403	2019	23/01/2019	\N	\N	Caduca	1	0
486	0101000020110F0000800EF38523762341C2A38D45136F5041	404	4452	7209	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7209.JPG	\N	404	2019	23/01/2019	\N	\N	Caduca	1	0
487	0101000020110F0000AE64C796297623412BA4FC3A156F5041	405	4453	7210	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7210.JPG	\N	405	2019	23/01/2019	\N	\N	Caduca	1	0
488	0101000020110F0000917EFB1A2B762341FAB836AC156F5041	406	4454	7211	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7211.JPG	\N	406	2019	23/01/2019	\N	\N	Caduca	1	0
489	0101000020110F0000A2EE03B032762341FED47891176F5041	407	4455	7212	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7212.JPG	\N	407	2019	23/01/2019	\N	\N	Caduca	1	0
490	0101000020110F0000357BA0B534762341680586F2176F5041	408	4456	7213	Albero	PRUNUS SERRULATA "KANZAN"	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7213.JPG	\N	408	2019	23/01/2019	\N	\N	Caduca	1	0
491	0101000020110F00007D790116137623418CA19CC40C6F5041	409	4457	7215	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7215.JPG	\N	409	2019	23/01/2019	\N	\N	Caduca	1	0
492	0101000020110F00008A8EE46214762341A779C7470C6F5041	410	4458	7216	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7216.JPG	\N	410	2019	23/01/2019	\N	\N	Caduca	1	0
493	0101000020110F0000BC96906F127623411A6EC0DF0B6F5041	411	4459	7217	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7217.JPG	\N	411	2019	23/01/2019	\N	\N	Caduca	1	0
494	0101000020110F0000D09B8A04CB8B2341423EE8198C655041	412	280	535	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\535.JPG	\N	412	2018	24/09/2018	\N	\N	Caduca	1	0
495	0101000020110F0000C7116B510E7623418AB0E1D10B6F5041	413	4460	7218	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7218.JPG	\N	413	2019	23/01/2019	\N	\N	Caduca	1	0
496	0101000020110F00002BFBAE480B76234105172B1E0C6F5041	414	4461	7219	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7219.JPG	\N	414	2019	23/01/2019	\N	\N	Caduca	1	0
497	0101000020110F0000ABE7A4B70B7623415A81218D0C6F5041	415	4462	7220	Ceppaia	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2021-11-05	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7220.JPG	\N	415	2021	05/11/2021	\N	\N	Caduca	2	0
498	0101000020110F00001344DDF70E762341D5E76AD90C6F5041	416	4463	7221	Ceppaia	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7221.JPG	\N	416	2019	23/01/2019	\N	\N	Caduca	2	0
499	0101000020110F0000446E860BF675234124D1CB860D6F5041	417	4464	7222	Albero	CERCIS SILIQUASTRUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7222.JPG	\N	417	2019	23/01/2019	\N	\N	Caduca	1	0
500	0101000020110F0000236761FFB8752341EAB298BC176F5041	418	4465	7228	Albero	LAURUS NOBILIS	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7228.JPG	\N	418	2019	23/01/2019	\N	\N	Sempreverde	1	0
501	0101000020110F000006D847E7C075234177D66E03186F5041	419	4466	7229	Albero	LAURUS NOBILIS	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7229.JPG	\N	419	2019	23/01/2019	\N	\N	Sempreverde	1	0
502	0101000020110F000090831236BB752341C824233D196F5041	420	4467	7233	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7233.JPG	\N	420	2019	23/01/2019	\N	\N	Sempreverde	1	0
503	0101000020110F00006F4738FDB275234130647509166F5041	421	4468	7230	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7230.JPG	\N	421	2019	23/01/2019	\N	\N	Sempreverde	1	0
504	0101000020110F00006F4738FDB2752341AC562640186F5041	422	4469	7231	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7231.JPG	\N	422	2019	23/01/2019	\N	\N	Sempreverde	1	0
505	0101000020110F00001B81785DB8752341543A58A5186F5041	423	4470	7232	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7232.JPG	\N	423	2019	23/01/2019	\N	\N	Sempreverde	1	0
506	0101000020110F0000FC6F255BD7752341B4AB9010176F5041	424	4471	7234	Albero	-	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Morto in piedi	-	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7234.JPG	\N	424	2019	23/01/2019	\N	\N	-	1	0
507	0101000020110F00002A6F4768D67523415D1613E5176F5041	425	4472	7235	Ceppaia	NERIUM OLEANDER	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2022-12-15	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Lampione;	\N	photos/Albero/4472/thb_WhatsApp Image 2022-12-15 at 12.52.30 (2)_319.jpeg	\N	425	2022	15/12/2022	\N	\N	Sempreverde	2	0
508	0101000020110F000077D66E7B46722341828B15E7F96D5041	704	4733	7983	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7983.JPG	\N	704	2019	28/01/2019	\N	\N	Sempreverde	1	0
509	0101000020110F0000DC6800FF48722341DE020936F86D5041	705	4734	7984	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7984.JPG	\N	705	2019	28/01/2019	\N	\N	Sempreverde	1	0
510	0101000020110F0000CB4A93824B7223412BA4FC84F66D5041	706	4735	7985	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7985.JPG	\N	706	2019	28/01/2019	\N	\N	Sempreverde	1	0
511	0101000020110F0000B398D8FC4A722341861BF0D3F46D5041	707	4736	7986	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7986.JPG	\N	707	2019	28/01/2019	\N	\N	Sempreverde	1	0
512	0101000020110F00000D71AC6BDA872341E3FC4D0022655041	708	298	584	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede;	\N	desktop/Foto\\584.JPG	\N	708	2018	25/09/2018	\N	\N	Caduca	1	0
513	0101000020110F00007632387A4B722341355EBAC1F26D5041	709	4737	7987	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7987.JPG	\N	709	2019	28/01/2019	\N	\N	Sempreverde	1	0
514	0101000020110F0000A7E848EE48722341D9994241F16D5041	710	4738	7988	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7988.JPG	\N	710	2019	28/01/2019	\N	\N	Sempreverde	1	0
515	0101000020110F000058A835ED497223417CD5CAC0EF6D5041	711	4739	7989	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7989.JPG	\N	711	2019	28/01/2019	\N	\N	Sempreverde	1	0
516	0101000020110F0000895E46614772234167D5E770EE6D5041	712	4740	7990	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7990.JPG	\N	712	2019	28/01/2019	\N	\N	Sempreverde	1	0
517	0101000020110F0000BED9E656457223413E963EE0EC6D5041	713	4741	7991	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	713	2019	28/01/2019	\N	\N	Sempreverde	1	0
518	0101000020110F0000F62345D445722341C18BBEB0EB6D5041	714	4742	7992	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7992.JPG	\N	714	2019	28/01/2019	\N	\N	Sempreverde	1	0
519	0101000020110F0000CC9717D045722341840D4FDFE96D5041	715	4743	7993	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7993.JPG	\N	715	2019	28/01/2019	\N	\N	Sempreverde	1	0
520	0101000020110F0000F20703CF467223417B14AEFDE76D5041	716	4744	7994	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7994.JPG	\N	716	2019	28/01/2019	\N	\N	Sempreverde	1	0
521	0101000020110F00000E32C9584B72234105A8A9FBE56D5041	717	4745	7995	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7995.JPG	\N	717	2019	28/01/2019	\N	\N	Sempreverde	1	0
522	0101000020110F0000B79734865B722341158C4A88E36D5041	718	4746	7996	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7996.JPG	\N	718	2019	28/01/2019	\N	\N	Sempreverde	1	0
523	0101000020110F00001878EE9D647223412FA86FE7E16D5041	719	4747	7997	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7997.JPG	\N	719	2019	28/01/2019	\N	\N	Sempreverde	1	0
524	0101000020110F00002497FF306C7223415C035B87E06D5041	720	4748	7998	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7998.JPG	\N	720	2019	28/01/2019	\N	\N	Sempreverde	1	0
525	0101000020110F0000147992B46E722341A9A44ED6DE6D5041	721	4749	7999	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7999.JPG	\N	721	2019	28/01/2019	\N	\N	Sempreverde	1	0
526	0101000020110F0000FCE3BD4A77722341041C4225DD6D5041	722	4750	8000	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8000.JPG	\N	722	2019	28/01/2019	\N	\N	Sempreverde	1	0
527	0101000020110F0000670A9DD77C722341C79DD253DB6D5041	723	4751	8001	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8001.JPG	\N	723	2019	28/01/2019	\N	\N	Sempreverde	1	0
528	0101000020110F00007BA015587E722341143FC6A2D96D5041	724	4752	8002	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8002.JPG	\N	724	2019	28/01/2019	\N	\N	Sempreverde	1	0
529	0101000020110F0000062FFA1AE287234119E2581923655041	725	299	585	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede;	\N	desktop/Foto\\585.JPG	\N	725	2018	25/09/2018	\N	\N	Caduca	1	0
530	0101000020110F00002D6002577F72234170B6B9F1D76D5041	726	4753	8003	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8003.JPG	\N	726	2019	28/01/2019	\N	\N	Sempreverde	1	0
531	0101000020110F000065AA60D47F72234147771061D66D5041	727	4754	8004	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8004.JPG	\N	727	2019	28/01/2019	\N	\N	Sempreverde	1	0
532	0101000020110F00000FD6FFC97D722341931804B0D46D5041	728	4755	8005	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8005.JPG	\N	728	2019	28/01/2019	\N	\N	Sempreverde	1	0
533	0101000020110F00007368914D80722341EF8FF7FED26D5041	729	4756	8006	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8006.JPG	\N	729	2019	28/01/2019	\N	\N	Sempreverde	1	0
534	0101000020110F000024287E4C817223410E15E39ED16D5041	730	4757	8007	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8007.JPG	\N	730	2019	28/01/2019	\N	\N	Sempreverde	1	0
535	0101000020110F0000B020CD386C7C2341809F71FD086E5041	731	4758	7567	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7567.JPG	\N	731	2019	25/01/2019	\N	\N	Sempreverde	1	0
536	0101000020110F0000B2BAD5F3717C234120292259096E5041	732	4759	7568	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7568.JPG	\N	732	2019	25/01/2019	\N	\N	Sempreverde	1	0
537	0101000020110F00004182E297797C2341910A63D3096E5041	733	4760	7569	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7569.JPG	\N	733	2019	25/01/2019	\N	\N	Sempreverde	1	0
538	0101000020110F000044FAED3B817C2341516683100A6E5041	734	4761	7570	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7570.JPG	\N	734	2019	25/01/2019	\N	\N	Sempreverde	1	0
987	0101000020110F0000B84082323A712341BBB88D02C4705041	908	4924	7877	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7877.JPG	\N	908	2019	28/01/2019	\N	\N	Caduca	2	0
539	0101000020110F00004772F9DF887C2341F2EF336C0A6E5041	735	4762	7571	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7571.JPG	\N	735	2019	25/01/2019	\N	\N	Sempreverde	1	0
540	0101000020110F0000D6390684907C2341B24B54A90A6E5041	736	4763	7572	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche secche;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7572.JPG	\N	736	2019	25/01/2019	\N	\N	Sempreverde	1	0
541	0101000020110F0000DA8F14119A7C234152D504050B6E5041	737	4764	7573	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2022-02-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Illuminazione pubblica;	\N	photos/Albero/4764/thb_WhatsApp Image 2022-02-22 at 13.23.48_308.jpeg	\N	737	2022	22/02/2022	\N	\N	Sempreverde	2	0
542	0101000020110F000068E89FC0A07C2341D28C457F0B6E5041	738	4765	7574	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2022-02-22	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica;	\N	photos/Albero/4765/thb_WhatsApp Image 2022-02-22 at 13.23.47 (3)_310.jpeg	\N	738	2022	22/02/2022	\N	\N	Sempreverde	2	0
543	0101000020110F00006CCF2C59A97C234192E865BC0B6E5041	739	4766	7575	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7575.JPG	\N	739	2019	25/01/2019	\N	\N	Sempreverde	1	0
544	0101000020110F0000FB05BBF1B17C234104CAA6360C6E5041	740	4767	7576	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7576.JPG	\N	740	2019	25/01/2019	\N	\N	Sempreverde	1	0
545	0101000020110F0000FF5BC97EBB7C2341E4F736550C6E5041	741	4768	7577	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7577.JPG	\N	741	2019	25/01/2019	\N	\N	Sempreverde	1	0
546	0101000020110F0000739D46CAE987234141F1633224655041	742	300	586	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede;	\N	desktop/Foto\\586.JPG	\N	742	2018	25/09/2018	\N	\N	Caduca	1	0
547	0101000020110F00008E23D622C37C234144DD07EE0C6E5041	743	4769	7578	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7578.JPG	\N	743	2019	25/01/2019	\N	\N	Sempreverde	1	0
548	0101000020110F0000912C60D2C97C23410439282B0D6E5041	744	4770	7579	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7579.JPG	\N	744	2019	25/01/2019	\N	\N	Sempreverde	1	0
549	0101000020110F00009335EA81D07C2341A4C2D8860D6E5041	745	4771	7580	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7580.JPG	\N	745	2019	25/01/2019	\N	\N	Sempreverde	1	0
550	0101000020110F0000226C781AD97C2341444C89E20D6E5041	746	4772	7581	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Filare	4	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Cavi Aerei;	\N	desktop/Foto\\7581.JPG	\N	746	2019	25/01/2019	\N	\N	Sempreverde	1	0
551	0101000020110F00000C3CF7CE767523412E73BAAE696F5041	747	4773	6110	Albero	PRUNUS LAUROCERASUS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	capitozzatura; carie; cavit�; decorticazione; ferite; necrosi corticale;	\N	\N	\N	\N	\N	\N	\N	747	2019	26/01/2019	\N	\N	Sempreverde	1	0
552	0101000020110F0000C45A7C3A86752341153AAFD5696F5041	748	4774	6111	Albero	PRUNUS LAUROCERASUS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	cavit�; decorticazione; ferite; necrosi corticale; capitozzatura; carie;	\N	\N	\N	\N	\N	\N	\N	748	2019	26/01/2019	\N	\N	Sempreverde	1	0
553	0101000020110F00000CB08FCE7675234109E1D1E0686F5041	749	4775	6112	Albero	THUJA OCCIDENTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	\N	\N	749	2019	26/01/2019	\N	\N	Sempreverde	1	0
554	0101000020110F00000C1F11C37575234197FF903A6A6F5041	750	4776	6113	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	\N	\N	750	2019	26/01/2019	\N	\N	Sempreverde	1	0
555	0101000020110F0000EFACDDC698752341D00F235E6A6F5041	751	4777	6114	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	\N	\N	751	2019	26/01/2019	\N	\N	Sempreverde	1	0
556	0101000020110F0000A37554357A7523417CD5CA36686F5041	752	4778	6115	Albero	LIGUSTRUM JAPONICA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	752	2019	26/01/2019	\N	\N	Sempreverde	1	0
557	0101000020110F0000422102DE677523416DE2E426696F5041	753	4779	6119	Albero	ERIOBOTRYA JAPONICA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	753	2019	26/01/2019	\N	\N	Sempreverde	1	0
558	0101000020110F0000EFACDD966775234110069E9F676F5041	754	4780	6120	Albero	AILANTHUS ALTISSIMA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	754	2019	26/01/2019	\N	\N	Caduca	1	0
559	0101000020110F00009F76F81B557523417311DFF7696F5041	755	4781	6121	Albero	AILANTHUS ALTISSIMA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	755	2019	26/01/2019	\N	\N	Caduca	1	0
560	0101000020110F0000F2EA1C6355752341C9E53F5C696F5041	756	4782	6122	Albero	AILANTHUS ALTISSIMA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	756	2019	26/01/2019	\N	\N	Caduca	1	0
561	0101000020110F000072FE26944E752341FBE8D48D676F5041	757	4783	6123	Albero	LIGUSTRUM JAPONICA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	\N	\N	757	2019	26/01/2019	\N	\N	Sempreverde	1	0
562	0101000020110F0000ECFA055B4C752341D48217ED686F5041	758	4784	6124	Ceppaia	PRUNUS LAUROCERASUS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-19	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4784/thb_199_WhatsApp Image 2020-09-19 at 13.10.57.jpeg	\N	758	2020	19/09/2020	\N	\N	Sempreverde	2	0
563	0101000020110F00009C508860F0872341BC3FDE3925655041	759	301	587	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Marciapiede; Utenze Sotterranee; Illuminazione pubblica;	\N	desktop/Foto\\587.JPG	\N	759	2018	25/09/2018	\N	\N	Caduca	1	0
564	0101000020110F0000E69656134775234154742465696F5041	760	4785	6125	Albero	THUJA OCCIDENTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	\N	\N	760	2019	26/01/2019	\N	\N	Sempreverde	1	0
565	0101000020110F00008104C5EF46752341C49448AC696F5041	761	4786	6126	Albero	THUJA OCCIDENTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2.5	5) >23m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	761	2019	26/01/2019	\N	\N	Sempreverde	1	0
566	0101000020110F000017F19D283475234153910A81696F5041	762	4787	6131	Ceppaia	PRUNUS LAUROCERASUS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-19	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4787/thb_196_WhatsApp Image 2020-09-19 at 13.10.46.jpeg	\N	762	2020	19/09/2020	\N	\N	Sempreverde	2	0
567	0101000020110F00003C4ED13136752341FE2614E0676F5041	763	4788	6132	Albero	PRUNUS ARMENIACA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	763	2019	26/01/2019	\N	\N	Caduca	1	0
568	0101000020110F000076C3B6858575234120EF556B746F5041	764	4789	7620	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	764	2019	26/01/2019	\N	\N	Sempreverde	2	0
569	0101000020110F000051A5665F887523415053CB80736F5041	765	4790	7621	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	765	2019	26/01/2019	\N	\N	Sempreverde	2	0
570	0101000020110F000048E17A348A75234186032139736F5041	766	4791	7622	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	766	2019	26/01/2019	\N	\N	Sempreverde	2	0
571	0101000020110F0000A4A5F2D680752341611A860B736F5041	767	4792	7623	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	767	2019	26/01/2019	\N	\N	Sempreverde	2	0
572	0101000020110F00005227A0997E75234180D426F4746F5041	768	4793	7624	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7624.JPG	\N	768	2019	26/01/2019	\N	\N	Sempreverde	2	0
573	0101000020110F00001E6D1C8184752341A5BDC121756F5041	769	4794	7625	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	769	2019	26/01/2019	\N	\N	Sempreverde	2	0
574	0101000020110F00007B3194237B752341DA722E01756F5041	770	4795	7626	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7626.JPG	\N	770	2019	26/01/2019	\N	\N	Sempreverde	2	0
575	0101000020110F0000732EC51578752341253B360E756F5041	771	4796	7627	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7627.JPG	\N	771	2019	26/01/2019	\N	\N	Sempreverde	2	0
576	0101000020110F000021B072D875752341DA722E01756F5041	772	4797	7628	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	772	2019	26/01/2019	\N	\N	Sempreverde	2	0
577	0101000020110F0000CB845F1A79752341F06DFAF7726F5041	773	4798	7629	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	773	2019	26/01/2019	\N	\N	Sempreverde	2	0
578	0101000020110F0000FA27B8886F752341BBB88D18736F5041	774	4799	7630	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	774	2019	26/01/2019	\N	\N	Sempreverde	2	0
579	0101000020110F00004D6727E36C752341611A860B736F5041	775	4800	7631	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	775	2019	26/01/2019	\N	\N	Sempreverde	2	0
580	0101000020110F0000FC355963B887234114CB2DF919655041	776	302	577	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\577.JPG	\N	776	2018	25/09/2018	\N	\N	Caduca	1	0
581	0101000020110F000076711B6D697523411AA375C8736F5041	777	4801	7632	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	777	2019	26/01/2019	\N	\N	Sempreverde	2	0
582	0101000020110F000023F3C82F677523419B20EAB4736F5041	778	4802	7633	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	778	2019	26/01/2019	\N	\N	Sempreverde	2	0
583	0101000020110F0000F6D1A9FB667523417B832F2A746F5041	779	4803	7634	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	779	2019	26/01/2019	\N	\N	Sempreverde	2	0
584	0101000020110F000003B2D74BB98223418C2D0485E2675041	505	4547	7281	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7281.JPG	\N	505	2019	24/01/2019	\N	\N	Caduca	1	0
585	0101000020110F0000617138D3C98223410B410E98E3675041	506	4548	7282	Albero	SCHINUS MOLLE	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7282.JPG	\N	506	2019	24/01/2019	\N	\N	Sempreverde	1	0
586	0101000020110F00005A0D896BD28223415452272CE4675041	507	4549	7283	Albero	SCHINUS MOLLE	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cartellonistica; Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7283.JPG	\N	507	2019	24/01/2019	\N	\N	Sempreverde	1	0
587	0101000020110F0000F92CCF93A7822341456458E7FD675041	508	4550	7287	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7287.JPG	\N	508	2019	24/01/2019	\N	\N	Sempreverde	1	0
588	0101000020110F00002C9ACEEE9C82234187DC0CABFC675041	509	4551	7288	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7288.JPG	\N	509	2019	24/01/2019	\N	\N	Sempreverde	1	0
589	0101000020110F00006C5B94195F822341A661F862FE675041	510	4552	7289	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7289.JPG	\N	510	2019	24/01/2019	\N	\N	Sempreverde	1	0
590	0101000020110F00004209336D3F82234174EFE1AAFF675041	511	4553	7290	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7290.JPG	\N	511	2019	24/01/2019	\N	\N	Sempreverde	1	0
591	0101000020110F0000C2120F08608223411EFE9A1001685041	512	4554	7291	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7291.JPG	\N	512	2019	24/01/2019	\N	\N	Sempreverde	1	0
592	0101000020110F00004B5986A82E822341BF654EC506685041	513	4555	7292	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7292.JPG	\N	513	2019	24/01/2019	\N	\N	Sempreverde	1	0
593	0101000020110F0000B9196E50A98B234128B8588187655041	514	286	545	Albero	CINNAMOMUM CAMPHORA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\545.JPG	\N	514	2018	24/09/2018	\N	\N	Sempreverde	1	0
594	0101000020110F00004F75C89D21822341B6BE48140B685041	515	4556	7293	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7293.JPG	\N	515	2019	24/01/2019	\N	\N	Sempreverde	1	0
841	0101000020110F0000022B87F6477F2341022B87386D6A5041	1068	5074	8051	Albero	HIBISCUS SYRIACUS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8051.JPG	\N	1068	2019	29/01/2019	\N	\N	Caduca	1	0
595	0101000020110F0000C841099314822341A9BC1DE306685041	516	4557	7294	Albero	MELIA AZEDARACH	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola stradale	0	0	-1	-	0	\N	-	0	\N	2019-01-24	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7294.JPG	\N	516	2019	24/01/2019	\N	\N	Caduca	1	0
596	0101000020110F0000A0FD48016E8223417094BC1E07685041	517	4558	7296	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7296.JPG	\N	517	2019	24/01/2019	\N	\N	Caduca	1	0
597	0101000020110F0000B2F4A19B148223413DD521D50F685041	518	4559	7298	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Camminamento;	\N	desktop/Foto\\7298.JPG	\N	518	2019	24/01/2019	\N	\N	Caduca	1	0
598	0101000020110F0000A27F825B2082234126C79D6411685041	519	4560	7299	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7299.JPG	\N	519	2019	24/01/2019	\N	\N	Caduca	1	0
599	0101000020110F0000B5E0451F378223414226192313685041	520	4561	7300	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7300.JPG	\N	520	2019	24/01/2019	\N	\N	Caduca	1	0
600	0101000020110F0000A54E4053398223414833163D14685041	521	4562	7301	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7301.JPG	\N	521	2019	24/01/2019	\N	\N	Caduca	1	0
601	0101000020110F00006A4DF39E658223411AA3758408685041	522	4563	7297	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7297.JPG	\N	522	2019	24/01/2019	\N	\N	Caduca	1	0
602	0101000020110F00001D8F19B8458223415743E2D409685041	523	4564	7302	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7302.JPG	\N	523	2019	24/01/2019	\N	\N	Caduca	1	0
603	0101000020110F0000912749872A822341261E50E20D685041	524	4565	7303	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7303.JPG	\N	524	2019	24/01/2019	\N	\N	Caduca	1	0
604	0101000020110F000046B1DC423B8223415188800F0F685041	525	4566	7304	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con fratture/incrinature; branche protese;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7304.JPG	\N	525	2019	24/01/2019	\N	\N	Caduca	1	0
605	0101000020110F00004DBED996598223414EB9C2F90F685041	526	4567	7305	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con fratture/incrinature; branche protese;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7305.JPG	\N	526	2019	24/01/2019	\N	\N	Caduca	1	0
606	0101000020110F00003C1405BA5C822341401878660B685041	527	4568	7306	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7306.JPG	\N	527	2019	24/01/2019	\N	\N	Caduca	1	0
607	0101000020110F00002E39EE9442822341BED9E6DE07685041	528	4569	7307	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7307.JPG	\N	528	2019	24/01/2019	\N	\N	Caduca	1	0
608	0101000020110F0000C53D964E3C8223412BD9B1A708685041	529	4570	7308	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7308.JPG	\N	529	2019	24/01/2019	\N	\N	Caduca	1	0
609	0101000020110F00006CEC12E53282234114AE47390A685041	530	4571	7309	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7309.JPG	\N	530	2019	24/01/2019	\N	\N	Caduca	1	0
610	0101000020110F000032772D71AF8B2341910A63D587655041	531	287	546	Albero	CINNAMOMUM CAMPHORA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\546.JPG	\N	531	2018	24/09/2018	\N	\N	Sempreverde	1	0
611	0101000020110F0000846401932B822341401878660B685041	532	4572	7310	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Lampione; Manufatto;	\N	desktop/Foto\\7310.JPG	\N	532	2019	24/01/2019	\N	\N	Caduca	1	0
612	0101000020110F0000D3C1FABF18822341E388B5460E685041	533	4573	7311	Albero	MELIA AZEDARACH	PARCO DEI FRUTTI ANTICHI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Lampione; Manufatto;	\N	desktop/Foto\\7311.JPG	\N	533	2019	24/01/2019	\N	\N	Caduca	1	0
613	0101000020110F00003D0AD733E38123411E8A023BF2675041	534	4574	7315	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE D	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4574/IMG_1544_354.jpeg	\N	534	2024	23/01/2024	\N	\N	Sempreverde	1	0
614	0101000020110F0000029A08ABD9812341DC9DB54DF1675041	535	4575	7316	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4575/IMG_1541_351.jpeg	\N	535	2024	23/01/2024	\N	\N	Sempreverde	1	0
615	0101000020110F0000F437A140D2812341D8B628B5F0675041	536	4576	7317	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE D	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4576/IMG_1542_352.jpeg	\N	536	2024	23/01/2024	\N	\N	Sempreverde	1	0
616	0101000020110F00006F0D6CE5CB8123416B82A80BF0675041	537	4577	7318	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4577/IMG_1543_353.jpeg	\N	537	2024	23/01/2024	\N	\N	Sempreverde	1	0
617	0101000020110F0000349D9D5CC2812341A1B94E2FEF675041	538	4578	7319	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Sede Stradale; Manufatto; Camminamento;	\N	photos/Albero/4578/IMG_1545_355.jpeg	\N	538	2024	23/01/2024	\N	\N	Sempreverde	1	0
618	0101000020110F000001DE0289BC8123418143A8B8EE675041	539	4579	7320	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Filare	5	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-23	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Sede Stradale; Manufatto; Camminamento; Edificio;	\N	photos/Albero/4579/IMG_1548_356.jpeg	\N	539	2024	23/01/2024	\N	\N	Sempreverde	1	0
619	0101000020110F00006C787A750B822341261E50CEF5675041	540	4580	7321	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\7321.JPG	\N	540	2019	24/01/2019	\N	\N	Sempreverde	1	0
620	0101000020110F0000AD6EF54CBA822341E4BD6AED45685041	541	4581	7325	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7325.JPG	\N	541	2019	24/01/2019	\N	\N	Caduca	1	0
621	0101000020110F00000BD28C65C18223419E0777C944685041	542	4582	7326	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7326.JPG	\N	542	2019	24/01/2019	\N	\N	Caduca	1	0
622	0101000020110F000061713893CE8223415B423E2042685041	543	4583	7327	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7327.JPG	\N	543	2019	24/01/2019	\N	\N	Caduca	1	0
623	0101000020110F00008E23D6B2D7822341158C4AFC40685041	544	4584	7328	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7328.JPG	\N	544	2019	24/01/2019	\N	\N	Caduca	1	0
624	0101000020110F0000F90FE9C7DD822341D0D556D83F685041	545	4585	7329	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7329.JPG	\N	545	2019	24/01/2019	\N	\N	Caduca	1	0
625	0101000020110F000027C286E7E6822341D68BA1323E685041	546	4586	7330	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Camminamento;	\N	desktop/Foto\\7330.JPG	\N	546	2019	24/01/2019	\N	\N	Caduca	1	0
626	0101000020110F00001EFE9AFCEC8223416B9F8E4F3D685041	547	4587	7331	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Camminamento;	\N	desktop/Foto\\7331.JPG	\N	547	2019	24/01/2019	\N	\N	Caduca	1	0
627	0101000020110F0000D1AE426AD686234189299158F7645041	548	18	228	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\228.JPG	\N	548	2018	24/09/2018	\N	\N	Sempreverde	1	0
628	0101000020110F00008D0B0772B68B2341AF997CA788655041	549	288	547	Albero	CINNAMOMUM CAMPHORA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\547.JPG	\N	549	2018	24/09/2018	\N	\N	Sempreverde	1	0
629	0101000020110F0000E388B518F58223414B1FBAEA3B685041	550	4588	7332	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\7332.JPG	\N	550	2019	24/01/2019	\N	\N	Caduca	1	0
630	0101000020110F0000103B5338FE8223412C9FE5853A685041	551	4589	7333	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\7333.JPG	\N	551	2019	24/01/2019	\N	\N	Caduca	1	0
631	0101000020110F0000A04FE44903832341D34D628239685041	552	4590	7334	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\7334.JPG	\N	552	2019	24/01/2019	\N	\N	Caduca	1	0
632	0101000020110F000039EE947E12832341908829D936685041	553	4591	7335	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche protese;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7335.JPG	\N	553	2019	24/01/2019	\N	\N	Caduca	1	0
633	0101000020110F000047E6913F25832341DFF8DA9533685041	554	4592	7337	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Lampione;	\N	desktop/Foto\\7337.JPG	\N	554	2019	24/01/2019	\N	\N	Caduca	1	0
634	0101000020110F00006BD44374348323415A2F86E430685041	555	4593	7338	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7338.JPG	\N	555	2019	24/01/2019	\N	\N	Caduca	1	0
635	0101000020110F0000BDC62EF11F83234162F8883A27685041	556	4594	7340	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\7340.JPG	\N	556	2019	24/01/2019	\N	\N	Sempreverde	1	0
636	0101000020110F0000DA722EB5168323415227A06326685041	557	4595	7341	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\7341.JPG	\N	557	2019	24/01/2019	\N	\N	Sempreverde	1	0
637	0101000020110F000008E6E8C1068323418412660625685041	558	4596	7342	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\7342.JPG	\N	558	2019	24/01/2019	\N	\N	Sempreverde	1	0
638	0101000020110F000062D68BE100832341B875376524685041	559	4597	7343	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\7343.JPG	\N	559	2019	24/01/2019	\N	\N	Sempreverde	1	0
639	0101000020110F000017B7D120F5822341EDD808C423685041	560	4598	7344	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7344.JPG	\N	560	2019	24/01/2019	\N	\N	Sempreverde	1	0
640	0101000020110F0000904946EEF0822341809F717323685041	561	4599	7345	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7345.JPG	\N	561	2019	24/01/2019	\N	\N	Sempreverde	1	0
641	0101000020110F00009D2E8B69EE82234147C9AB8122685041	562	4600	7346	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7346.JPG	\N	562	2019	24/01/2019	\N	\N	Sempreverde	1	0
642	0101000020110F00002788BA7FE3822341965B5AFB21685041	563	4601	7347	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7347.JPG	\N	563	2019	24/01/2019	\N	\N	Sempreverde	1	0
643	0101000020110F000062D68BF1DB822341CBBE2B5A21685041	564	4602	7348	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7348.JPG	\N	564	2019	24/01/2019	\N	\N	Sempreverde	1	0
644	0101000020110F0000C9AB738CD382234192E8656820685041	565	4603	7349	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7349.JPG	\N	565	2019	24/01/2019	\N	\N	Sempreverde	1	0
645	0101000020110F0000E4DA50A1FF862341E71DA75EFA645041	566	289	248	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\248.JPG	\N	566	2018	24/09/2018	\N	\N	Caduca	1	0
646	0101000020110F00009D2E8B79C982234174417D911F685041	567	4604	7350	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7350.JPG	\N	567	2019	24/01/2019	\N	\N	Sempreverde	1	0
647	0101000020110F000031D3F65FB2822341C05B207B1D685041	568	4605	7352	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7352.JPG	\N	568	2019	24/01/2019	\N	\N	Caduca	1	0
648	0101000020110F000009336D3FAF822341AD510F171D685041	569	4606	7353	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7353.JPG	\N	569	2019	24/01/2019	\N	\N	Caduca	1	0
649	0101000020110F000003780B14AB822341042159D41C685041	570	4607	7354	Albero	FICUS CARICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7354.JPG	\N	570	2019	24/01/2019	\N	\N	Caduca	1	0
650	0101000020110F0000DCD781F3A78223415AF0A2911C685041	571	4608	7355	Albero	MELIA AZEDARACH	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7355.JPG	\N	571	2019	24/01/2019	\N	\N	Caduca	1	0
651	0101000020110F0000F7E9780C9E8223419981CA861B685041	572	4609	7359	Albero	MELIA AZEDARACH	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7359.JPG	\N	572	2019	24/01/2019	\N	\N	Caduca	1	0
652	0101000020110F0000DCD781F3A7822341B1A206E51C685041	573	4610	7356	Albero	MELIA AZEDARACH	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7356.JPG	\N	573	2019	24/01/2019	\N	\N	Caduca	1	0
653	0101000020110F0000D61C20C8A382234147E6912D1C685041	574	4611	7357	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7357.JPG	\N	574	2019	24/01/2019	\N	\N	Sempreverde	1	0
654	0101000020110F0000EB8B84669A8223413D7E6F651B685041	575	4612	7358	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7358.JPG	\N	575	2019	24/01/2019	\N	\N	Sempreverde	1	0
655	0101000020110F00006FF085D98C822341E17A14441B685041	576	4613	7362	Albero	LAURUS NOBILIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7362.JPG	\N	576	2019	24/01/2019	\N	\N	Sempreverde	1	0
656	0101000020110F0000EE940EE64782234169006F9F26685041	577	4614	7364	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7364.JPG	\N	577	2019	24/01/2019	\N	\N	Sempreverde	1	0
657	0101000020110F0000ABB2EFDA3C822341B7D100E428685041	578	4615	7365	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7365.JPG	\N	578	2019	24/01/2019	\N	\N	Sempreverde	1	0
658	0101000020110F0000967840E93882234118B2BA2F29685041	579	4616	7366	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7366.JPG	\N	579	2019	24/01/2019	\N	\N	Sempreverde	1	0
659	0101000020110F0000562B135E388223414209339729685041	580	4617	7367	Albero	MELIA AZEDARACH	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7367.JPG	\N	580	2019	24/01/2019	\N	\N	Caduca	1	0
660	0101000020110F0000616C21782B8223414C546F272B685041	581	4618	7369	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	photos/Albero/4618/IMG_1552_360.jpeg	\N	581	2024	23/01/2024	\N	\N	Sempreverde	1	0
661	0101000020110F000026AAB7162282234147C9ABB72C685041	582	4619	7371	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; processionaria - Traumatocampa pityocampa; tagli impropri;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Recinzione;	\N	photos/Albero/4619/IMG_1553_361.jpeg	\N	582	2024	23/01/2024	\N	\N	Sempreverde	1	0
662	0101000020110F00001FBFB7F9F4862341399CF98B01655041	583	290	548	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\548.JPG	\N	583	2018	25/09/2018	\N	\N	Caduca	1	0
663	0101000020110F00002EFF211D32822341700855782A685041	584	4620	7368	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE D	\N	branche con ferite; processionaria - Traumatocampa pityocampa;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Recinzione;	\N	photos/Albero/4620/IMG_1551_359.jpeg	\N	584	2024	23/01/2024	\N	\N	Sempreverde	1	0
664	0101000020110F00004FCC7AE1198223419EEFA79E2C685041	585	4621	7372	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	-1	-	0	\N	-	0	\N	2024-01-23	6	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Mediocre	CLASSE D	\N	branche codominanti; branche con ferite; processionaria - Traumatocampa pityocampa; tagli impropri;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	photos/Albero/4621/IMG_1525_338.jpeg	\N	585	2024	23/01/2024	\N	\N	Sempreverde	1	0
665	0101000020110F00009E245D6326822341C2A38DEF2B685041	586	4622	7370	Albero	PINUS HALEPENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	-1	-	0	\N	-	0	\N	2024-01-23	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE D	\N	branche con ferite; processionaria - Traumatocampa pityocampa; tagli impropri;	\N	\N	capitozzatura; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	photos/Albero/4622/IMG_1524_337.jpeg	\N	586	2024	23/01/2024	\N	\N	Sempreverde	1	0
666	0101000020110F0000CB10C77A22822341F70148732D685041	587	4623	7373	Albero	FICUS ELASTICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-24	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Recinzione;	\N	desktop/Foto\\7373.JPG	\N	587	2019	24/01/2019	\N	\N	Sempreverde	1	0
667	0101000020110F0000E140481680812341AC90F2312B685041	588	4624	7377	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7377.JPG	\N	588	2019	24/01/2019	\N	\N	Sempreverde	1	0
668	0101000020110F00008FAA26B8458123413659A32429685041	589	4625	7378	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7378.JPG	\N	589	2019	24/01/2019	\N	\N	Sempreverde	1	0
669	0101000020110F00005A2A6F971D812341BDA9489524685041	590	4626	7379	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7379.JPG	\N	590	2019	24/01/2019	\N	\N	Sempreverde	1	0
670	0101000020110F00001DC9E5FF0E812341F0332EE623685041	591	4627	7380	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7380.JPG	\N	591	2019	24/01/2019	\N	\N	Sempreverde	1	0
671	0101000020110F00006BB75D6800812341EDBB226421685041	592	4628	7381	Palma	PHOENIX CANARIENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7381.JPG	\N	592	2019	24/01/2019	\N	\N	Sempreverde	1	0
672	0101000020110F0000D28C45F31C822341594C6C9C3B685041	593	4629	7384	Albero	EUCALYPTUS CAMALDULENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-23	3	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	ferite; strozzatura;	\N	\N	\N	\N	\N	Sede Stradale;	\N	photos/Albero/4629/IMG_1555_363.jpeg	\N	593	2024	23/01/2024	\N	\N	Sempreverde	1	0
673	0101000020110F000043E735C61E8223414243FF343D685041	594	4630	7385	Albero	EUCALYPTUS CAMALDULENSIS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-23	3	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	ferite; strozzatura;	\N	\N	\N	\N	\N	Sede Stradale;	\N	photos/Albero/4630/IMG_1554_362.jpeg	\N	594	2024	23/01/2024	\N	\N	Sempreverde	1	0
674	0101000020110F00008DD13ACA5C8223410C76C38044685041	595	4631	7386	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7386.JPG	\N	595	2019	24/01/2019	\N	\N	Caduca	1	0
675	0101000020110F0000A79196DA70822341F46C561946685041	596	4632	7387	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Lampione;	\N	desktop/Foto\\7387.JPG	\N	596	2019	24/01/2019	\N	\N	Caduca	1	0
676	0101000020110F0000BEA4318ADE8223415D6DC52C2C685041	597	4633	7389	Albero	CALLISTEMON CITRINUS	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7389.JPG	\N	597	2019	24/01/2019	\N	\N	-	1	0
677	0101000020110F00006AD95ADFC4822341F5D6C08C29685041	598	4634	7390	Albero	LIGUSTRUM JAPONICA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Magenta	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7390.JPG	\N	598	2019	24/01/2019	\N	\N	Sempreverde	1	0
678	0101000020110F000046088FA6D8822341698CD6F507685041	599	4635	7396	Albero	CATALPA BIGNONIOIDES	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede;	\N	desktop/Foto\\7396.JPG	\N	599	2019	24/01/2019	\N	\N	Caduca	1	0
679	0101000020110F0000FE0E4591A98723411F2E39EA17655041	600	291	575	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\575.JPG	\N	600	2018	25/09/2018	\N	\N	Caduca	1	0
680	0101000020110F00003563D144DC822341910F7A2E0C685041	601	4636	7397	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede;	\N	desktop/Foto\\7397.JPG	\N	601	2019	24/01/2019	\N	\N	Caduca	1	0
681	0101000020110F00000BEF72E1B68223413D61891315685041	602	4637	7398	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Marciapiede; Recinzione;	\N	desktop/Foto\\7398.JPG	\N	602	2019	24/01/2019	\N	\N	Caduca	1	0
682	0101000020110F0000A3E9ECA4AF822341486DE26E16685041	603	4638	7399	Ceppaia	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-04-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3	\N	\N	\N	\N	\N	\N	\N	Lampione; Marciapiede; Recinzione;	\N	photos/Albero/4638/44_WhatsApp Image 2019-04-10 at 16.56.51 (18).jpeg	\N	603	2019	10/04/2019	\N	\N	Caduca	2	0
683	0101000020110F000006D84787A8822341D53E1D7B17685041	604	4639	7400	Albero	POPULUS NIGRA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-23	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Pessimo	CLASSE D	\N	branche codominanti; branche con ferite;	\N	\N	carie; cercine di legatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione;	\N	photos/Albero/4639/IMG_1575_397.jpeg	\N	604	2024	23/01/2024	\N	\N	Caduca	1	0
684	0101000020110F000002F1BA5EAC8123414DF8A5500B685041	605	4640	7402	Albero	OLEA EUROPAEA	CORVO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Bezzecca	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7402.JPG	\N	605	2019	24/01/2019	\N	\N	Sempreverde	1	0
685	0101000020110F0000A2D11D0438752341E0675C56726F5041	606	4641	7586	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7586.JPG	\N	606	2019	26/01/2019	\N	\N	-	1	0
686	0101000020110F00005BD3BCA3367523410F971C43736F5041	607	4642	7587	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	607	2019	26/01/2019	\N	\N	-	1	0
687	0101000020110F0000C6504EB438752341F52D7382746F5041	608	4643	7588	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7588.JPG	\N	608	2019	26/01/2019	\N	\N	-	1	0
688	0101000020110F00007AA52C933475234139D1AE5E756F5041	609	4644	7589	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7589.JPG	\N	609	2019	26/01/2019	\N	\N	-	1	0
689	0101000020110F000043C5380F3C75234139D1AE5E756F5041	610	4645	7590	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7590.JPG	\N	610	2019	26/01/2019	\N	\N	-	1	0
690	0101000020110F00000CE5448B4375234139D1AE5E756F5041	611	4646	7591	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	611	2019	26/01/2019	\N	\N	-	1	0
691	0101000020110F000004215980477523417CED9911756F5041	612	4647	7592	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	612	2019	26/01/2019	\N	\N	-	1	0
692	0101000020110F000007CE19414A752341791EDC19756F5041	613	4648	7593	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE D	3C	branche con ferite; seccume diffuso;	\N	\N	\N	\N	pianta dominata;	\N	\N	\N	desktop/Foto\\7593.JPG	\N	613	2019	26/01/2019	\N	\N	-	1	0
693	0101000020110F00000B7BDA014D752341764F1E22756F5041	614	4649	7594	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE D	3C	branche con ferite; seccume diffuso;	\N	\N	\N	\N	pianta filata; pianta dominata;	\N	\N	\N	\N	\N	614	2019	26/01/2019	\N	\N	-	1	0
694	0101000020110F00000F289BC24F75234165AA602A756F5041	615	4650	7595	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	615	2019	26/01/2019	\N	\N	-	1	0
695	0101000020110F000013D55B835275234162DBA232756F5041	616	4651	7596	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE D	3C	branche con ferite; seccume diffuso; branche codominanti;	\N	\N	\N	\N	pianta dominata;	\N	\N	\N	desktop/Foto\\7596.JPG	\N	616	2019	26/01/2019	\N	\N	-	1	0
696	0101000020110F00006B7D9140B1872341AF94652619655041	617	292	576	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\576.JPG	\N	617	2018	25/09/2018	\N	\N	Caduca	1	0
697	0101000020110F0000AD6EF55C5875234147C9AB53756F5041	618	4652	7597	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	\N	\N	618	2019	26/01/2019	\N	\N	-	1	0
698	0101000020110F0000A4AA09525C752341E8137998746F5041	619	4653	7598	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE D	3C	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	pianta dominata;	\N	\N	\N	desktop/Foto\\7598.JPG	\N	619	2019	26/01/2019	\N	\N	-	1	0
699	0101000020110F000017821C4455752341B21188CF746F5041	620	4654	7599	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	620	2019	26/01/2019	\N	\N	-	1	0
700	0101000020110F00009049468E4E752341AC730CE0746F5041	621	4655	7600	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	621	2019	26/01/2019	\N	\N	-	1	0
701	0101000020110F0000425BCED54C752341EEB1F487746F5041	622	4656	7601	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	622	2019	26/01/2019	\N	\N	-	1	0
702	0101000020110F00004772F91F46752341543A581F746F5041	623	4657	7602	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	623	2019	26/01/2019	\N	\N	-	1	0
703	0101000020110F0000A9C1349C5575234182397AC4726F5041	624	4658	7603	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7603.JPG	\N	624	2019	26/01/2019	\N	\N	-	1	0
704	0101000020110F0000AE47E10A6E7523413E3F8C06736F5041	625	4659	7604	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7604.JPG	\N	625	2019	26/01/2019	\N	\N	-	1	0
705	0101000020110F0000836E2F79767523412AA91322736F5041	626	4660	7605	Albero	CUPRESSUS SP.	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	7	4) 16m = 23m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7605.JPG	\N	626	2019	26/01/2019	\N	\N	-	1	0
706	0101000020110F00007C7E18E15875234175C8CDF8736F5041	627	4661	7606	Albero	PINUS HALEPENSIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	10	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE D	3C	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata; ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7606.JPG	\N	627	2019	26/01/2019	\N	\N	Sempreverde	1	0
707	0101000020110F0000B70BCD156A752341543A581F746F5041	628	4662	7607	Albero	PINUS HALEPENSIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	10	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; seccume diffuso; branche con ginocchiatura;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7607.JPG	\N	628	2019	26/01/2019	\N	\N	Sempreverde	1	0
708	0101000020110F0000AB048BD36175234175C8CDF8736F5041	629	4663	7608	Albero	CEDRUS ATLANTICA	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	10	4) 16m = 23m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	629	2019	26/01/2019	\N	\N	Sempreverde	1	0
709	0101000020110F0000B79C4BB12D75234118433985756F5041	630	4664	7609	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	6	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE D	3C	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7609.JPG	\N	630	2019	26/01/2019	\N	\N	Caduca	1	0
710	0101000020110F00006F9EEA502C7523412A526140746F5041	631	4665	7610	Albero	CELTIS AUSTRALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata; cercine di legatura;	\N	\N	\N	\N	\N	\N	\N	631	2019	26/01/2019	\N	\N	Caduca	1	0
711	0101000020110F0000CAFD0ED52C752341C5FEB295736F5041	632	4666	7611	Albero	CELTIS AUSTRALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	632	2019	26/01/2019	\N	\N	Caduca	1	0
712	0101000020110F0000A6ED5F297775234147C9AB53756F5041	633	4667	7612	Albero	CELTIS AUSTRALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	633	2019	26/01/2019	\N	\N	Caduca	1	0
713	0101000020110F0000B29DEFC7DC872341E92B484B1B655041	634	293	316	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\316.JPG	\N	634	2018	24/09/2018	\N	\N	Sempreverde	1	0
714	0101000020110F0000CD3B4E31F374234181B22961686F5041	635	4668	7613	Albero	PRUNUS ARMENIACA	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7613.JPG	\N	635	2019	26/01/2019	\N	\N	Caduca	1	0
715	0101000020110F00003FA9F639047523411DE6CBDF686F5041	636	4669	7614	Albero	EUCALYPTUS CAMALDULENSIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	0	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE C/D	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	Radici superficiali;	\N	\N	Edificio;	\N	desktop/Foto\\7614.JPG	\N	636	2019	26/01/2019	\N	\N	Sempreverde	1	0
716	0101000020110F000051A04F741B752341C555653D696F5041	637	4670	7615	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	SCUOLA ALDISIO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via De Gasperi	Gruppo	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-26	1.7	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	Radici superficiali;	\N	\N	Edificio;	\N	desktop/Foto\\7615.JPG	\N	637	2019	26/01/2019	\N	\N	Sempreverde	1	0
717	0101000020110F00008143A8C265742341AAD4EC197E705041	638	4671	7758	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7758.JPG	\N	638	2019	28/01/2019	\N	\N	Sempreverde	1	0
718	0101000020110F00004BB0388C6874234111363C3B7E705041	639	4672	7759	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7759.JPG	\N	639	2019	28/01/2019	\N	\N	Sempreverde	1	0
719	0101000020110F00008ACDC7556B7423416AC18B5C7E705041	640	4673	7760	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7760.JPG	\N	640	2019	28/01/2019	\N	\N	Sempreverde	1	0
720	0101000020110F0000C8EA561F6E742341D122DB7D7E705041	641	4674	7761	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7761.JPG	\N	641	2019	28/01/2019	\N	\N	Sempreverde	1	0
721	0101000020110F00009357E7E87074234138842A9F7E705041	642	4675	7762	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7762.JPG	\N	642	2019	28/01/2019	\N	\N	Sempreverde	1	0
722	0101000020110F00005DC477B273742341910F7AC07E705041	643	4676	7763	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7763.JPG	\N	643	2019	28/01/2019	\N	\N	Sempreverde	1	0
723	0101000020110F00009CE1067C76742341F870C9E17E705041	644	4677	7764	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	644	2019	28/01/2019	\N	\N	Sempreverde	1	0
724	0101000020110F0000DAFE9545797423415FD218037F705041	645	4678	7765	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7765.JPG	\N	645	2019	28/01/2019	\N	\N	Sempreverde	1	0
725	0101000020110F0000A56B260F7C742341C63368247F705041	646	4679	7766	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	646	2019	28/01/2019	\N	\N	Sempreverde	1	0
726	0101000020110F00006FD8B6D87E7423411FBFB7457F705041	647	4680	7767	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7767.JPG	\N	647	2019	28/01/2019	\N	\N	Sempreverde	1	0
727	0101000020110F0000AEF545A281742341862007677F705041	648	4681	7768	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	648	2019	28/01/2019	\N	\N	Sempreverde	1	0
728	0101000020110F0000EC12D56B84742341ED8156887F705041	649	4682	7769	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	649	2019	28/01/2019	\N	\N	Sempreverde	1	0
729	0101000020110F0000B77F653587742341450DA6A97F705041	650	4683	7770	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	650	2019	28/01/2019	\N	\N	Sempreverde	1	0
730	0101000020110F0000F5F3A672B3872341C5FEB2191C655041	651	294	570	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	contrafforti scoperti;	\N	inclinazione ingiustificata;	\N	\N	\N	Cartellonistica; Sede Stradale; Marciapiede; Utenze Sotterranee;	\N	desktop/Foto\\570.JPG	\N	651	2018	25/09/2018	\N	\N	Caduca	1	0
731	0101000020110F000081ECF5FE89742341AD6EF5CA7F705041	652	4684	7771	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	652	2019	28/01/2019	\N	\N	Sempreverde	1	0
732	0101000020110F0000C00985C88C74234114D044EC7F705041	653	4685	7772	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	653	2019	28/01/2019	\N	\N	Sempreverde	1	0
733	0101000020110F0000FE2614928F7423417B31940D80705041	654	4686	7773	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	654	2019	28/01/2019	\N	\N	Sempreverde	1	0
734	0101000020110F0000C993A45B92742341D3BCE32E80705041	655	4687	7774	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7774.JPG	\N	655	2019	28/01/2019	\N	\N	Sempreverde	1	0
735	0101000020110F000093003525957423413A1E335080705041	656	4688	7775	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7775.JPG	\N	656	2019	28/01/2019	\N	\N	Sempreverde	1	0
736	0101000020110F0000D21DC4EE97742341A27F827180705041	657	4689	7776	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7776.JPG	\N	657	2019	28/01/2019	\N	\N	Sempreverde	1	0
737	0101000020110F0000103B53B89A742341FA0AD29280705041	658	4690	7777	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7777.JPG	\N	658	2019	28/01/2019	\N	\N	Sempreverde	1	0
738	0101000020110F0000DBA7E3819D742341616C21B480705041	659	4691	7778	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7778.JPG	\N	659	2019	28/01/2019	\N	\N	Sempreverde	1	0
739	0101000020110F00002A52611CC6872341DC68000D1F655041	660	295	581	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Marciapiede; Utenze Sotterranee;	\N	desktop/Foto\\581.JPG	\N	660	2018	25/09/2018	\N	\N	Caduca	1	0
740	0101000020110F0000D2E3F716B07423418BFD65B181705041	661	4692	7779	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7779.JPG	\N	661	2019	28/01/2019	\N	\N	Sempreverde	1	0
741	0101000020110F000062156F74B574234105C078F681705041	662	4693	7780	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7780.JPG	\N	662	2019	28/01/2019	\N	\N	Sempreverde	1	0
742	0101000020110F0000F146E6D1BA74234180828B3B82705041	663	4694	7781	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7781.JPG	\N	663	2019	28/01/2019	\N	\N	Sempreverde	1	0
743	0101000020110F000081785D2FC0742341091B9E8082705041	664	4695	7782	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	664	2019	28/01/2019	\N	\N	Sempreverde	1	0
744	0101000020110F000011AAD48CC574234183DDB0C582705041	665	4696	7783	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	665	2019	28/01/2019	\N	\N	Sempreverde	1	0
745	0101000020110F0000A1DB4BEACA742341FD9FC30A83705041	666	4697	7784	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	666	2019	28/01/2019	\N	\N	Sempreverde	1	0
746	0101000020110F0000BC5CC447D07423417862D64F83705041	667	4698	7785	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	667	2019	28/01/2019	\N	\N	Sempreverde	1	0
747	0101000020110F00004C8E3BA5D5742341F224E99483705041	668	4699	7786	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	668	2019	28/01/2019	\N	\N	Sempreverde	1	0
748	0101000020110F0000DBBFB202DB7423416DE7FBD983705041	669	4700	7787	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	669	2019	28/01/2019	\N	\N	Sempreverde	1	0
749	0101000020110F00006BF12960E0742341F67F0E1F84705041	670	4701	7788	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	670	2019	28/01/2019	\N	\N	Sempreverde	1	0
750	0101000020110F0000FB22A1BDE57423417042216484705041	671	4702	7789	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7789.JPG	\N	671	2019	28/01/2019	\N	\N	Sempreverde	1	0
751	0101000020110F00008B54181BEB742341EA0434A984705041	672	4703	7790	Albero	PITTOSPORUM ONDULATO	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	2	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	672	2019	28/01/2019	\N	\N	Sempreverde	1	0
752	0101000020110F00002C82FFED3D7123418A3C49963C6E5041	673	4704	7954	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	673	2019	28/01/2019	\N	\N	Sempreverde	1	0
753	0101000020110F00000E4A9899CB87234132C9C8DF1F655041	674	296	582	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	Sede Stradale; Marciapiede;	\N	desktop/Foto\\582.JPG	\N	674	2018	25/09/2018	\N	\N	Caduca	1	0
754	0101000020110F00006B7D910042712341006F81FA3A6E5041	675	4705	7955	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7955.JPG	\N	675	2019	28/01/2019	\N	\N	Sempreverde	1	0
755	0101000020110F0000AB7823134671234177A1B95E396E5041	676	4706	7956	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7956.JPG	\N	676	2019	28/01/2019	\N	\N	Sempreverde	1	0
756	0101000020110F0000EB73B5254A712341EDD3F1C2376E5041	677	4707	7957	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7957.JPG	\N	677	2019	28/01/2019	\N	\N	Sempreverde	1	0
757	0101000020110F00009F1F46384E71234164062A27366E5041	678	4708	7958	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7958.JPG	\N	678	2019	28/01/2019	\N	\N	Sempreverde	1	0
758	0101000020110F0000DF1AD84A52712341DA38628B346E5041	679	4709	7959	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7959.JPG	\N	679	2019	28/01/2019	\N	\N	Sempreverde	1	0
759	0101000020110F00001E166A5D56712341516B9AEF326E5041	680	4710	7960	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7960.JPG	\N	680	2019	28/01/2019	\N	\N	Sempreverde	1	0
760	0101000020110F00005E11FC6F5A712341C79DD253316E5041	681	4711	7961	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7961.JPG	\N	681	2019	28/01/2019	\N	\N	Sempreverde	1	0
761	0101000020110F00009E0C8E825E7123413ED00AB82F6E5041	682	4712	7962	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7962.JPG	\N	682	2019	28/01/2019	\N	\N	Sempreverde	1	0
762	0101000020110F0000DD07209562712341B402431C2E6E5041	683	4713	7963	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7963.JPG	\N	683	2019	28/01/2019	\N	\N	Sempreverde	1	0
763	0101000020110F00001D03B2A7667123412B357B802C6E5041	684	4714	7964	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7964.JPG	\N	684	2019	28/01/2019	\N	\N	Sempreverde	1	0
764	0101000020110F0000D1AE42BA6A7123419291B3E42A6E5041	685	4715	7965	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7965.JPG	\N	685	2019	28/01/2019	\N	\N	Sempreverde	1	0
765	0101000020110F000011AAD4CC6E71234109C4EB48296E5041	686	4716	7966	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7966.JPG	\N	686	2019	28/01/2019	\N	\N	Sempreverde	1	0
766	0101000020110F000051A566DF727123417FF623AD276E5041	687	4717	7967	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7967.JPG	\N	687	2019	28/01/2019	\N	\N	Sempreverde	1	0
767	0101000020110F000090A0F8F176712341F6285C11266E5041	688	4718	7968	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7968.JPG	\N	688	2019	28/01/2019	\N	\N	Sempreverde	1	0
768	0101000020110F0000D09B8A047B7123416C5B9475246E5041	689	4719	7969	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7969.JPG	\N	689	2019	28/01/2019	\N	\N	Sempreverde	1	0
769	0101000020110F00000F971C177F712341E38DCCD9226E5041	690	4720	7970	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7970.JPG	\N	690	2019	28/01/2019	\N	\N	Sempreverde	1	0
770	0101000020110F00009F0260BCD287234168AED3F820655041	691	297	583	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	insetti lignivori; lesione aperta;	\N	\N	\N	Sede Stradale; Marciapiede;	\N	desktop/Foto\\583.JPG	\N	691	2018	25/09/2018	\N	\N	Caduca	1	0
771	0101000020110F00004F92AE298371234159C0043E216E5041	692	4721	7971	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7971.JPG	\N	692	2019	28/01/2019	\N	\N	Sempreverde	1	0
772	0101000020110F0000033E3F3C87712341D0F23CA21F6E5041	693	4722	7972	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7972.JPG	\N	693	2019	28/01/2019	\N	\N	Sempreverde	1	0
773	0101000020110F00004339D14E8B712341462575061E6E5041	694	4723	7973	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7973.JPG	\N	694	2019	28/01/2019	\N	\N	Sempreverde	1	0
774	0101000020110F0000833463618F712341BC57AD6A1C6E5041	695	4724	7974	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7974.JPG	\N	695	2019	28/01/2019	\N	\N	Sempreverde	1	0
775	0101000020110F0000C22FF57393712341338AE5CE1A6E5041	696	4725	7975	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7975.JPG	\N	696	2019	28/01/2019	\N	\N	Sempreverde	1	0
776	0101000020110F00008D976EE2347223414B766CBE056E5041	697	4726	7976	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7976.JPG	\N	697	2019	28/01/2019	\N	\N	Sempreverde	1	0
777	0101000020110F00007D790166377223419817600D046E5041	698	4727	7977	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7977.JPG	\N	698	2019	28/01/2019	\N	\N	Sempreverde	1	0
778	0101000020110F0000A306D38041722341C5724BAD026E5041	699	4728	7978	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7978.JPG	\N	699	2019	28/01/2019	\N	\N	Sempreverde	1	0
779	0101000020110F0000EA78CC104872234188F4DBDB006E5041	700	4729	7979	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7979.JPG	\N	700	2019	28/01/2019	\N	\N	Sempreverde	1	0
780	0101000020110F000010E9B70F497223414B766C0AFF6D5041	701	4730	7980	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7980.JPG	\N	701	2019	28/01/2019	\N	\N	Sempreverde	1	0
781	0101000020110F0000FFCA4A934B722341E9482E49FD6D5041	702	4731	7981	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7981.JPG	\N	702	2019	28/01/2019	\N	\N	Sempreverde	1	0
782	0101000020110F0000253B36924C722341C00985B8FB6D5041	703	4732	7982	Albero	QUERCUS ILEX	CATANZARO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Lombardi	Filare	5	Prato margine strada	0	0	0	-	0	\N	Tipico	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7982.JPG	\N	703	2019	28/01/2019	\N	\N	Sempreverde	1	0
783	0101000020110F0000C6DCB56494702341ED478A527E715041	1010	5020	7915	Albero	NERIUM OLEANDER	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7915.JPG	\N	1010	2019	28/01/2019	\N	\N	Sempreverde	1	0
784	0101000020110F000018601F7D417023414E6210B692715041	1011	5021	7921	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7921.JPG	\N	1011	2019	28/01/2019	\N	\N	Sempreverde	1	0
785	0101000020110F0000DB50318E36702341174850F091715041	1012	5022	7918	Albero	LIQUIDAMBAR STYRACIFLUA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	radici strozzanti;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7918.JPG	\N	1012	2019	28/01/2019	\N	\N	Caduca	1	0
786	0101000020110F0000F853E3353D702341F67AF72790715041	1013	5023	7919	Albero	LIQUIDAMBAR STYRACIFLUA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	radici strozzanti;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7919.JPG	\N	1013	2019	28/01/2019	\N	\N	Caduca	1	0
787	0101000020110F0000618E1E4F3B7023411557954B92715041	1014	5024	7920	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7920.JPG	\N	1014	2019	28/01/2019	\N	\N	Sempreverde	1	0
788	0101000020110F00000AA2EEB37A8823413D49BA7236655041	1015	316	618	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\618.JPG	\N	1015	2018	25/09/2018	\N	\N	Caduca	1	0
789	0101000020110F0000C9C8596839702341446E86FF91715041	1016	5025	7926	Palma	PHOENIX CANARIENSIS	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7926.JPG	\N	1016	2019	28/01/2019	\N	\N	Sempreverde	1	0
790	0101000020110F0000DB50318E36702341A11001538F715041	1017	5026	7927	Palma	PHOENIX CANARIENSIS	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Fioriera in muratura	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7927.JPG	\N	1017	2019	28/01/2019	\N	\N	Sempreverde	1	0
791	0101000020110F0000DEAB56D6F06F23412F51BDFD98715041	1018	5027	7903	Ceppaia	TILIA AMERICANA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2020-09-24	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione;	\N	photos/Albero/5027/thb_223_WhatsApp Image 2020-09-24 at 13.35.12.jpeg	\N	1018	2020	24/09/2020	\N	\N	Sempreverde	2	0
792	0101000020110F0000AF777F0C007023416C26DF8894715041	1019	5028	7905	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite;	\N	\N	capitozzatura; carie; cavit�; cercine di legatura; insetti lignivori;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7905.JPG	\N	1019	2019	28/01/2019	\N	\N	Sempreverde	1	0
793	0101000020110F000038BEF66C02702341BB7EC1F093715041	1020	5029	7906	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	\N	\N	\N	capitozzatura; carie; cavit�; cercine di legatura; insetti lignivori;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7906.JPG	\N	1020	2019	28/01/2019	\N	\N	Sempreverde	1	0
794	0101000020110F000033A7CB628C6F2341111956FB27725041	1021	5030	7929	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	0	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Manufatto; Camminamento;	\N	photos/Albero/5030/IMG_1695_452.jpeg	\N	1021	2024	24/01/2024	\N	\N	Sempreverde	1	0
795	0101000020110F0000740CC85E8E6F2341E258171D27725041	1022	5031	7930	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	0	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	rimozione del secco o spignatura	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	radici strozzanti;	\N	\N	\N	\N	\N	Manufatto; Camminamento;	\N	photos/Albero/5031/IMG_1696_453.jpeg	\N	1022	2024	24/01/2024	\N	\N	Sempreverde	1	0
796	0101000020110F00008F19A82CA76F2341D68BA16C1F725041	1023	5032	7932	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Manufatto; Pavimentazione; Edificio;	\N	photos/Albero/5032/IMG_1697_454.jpeg	\N	1023	2024	24/01/2024	\N	\N	Sempreverde	1	0
797	0101000020110F0000E2E99512B46F234182C5E14C1F725041	1024	5033	7933	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Manufatto; Pavimentazione; Edificio;	\N	photos/Albero/5033/IMG_1698_455.jpeg	\N	1024	2024	24/01/2024	\N	\N	Sempreverde	1	0
798	0101000020110F0000CD237FF0C46F234109F9A0EB1F725041	1025	5034	7934	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Manufatto; Pavimentazione; Edificio;	\N	photos/Albero/5034/IMG_1699_456.jpeg	\N	1025	2024	24/01/2024	\N	\N	Sempreverde	1	0
799	0101000020110F0000DE8E70DACF6F2341F775E04A20725041	1026	5035	7935	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Pavimentazione; Edificio;	\N	photos/Albero/5035/IMG_1700_457.jpeg	\N	1026	2024	24/01/2024	\N	\N	Sempreverde	1	0
800	0101000020110F000050C763C6D96F2341912C608A20725041	1027	5036	7936	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Pavimentazione; Edificio;	\N	photos/Albero/5036/IMG_1701_458.jpeg	\N	1027	2024	24/01/2024	\N	\N	Sempreverde	1	0
801	0101000020110F000043AD69CED56F23416C26DF4821725041	1028	5037	7937	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Pavimentazione;	\N	photos/Albero/5037/IMG_1702_459.jpeg	\N	1028	2024	24/01/2024	\N	\N	Sempreverde	1	0
802	0101000020110F0000390B7BEAC76F23417EA99FE920725041	1029	5038	7938	Albero	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-24	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Pavimentazione;	\N	photos/Albero/5038/IMG_1703_460.jpeg	\N	1029	2024	24/01/2024	\N	\N	Sempreverde	1	0
803	0101000020110F0000AF9465C8D86F2341C0EC9E6821725041	1030	5039	7939	Ceppaia	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Pavimentazione;	\N	desktop/Foto\\7939.JPG	\N	1030	2019	28/01/2019	\N	\N	Sempreverde	2	0
804	0101000020110F0000BED9E636B76F23417E5704C71F725041	1031	5040	7940	Ceppaia	PINUS PINEA	SCUOLA PITERA'	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Pavimentazione;	\N	\N	\N	1031	2019	28/01/2019	\N	\N	Sempreverde	2	0
805	0101000020110F000084BBB3768E882341C66D340E39655041	1032	317	623	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\623.JPG	\N	1032	2018	25/09/2018	\N	\N	Caduca	1	0
842	0101000020110F000025068185497F2341F54A597E6D6A5041	1069	5075	8052	Albero	HIBISCUS SYRIACUS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8052.JPG	\N	1069	2019	29/01/2019	\N	\N	Caduca	1	0
806	0101000020110F000037FDD9FF4E6F2341C68A1A403F725041	1033	5041	7943	Albero	PINUS PINEA	PONTEGRANDE	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2024-11-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Manufatto; Sede Stradale;	\N	desktop/Foto\\7943.JPG	\N	1033	2024	25/11/2024	\N	\N	Sempreverde	1	0
807	0101000020110F00008CDB6820616F2341DF4F8D5741725041	1034	5042	7944	Albero	PINUS PINEA	PONTEGRANDE	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-11-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche secche; seccume diffuso;	radici strozzanti;	\N	\N	\N	\N	\N	Sede Stradale; Cavi Aerei; Manufatto;	\N	desktop/Foto\\7944.JPG	\N	1034	2024	25/11/2024	\N	\N	Sempreverde	1	0
808	0101000020110F000098DD93275A6F2341456458A744725041	1035	5043	7945	Albero	SCHINUS MOLLE	PONTEGRANDE	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Camminamento;	\N	desktop/Foto\\7945.JPG	\N	1035	2019	28/01/2019	\N	\N	Sempreverde	1	0
809	0101000020110F0000FFCF619E396F234178EE3DC843725041	1036	5044	7946	Fallanza	SCHINUS MOLLE	PONTEGRANDE	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Camminamento;	\N	\N	\N	1036	2019	28/01/2019	\N	\N	Sempreverde	3	0
810	0101000020110F0000302FC02E536F234194DE37A83F725041	1037	5045	7947	Ceppaia	PINUS PINEA	PONTEGRANDE	-	Scuola	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Gattoleo	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Camminamento;	\N	desktop/Foto\\7947.JPG	\N	1037	2019	28/01/2019	\N	\N	Sempreverde	2	0
811	0101000020110F0000166A4D632A8023416AC18BAE466A5041	1038	5046	8021	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Angitola	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\8021.JPG	\N	1038	2019	29/01/2019	\N	\N	Sempreverde	1	0
812	0101000020110F0000FAB83684218023412E39EE7A466A5041	1039	5047	8022	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Angitola	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\8022.JPG	\N	1039	2019	29/01/2019	\N	\N	Sempreverde	1	0
813	0101000020110F0000F241CFA6927F2341B806B6E25C6A5041	1040	5048	8023	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8023.JPG	\N	1040	2019	29/01/2019	\N	\N	-	1	0
814	0101000020110F00008AB0E109917F2341008C67185E6A5041	1041	5049	8024	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8024.JPG	\N	1041	2019	29/01/2019	\N	\N	Caduca	1	0
815	0101000020110F000061376C3B907F2341DFFDF1E85F6A5041	1042	5050	8025	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; torsioni;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8025.JPG	\N	1042	2019	29/01/2019	\N	\N	-	1	0
816	0101000020110F00001B6492018D7F2341C269C1A1626A5041	1043	5051	8026	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8026.JPG	\N	1043	2019	29/01/2019	\N	\N	-	1	0
817	0101000020110F00008A592F968A7F2341DC63E9A5646A5041	1044	5052	8027	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8027.JPG	\N	1044	2019	29/01/2019	\N	\N	Caduca	1	0
818	0101000020110F0000F94ECC2A887F2341F65D11AA666A5041	1045	5053	8028	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8028.JPG	\N	1045	2019	29/01/2019	\N	\N	-	1	0
819	0101000020110F00004486555C877F234191442F2D686A5041	1046	5054	8029	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8029.JPG	\N	1046	2019	29/01/2019	\N	\N	Caduca	1	0
820	0101000020110F0000674469BF857F23411D554DB0696A5041	1047	5055	8030	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8030.JPG	\N	1047	2019	29/01/2019	\N	\N	-	1	0
821	0101000020110F0000D6390654837F23410A9DD7806B6A5041	1048	5056	8031	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8031.JPG	\N	1048	2019	29/01/2019	\N	\N	Caduca	1	0
822	0101000020110F000015747B9995882341A913D0383A655041	1049	318	624	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\624.JPG	\N	1049	2018	25/09/2018	\N	\N	Caduca	1	0
823	0101000020110F0000E3AAB2CF747F2341FD9FC37E6A6A5041	1050	5057	8032	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8032.JPG	\N	1050	2019	29/01/2019	\N	\N	-	1	0
824	0101000020110F00009773299E757F2341B51A1249696A5041	1051	5058	8033	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8033.JPG	\N	1051	2019	29/01/2019	\N	\N	-	1	0
825	0101000020110F0000287E8C09787F23411A34F4C5676A5041	1052	5059	8034	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8034.JPG	\N	1052	2019	29/01/2019	\N	\N	-	1	0
826	0101000020110F00006E5166437B7F2341003ACCC1656A5041	1053	5060	8035	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8035.JPG	\N	1053	2019	29/01/2019	\N	\N	Caduca	1	0
827	0101000020110F0000FF5BC9AE7D7F234187E1236E626A5041	1054	5061	8036	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8036.JPG	\N	1054	2019	29/01/2019	\N	\N	-	1	0
828	0101000020110F0000452FA3E8807F23418D9C859B5F6A5041	1055	5062	8037	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8037.JPG	\N	1055	2019	29/01/2019	\N	\N	Caduca	1	0
829	0101000020110F0000D6390654837F2341AE2AFBCA5D6A5041	1056	5063	8038	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8038.JPG	\N	1056	2019	29/01/2019	\N	\N	-	1	0
830	0101000020110F0000B37BF2F0847F23414FCC7A7B5C6A5041	1057	5064	8039	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Chiesa	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\8039.JPG	\N	1057	2019	29/01/2019	\N	\N	Caduca	1	0
831	0101000020110F0000488AC860387F2341EC4CA181686A5041	1058	5065	8042	Albero	CEDRUS ATLANTICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	non movimentare il terreno\n	branche con ferite; branche con fratture/incrinature; branche secche;	\N	\N	capitozzatura; ferite;	\N	\N	\N	Cartellonistica; Cavi Aerei; Manufatto; Illuminazione pubblica; Recinzione;	\N	photos/Albero/5065/IMG_1884_552.jpeg	\N	1058	2024	25/01/2024	\N	\N	Sempreverde	1	0
832	0101000020110F00008ECC23DF3A7F2341CF83BB59686A5041	1059	5066	8043	Albero	CEDRUS ATLANTICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	non movimentare il terreno	branche con ferite; branche con fratture/incrinature; branche secche;	contrafforti scoperti;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei; Manufatto;	\N	photos/Albero/5066/IMG_1886_548.jpeg	\N	1059	2024	25/01/2024	\N	\N	Sempreverde	1	0
833	0101000020110F0000EB56CFF9427F234122E010D8676A5041	1060	5067	8044	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1060	2019	29/01/2019	\N	\N	Sempreverde	1	0
834	0101000020110F0000B1E1E9E5487F2341C4995FE5686A5041	1061	5068	8045	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8045.JPG	\N	1061	2019	29/01/2019	\N	\N	Sempreverde	1	0
835	0101000020110F00008E06F056477F234192054C886A6A5041	1062	5069	8046	Albero	MAGNOLIA GRANDIFLORA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8046.JPG	\N	1062	2019	29/01/2019	\N	\N	Sempreverde	1	0
836	0101000020110F0000EB909B714F7F23417B31949F6B6A5041	1063	5070	8047	Palma	MAGNOLIA GRANDIFLORA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8047.JPG	\N	1063	2019	29/01/2019	\N	\N	Sempreverde	1	0
837	0101000020110F0000C8B5A1E24D7F23416666666A6D6A5041	1064	5071	8048	Albero	CEDRUS ATLANTICA "GLAUCA"	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	1064	2019	29/01/2019	\N	\N	Sempreverde	1	0
838	0101000020110F0000DF6C73A34C7F2341E86A2BC46D6A5041	1065	5072	8049	Albero	ACER SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite; branche secche; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Camminamento;	\N	\N	\N	1065	2019	29/01/2019	\N	\N	-	1	0
839	0101000020110F000082E2C7489D8823410E4A980B3B655041	1066	319	625	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\625.JPG	\N	1066	2018	25/09/2018	\N	\N	Caduca	1	0
840	0101000020110F00005F5E805D3D7F23419FE579426A6A5041	1067	5073	8050	Albero	HIBISCUS SYRIACUS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8050.JPG	\N	1067	2019	29/01/2019	\N	\N	Caduca	1	0
843	0101000020110F000048E17A144B7F2341A2EE03006E6A5041	1070	5076	8053	Albero	HIBISCUS SYRIACUS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8053.JPG	\N	1070	2019	29/01/2019	\N	\N	Caduca	1	0
844	0101000020110F00006AC18B0E9D7F2341E17F2B496F6A5041	1071	5077	8054	Albero	TAMARIX GALLICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	6	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Camminamento;	\N	desktop/Foto\\8054.JPG	\N	1071	2019	29/01/2019	\N	\N	Sempreverde	1	0
845	0101000020110F000081B22947A87F23419B0304856F6A5041	1072	5078	8055	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	6	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	ferite; strozzatura;	\N	\N	\N	\N	\N	Marciapiede; Cavi Aerei;	\N	desktop/Foto\\8055.JPG	\N	1072	2019	29/01/2019	\N	\N	Caduca	1	0
846	0101000020110F0000AF9465B8BE7F23411EFE9A24706A5041	1073	5079	8056	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	contrafforti scoperti;	\N	\N	\N	\N	\N	Marciapiede;	\N	desktop/Foto\\8056.JPG	\N	1073	2019	29/01/2019	\N	\N	-	1	0
847	0101000020110F000080608EAECD7F234175594C9C706A5041	1074	5080	8057	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8057.JPG	\N	1074	2019	29/01/2019	\N	\N	Caduca	1	0
848	0101000020110F0000AF25E4E3DD7F23414CA60A00716A5041	1075	5081	8058	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8058.JPG	\N	1075	2019	29/01/2019	\N	\N	Caduca	1	0
849	0101000020110F0000F31FD2FF75802341FE65F7B6786A5041	1076	5082	8062	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con ginocchiatura; branche protese;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Recinzione; Camminamento;	\N	\N	\N	1076	2019	29/01/2019	\N	\N	Sempreverde	1	0
850	0101000020110F0000677E35679B802341320395D17A6A5041	1077	5083	8064	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con ginocchiatura;	\N	\N	ferite;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8064.JPG	\N	1077	2019	29/01/2019	\N	\N	Sempreverde	1	0
851	0101000020110F000067B801DFA7802341B5FD2B717B6A5041	1078	5084	8065	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con ginocchiatura;	\N	\N	ferite;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8065.JPG	\N	1078	2019	29/01/2019	\N	\N	Sempreverde	1	0
852	0101000020110F0000957D5714B880234143E21E857B6A5041	1079	5085	8066	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con ginocchiatura;	\N	\N	cercine di legatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	\N	\N	1079	2019	29/01/2019	\N	\N	Sempreverde	1	0
853	0101000020110F00007EC68553B980234120240B1E7A6A5041	1080	5086	8067	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con ginocchiatura;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\8067.JPG	\N	1080	2019	29/01/2019	\N	\N	Sempreverde	1	0
854	0101000020110F000021020E718C80234120240B1E7A6A5041	1081	5087	8063	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con ginocchiatura; branche protese;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Recinzione; Arredo urbano; Camminamento;	\N	desktop/Foto\\8063.JPG	\N	1081	2019	29/01/2019	\N	\N	Sempreverde	1	0
855	0101000020110F0000C66D34100D81234162F888E2796A5041	1082	5088	8069	Ceppaia	ACER SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2020-01-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8069.JPG	\N	1082	2020	25/01/2020	\N	\N	-	2	0
856	0101000020110F0000E292E3AECD8623411B6492F7F4645041	1083	20	231	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\231.JPG	\N	1083	2018	24/09/2018	\N	\N	Sempreverde	1	0
857	0101000020110F0000BBED42E34F882341FBAE081633655041	1084	320	628	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Marciapiede; Edificio;	\N	desktop/Foto\\628.JPG	\N	1084	2018	25/09/2018	\N	\N	Caduca	1	0
858	0101000020110F0000F4893CA917812341C7293A5A7A6A5041	1085	5089	8070	Ceppaia	ACER SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2020-01-23	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8070.JPG	\N	1085	2020	23/01/2020	\N	\N	-	2	0
859	0101000020110F000052D5048162752341D5213737746F5041	780	4804	7635	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	780	2019	26/01/2019	\N	\N	Sempreverde	2	0
860	0101000020110F0000CF49EFAB60752341666B7DD5736F5041	781	4805	7636	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	781	2019	26/01/2019	\N	\N	Sempreverde	2	0
861	0101000020110F00002861A6CD5C752341601F9D32736F5041	782	4806	7637	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7637.JPG	\N	782	2019	26/01/2019	\N	\N	Sempreverde	2	0
862	0101000020110F00007BA015285A7523410586AC4C736F5041	783	4807	7638	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7638.JPG	\N	783	2019	26/01/2019	\N	\N	Sempreverde	2	0
863	0101000020110F0000205ED7BF59752341753C66AE736F5041	784	4808	7639	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7639.JPG	\N	784	2019	26/01/2019	\N	\N	Sempreverde	2	0
864	0101000020110F000078B471C45A7523419F71E17E746F5041	785	4809	7640	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7640.JPG	\N	785	2019	26/01/2019	\N	\N	Sempreverde	2	0
865	0101000020110F00007689EA7D567523419F71E17E746F5041	786	4810	7641	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7641.JPG	\N	786	2019	26/01/2019	\N	\N	Sempreverde	2	0
866	0101000020110F0000D28C45035275234100529BE0746F5041	787	4811	7642	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	787	2019	26/01/2019	\N	\N	Sempreverde	2	0
867	0101000020110F0000D34D62204D7523411B9E5EA1736F5041	788	4812	7643	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	788	2019	26/01/2019	\N	\N	Sempreverde	2	0
868	0101000020110F0000CE3637764975234106819525736F5041	789	4813	7644	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7644.JPG	\N	789	2019	26/01/2019	\N	\N	Sempreverde	2	0
869	0101000020110F0000FE43FA0D49752341F085C92E756F5041	790	4814	7645	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Jannelli	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	790	2019	26/01/2019	\N	\N	Sempreverde	2	0
870	0101000020110F0000CA1AF5E07C762341D8B6289B726F5041	791	4815	7648	Palma	WASHINGTONIA FILIFERA	CATANZARO	-	Edifici comunali	II Centro Storico, Stadio, San Leonardo	Via Pascali	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7648.JPG	\N	791	2019	26/01/2019	\N	\N	Sempreverde	1	0
871	0101000020110F000002B7EE06777623412C7DE84A726F5041	792	4816	7649	Palma	WASHINGTONIA FILIFERA	CATANZARO	-	Edifici comunali	II Centro Storico, Stadio, San Leonardo	Via Pascali	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7649.JPG	\N	792	2019	26/01/2019	\N	\N	Sempreverde	1	0
872	0101000020110F000060B01BC6D8872341A2629CA31E655041	793	303	589	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\589.JPG	\N	793	2018	25/09/2018	\N	\N	Caduca	1	0
873	0101000020110F000000A94D6C70762341D200DE84726F5041	794	4817	7655	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Edifici comunali	II Centro Storico, Stadio, San Leonardo	Via Pascali	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	794	2019	26/01/2019	\N	\N	Sempreverde	1	0
874	0101000020110F00007C9BFE3C857623413815A9D0726F5041	795	4818	7647	Albero	CUPRESSUS SP.	CATANZARO	-	Edifici comunali	II Centro Storico, Stadio, San Leonardo	Via Pascali	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\7647.JPG	\N	795	2019	26/01/2019	\N	\N	-	1	0
875	0101000020110F00007E3A1E1386742341450DA67FDB6F5041	796	4819	7661	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\7661.JPG	\N	796	2019	26/01/2019	\N	\N	Sempreverde	1	0
876	0101000020110F00004DF8A59E8074234136C82447DC6F5041	797	4820	7662	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\7662.JPG	\N	797	2019	26/01/2019	\N	\N	Sempreverde	1	0
877	0101000020110F0000A7052F2A7B7423416F128340DD6F5041	798	4821	7663	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\7663.JPG	\N	798	2019	26/01/2019	\N	\N	Sempreverde	1	0
878	0101000020110F00000113B8B575742341183E22D6DD6F5041	799	4822	7664	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\7664.JPG	\N	799	2019	26/01/2019	\N	\N	Sempreverde	1	0
879	0101000020110F00003E05C008717423416D1CB184DE6F5041	800	4823	7665	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Camminamento; Pavimentazione;	\N	desktop/Foto\\7665.JPG	\N	800	2019	26/01/2019	\N	\N	Sempreverde	1	0
880	0101000020110F00008A027D52317423414AD23565EC6F5041	801	4824	7666	Albero	FICUS CARICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7666.JPG	\N	801	2019	26/01/2019	\N	\N	Caduca	1	0
881	0101000020110F0000E40F06DE2B742341E5B853C2ED6F5041	802	4825	7667	Albero	FICUS CARICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7667.JPG	\N	802	2019	26/01/2019	\N	\N	Caduca	1	0
882	0101000020110F0000522CB7C4BE732341C824230DEE6F5041	803	4826	7668	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Vinicio Cortese	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7668.JPG	\N	803	2019	26/01/2019	\N	\N	Sempreverde	1	0
883	0101000020110F000014CB2DBD07742341056EDD131B705041	804	4827	7670	Albero	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7670.JPG	\N	804	2019	26/01/2019	\N	\N	Sempreverde	1	0
884	0101000020110F000023F3C8BF1F742341821C94E419705041	805	4828	7672	Albero	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7672.JPG	\N	805	2019	26/01/2019	\N	\N	Sempreverde	1	0
885	0101000020110F0000404D2DDB2374234184D382C918705041	806	4829	7673	Ceppaia	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-02-01	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/4829/thb_256_WhatsApp Image 2020-02-01 at 14.01.49 (1).jpeg	\N	806	2020	01/02/2020	\N	\N	Sempreverde	2	0
886	0101000020110F0000412B30440A74234108556A6418705041	807	4830	7674	Albero	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	807	2019	26/01/2019	\N	\N	Sempreverde	1	0
887	0101000020110F0000FDF675B00E742341C3F011831B705041	808	4831	7675	Albero	-	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7675.JPG	\N	808	2019	26/01/2019	\N	\N	-	1	0
888	0101000020110F00001FD786DA1D7423413D0AD7E718705041	809	4832	7676	Albero	CEDRUS ATLANTICA	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	3	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	colature; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7676.JPG	\N	809	2019	26/01/2019	\N	\N	Sempreverde	1	0
889	0101000020110F0000AED348ABDA862341247F30F6F7645041	810	19	230	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\230.JPG	\N	810	2018	24/09/2018	\N	\N	Sempreverde	1	0
890	0101000020110F00009E29748EE1872341D847A7BC1F655041	811	304	590	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\590.JPG	\N	811	2018	25/09/2018	\N	\N	Caduca	1	0
891	0101000020110F000038F3AB7906742341CA6C903F1A705041	812	4833	7677	Albero	CEDRUS ATLANTICA	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	3	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	colature; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7677.JPG	\N	812	2019	26/01/2019	\N	\N	Sempreverde	1	0
892	0101000020110F00000113B89510742341BDC62EAB18705041	813	4834	7678	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	colature; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7678.JPG	\N	813	2019	26/01/2019	\N	\N	Sempreverde	1	0
893	0101000020110F0000412B30440A74234144DD07B219705041	814	4835	7679	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	colature; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7679.JPG	\N	814	2019	26/01/2019	\N	\N	Sempreverde	1	0
894	0101000020110F00000A4B3C6014742341C0046E0918705041	815	4836	7680	Albero	PINUS PINASTER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	colature; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7680.JPG	\N	815	2019	26/01/2019	\N	\N	-	1	0
895	0101000020110F000072BF4361F77323418672A2BD16705041	816	4837	7683	Albero	CITRUS AURANTIUM	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\7683.JPG	\N	816	2019	26/01/2019	\N	\N	Sempreverde	1	0
896	0101000020110F0000AD6EF57CFF73234146EBA81016705041	817	4838	7684	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2.5	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con ferite;	strozzatura;	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\7684.JPG	\N	817	2019	26/01/2019	\N	\N	Sempreverde	1	0
897	0101000020110F00001BBB44F51B742341C72E51E11A705041	818	4839	7671	Albero	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7671.JPG	\N	818	2019	26/01/2019	\N	\N	Sempreverde	1	0
898	0101000020110F0000CC7F487F087423415778977913705041	819	4840	7685	Albero	NERIUM OLEANDER	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7685.JPG	\N	819	2019	26/01/2019	\N	\N	Sempreverde	1	0
899	0101000020110F0000406A13E70D742341091B9ECC12705041	820	4841	7686	Albero	CITRUS AURANTIUM	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7686.JPG	\N	820	2019	26/01/2019	\N	\N	Sempreverde	1	0
900	0101000020110F0000766C04B20674234121E527C911705041	821	4842	7687	Albero	PRUNUS SP.	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7687.JPG	\N	821	2019	26/01/2019	\N	\N	-	1	0
901	0101000020110F00003CBD5296FE7323410FB4023911705041	822	4843	7688	Albero	PRUNUS SP.	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\7688.JPG	\N	822	2019	26/01/2019	\N	\N	-	1	0
902	0101000020110F0000E370E647F87323413AAFB1C510705041	823	4844	7689	Albero	FICUS CARICA	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\7689.JPG	\N	823	2019	26/01/2019	\N	\N	Caduca	1	0
903	0101000020110F0000349D9D5CE57323418273460613705041	824	4845	7690	Albero	PRUNUS SP.	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7690.JPG	\N	824	2019	26/01/2019	\N	\N	-	1	0
904	0101000020110F0000FAEDEB40DD73234122895EF014705041	825	4846	7691	Albero	PRUNUS SP.	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ginocchiatura;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7691.JPG	\N	825	2019	26/01/2019	\N	\N	-	1	0
905	0101000020110F0000E3361AA0D3732341FC6F259B04705041	826	4847	7692	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7692.JPG	\N	826	2019	26/01/2019	\N	\N	Sempreverde	1	0
906	0101000020110F0000DF89594FC4732341D80DDB7A03705041	827	4848	7693	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7693.JPG	\N	827	2019	26/01/2019	\N	\N	Sempreverde	1	0
907	0101000020110F0000FD135CFCEB8723413A5D163F21655041	828	305	591	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	Utenze Sotterranee;	\N	desktop/Foto\\591.JPG	\N	828	2018	25/09/2018	\N	\N	Caduca	1	0
908	0101000020110F0000632827FA06742341BBF259600C705041	829	4849	7694	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7694.JPG	\N	829	2019	26/01/2019	\N	\N	Sempreverde	1	0
909	0101000020110F00004C37893117742341E449D2C508705041	830	4850	7695	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Nobili	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7695.JPG	\N	830	2019	26/01/2019	\N	\N	Sempreverde	1	0
910	0101000020110F00009AB67F55D875234197E2AA7E3E705041	831	4851	7696	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Camminamento;	\N	desktop/Foto\\7696.JPG	\N	831	2019	26/01/2019	\N	\N	Sempreverde	1	0
911	0101000020110F00002E56D4A0D275234190DAC4593F705041	832	4852	7697	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Camminamento; Edificio;	\N	desktop/Foto\\7697.JPG	\N	832	2019	26/01/2019	\N	\N	Sempreverde	1	0
912	0101000020110F0000DF15C17FC9752341A0E0625940705041	833	4853	7698	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2022-06-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE D	\N	\N	\N	\N	capitozzatura; carie; ferite;	\N	\N	\N	Marciapiede; Camminamento;	\N	desktop/Foto\\7698.JPG	\N	833	2022	24/06/2022	\N	\N	Sempreverde	1	0
913	0101000020110F0000AEF545F2BC752341A4AA09A241705041	834	4854	7699	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Camminamento; Edificio;	\N	desktop/Foto\\7699.JPG	\N	834	2019	26/01/2019	\N	\N	Sempreverde	1	0
914	0101000020110F00008FA50FADB2752341B4B0A7A142705041	835	4855	7700	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Camminamento; Edificio;	\N	desktop/Foto\\7700.JPG	\N	835	2019	26/01/2019	\N	\N	Sempreverde	1	0
915	0101000020110F0000FDA4DA67A8752341BD18CAC543705041	836	4856	7701	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Cavi Aerei; Camminamento; Edificio;	\N	desktop/Foto\\7701.JPG	\N	836	2019	26/01/2019	\N	\N	Sempreverde	1	0
916	0101000020110F0000F224E96AA0752341B610E4A044705041	837	4857	7702	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Cavi Aerei; Camminamento; Edificio;	\N	desktop/Foto\\7702.JPG	\N	837	2019	26/01/2019	\N	\N	Sempreverde	1	0
917	0101000020110F0000A4E4D54997752341C61682A045705041	838	4858	7703	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Cavi Aerei; Camminamento; Edificio;	\N	desktop/Foto\\7703.JPG	\N	838	2019	26/01/2019	\N	\N	Sempreverde	1	0
918	0101000020110F00002E73BAEC6B752341F050147A4A705041	839	4859	7704	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Cavi Aerei; Manufatto; Camminamento; Edificio;	\N	desktop/Foto\\7704.JPG	\N	839	2019	26/01/2019	\N	\N	Sempreverde	1	0
919	0101000020110F000054E3A5CB62752341EBE2369E4B705041	840	4860	7705	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7705.JPG	\N	840	2019	26/01/2019	\N	\N	Sempreverde	1	0
920	0101000020110F0000D5B2B5CE5A752341F2B050794C705041	841	4861	7706	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7706.JPG	\N	841	2019	26/01/2019	\N	\N	Sempreverde	1	0
921	0101000020110F0000FB9122023475234114ED2A784F705041	842	4862	7707	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7707.JPG	\N	842	2019	26/01/2019	\N	\N	Sempreverde	1	0
922	0101000020110F000016DEE5B2E174234143AD694253705041	843	4863	7708	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	\N	\N	843	2019	26/01/2019	\N	\N	Sempreverde	1	0
923	0101000020110F0000618E1E4FCF74234139D1AE9254705041	844	4864	7709	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7709.JPG	\N	844	2019	26/01/2019	\N	\N	Sempreverde	1	0
924	0101000020110F00008ECC231FF3872341B4AB904622655041	845	306	592	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\592.JPG	\N	845	2018	25/09/2018	\N	\N	Caduca	1	0
925	0101000020110F0000FA7E6A2CC27423413529053756705041	846	4865	7710	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7710.JPG	\N	846	2019	26/01/2019	\N	\N	Sempreverde	1	0
926	0101000020110F00001FBFB709B574234122AB5BDB57705041	847	4866	7711	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	carie; carpofori; ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7711.JPG	\N	847	2019	26/01/2019	\N	\N	Sempreverde	1	0
927	0101000020110F0000B8AF03E7A77423411361C3D359705041	848	4867	7712	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7712.JPG	\N	848	2019	26/01/2019	\N	\N	Sempreverde	1	0
928	0101000020110F0000DDEF50C49A74234105172BCC5B705041	849	4868	7713	Ceppaia	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2020-09-23	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	photos/Albero/4868/thb_206_WhatsApp Image 2020-09-23 at 13.25.11.jpeg	\N	849	2020	23/09/2020	\N	\N	Sempreverde	2	0
929	0101000020110F000076E09CA18D742341F7CC92C45D705041	850	4869	7714	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7714.JPG	\N	850	2019	26/01/2019	\N	\N	Sempreverde	1	0
930	0101000020110F00009B20EA7E80742341F224E9685F705041	851	4870	7715	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7715.JPG	\N	851	2019	26/01/2019	\N	\N	Sempreverde	1	0
931	0101000020110F00003411365C73742341DFA63F0D61705041	852	4871	7716	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7716.JPG	\N	852	2019	26/01/2019	\N	\N	Sempreverde	1	0
932	0101000020110F00005951833966742341DAFE95B162705041	853	4872	7717	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7717.JPG	\N	853	2019	26/01/2019	\N	\N	Sempreverde	1	0
933	0101000020110F0000A5315AB75B742341D122DB0164705041	854	4873	7718	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	carie; ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7718.JPG	\N	854	2019	26/01/2019	\N	\N	Sempreverde	1	0
934	0101000020110F00003DF207B346742341C3D842FA65705041	855	4874	7719	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7719.JPG	\N	855	2019	26/01/2019	\N	\N	Sempreverde	1	0
935	0101000020110F000089D2DE303C742341B9FC874A67705041	856	4875	7720	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7720.JPG	\N	856	2019	26/01/2019	\N	\N	Sempreverde	1	0
936	0101000020110F0000D5B2B5AE31742341B020CD9A68705041	857	4876	7721	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7721.JPG	\N	857	2019	26/01/2019	\N	\N	Sempreverde	1	0
937	0101000020110F0000FED478A92B742341EBA86A2A69705041	858	4877	7722	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7722.JPG	\N	858	2019	26/01/2019	\N	\N	Sempreverde	1	0
938	0101000020110F000027F73BA425742341DE718AC469705041	859	4878	7723	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7723.JPG	\N	859	2019	26/01/2019	\N	\N	Sempreverde	1	0
939	0101000020110F0000952BBC3B23742341D3D9C9F86A705041	860	4879	7724	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7724.JPG	\N	860	2019	26/01/2019	\N	\N	Sempreverde	1	0
940	0101000020110F00005E11FC6F247423410F4581066C705041	861	4880	7725	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7725.JPG	\N	861	2019	26/01/2019	\N	\N	Sempreverde	1	0
941	0101000020110F0000B77F65B5F9872341DCBA9B5F23655041	862	307	593	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\593.JPG	\N	862	2018	25/09/2018	\N	\N	Caduca	1	0
942	0101000020110F00002E73BA0C287423414BB038146D705041	863	4881	7726	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7726.JPG	\N	863	2019	26/01/2019	\N	\N	Sempreverde	1	0
943	0101000020110F00000551F7112E7423413E7958AE6D705041	864	4882	7727	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7727.JPG	\N	864	2019	26/01/2019	\N	\N	Sempreverde	1	0
944	0101000020110F0000E3AAB27F367423417AE40FBC6E705041	865	4883	7728	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7728.JPG	\N	865	2019	26/01/2019	\N	\N	Sempreverde	1	0
945	0101000020110F0000C0046EED3E7423417B832F566F705041	866	4884	7729	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7729.JPG	\N	866	2019	26/01/2019	\N	\N	Sempreverde	1	0
946	0101000020110F00009E5E295B47742341B54FC7C96F705041	867	4885	7730	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7730.JPG	\N	867	2019	26/01/2019	\N	\N	Sempreverde	1	0
965	0101000020110F0000D21DC4AE7973234103B2D76575705041	886	4903	7851	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7851.JPG	\N	886	2019	28/01/2019	\N	\N	Sempreverde	1	0
947	0101000020110F0000459E24FD50742341EF1B5F3D70705041	868	4886	7731	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7731.JPG	\N	868	2019	26/01/2019	\N	\N	Sempreverde	1	0
948	0101000020110F0000ECDD1F9F5A74234129E8F6B070705041	869	4887	7732	Ceppaia	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-10-31	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7732.JPG	\N	869	2019	31/10/2019	\N	\N	Sempreverde	2	0
949	0101000020110F0000931D1B4164742341F1BA7ED770705041	870	4888	7733	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7733.JPG	\N	870	2019	26/01/2019	\N	\N	Sempreverde	1	0
950	0101000020110F000077F354176F742341E4839E7171705041	871	4889	7734	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Recinzione; Camminamento;	\N	desktop/Foto\\7734.JPG	\N	871	2019	26/01/2019	\N	\N	Sempreverde	1	0
951	0101000020110F0000594C6CBE43742341D9EBDDA572705041	872	4890	7735	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Recinzione; Camminamento;	\N	desktop/Foto\\7735.JPG	\N	872	2019	26/01/2019	\N	\N	Sempreverde	1	0
952	0101000020110F0000DC2E3417347423411E5036E571705041	873	4891	7736	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Mottola D'Amato	Filare	5	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Recinzione; Camminamento;	\N	desktop/Foto\\7736.JPG	\N	873	2019	26/01/2019	\N	\N	Sempreverde	1	0
953	0101000020110F000089EFC4FCEF7323416EC0E7CD90705041	874	4892	7840	Albero	QUERCUS SUBER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	3.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	\N	\N	874	2019	28/01/2019	\N	\N	-	1	0
954	0101000020110F0000ED815670E57323414BEA045493705041	875	4893	7842	Albero	QUERCUS PUBESCENS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	3.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	\N	\N	875	2019	28/01/2019	\N	\N	Caduca	1	0
955	0101000020110F0000BFF1B527E87323415726FC6492705041	876	4894	7841	Albero	QUERCUS SUBER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	3.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche con fratture/incrinature; branche protese;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7841.JPG	\N	876	2019	28/01/2019	\N	\N	-	1	0
956	0101000020110F0000BA313D31EA73234114AE477395705041	877	4895	7843	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso;	ferite;	\N	ginocchiatura;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7843.JPG	\N	877	2019	28/01/2019	\N	\N	Caduca	1	0
957	0101000020110F000015527EC2E4732341F3716DFA96705041	878	4896	7844	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche secche;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7844.JPG	\N	878	2019	28/01/2019	\N	\N	Sempreverde	1	0
958	0101000020110F00000E4FAFA41A882341304CA6A027655041	879	308	600	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\600.JPG	\N	879	2018	25/09/2018	\N	\N	Caduca	1	0
959	0101000020110F0000BFF1B527E8732341FA9B506296705041	880	4897	7845	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	880	2019	28/01/2019	\N	\N	-	2	0
960	0101000020110F00007632384ADD7323411AC05B1C95705041	881	4898	7846	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	881	2019	28/01/2019	\N	\N	-	2	0
961	0101000020110F00009A42E7A5DE7323412AC6F99994705041	882	4899	7847	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	882	2019	28/01/2019	\N	\N	-	2	0
962	0101000020110F000053D0ED559773234168E89FCE77705041	883	4900	7848	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7848.JPG	\N	883	2019	28/01/2019	\N	\N	Sempreverde	1	0
963	0101000020110F000095B723EC8F732341AA2B9F2376705041	884	4901	7849	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7849.JPG	\N	884	2019	28/01/2019	\N	\N	Sempreverde	1	0
964	0101000020110F00003DB83B8B8573234103B2D76575705041	885	4902	7850	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7850.JPG	\N	885	2019	28/01/2019	\N	\N	Sempreverde	1	0
966	0101000020110F0000791EDC4D6F73234192E8653675705041	887	4904	7852	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Manufatto;	\N	desktop/Foto\\7852.JPG	\N	887	2019	28/01/2019	\N	\N	Sempreverde	1	0
967	0101000020110F000034BA83686673234103B2D76575705041	888	4905	7853	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7853.JPG	\N	888	2019	28/01/2019	\N	\N	Sempreverde	1	0
968	0101000020110F000064062A835D73234130F5F30675705041	889	4906	7854	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7854.JPG	\N	889	2019	28/01/2019	\N	\N	Sempreverde	1	0
969	0101000020110F0000232D958774712341205ED74BBD705041	890	4907	7858	Ceppaia	EUCALYPTUS CAMALDULENSIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-01-08	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione;	\N	photos/Albero/4907/244_WhatsApp Image 2020-01-08 at 14.13.30.jpeg	\N	890	2020	08/01/2020	\N	\N	Sempreverde	2	0
970	0101000020110F0000C18BBEB26B712341EF8FF79EBE705041	891	4908	7859	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	capitozzatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7859.JPG	\N	891	2019	28/01/2019	\N	\N	Caduca	1	0
971	0101000020110F0000F224E94A6A712341D74CBE13BF705041	892	4909	7860	Albero	VIBURNUM TINUS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	892	2019	28/01/2019	\N	\N	Sempreverde	1	0
972	0101000020110F0000D061BE3C687123417A36AB62BF705041	893	4910	7861	Albero	VIBURNUM TINUS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7861.JPG	\N	893	2019	28/01/2019	\N	\N	Sempreverde	1	0
973	0101000020110F0000C68A1A5C65712341E7A90ED9BF705041	894	4911	7862	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\7862.JPG	\N	894	2019	28/01/2019	\N	\N	Sempreverde	1	0
974	0101000020110F0000B9AAECFB4F71234133DC80FFBD705041	895	4912	7864	Albero	LAURUS NOBILIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	branche con ferite; branche protese; branche secche;	carpofori; ferite; strozzatura;	\N	capitozzatura; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\7864.JPG	\N	895	2019	28/01/2019	\N	\N	Sempreverde	1	0
975	0101000020110F00007BBDFB5322882341CE88D2DC28655041	896	309	601	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\601.JPG	\N	896	2018	25/09/2018	\N	\N	Caduca	1	0
976	0101000020110F0000BCB3767B6271234151A566F7BA705041	897	4913	7865	Albero	PINUS HALEPENSIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	\N	\N	897	2019	28/01/2019	\N	\N	Sempreverde	1	0
977	0101000020110F0000862007B5757123410D71AC87BB705041	898	4914	7857	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7857.JPG	\N	898	2019	28/01/2019	\N	\N	Sempreverde	1	0
978	0101000020110F00007F130A01677123418EAF3D3FBA705041	899	4915	7866	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	899	2019	28/01/2019	\N	\N	Sempreverde	1	0
979	0101000020110F0000DA38621D6B71234157B263A1B9705041	900	4916	7867	Ceppaia	-	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	900	2019	28/01/2019	\N	\N	-	2	0
980	0101000020110F0000EE7C3F155B71234109C4EBCEB8705041	901	4917	7868	Ceppaia	-	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	901	2019	28/01/2019	\N	\N	-	2	0
981	0101000020110F0000A7052FBA5C7123410C074240BC705041	902	4918	7869	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	902	2019	28/01/2019	\N	\N	Sempreverde	2	0
982	0101000020110F00005721E54771712341F415A40BBC705041	903	4919	7870	Ceppaia	-	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	903	2019	28/01/2019	\N	\N	-	2	0
983	0101000020110F00003529055D407123418542042AC4705041	904	4920	7873	Albero	-	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	capitozzatura; ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7873.JPG	\N	904	2019	28/01/2019	\N	\N	-	1	0
984	0101000020110F0000B84082323A7123415760C8C0C3705041	905	4921	7874	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2021-03-03	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	photos/Albero/4921/thb_WhatsApp Image 2021-03-03 at 13.20.44 (1)_292.jpeg	\N	905	2021	03/03/2021	\N	\N	Caduca	2	0
988	0101000020110F0000088F366E3B7123418542042AC4705041	909	4925	7878	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7878.JPG	\N	909	2019	28/01/2019	\N	\N	Caduca	2	0
989	0101000020110F00002A52617C3D7123415760C8C0C3705041	910	4926	7879	Ceppaia	ACACIA DEALBATA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	910	2019	28/01/2019	\N	\N	Caduca	2	0
990	0101000020110F0000401361E31D712341D639060EC5705041	911	4927	7881	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7881.JPG	\N	911	2019	28/01/2019	\N	\N	Sempreverde	1	0
991	0101000020110F0000BDC62E11B1702341C3F0114FF8705041	912	4928	7882	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7882.JPG	\N	912	2019	28/01/2019	\N	\N	Sempreverde	1	0
992	0101000020110F000096ECD8A82B882341C746203C2A655041	913	310	602	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\602.JPG	\N	913	2018	25/09/2018	\N	\N	Caduca	1	0
993	0101000020110F00007172BFA3AC70234143AD69C0F8705041	914	4929	7883	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7883.JPG	\N	914	2019	28/01/2019	\N	\N	Sempreverde	1	0
994	0101000020110F0000B16D5136A8702341B493C131F9705041	915	4930	7884	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7884.JPG	\N	915	2019	28/01/2019	\N	\N	Sempreverde	1	0
995	0101000020110F00002C4833E6A27023414C546FBFF9705041	916	4931	7885	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7885.JPG	\N	916	2019	28/01/2019	\N	\N	Sempreverde	1	0
996	0101000020110F0000A72215969D702341D53E1D4DFA705041	917	4932	7886	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7886.JPG	\N	917	2019	28/01/2019	\N	\N	Sempreverde	1	0
997	0101000020110F0000E92B4863977023416DFFCADAFA705041	918	4933	7887	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7887.JPG	\N	918	2019	28/01/2019	\N	\N	Sempreverde	1	0
998	0101000020110F0000809F7101BF7B2341B18A37E4E26D5041	919	4934	8239	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8239.JPG	\N	919	2019	29/01/2019	\N	\N	Caduca	1	0
999	0101000020110F00004C6C3E7EBC7B23416F810485E36D5041	920	4935	8240	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8240.JPG	\N	920	2019	29/01/2019	\N	\N	Caduca	1	0
1000	0101000020110F0000205ED7BFBD7B2341F3599EFDE36D5041	921	4936	8241	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8241.JPG	\N	921	2019	29/01/2019	\N	\N	Caduca	1	0
1001	0101000020110F000054A9D9E3C07B234168791E62E46D5041	922	4937	8242	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8242.JPG	\N	922	2019	29/01/2019	\N	\N	Caduca	1	0
1002	0101000020110F000087DC0C67C37B2341DD989EC6E46D5041	923	4938	8243	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8243.JPG	\N	923	2019	29/01/2019	\N	\N	Caduca	1	0
1003	0101000020110F00000C1F11D3CC7B2341683F521CE66D5041	924	4939	8244	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8244.JPG	\N	924	2019	29/01/2019	\N	\N	Caduca	1	0
1004	0101000020110F0000890CAB38D17B2341EC17EC94E66D5041	925	4940	8245	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8245.JPG	\N	925	2019	29/01/2019	\N	\N	Caduca	1	0
1005	0101000020110F000004E2756DC87B234110AFEBCBE56D5041	926	4941	8247	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8247.JPG	\N	926	2019	29/01/2019	\N	\N	Caduca	1	0
1006	0101000020110F0000809F7101BF7B234168791E62E46D5041	927	4942	8248	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8248.JPG	\N	927	2019	29/01/2019	\N	\N	Caduca	1	0
1047	0101000020110F00002F17F14DE48023414B93527E346D5041	968	4980	8194	Albero	THUJA OCCIDENTALIS	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Fioriera in muratura	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8194.JPG	\N	968	2019	29/01/2019	\N	\N	Sempreverde	1	0
1007	0101000020110F000036E50A1FBD7B2341AA8251C1E36D5041	928	4943	8249	Albero	AILANTHUS ALTISSIMA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8249.JPG	\N	928	2019	29/01/2019	\N	\N	Caduca	1	0
1008	0101000020110F0000FF0417ABDF7B23411FF46C54E96D5041	929	4944	8250	Albero	ALBIZIA JULIBRISSIN	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8250.JPG	\N	929	2019	29/01/2019	\N	\N	Caduca	1	0
1009	0101000020110F0000F5D6C016368823417C9BFEAC2B655041	930	311	603	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\603.JPG	\N	930	2018	25/09/2018	\N	\N	Caduca	1	0
1010	0101000020110F00007C0A80B1E47B234102655340E96D5041	931	4945	8251	Albero	ALBIZIA JULIBRISSIN	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8251.JPG	\N	931	2019	29/01/2019	\N	\N	Caduca	1	0
1011	0101000020110F0000BE874B2EE27B234161FD9FB3E86D5041	932	4946	8252	Ceppaia	ALBIZIA JULIBRISSIN	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8252.JPG	\N	932	2019	29/01/2019	\N	\N	Caduca	2	0
1012	0101000020110F000064062A139270234105C07868FB705041	933	4947	7888	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7888.JPG	\N	933	2019	28/01/2019	\N	\N	Sempreverde	1	0
1013	0101000020110F00001AC05BE08B702341B6847C12FC705041	934	4948	7889	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7889.JPG	\N	934	2019	28/01/2019	\N	\N	Sempreverde	1	0
1014	0101000020110F000021EA3E90867023418E23D6D8FC705041	935	4949	7890	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7890.JPG	\N	935	2019	28/01/2019	\N	\N	Sempreverde	1	0
1015	0101000020110F00005070B1D27C702341AFCE31F4FD705041	936	4950	7891	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7891.JPG	\N	936	2019	28/01/2019	\N	\N	Sempreverde	1	0
1016	0101000020110F0000CD5834BD75702341876D8BBAFE705041	937	4951	7892	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7892.JPG	\N	937	2019	28/01/2019	\N	\N	Sempreverde	1	0
1017	0101000020110F00000725CC246370234140D9946300715041	938	4952	7893	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	938	2019	28/01/2019	\N	\N	Sempreverde	1	0
1018	0101000020110F0000CD5834BD75702341A818E7D5FF705041	939	4953	7894	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7894.JPG	\N	939	2019	28/01/2019	\N	\N	Sempreverde	1	0
1019	0101000020110F0000159161B57D702341A818E7D5FF705041	940	4954	7895	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	940	2019	28/01/2019	\N	\N	Sempreverde	1	0
1020	0101000020110F00005ED72FE883702341B87537F3FE705041	941	4955	7896	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	941	2019	28/01/2019	\N	\N	Sempreverde	1	0
1021	0101000020110F0000E1EEACFD8A702341AFCE31F4FD705041	942	4956	7897	Albero	THUJA OCCIDENTALIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7897.JPG	\N	942	2019	28/01/2019	\N	\N	Sempreverde	1	0
1022	0101000020110F000097A8DECA847023416FF085BBFD705041	943	4957	7898	Albero	LAGERSTROEMIA INDICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	943	2019	28/01/2019	\N	\N	Caduca	1	0
1023	0101000020110F00004F5DF91C6B70234138328F64FF705041	944	4958	7899	Albero	LAGERSTROEMIA INDICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7899.JPG	\N	944	2019	28/01/2019	\N	\N	Caduca	1	0
1024	0101000020110F0000FBCBEE495A702341BA66F2D301715041	945	4959	7900	Albero	PINUS HALEPENSIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche secche; processionaria - Traumatocampa pityocampa;	ferite;	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	945	2019	28/01/2019	\N	\N	Sempreverde	1	0
1025	0101000020110F0000BBD05CB75E70234192054C9A02715041	946	4960	7901	Albero	MELIA AZEDARACH	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	946	2019	28/01/2019	\N	\N	Caduca	1	0
1026	0101000020110F0000763238CA4E88234167D5E7CA2F655041	947	312	611	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\611.JPG	\N	947	2018	25/09/2018	\N	\N	Caduca	1	0
1027	0101000020110F0000CA37DBCC657023412AC6F92703715041	948	4961	7902	Albero	MELIA AZEDARACH	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Teti	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	948	2019	28/01/2019	\N	\N	Caduca	1	0
1028	0101000020110F00005704FF7BD47B23412592E8F5F16D5041	949	4962	8228	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con carie; branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8228.JPG	\N	949	2019	29/01/2019	\N	\N	Sempreverde	1	0
1029	0101000020110F00000C022B97D77B2341A79196AAF06D5041	950	4963	8229	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con carie;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\8229.JPG	\N	950	2019	29/01/2019	\N	\N	Sempreverde	1	0
1030	0101000020110F000036B055B2DA7B2341EDBB223EEF6D5041	951	4964	8230	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con carie;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\8230.JPG	\N	951	2019	29/01/2019	\N	\N	Sempreverde	1	0
1031	0101000020110F0000145CACE8E07B2341F3E5052CED6D5041	952	4965	8231	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8231.JPG	\N	952	2019	29/01/2019	\N	\N	Sempreverde	1	0
1032	0101000020110F00003EAE0D85D57B23413A3B1944EC6D5041	953	4966	8232	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8232.JPG	\N	953	2019	29/01/2019	\N	\N	Sempreverde	1	0
1033	0101000020110F000092AE993CCD7B2341FB3A709EEB6D5041	954	4967	8233	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8233.JPG	\N	954	2019	29/01/2019	\N	\N	Sempreverde	1	0
1034	0101000020110F0000A4AA09E2C27B2341BD3AC7F8EA6D5041	955	4968	8234	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8234.JPG	\N	955	2019	29/01/2019	\N	\N	Sempreverde	1	0
1035	0101000020110F0000D9B11128E87B2341BA66F213EE6D5041	956	4969	8236	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lamonica	Filare	4	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8236.JPG	\N	956	2019	29/01/2019	\N	\N	-	2	0
1036	0101000020110F0000617138131F8123410725CCD83F6D5041	957	4970	8184	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	957	2019	29/01/2019	\N	\N	Sempreverde	1	0
1037	0101000020110F00002D95B76314812341CC7F489B3E6D5041	958	4971	8185	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8185.JPG	\N	958	2019	29/01/2019	\N	\N	Sempreverde	1	0
1038	0101000020110F00006E6935B409812341815B77BF3D6D5041	959	4972	8186	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8186.JPG	\N	959	2019	29/01/2019	\N	\N	Sempreverde	1	0
1039	0101000020110F00003B8DB404FF802341BEF6CCB23C6D5041	960	4973	8187	Fallanza	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8187.JPG	\N	960	2019	29/01/2019	\N	\N	Sempreverde	3	0
1040	0101000020110F00004165FCDBF58023410A6822A63B6D5041	961	4974	8188	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8188.JPG	\N	961	2019	29/01/2019	\N	\N	Sempreverde	1	0
1041	0101000020110F0000473D44B3EC8023410ABABDE23A6D5041	962	4975	8189	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8189.JPG	\N	962	2019	29/01/2019	\N	\N	Sempreverde	1	0
1042	0101000020110F000068CBB9D4E58023410B0C591F3A6D5041	963	4976	8190	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8190.JPG	\N	963	2019	29/01/2019	\N	\N	Sempreverde	1	0
1043	0101000020110F00006E179AAB58882341DE02098231655041	964	313	612	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\612.JPG	\N	964	2018	25/09/2018	\N	\N	Caduca	1	0
1044	0101000020110F00008A592FF6DE802341C0E78743396D5041	965	4977	8191	Albero	LIGUSTRUM JAPONICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\8191.JPG	\N	965	2019	29/01/2019	\N	\N	Sempreverde	1	0
1045	0101000020110F00003737A617D8802341888043AE326D5041	966	4978	8192	Albero	LAGERSTROEMIA INDICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	966	2019	29/01/2019	\N	\N	Caduca	1	0
1046	0101000020110F000068CBB9D4E580234188D7F50F336D5041	967	4979	8193	Albero	LAGERSTROEMIA INDICA	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8193.JPG	\N	967	2019	29/01/2019	\N	\N	Caduca	1	0
1048	0101000020110F000062F371FDEE8023414C8E3B59336D5041	969	4981	8195	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8195.JPG	\N	969	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1049	0101000020110F00004165FCDBF5802341C425C7EB336D5041	970	4982	8196	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8196.JPG	\N	970	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1050	0101000020110F0000643BDFEFEB8023410EA14A29356D5041	971	4983	8197	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8197.JPG	\N	971	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1051	0101000020110F000068CBB9D4E5802341868F881D366D5041	972	4984	8198	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	972	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1052	0101000020110F00009279E4BFD28023414B3CA01C346D5041	973	4985	8199	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8199.JPG	\N	973	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1053	0101000020110F0000903177CDD5802341882EA871336D5041	974	4986	8200	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8200.JPG	\N	974	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1054	0101000020110F00009279E4BFD28023418929914C326D5041	975	4987	8201	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8201.JPG	\N	975	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1055	0101000020110F000094C151B2CF80234188D7F50F336D5041	976	4988	8202	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8202.JPG	\N	976	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1056	0101000020110F00009609BFA4CC80234188855AD3336D5041	977	4989	8203	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8203.JPG	\N	977	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1057	0101000020110F0000802BD931C1802341109205BA316D5041	978	4990	8204	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8204.JPG	\N	978	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1058	0101000020110F00009E29746EC08023418929914C326D5041	979	4991	8205	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	2019-12-18	2019-12-18	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE A	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8205.JPG	\N	979	2019	18/12/2019	2019	18/12/2019	Sempreverde	1	0
1059	0101000020110F0000E388B518E2802341C190D511486D5041	980	4992	8206	Albero	ROBINIA PSEUDOACACIA	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8206.JPG	\N	980	2019	29/01/2019	\N	\N	Caduca	1	0
1060	0101000020110F0000AC90F273618823412A00C6CF32655041	981	314	613	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\613.JPG	\N	981	2018	25/09/2018	\N	\N	Caduca	1	0
1061	0101000020110F00001FD7863AD5802341083D9BAD496D5041	982	4993	8207	Albero	ROBINIA PSEUDOACACIA	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8207.JPG	\N	982	2019	29/01/2019	\N	\N	Caduca	1	0
1062	0101000020110F0000399CF995E3802341EEEBC007496D5041	983	4994	8208	Albero	ROBINIA PSEUDOACACIA	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei; Illuminazione pubblica;	\N	desktop/Foto\\8208.JPG	\N	983	2019	29/01/2019	\N	\N	Caduca	1	0
1063	0101000020110F00002C9ACE3EE9802341FA7E6A74496D5041	984	4995	8209	Albero	ROBINIA PSEUDOACACIA	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	984	2019	29/01/2019	\N	\N	Caduca	1	0
1064	0101000020110F0000E8305FFE11812341467C27224D6D5041	985	4996	8210	Albero	LIGUSTRUM JAPONICA	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	ferite;	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica;	\N	\N	\N	985	2019	29/01/2019	\N	\N	Sempreverde	1	0
1065	0101000020110F00007D96E741148123412B137EB54C6D5041	986	4997	8211	Ceppaia	-	PARCO VIA LEONDARDO DA VINCI	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	986	2019	29/01/2019	\N	\N	-	2	0
1066	0101000020110F0000DB334B22278823416519E260CF6D5041	987	4998	8212	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	-	Via degli Svevi	Isolato	0	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	987	2019	29/01/2019	\N	\N	Sempreverde	1	0
1067	0101000020110F0000EECEDA2D30882341DBF97E34D26D5041	988	4999	8213	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	-	Via degli Svevi	Isolato	0	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Cavi Aerei;	\N	desktop/Foto\\8213.JPG	\N	988	2019	29/01/2019	\N	\N	Sempreverde	1	0
1068	0101000020110F0000828B15D535882341C078062FD46D5041	989	5000	8214	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	-	Via degli Svevi	Isolato	0	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Cavi Aerei; Manufatto;	\N	desktop/Foto\\8214.JPG	\N	989	2019	29/01/2019	\N	\N	Sempreverde	1	0
1069	0101000020110F0000789CA2B334882341F67AF739D06D5041	990	5001	8215	Albero	OLEA EUROPAEA	CAVA CUCULERA	-	Via	-	Via degli Svevi	Isolato	0	Fioriera in muratura	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8215.JPG	\N	990	2019	29/01/2019	\N	\N	Sempreverde	1	0
1070	0101000020110F00004F3BFCA5358323419A081B2E2C6D5041	991	5002	8216	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite; insetti lignivori;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8216.JPG	\N	991	2019	29/01/2019	\N	\N	-	1	0
1071	0101000020110F00004F3BFCA53583234148E17AE82A6D5041	992	5003	8217	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite; insetti lignivori;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8217.JPG	\N	992	2019	29/01/2019	\N	\N	-	1	0
1072	0101000020110F00004F3BFCA53583234153962112296D5041	993	5004	8218	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	inclinazione ingiustificata; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8218.JPG	\N	993	2019	29/01/2019	\N	\N	-	1	0
1073	0101000020110F00005A2A6FC7368323414F75C83B276D5041	994	5005	8219	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; insetti lignivori;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8219.JPG	\N	994	2019	29/01/2019	\N	\N	-	1	0
1074	0101000020110F0000F792C658448323412CBCCBAD256D5041	995	5006	8220	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	insetti lignivori;	ferite;	\N	ferite; inclinazione ingiustificata; torsioni;	\N	\N	\N	\N	\N	\N	\N	995	2019	29/01/2019	\N	\N	-	1	0
1075	0101000020110F000076711BBD47832341A29C6881286D5041	996	5007	8221	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	996	2019	29/01/2019	\N	\N	-	1	0
1076	0101000020110F0000F792C65844832341E90E629D2B6D5041	997	5008	8222	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	997	2019	29/01/2019	\N	\N	-	1	0
1077	0101000020110F0000876D8BD27088234188F4DB0135655041	998	315	617	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Aiuola Spartitraffico	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\617.JPG	\N	998	2018	25/09/2018	\N	\N	Caduca	1	0
1078	0101000020110F0000D908C42B3A832341ED81561A266D5041	999	5009	8223	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	999	2019	29/01/2019	\N	\N	Sempreverde	1	0
1079	0101000020110F0000D09B8A8434832341E0D6DD14286D5041	1000	5010	8224	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1000	2019	29/01/2019	\N	\N	Sempreverde	1	0
1080	0101000020110F00004F3BFCA535832341D52137EB296D5041	1001	5011	8225	Albero	PITTOSPORUM TOBIRA	CAVA CUCULERA	-	Via	-	Via Ridola	Filare	5	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1001	2019	29/01/2019	\N	\N	Sempreverde	1	0
1081	0101000020110F000064E94397F56F23411A69A99097715041	1002	5012	7904	Fallanza	PLATANUS SP.	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7904.JPG	\N	1002	2019	28/01/2019	\N	\N	-	3	0
1082	0101000020110F00000118CFC0057023418464012B93715041	1003	5013	7907	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche;	\N	\N	cercine di legatura; ferite;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7907.JPG	\N	1003	2019	28/01/2019	\N	\N	Sempreverde	1	0
1083	0101000020110F0000895E4621087023414D4A416592715041	1004	5014	7908	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7908.JPG	\N	1004	2019	28/01/2019	\N	\N	Sempreverde	1	0
1084	0101000020110F000052B81E750B702341EA094B9091715041	1005	5015	7909	Albero	PLATANUS ACERIFOLIA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Filare	4	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2.2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	carie;	capitozzatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Cartellonistica; Manufatto; Recinzione;	\N	desktop/Foto\\7909.JPG	\N	1005	2019	28/01/2019	\N	\N	Caduca	1	0
1085	0101000020110F0000F207038F8770234183C0CAA380715041	1006	5016	7910	Albero	PLATANUS ACERIFOLIA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Asola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2.2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento; Edificio;	\N	desktop/Foto\\7910.JPG	\N	1006	2019	28/01/2019	\N	\N	Caduca	1	0
1452	0101000020110F000030F0DC0B3A7E2341D9994209806F5041	1371	5358	8388	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1371	2019	30/01/2019	\N	\N	Sempreverde	2	0
1086	0101000020110F0000DB6D172A8F702341F73B14097F715041	1007	5017	7912	Albero	ACER SP.	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2.3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7912.JPG	\N	1007	2019	28/01/2019	\N	\N	-	1	0
1087	0101000020110F00009548A2F792702341187D05BD7E715041	1008	5018	7913	Albero	ACER SP.	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2.3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7913.JPG	\N	1008	2019	28/01/2019	\N	\N	-	1	0
1088	0101000020110F0000419FC8A38F702341910A638F7E715041	1009	5019	7914	Albero	NERIUM OLEANDER	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7914.JPG	\N	1009	2019	28/01/2019	\N	\N	Sempreverde	1	0
1089	0101000020110F0000C03E3AA5C774234148E17A6479705041	1278	5271	7806	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Lampione; Manufatto;	\N	desktop/Foto\\7806.JPG	\N	1278	2019	28/01/2019	\N	\N	Sempreverde	1	0
1090	0101000020110F0000EF72119FC1742341923F180479705041	1279	5272	7807	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7807.JPG	\N	1279	2019	28/01/2019	\N	\N	Sempreverde	1	0
1091	0101000020110F00001EA7E898BB742341DC9DB5A378705041	1280	5273	7808	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7808.JPG	\N	1280	2019	28/01/2019	\N	\N	Sempreverde	1	0
1092	0101000020110F0000F3768453B6742341F71E2E1F78705041	1281	5274	7809	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7809.JPG	\N	1281	2019	28/01/2019	\N	\N	Sempreverde	1	0
1093	0101000020110F000019390B0BAE742341CDE9B2A677705041	1282	5275	7810	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2022-06-24	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Cattivo	CLASSE D	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7810.JPG	\N	1282	2022	24/06/2022	\N	\N	Sempreverde	1	0
1094	0101000020110F0000CB4A93C2A5742341A2B4372E77705041	1283	5276	7811	Ceppaia	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-10-30	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1283	2019	30/10/2019	\N	\N	Sempreverde	2	0
1095	0101000020110F00009FCDAA8FB2742341A779C7A97A705041	1284	5277	7812	Albero	TILIA CORDATA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7812.JPG	\N	1284	2019	28/01/2019	\N	\N	Sempreverde	1	0
1096	0101000020110F0000C7116BA1A4742341E92B484F74705041	1285	5278	7813	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Lampione; Cavi Aerei; Recinzione;	\N	desktop/Foto\\7813.JPG	\N	1285	2019	28/01/2019	\N	\N	Sempreverde	1	0
1097	0101000020110F00004CA60A26A974234118096D7374705041	1286	5279	7814	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7814.JPG	\N	1286	2019	28/01/2019	\N	\N	Sempreverde	1	0
1098	0101000020110F00009A94826EB1742341A375545B74705041	1287	5280	7816	Ceppaia	CUPRESSUS SP.	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-10-30	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7816.JPG	\N	1287	2019	30/10/2019	\N	\N	-	2	0
1099	0101000020110F000040A4DF2E2C86234169520A4C30655041	1288	332	640	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\640.JPG	\N	1288	2018	25/09/2018	\N	\N	Sempreverde	1	0
1100	0101000020110F0000739D464AAD7423417EC6858B74705041	1289	5281	7815	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7815.JPG	\N	1289	2019	28/01/2019	\N	\N	Sempreverde	1	0
1101	0101000020110F000049A29771B4742341A9FB000475705041	1290	5282	7817	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7817.JPG	\N	1290	2019	28/01/2019	\N	\N	Sempreverde	1	0
1102	0101000020110F000018EC861DC0742341FE65F7F475705041	1291	5283	7818	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7818.JPG	\N	1291	2019	28/01/2019	\N	\N	Sempreverde	1	0
1103	0101000020110F0000179F0230D27423419E0C8E8277705041	1292	5284	7819	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	\N	\N	1292	2019	28/01/2019	\N	\N	Sempreverde	1	0
1104	0101000020110F000038109245E7742341425BCEBB78705041	1293	5285	7820	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	carpofori; ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7820.JPG	\N	1293	2019	28/01/2019	\N	\N	Sempreverde	1	0
1105	0101000020110F00008F705AD0F174234148E17A6479705041	1294	5286	7821	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	radici strozzanti;	\N	cavit�; ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7821.JPG	\N	1294	2019	28/01/2019	\N	\N	Sempreverde	1	0
1106	0101000020110F0000B4E55C9AFB74234107B133197A705041	1295	5287	7822	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite;	\N	\N	cavit�; ferite;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\7822.JPG	\N	1295	2019	28/01/2019	\N	\N	Sempreverde	1	0
1107	0101000020110F00003ECBF3C0E27423414703786778705041	1296	5288	7824	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1296	2019	28/01/2019	\N	\N	Sempreverde	1	0
1108	0101000020110F00006F810415D7742341CDE9B2A677705041	1297	5289	7828	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1297	2019	28/01/2019	\N	\N	Sempreverde	1	0
1109	0101000020110F0000BD6F7C5DDF7423419E0C8E8277705041	1298	5290	7825	Albero	TILIA CORDATA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1298	2019	28/01/2019	\N	\N	Sempreverde	1	0
1110	0101000020110F0000E466B881E374234153D0EDE576705041	1299	5291	7826	Albero	LAURUS NOBILIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7826.JPG	\N	1299	2019	28/01/2019	\N	\N	Sempreverde	1	0
1111	0101000020110F0000EB6E9EEACC742341431CEBE875705041	1300	5292	7827	Ceppaia	CUPRESSUS SP.	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1300	2019	28/01/2019	\N	\N	-	2	0
1112	0101000020110F00003685471D127523417962D09F81705041	1301	5293	7831	Albero	OLEA EUROPAEA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7831.JPG	\N	1301	2019	28/01/2019	\N	\N	Sempreverde	1	0
1113	0101000020110F000023F3C85F187523414F06478780705041	1302	5294	7832	Albero	OLEA EUROPAEA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7832.JPG	\N	1302	2019	28/01/2019	\N	\N	Sempreverde	1	0
1114	0101000020110F000030F5F3966B7423417AC7294A76705041	1303	5295	7837	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7837.JPG	\N	1303	2019	28/01/2019	\N	\N	Sempreverde	1	0
1115	0101000020110F0000D2C611CB677423415969529E77705041	1304	5296	7838	Ceppaia	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-10-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7838.JPG	\N	1304	2019	25/10/2019	\N	\N	Sempreverde	2	0
1116	0101000020110F00006C21C8F12886234101DE025F31655041	1305	333	641	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\641.JPG	\N	1305	2018	25/09/2018	\N	\N	Sempreverde	1	0
1117	0101000020110F00001B81789DB8732341CA37DB5698705041	1306	5297	6203	Albero	QUERCUS SUBER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche protese; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6203.JPG	\N	1306	2019	28/01/2019	\N	\N	-	1	0
1118	0101000020110F0000D717095DA673234160B01B2E98705041	1307	5298	6204	Albero	QUERCUS PUBESCENS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche protese; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\6204.JPG	\N	1307	2019	28/01/2019	\N	\N	Caduca	1	0
1119	0101000020110F0000CF2C0960517D23417EC685C5FD6D5041	1308	5299	6371	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; monconi;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6371.JPG	\N	1308	2019	29/01/2019	\N	\N	Caduca	1	0
1120	0101000020110F0000C30DF88C4E7D2341F4E0EE7AFC6D5041	1309	5300	6373	Albero	VIBURNUM TINUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6373.JPG	\N	1309	2019	29/01/2019	\N	\N	Sempreverde	1	0
1121	0101000020110F0000E882FAA6DE7C23418CD6519DF26D5041	1310	5301	6378	Ceppaia	LIGUSTRUM JAPONICA	VIALE DEI BIZANTINI	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-11-20	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6378.JPG	\N	1310	2019	20/11/2019	\N	\N	Sempreverde	2	0
1122	0101000020110F0000C5C9FDEEC17C2341923F186EEB6D5041	1311	5302	6380	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale Bizantini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6380.JPG	\N	1311	2019	29/01/2019	\N	\N	Sempreverde	1	0
1141	0101000020110F00006C956091006B2341A8C64BAF8E6E5041	1330	5320	8320	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	\N	carpofori; ferite;	\N	\N	\N	\N	\N	Lampione; Cavi Aerei;	\N	desktop/Foto\\8320.JPG	\N	1330	2019	30/01/2019	\N	\N	Sempreverde	1	0
1123	0101000020110F00009886E1F3657D234153AEF0E4E96D5041	1312	5303	6382	Albero	PINUS HALEPENSIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Gariani	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; branche secche; monconi; processionaria - Traumatocampa pityocampa; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6382.JPG	\N	1312	2019	29/01/2019	\N	\N	Sempreverde	1	0
1124	0101000020110F000060E5D052226B234199F04B379E6E5041	1313	5304	8303	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8303.JPG	\N	1313	2019	30/01/2019	\N	\N	Sempreverde	1	0
1125	0101000020110F0000003ACC97276B2341A4703D829E6E5041	1314	5305	8304	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8304.JPG	\N	1314	2019	30/01/2019	\N	\N	Sempreverde	1	0
1126	0101000020110F000097E2AA722D6B23412F8672BA9E6E5041	1315	5306	8305	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8305.JPG	\N	1315	2019	30/01/2019	\N	\N	Sempreverde	1	0
1127	0101000020110F0000ADDD7661486B2341CC457CD39F6E5041	1316	5307	8306	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche secche; giallume diffuso;	\N	\N	ferite; insetti lignivori;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8306.JPG	\N	1316	2019	30/01/2019	\N	\N	Sempreverde	1	0
1128	0101000020110F0000D88173A64D6B2341D6C56D1EA06E5041	1317	5308	8307	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8307.JPG	\N	1317	2019	30/01/2019	\N	\N	Sempreverde	1	0
1129	0101000020110F000080828B55526B2341D49AE643A06E5041	1318	5309	8308	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8308.JPG	\N	1318	2019	30/01/2019	\N	\N	Sempreverde	1	0
1130	0101000020110F00002783A304576B234160B01B7CA06E5041	1319	5310	8309	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche; giallume diffuso;	\N	\N	\N	\N	\N	\N	Cartellonistica; Recinzione;	\N	desktop/Foto\\8309.JPG	\N	1319	2019	30/01/2019	\N	\N	Sempreverde	1	0
1131	0101000020110F0000BADA8A5DFD6A23416EA3014A946E5041	1320	5311	8311	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8311.JPG	\N	1320	2019	30/01/2019	\N	\N	Sempreverde	1	0
1132	0101000020110F0000247F3090FA6A2341C347C416946E5041	1321	5312	8312	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8312.JPG	\N	1321	2019	30/01/2019	\N	\N	Sempreverde	1	0
1133	0101000020110F0000A301BC0525862341B8239CC232655041	1322	334	642	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	ginocchiatura;	\N	\N	\N	Edificio;	\N	desktop/Foto\\642.JPG	\N	1322	2018	25/09/2018	\N	\N	Sempreverde	1	0
1134	0101000020110F000072C45A5CF76A2341423EE8C9936E5041	1323	5313	8313	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8313.JPG	\N	1323	2019	30/01/2019	\N	\N	Sempreverde	1	0
1135	0101000020110F0000139B8F5BF36A234197E2AA96936E5041	1324	5314	8314	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8314.JPG	\N	1324	2019	30/01/2019	\N	\N	Sempreverde	1	0
1136	0101000020110F0000B471C45AEF6A2341FA449E56936E5041	1325	5315	8315	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8315.JPG	\N	1325	2019	30/01/2019	\N	\N	Sempreverde	1	0
1137	0101000020110F0000BAA0BE25E66A2341A48D23F0926E5041	1326	5316	8316	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8316.JPG	\N	1326	2019	30/01/2019	\N	\N	Sempreverde	1	0
1138	0101000020110F00009E4143BFE56A23416A6AD97C926E5041	1327	5317	8317	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	Lampione; Cavi Aerei;	\N	desktop/Foto\\8317.JPG	\N	1327	2019	30/01/2019	\N	\N	Sempreverde	1	0
1139	0101000020110F0000A9D9038DEA6A234104CAA67C916E5041	1328	5318	8318	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8318.JPG	\N	1328	2019	30/01/2019	\N	\N	Sempreverde	1	0
1140	0101000020110F000061E0B927F06A234101A43649906E5041	1329	5319	8319	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8319.JPG	\N	1329	2019	30/01/2019	\N	\N	Sempreverde	1	0
1907	0101000020110F000043E21E6B687B23418BE07FF5CA6C5041	1828	5787	8819	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1828	2018	06/12/2018	\N	\N	Sempreverde	1	0
1142	0101000020110F00005682C591026B23411D38673C906E5041	1331	5321	8321	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8321.JPG	\N	1331	2019	30/01/2019	\N	\N	Sempreverde	1	0
1143	0101000020110F0000CBBE2B92046B23412D0950C9906E5041	1332	5322	8322	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1332	2019	30/01/2019	\N	\N	Sempreverde	1	0
1144	0101000020110F0000611A865F076B2341596E6949916E5041	1333	5323	8323	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1333	2019	30/01/2019	\N	\N	Sempreverde	1	0
1145	0101000020110F000082C5E12C0A6B2341CBB914A3916E5041	1334	5324	8324	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1334	2019	30/01/2019	\N	\N	Sempreverde	1	0
1146	0101000020110F000018213CFA0C6B2341CDCCCC3C926E5041	1335	5325	8325	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1335	2019	30/01/2019	\N	\N	Sempreverde	1	0
1147	0101000020110F00003ACC97C70F6B2341F931E6BC926E5041	1336	5326	8326	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8326.JPG	\N	1336	2019	30/01/2019	\N	\N	Sempreverde	1	0
1148	0101000020110F0000EC866DFB126B234117D9CE49936E5041	1337	5327	8327	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1337	2019	30/01/2019	\N	\N	Sempreverde	1	0
1149	0101000020110F00009E41432F166B234126AAB7D6936E5041	1338	5328	8328	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8328.JPG	\N	1338	2019	30/01/2019	\N	\N	Sempreverde	1	0
1150	0101000020110F0000F4C308C121862341BCAE5FFC33655041	1339	335	643	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	Edificio;	\N	desktop/Foto\\643.JPG	\N	1339	2018	25/09/2018	\N	\N	Sempreverde	1	0
1151	0101000020110F0000882EA82F186B234119FF3E7D946E5041	1340	5329	8329	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8329.JPG	\N	1340	2019	30/01/2019	\N	\N	Sempreverde	1	0
1152	0101000020110F00007D5C1B2AFC6A2341F60B7697976E5041	1341	5330	8333	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1341	2019	30/01/2019	\N	\N	Sempreverde	1	0
1153	0101000020110F00005BCEA5F8046B2341E960FD3D986E5041	1342	5331	8334	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1342	2019	30/01/2019	\N	\N	Sempreverde	1	0
1154	0101000020110F0000C58F31C70D6B2341B26323FE986E5041	1343	5332	8335	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1343	2019	30/01/2019	\N	\N	Sempreverde	1	0
1155	0101000020110F000082E2C7C8156B23416D9049BE996E5041	1344	5333	8336	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1344	2019	30/01/2019	\N	\N	Sempreverde	1	0
1156	0101000020110F0000E65773301C6B234199F5623E9A6E5041	1345	5334	8337	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1345	2019	30/01/2019	\N	\N	Sempreverde	1	0
1157	0101000020110F0000F2EF33FE206B2341E1EEACB19A6E5041	1346	5335	8338	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1346	2019	30/01/2019	\N	\N	Sempreverde	1	0
1158	0101000020110F000034BA8398246B234137A627189B6E5041	1347	5336	8339	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Parco	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1347	2019	30/01/2019	\N	\N	Sempreverde	1	0
1159	0101000020110F000093003575826B234167614F359B6E5041	1348	5337	8343	Palma	WASHINGTONIA ROBUSTA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8343.JPG	\N	1348	2019	30/01/2019	\N	\N	Sempreverde	1	0
1160	0101000020110F0000FC3559E3846B2341A83AE4729A6E5041	1349	5338	8344	Albero	CALLISTEMON CITRINUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8344.JPG	\N	1349	2019	30/01/2019	\N	\N	-	1	0
1161	0101000020110F00006DFFCA2A7B6B234191D0962B9B6E5041	1350	5339	8345	Albero	CALLISTEMON CITRINUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8345.JPG	\N	1350	2019	30/01/2019	\N	\N	-	1	0
1162	0101000020110F0000DA1B7C51876B23416D9049A0986E5041	1351	5340	8347	Albero	NERIUM OLEANDER	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8347.JPG	\N	1351	2019	30/01/2019	\N	\N	Sempreverde	1	0
1163	0101000020110F0000352905ED876B2341B988EF3EA16E5041	1352	5341	8350	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1352	2019	30/01/2019	\N	\N	-	2	0
1164	0101000020110F00003CBD52D6886B2341F4328A11A36E5041	1353	5342	8351	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1353	2019	30/01/2019	\N	\N	-	2	0
1165	0101000020110F0000F4893CF92F812341D908C40D7B6A5041	1086	5090	8071	Fallanza	ACER SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Filare	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1086	2019	29/01/2019	\N	\N	-	3	0
1166	0101000020110F000096E7C16D4181234190831282746A5041	1087	5091	8074	Ceppaia	THUJA OCCIDENTALIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-07-14	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/5091/thb_181_WhatsApp Image 2020-07-14 at 07.56.08.jpeg	\N	1087	2020	14/07/2020	\N	\N	Sempreverde	2	0
1167	0101000020110F00003A7AFC8E3F812341137EA921756A5041	1088	5092	8076	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8076.JPG	\N	1088	2019	29/01/2019	\N	\N	-	1	0
1168	0101000020110F000043CA4FCA0E81234152616C89726A5041	1089	5093	8082	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\8082.JPG	\N	1089	2019	29/01/2019	\N	\N	-	1	0
1169	0101000020110F0000732EC5250D812341BE6A6574726A5041	1090	5094	8083	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\8083.JPG	\N	1090	2019	29/01/2019	\N	\N	-	1	0
1170	0101000020110F00008C2D04D90A8123416C04E269726A5041	1091	5095	8084	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8084.JPG	\N	1091	2019	29/01/2019	\N	\N	-	1	0
1171	0101000020110F0000BC9179340981234187A7574A726A5041	1092	5096	8085	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8085.JPG	\N	1092	2019	29/01/2019	\N	\N	-	1	0
1172	0101000020110F00004A41B7E7068123417DCB9C1C736A5041	1093	5097	8086	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8086.JPG	\N	1093	2019	29/01/2019	\N	\N	-	1	0
1173	0101000020110F00001D5A64EB05812341A6B8AA46736A5041	1094	5098	8087	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8087.JPG	\N	1094	2019	29/01/2019	\N	\N	-	1	0
1174	0101000020110F00003659A39E03812341DF6C7323746A5041	1095	5099	8088	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	ferite;	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8088.JPG	\N	1095	2019	29/01/2019	\N	\N	-	1	0
1175	0101000020110F0000999EB0B4FD802341A8A96503776A5041	1096	5100	8093	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8093.JPG	\N	1096	2019	29/01/2019	\N	\N	-	1	0
1176	0101000020110F000024D1CB08FE802341B6F3FD4C776A5041	1097	5101	8094	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	ferite;	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8094.JPG	\N	1097	2019	29/01/2019	\N	\N	-	1	0
1177	0101000020110F0000C68503B1FE80234130478F81776A5041	1098	5102	8095	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8095.JPG	\N	1098	2019	29/01/2019	\N	\N	-	1	0
1178	0101000020110F000052B81E05FF80234135B56C9D786A5041	1099	5103	8096	Albero	CUPRESSUS SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\8096.JPG	\N	1099	2019	29/01/2019	\N	\N	-	1	0
1179	0101000020110F0000315F5EE008812341DD7BB870736A5041	1100	5104	8091	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8091.JPG	\N	1100	2019	29/01/2019	\N	\N	Caduca	1	0
1180	0101000020110F000083DDB0DD5A8823411F9DBADE34655041	1101	321	629	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Marciapiede; Illuminazione pubblica; Edificio;	\N	desktop/Foto\\629.JPG	\N	1101	2018	25/09/2018	\N	\N	Caduca	1	0
1273	0101000020110F00007B884637F1652341139B8FE3276A5041	1194	5192	8286	Albero	CERATONIA SILIQUA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8286.JPG	\N	1194	2019	30/01/2019	\N	\N	-	1	0
1181	0101000020110F0000F2EF334E02812341276BD453786A5041	1102	5105	8100	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Procopio	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\8100.JPG	\N	1102	2019	29/01/2019	\N	\N	Caduca	1	0
1182	0101000020110F00002C6519A264812341314278F07E6A5041	1103	5106	8101	Albero	MESPILUS GERMANICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	\N	\N	\N	interferenza robinia	Manufatto; Camminamento;	\N	desktop/Foto\\8101.JPG	\N	1103	2019	29/01/2019	\N	\N	Caduca	1	0
1183	0101000020110F0000CB9C2EEB67812341314278F07E6A5041	1104	5107	8102	Ceppaia	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2020-01-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\8102.JPG	\N	1104	2020	25/01/2020	\N	\N	Caduca	2	0
1184	0101000020110F00000118CF0079812341D1915C9C7E6A5041	1105	5108	8103	Ceppaia	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2020-01-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Lampione; Sede Stradale; Marciapiede; Manufatto; Camminamento;	\N	photos/Albero/5108/thb_117_WhatsApp Image 2020-01-25 at 12.03.01.jpeg	\N	1105	2020	25/01/2020	\N	\N	Caduca	2	0
1185	0101000020110F00001500E369B781234155C1A86A746A5041	1106	5109	8104	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8104.JPG	\N	1106	2019	29/01/2019	\N	\N	Sempreverde	1	0
1186	0101000020110F00000D897B4CBF8123417DAEB694746A5041	1107	5110	8105	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1107	2019	29/01/2019	\N	\N	Sempreverde	2	0
1187	0101000020110F0000B537F8B2BA8123411B8178E1766A5041	1108	5111	8106	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1108	2019	29/01/2019	\N	\N	Caduca	1	0
1188	0101000020110F00009ED2C15AD28123416FD8B69E776A5041	1109	5112	8107	Albero	LAGERSTROEMIA INDICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8107.JPG	\N	1109	2019	29/01/2019	\N	\N	Caduca	1	0
1189	0101000020110F00009B559FFBD4812341F016484E766A5041	1110	5113	8108	Ceppaia	-	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-01-25	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/5113/thb_116_WhatsApp Image 2020-01-25 at 12.03.02 (1).jpeg	\N	1110	2020	25/01/2020	\N	\N	-	2	0
1190	0101000020110F0000C6DCB5E408822341878A71CC766A5041	1111	5114	8109	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1111	2019	29/01/2019	\N	\N	Sempreverde	1	0
1191	0101000020110F0000C959D843068223413A92CBDD776A5041	1112	5115	8110	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1112	2019	29/01/2019	\N	\N	Sempreverde	1	0
1192	0101000020110F000061E0B927C981234190662CFA756A5041	1113	5116	8112	Fallanza	-	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1113	2019	29/01/2019	\N	\N	-	3	0
1193	0101000020110F0000315F5ED0B2812341F3936AB7766A5041	1114	5117	8113	Fallanza	-	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1114	2019	29/01/2019	\N	\N	-	3	0
1194	0101000020110F00009127493797812341FC6F25E5756A5041	1115	5118	8114	Fallanza	-	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1115	2019	29/01/2019	\N	\N	-	3	0
1195	0101000020110F0000315F5E809A8123415E9D6398736A5041	1116	5119	8115	Fallanza	-	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1116	2019	29/01/2019	\N	\N	-	3	0
1196	0101000020110F000010406AF304822341C5AC17C5786A5041	1117	5120	8111	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\8111.JPG	\N	1117	2019	29/01/2019	\N	\N	Sempreverde	1	0
1197	0101000020110F00002783A36466882341D4F1984F36655041	1118	322	630	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	Sede Stradale; Marciapiede; Illuminazione pubblica; Edificio;	\N	desktop/Foto\\630.JPG	\N	1118	2018	25/09/2018	\N	\N	Caduca	1	0
1198	0101000020110F0000B7EEE6590082234103CFBDBD7A6A5041	1119	5121	8122	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\8122.JPG	\N	1119	2019	29/01/2019	\N	\N	Sempreverde	1	0
1199	0101000020110F000073857709FF8123412063EE507B6A5041	1120	5122	8123	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\8123.JPG	\N	1120	2019	29/01/2019	\N	\N	Sempreverde	1	0
1200	0101000020110F0000BA6B09B9FD812341DFC325F97B6A5041	1121	5123	8124	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	\N	\N	1121	2019	29/01/2019	\N	\N	Sempreverde	1	0
1201	0101000020110F0000D34D62C0FB81234176374F777C6A5041	1122	5124	8125	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione; Edificio;	\N	\N	\N	1122	2019	29/01/2019	\N	\N	Sempreverde	1	0
1202	0101000020110F00001A34F46FFA812341C98E8D347D6A5041	1123	5125	8126	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1123	2019	29/01/2019	\N	\N	Sempreverde	1	0
1203	0101000020110F0000D5CA841FF9812341522CB7B27D6A5041	1124	5126	8127	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1124	2019	29/01/2019	\N	\N	Sempreverde	1	0
1204	0101000020110F00007AFCDE26F78123417D96E7457E6A5041	1125	5127	8128	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1125	2019	29/01/2019	\N	\N	Sempreverde	1	0
1205	0101000020110F000036936FD6F5812341130A11C47E6A5041	1126	5128	8129	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1126	2019	29/01/2019	\N	\N	Sempreverde	1	0
1206	0101000020110F00007D790186F48123419CA73A427F6A5041	1127	5129	8130	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1127	2019	29/01/2019	\N	\N	Sempreverde	1	0
1207	0101000020110F0000DBC4C9DDF38123415B0872EA7F6A5041	1128	5130	8131	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	\N	\N	1128	2019	29/01/2019	\N	\N	Sempreverde	1	0
1208	0101000020110F000026AAB716C48223418B89CD1B896A5041	1129	5131	8132	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	cercine di legatura;	\N	\N	\N	Edificio;	\N	desktop/Foto\\8132.JPG	\N	1129	2019	29/01/2019	\N	\N	Sempreverde	1	0
1209	0101000020110F0000232D95B7C6822341D3872E428A6A5041	1130	5132	8133	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Edificio;	\N	\N	\N	1130	2019	29/01/2019	\N	\N	Sempreverde	1	0
1210	0101000020110F000017BCE8DBD38223414BEA04C4896A5041	1131	5133	8134	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Edificio;	\N	desktop/Foto\\8134.JPG	\N	1131	2019	29/01/2019	\N	\N	Sempreverde	1	0
1211	0101000020110F000019390B3BD18223416AFB57C08A6A5041	1132	5134	8135	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Edificio;	\N	desktop/Foto\\8135.JPG	\N	1132	2019	29/01/2019	\N	\N	Sempreverde	1	0
1212	0101000020110F00001C99478ED0822341FB7953458B6A5041	1133	5135	8136	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	capitozzatura; ferite;	\N	\N	\N	Recinzione;	\N	\N	\N	1133	2019	29/01/2019	\N	\N	Sempreverde	1	0
1213	0101000020110F000008944D39CF8223419626A5288C6A5041	1134	5136	8138	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	capitozzatura; ferite;	\N	\N	\N	Recinzione;	\N	\N	\N	1134	2019	29/01/2019	\N	\N	Sempreverde	1	0
1214	0101000020110F0000EF72115F71882341E3C798E337655041	1135	323	631	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Edificio;	\N	desktop/Foto\\631.JPG	\N	1135	2018	25/09/2018	\N	\N	Caduca	1	0
1215	0101000020110F00006440F6AACF822341BD3AC7A88B6A5041	1136	5137	8137	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\8137.JPG	\N	1136	2019	29/01/2019	\N	\N	Sempreverde	1	0
1216	0101000020110F00004F3BFC55CE822341603C83A88C6A5041	1137	5138	8139	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Recinzione; Edificio;	\N	desktop/Foto\\8139.JPG	\N	1137	2019	29/01/2019	\N	\N	Sempreverde	1	0
1217	0101000020110F00000C93A972CD822341C53D96368D6A5041	1138	5139	8140	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Santa Maria	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8140.JPG	\N	1138	2019	29/01/2019	\N	\N	Sempreverde	1	0
1218	0101000020110F0000A852B367FE8423416536C8D8C56A5041	1139	5140	8141	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-12-17	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8141.JPG	\N	1139	2019	17/12/2019	\N	\N	Sempreverde	2	0
1219	0101000020110F0000D0ED254DF7842341E8D9AC12C26A5041	1140	5141	8142	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8142.JPG	\N	1140	2019	29/01/2019	\N	\N	Sempreverde	1	0
1220	0101000020110F0000419FC813F98423411500E32FBF6A5041	1141	5142	8143	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8143.JPG	\N	1141	2019	29/01/2019	\N	\N	Caduca	1	0
1221	0101000020110F0000A453572E008523410E2DB2BDC06A5041	1142	5143	8144	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	\N	\N	1142	2019	29/01/2019	\N	\N	Caduca	1	0
1222	0101000020110F00009D685791F7842341BA490C08C16A5041	1143	5144	8145	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	\N	\N	1143	2019	29/01/2019	\N	\N	Caduca	1	0
1223	0101000020110F00004DA1F34AF18423416ADE7162C36A5041	1144	5145	8146	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con ferite; branche secche; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8146.JPG	\N	1144	2019	29/01/2019	\N	\N	Caduca	1	0
1224	0101000020110F0000DA38621DDC842341282CF1DAC46A5041	1145	5146	8150	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-12-17	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1145	2019	17/12/2019	\N	\N	Sempreverde	2	0
1225	0101000020110F00008B71FED6D58423419D68573FC56A5041	1146	5147	8151	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	\N	\N	1146	2019	29/01/2019	\N	\N	Caduca	1	0
1226	0101000020110F0000EACA6759D0842341ED2AA48AC56A5041	1147	5148	8152	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8152.JPG	\N	1147	2019	29/01/2019	\N	\N	Caduca	1	0
1227	0101000020110F0000BFD4CFDBCA8423413EEDF0D5C56A5041	1148	5149	8153	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	\N	\N	1148	2019	29/01/2019	\N	\N	Caduca	1	0
1228	0101000020110F00006F0D6C95C4842341780B2408C66A5041	1149	5150	8154	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8154.JPG	\N	1149	2019	29/01/2019	\N	\N	Caduca	1	0
1229	0101000020110F00009C33A2F4BB84234112C2A385C66A5041	1150	5151	8155	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8155.JPG	\N	1150	2019	29/01/2019	\N	\N	Caduca	1	0
1230	0101000020110F0000787AA51CB48423416284F0D0C66A5041	1151	5152	8156	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con cancri; branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	\N	\N	1151	2019	29/01/2019	\N	\N	Caduca	1	0
1231	0101000020110F0000182653F5778823418104C51F39655041	1152	324	632	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche con fratture/incrinature; insetti lignivori; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	Sede Stradale; Marciapiede; Illuminazione pubblica; Edificio;	\N	desktop/Foto\\632.JPG	\N	1152	2018	25/09/2018	\N	\N	Caduca	1	0
1232	0101000020110F00004417D417BF842341ED478A6CC66A5041	1153	5153	8158	Albero	FICUS ELASTICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1153	2019	29/01/2019	\N	\N	Sempreverde	1	0
1233	0101000020110F000071C971A767802341130A11DA3C6A5041	1154	5154	8020	Ceppaia	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Quattro Novembre	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2022-11-23	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Recinzione;	\N	photos/Albero/5154/thb_WhatsApp Image 2022-11-23 at 12.52.03 (1)_326.jpeg	\N	1154	2022	23/11/2022	\N	\N	Sempreverde	2	0
1234	0101000020110F0000C7293A72C1842341D7A37053C66A5041	1155	5155	8157	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei; Sede Stradale;	\N	desktop/Foto\\8157.JPG	\N	1155	2019	29/01/2019	\N	\N	Sempreverde	1	0
1235	0101000020110F0000061214EF9E842341FB3A704EC76A5041	1156	5156	8159	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	\N	\N	1156	2019	29/01/2019	\N	\N	Sempreverde	1	0
1236	0101000020110F0000EF1B5F0B3C84234116C1FFAEC36A5041	1157	5157	8161	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	\N	\N	1157	2019	29/01/2019	\N	\N	Sempreverde	1	0
1237	0101000020110F00008EE9090B2A8423414850FCEEC26A5041	1158	5158	8162	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Sede Stradale; Recinzione;	\N	desktop/Foto\\8162.JPG	\N	1158	2019	29/01/2019	\N	\N	Sempreverde	1	0
1238	0101000020110F0000F5B9DA0A2084234123DBF96EC26A5041	1159	5159	8163	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Lampione; Sede Stradale; Recinzione;	\N	desktop/Foto\\8163.JPG	\N	1159	2019	29/01/2019	\N	\N	Sempreverde	1	0
1239	0101000020110F0000726DA808A98323413602F18EC06A5041	1160	5160	8164	Ceppaia	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Lampione; Sede Stradale; Recinzione;	\N	desktop/Foto\\8164.JPG	\N	1160	2019	29/01/2019	\N	\N	Sempreverde	2	0
1240	0101000020110F00009C8A540897832341CF4E060FC56A5041	1161	5161	8166	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	\N	\N	1161	2019	29/01/2019	\N	\N	Sempreverde	1	0
1241	0101000020110F00009F1F460894832341280F0B0FC66A5041	1162	5162	8167	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	desktop/Foto\\8167.JPG	\N	1162	2019	29/01/2019	\N	\N	Sempreverde	1	0
1242	0101000020110F0000D3872E088F832341BB270FEFC66A5041	1163	5163	8168	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	desktop/Foto\\8168.JPG	\N	1163	2019	29/01/2019	\N	\N	Sempreverde	1	0
1243	0101000020110F0000374F75089E83234196CFF2EEC06A5041	1164	5164	8169	Ceppaia	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8169.JPG	\N	1164	2019	29/01/2019	\N	\N	Sempreverde	2	0
1244	0101000020110F0000AF7C96076F832341A01A2FAFCD6A5041	1165	5165	8170	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8170.JPG	\N	1165	2019	29/01/2019	\N	\N	Caduca	1	0
1245	0101000020110F00007B14AE07748323417FD93DCFD06A5041	1166	5166	8171	Albero	EUCALYPTUS CAMALDULENSIS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	desktop/Foto\\8171.JPG	\N	1166	2019	29/01/2019	\N	\N	Sempreverde	1	0
1246	0101000020110F000004E78C08A38323415F984CEFD36A5041	1167	5167	8172	Albero	OLEA EUROPAEA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\8172.JPG	\N	1167	2019	29/01/2019	\N	\N	Sempreverde	1	0
1247	0101000020110F000068AED308B28323415F984CEFD36A5041	1168	5168	8173	Albero	OLEA EUROPAEA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\8173.JPG	\N	1168	2019	29/01/2019	\N	\N	Sempreverde	1	0
1248	0101000020110F0000569FABBD808823417AC2127F3A655041	1169	325	633	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Tornello con cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Illuminazione pubblica; Edificio;	\N	desktop/Foto\\633.JPG	\N	1169	2018	25/09/2018	\N	\N	Caduca	1	0
1249	0101000020110F000068226C089C832341758E010FC46A5041	1170	5169	8165	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	desktop/Foto\\8165.JPG	\N	1170	2019	29/01/2019	\N	\N	Sempreverde	1	0
1250	0101000020110F0000CA6C9009DA8323413B191CAFC96A5041	1171	5170	8174	Albero	NERIUM OLEANDER	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione;	\N	desktop/Foto\\8174.JPG	\N	1171	2019	29/01/2019	\N	\N	Sempreverde	1	0
1251	0101000020110F0000618E1E6FBE842341DA209356A96A5041	1172	5171	8176	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8176.JPG	\N	1172	2019	29/01/2019	\N	\N	Caduca	1	0
1252	0101000020110F0000C80C5446C3842341841266E2A86A5041	1173	5172	8177	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8177.JPG	\N	1173	2019	29/01/2019	\N	\N	Caduca	1	0
1253	0101000020110F000054573EFBCF842341EDBB2234A86A5041	1174	5173	8178	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	\N	\N	1174	2019	29/01/2019	\N	\N	Sempreverde	1	0
1254	0101000020110F0000C16ED866D28423410057B211A76A5041	1175	5174	8179	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8179.JPG	\N	1175	2019	29/01/2019	\N	\N	Caduca	1	0
1255	0101000020110F00009604A8A9D9842341711B0D18A16A5041	1176	5175	8183	Albero	PRUNUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; seccume diffuso;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8183.JPG	\N	1176	2019	29/01/2019	\N	\N	-	1	0
1256	0101000020110F0000A1D6348FA965234169A9BCA1366A5041	1177	5176	8270	Ceppaia	-	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8270.JPG	\N	1177	2019	30/01/2019	\N	\N	-	2	0
1257	0101000020110F0000ABECBBE2CA65234189247A53376A5041	1178	5177	8271	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1178	2019	30/01/2019	\N	\N	Sempreverde	1	0
1258	0101000020110F00001B2AC609CE652341DE8E7026366A5041	1179	5178	8272	Fallanza	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1179	2019	30/01/2019	\N	\N	Sempreverde	3	0
1259	0101000020110F0000E544BBCAD265234177BE9F14356A5041	1180	5179	8273	Fallanza	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1180	2019	30/01/2019	\N	\N	Sempreverde	3	0
1260	0101000020110F000058AD4C98D6652341D34D62E4336A5041	1181	5180	8274	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8274.JPG	\N	1181	2019	30/01/2019	\N	\N	Sempreverde	1	0
1261	0101000020110F000073637A72D96523412FDD24B4326A5041	1182	5181	8275	Fallanza	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1182	2019	30/01/2019	\N	\N	Sempreverde	3	0
1262	0101000020110F0000E6CB0B40DD6523418B6CE783316A5041	1183	5182	8276	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8276.JPG	\N	1183	2019	30/01/2019	\N	\N	Sempreverde	1	0
1263	0101000020110F00007632381AE06523416F128390306A5041	1184	5183	8277	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8277.JPG	\N	1184	2019	30/01/2019	\N	\N	Sempreverde	1	0
1264	0101000020110F0000E99AC9E7E36523418E588BBB2F6A5041	1185	5184	8278	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1185	2019	30/01/2019	\N	\N	Sempreverde	1	0
1265	0101000020110F0000C2340C3F9788234119FF3E4F3D655041	1186	326	634	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Edificio;	\N	desktop/Foto\\634.JPG	\N	1186	2018	25/09/2018	\N	\N	Caduca	1	0
1266	0101000020110F00000551F7C1E665234172FE26C82E6A5041	1187	5185	8279	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8279.JPG	\N	1187	2019	30/01/2019	\N	\N	Sempreverde	1	0
1267	0101000020110F00005C035BB5E765234155A4C2D42D6A5041	1188	5186	8280	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8280.JPG	\N	1188	2019	30/01/2019	\N	\N	Sempreverde	1	0
1268	0101000020110F0000261E5076EC652341384A5EE12C6A5041	1189	5187	8281	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8281.JPG	\N	1189	2019	30/01/2019	\N	\N	Sempreverde	1	0
1269	0101000020110F00009886E143F0652341D1798DCF2B6A5041	1190	5188	8282	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8282.JPG	\N	1190	2019	30/01/2019	\N	\N	Sempreverde	1	0
1270	0101000020110F00000BEF7211F46523412D09509F2A6A5041	1191	5189	8283	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1191	2019	30/01/2019	\N	\N	Sempreverde	1	0
1271	0101000020110F000044A33BF8F5652341C5387F8D296A5041	1192	5190	8284	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8284.JPG	\N	1192	2019	30/01/2019	\N	\N	Sempreverde	1	0
1272	0101000020110F0000990D32B9FA652341A9DE1A9A286A5041	1193	5191	8285	Albero	LIGUSTRUM JAPONICA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8285.JPG	\N	1193	2019	30/01/2019	\N	\N	Sempreverde	1	0
1274	0101000020110F00000F45812E05662341F35487B8286A5041	1195	5193	8287	Albero	CERATONIA SILIQUA	SANTA MARIA-CORVO-BARONE	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8287.JPG	\N	1195	2019	30/01/2019	\N	\N	-	1	0
1275	0101000020110F00007EE36B2F7D6723415DE15D06076F5041	1196	5194	7492	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	2.4	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7492.JPG	\N	1196	2019	25/01/2019	\N	\N	-	1	0
1276	0101000020110F0000A436712294672341B2463D1C086F5041	1197	5195	7493	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	2.4	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7493.JPG	\N	1197	2019	25/01/2019	\N	\N	-	1	0
1277	0101000020110F0000008C6780A56723410820B561086F5041	1198	5196	7494	Albero	TILIA SP	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7494.JPG	\N	1198	2019	25/01/2019	\N	\N	-	1	0
1278	0101000020110F00007250C25CA767234140136187076F5041	1199	5197	7495	Albero	TILIA SP	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7495.JPG	\N	1199	2019	25/01/2019	\N	\N	-	1	0
1279	0101000020110F00008BC399BF9D672341EBC55012086F5041	1200	5198	7497	Albero	CEDRUS ATLANTICA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7497.JPG	\N	1200	2019	25/01/2019	\N	\N	Sempreverde	1	0
1280	0101000020110F0000698CD6719467234179AF5A85066F5041	1201	5199	7498	Albero	CALLISTEMON CITRINUS	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7498.JPG	\N	1201	2019	25/01/2019	\N	\N	-	1	0
1281	0101000020110F0000C02154C99867234196ECD8CC076F5041	1202	5200	7499	Albero	CITRUS LIMONUM	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7499.JPG	\N	1202	2019	25/01/2019	\N	\N	Sempreverde	1	0
1282	0101000020110F0000745E6307A08823413ACC97333E655041	1203	327	635	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	7	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Sede Stradale; Marciapiede; Edificio;	\N	desktop/Foto\\635.JPG	\N	1203	2018	25/09/2018	\N	\N	Caduca	1	0
1283	0101000020110F0000D578E9868167234140FB91E6056F5041	1204	5201	7500	Albero	OLEA EUROPAEA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7500.JPG	\N	1204	2019	25/01/2019	\N	\N	Sempreverde	1	0
1284	0101000020110F00000B7BDAF17B6723414D10756D046F5041	1205	5202	7506	Albero	OLEA EUROPAEA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7506.JPG	\N	1205	2019	25/01/2019	\N	\N	Sempreverde	1	0
1285	0101000020110F000040D994FB76672341A2D11D12036F5041	1206	5203	7507	Albero	OLEA EUROPAEA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7507.JPG	\N	1206	2019	25/01/2019	\N	\N	Sempreverde	1	0
1286	0101000020110F000064CC5D6B876723411405FAA6036F5041	1207	5204	7508	Albero	OLEA EUROPAEA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7508.JPG	\N	1207	2019	25/01/2019	\N	\N	Sempreverde	1	0
1287	0101000020110F0000FB3A70DE54672341CC971710026F5041	1208	5205	7509	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7509.JPG	\N	1208	2019	25/01/2019	\N	\N	-	1	0
1288	0101000020110F0000349D9DCC55672341763238FA006F5041	1209	5206	7510	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7510.JPG	\N	1209	2019	25/01/2019	\N	\N	-	1	0
1289	0101000020110F0000A661F8A85767234168226CDAFF6E5041	1210	5207	7511	Albero	JUGLANS REGIA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7511.JPG	\N	1210	2019	25/01/2019	\N	\N	Caduca	1	0
1290	0101000020110F0000C49448125B672341BEDEFD17016F5041	1211	5208	7512	Albero	CEDRUS ATLANTICA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7512.JPG	\N	1211	2019	25/01/2019	\N	\N	Sempreverde	1	0
1291	0101000020110F0000E7E3DA206C672341CC7F486F006F5041	1212	5209	7514	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7514.JPG	\N	1212	2019	25/01/2019	\N	\N	-	1	0
1292	0101000020110F00000877670D76672341763238FA006F5041	1213	5210	7515	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7515.JPG	\N	1213	2019	25/01/2019	\N	\N	-	1	0
1293	0101000020110F0000616C21E88067234121E52785016F5041	1214	5211	7516	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7516.JPG	\N	1214	2019	25/01/2019	\N	\N	-	1	0
1294	0101000020110F0000499D80E6896723414C6C3EFC016F5041	1215	5212	7517	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7517.JPG	\N	1215	2019	25/01/2019	\N	\N	-	1	0
1295	0101000020110F000031CEDFE492672341BE9F1A91026F5041	1216	5213	7518	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE B	\N	\N	ferite;	\N	capitozzatura; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7518.JPG	\N	1216	2019	25/01/2019	\N	\N	-	1	0
1296	0101000020110F0000A54E40E39B6723415B2558F4026F5041	1217	5214	7519	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7519.JPG	\N	1217	2019	25/01/2019	\N	\N	-	1	0
1297	0101000020110F0000008C6780A567234106D8477F036F5041	1218	5215	7520	Albero	JUGLANS NIGRA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7520.JPG	\N	1218	2019	25/01/2019	\N	\N	Caduca	1	0
1298	0101000020110F000003ECA303AC672341A25D85E2036F5041	1219	5216	7521	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7521.JPG	\N	1219	2019	25/01/2019	\N	\N	-	1	0
1299	0101000020110F000031EBC5F0A6852341A1A17F862A655041	1220	328	636	Albero	SCHINUS MOLLE	CATANZARO LIDO	-	Piazza	IV Fortuna, Lido	Piazza Venezia	Isolato	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	tagli impropri;	polloni radicali;	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\636.JPG	\N	1220	2018	25/09/2018	\N	\N	Sempreverde	1	0
1300	0101000020110F0000CC457C37B26723413FE3C245046F5041	1221	5217	7522	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7522.JPG	\N	1221	2019	25/01/2019	\N	\N	-	1	0
1301	0101000020110F0000923F18E8B1672341EA95B2D0046F5041	1222	5218	7523	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	ferite;	\N	capitozzatura;	\N	\N	\N	\N	\N	desktop/Foto\\7523.JPG	\N	1222	2019	25/01/2019	\N	\N	-	1	0
1302	0101000020110F0000740CC87EAE6723414E28440E066F5041	1223	5219	7524	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7524.JPG	\N	1223	2019	25/01/2019	\N	\N	-	1	0
1303	0101000020110F0000378E58EB9F672341A48D2324076F5041	1224	5220	7496	Albero	LIQUIDAMBAR STYRACIFLUA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7496.JPG	\N	1224	2019	25/01/2019	\N	\N	Caduca	1	0
1304	0101000020110F0000FE43FABDA667234123A12D97056F5041	1225	5221	7525	Albero	LIQUIDAMBAR STYRACIFLUA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7525.JPG	\N	1225	2019	25/01/2019	\N	\N	Caduca	1	0
1305	0101000020110F0000E5B8539AA8672341BF0E9C59046F5041	1226	5222	7526	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7526.JPG	\N	1226	2019	25/01/2019	\N	\N	-	1	0
1306	0101000020110F0000A3923AC1946723413F575B75036F5041	1227	5223	7527	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7527.JPG	\N	1227	2019	25/01/2019	\N	\N	-	1	0
1307	0101000020110F00002ECA6C008D672341147992D6026F5041	1228	5224	7528	Albero	ACER SP.	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7528.JPG	\N	1228	2019	25/01/2019	\N	\N	-	1	0
1308	0101000020110F0000ECA353277967234105C078DE016F5041	1229	5225	7529	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7529.JPG	\N	1229	2019	25/01/2019	\N	\N	Sempreverde	1	0
1309	0101000020110F000005172B8A6F67234113B8755D016F5041	1230	5226	7530	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Miraglia	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7530.JPG	\N	1230	2019	25/01/2019	\N	\N	Sempreverde	1	0
1310	0101000020110F0000A1F831D6B27623414F58E217AE6E5041	1231	5227	7538	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Via Carlo V	Isolato	0	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7538.JPG	\N	1231	2019	25/01/2019	\N	\N	Sempreverde	1	0
1311	0101000020110F000087A7575A0D78234192B3B04DAB6E5041	1232	5228	7539	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Coculi	Isolato	0	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7539.JPG	\N	1232	2019	25/01/2019	\N	\N	Sempreverde	1	0
1312	0101000020110F0000257502BABE752341EE3D5CE6F86E5041	1233	5229	7543	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7543.JPG	\N	1233	2019	25/01/2019	\N	\N	Sempreverde	1	0
1313	0101000020110F0000C18BBE42F8752341BD5296C9FD6E5041	1234	5230	7542	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7542.JPG	\N	1234	2019	25/01/2019	\N	\N	Sempreverde	1	0
1314	0101000020110F00008E40BC7EFA752341E25817F3FC6E5041	1235	5231	7541	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7541.JPG	\N	1235	2019	25/01/2019	\N	\N	Sempreverde	1	0
1315	0101000020110F0000CEA5B8BAFC7523413142782EFC6E5041	1236	5232	7540	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7540.JPG	\N	1236	2019	25/01/2019	\N	\N	Sempreverde	1	0
1316	0101000020110F0000AA436E069F8523411EF983D52C655041	1237	329	637	Albero	SCHINUS MOLLE	CATANZARO LIDO	-	Piazza	IV Fortuna, Lido	Piazza Venezia	Isolato	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	tagli impropri;	polloni radicali;	\N	inclinazione ingiustificata;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\637.JPG	\N	1237	2018	25/09/2018	\N	\N	Sempreverde	1	0
1317	0101000020110F0000FAF2029CBD7523418DD13A16FA6E5041	1238	5233	7544	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7544.JPG	\N	1238	2019	25/01/2019	\N	\N	Sempreverde	1	0
1318	0101000020110F000009A705EFBB752341EFFE789FFB6E5041	1239	5234	7545	Albero	CITRUS AURANTIUM	PIAZZA MATTEOTTI	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Matteotti	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7545.JPG	\N	1239	2019	25/01/2019	\N	\N	Sempreverde	1	0
1319	0101000020110F0000F3599EF7DE742341EBFF1CAC076F5041	1240	5235	7546	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Turco	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-25	7	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con carie; branche con ferite; branche con fratture/incrinature; branche protese;	ferite; strozzatura;	\N	cercine di legatura; ferite;	\N	\N	\N	Cartellonistica; Sede Stradale; Manufatto; Edificio;	\N	desktop/Foto\\7546.JPG	\N	1240	2019	25/01/2019	\N	\N	Caduca	1	0
1320	0101000020110F000062F88848F0742341D8BB3F5E056F5041	1241	5236	7547	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Turco	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2024-11-25	7	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE D	\N	branche con carie; branche con ferite; branche con fratture/incrinature; branche protese;	ferite; strozzatura;	\N	carie; cercine di legatura; ferite; insetti lignivori;	\N	\N	\N	Cartellonistica; Sede Stradale; Manufatto; Edificio;	\N	desktop/Foto\\7547.JPG	\N	1241	2024	25/11/2024	\N	\N	Caduca	1	0
1321	0101000020110F0000EFFE783FFE742341DCD7818D036F5041	1242	5237	7548	Ceppaia	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Turco	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Manufatto; Edificio;	\N	desktop/Foto\\7548.JPG	\N	1242	2019	25/01/2019	\N	\N	Caduca	2	0
1322	0101000020110F000082E2C7E8867A2341FA449EA6F86D5041	1243	5238	7553	Albero	PINUS PINEA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	7	4) 16m = 23m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	strozzatura;	\N	\N	\N	\N	\N	Cartellonistica; Sede Stradale; Manufatto; Edificio;	\N	desktop/Foto\\7553.JPG	\N	1243	2019	25/01/2019	\N	\N	Sempreverde	1	0
1323	0101000020110F00006B82A89B8A7A2341CBF3E0B2F66D5041	1244	5239	7554	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche;	strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7554.JPG	\N	1244	2019	25/01/2019	\N	\N	Sempreverde	1	0
1324	0101000020110F000006D847D78B7A23414AB54FD3F56D5041	1245	5240	7555	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche;	strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7555.JPG	\N	1245	2019	25/01/2019	\N	\N	Sempreverde	1	0
1325	0101000020110F0000DC291D7C8D7A23417C61321BF56D5041	1246	5241	7556	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche secche;	strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7556.JPG	\N	1246	2019	25/01/2019	\N	\N	Sempreverde	1	0
1326	0101000020110F0000543A581FF17A23410E4A9849F86D5041	1247	5242	7559	Palma	BUTIA CAPITATA	CATANZARO	-	Aiuola stradale	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7559.JPG	\N	1247	2019	25/01/2019	\N	\N	Sempreverde	1	0
1327	0101000020110F000017653608D87A23414FCC7A29F86D5041	1248	5243	7560	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Aiuola stradale	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7560.JPG	\N	1248	2019	25/01/2019	\N	\N	Sempreverde	2	0
1328	0101000020110F000086E63A2D007B23417099D389F86D5041	1249	5244	7561	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Aiuola stradale	II Centro Storico, Stadio, San Leonardo	Viale dei Bizantini	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7561.JPG	\N	1249	2019	25/01/2019	\N	\N	Sempreverde	2	0
1348	0101000020110F0000BBB88D46EE7423413E22A6DE84705041	1269	5263	7797	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7797.JPG	\N	1269	2019	28/01/2019	\N	\N	Sempreverde	1	0
1329	0101000020110F0000444C89E401742341C616826AFE6F5041	1250	5245	6153	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6153.JPG	\N	1250	2019	26/01/2019	\N	\N	Sempreverde	1	0
1330	0101000020110F0000D8F50B46D77423417ADFF85473705041	1251	5246	7738	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Cartellonistica;	\N	desktop/Foto\\7738.JPG	\N	1251	2019	28/01/2019	\N	\N	Sempreverde	1	0
1331	0101000020110F000046B1DCD2E0742341541D721774705041	1252	5247	7739	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7739.JPG	\N	1252	2019	28/01/2019	\N	\N	Sempreverde	1	0
1332	0101000020110F00002A1DAC5FEA74234163EE5AA274705041	1253	5248	7740	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7740.JPG	\N	1253	2019	28/01/2019	\N	\N	Sempreverde	1	0
1333	0101000020110F0000DDCD534DA48523419296CA832B655041	1254	330	638	Albero	FICUS SP.	CATANZARO LIDO	-	Piazza	IV Fortuna, Lido	Piazza Venezia	Isolato	0	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	tagli impropri;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\638.JPG	\N	1254	2018	25/09/2018	\N	\N	-	1	0
1334	0101000020110F00000D897BECF3742341F7C77B1175705041	1255	5249	7741	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7741.JPG	\N	1255	2019	28/01/2019	\N	\N	Sempreverde	1	0
1335	0101000020110F00000E4A984905752341AA48850B76705041	1256	5250	7742	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7742.JPG	\N	1256	2019	28/01/2019	\N	\N	Sempreverde	1	0
1336	0101000020110F0000E1D1C61121752341F0A2AF7477705041	1257	5251	7749	Albero	POPULUS NIGRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche codominanti; branche con ferite; branche protese;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7749.JPG	\N	1257	2019	28/01/2019	\N	\N	Caduca	1	0
1337	0101000020110F0000FE65F784177523414DF38E0577705041	1258	5252	7743	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7743.JPG	\N	1258	2019	28/01/2019	\N	\N	Sempreverde	1	0
1338	0101000020110F0000FE2614E228752341F19D98FF77705041	1259	5253	7744	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7744.JPG	\N	1259	2019	28/01/2019	\N	\N	Sempreverde	1	0
1339	0101000020110F00007F87A29031752341282CF15278705041	1260	5254	7745	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7745.JPG	\N	1260	2019	28/01/2019	\N	\N	Sempreverde	1	0
1340	0101000020110F00009CDCEF60397523415EBA49A678705041	1261	5255	7746	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7746.JPG	\N	1261	2019	28/01/2019	\N	\N	Sempreverde	1	0
1341	0101000020110F00001D3D7E0F427523416E8B323179705041	1262	5256	7747	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\7747.JPG	\N	1262	2019	28/01/2019	\N	\N	Sempreverde	1	0
1342	0101000020110F000063B48E7A4C752341103B53A079705041	1263	5257	7748	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7748.JPG	\N	1263	2019	28/01/2019	\N	\N	Sempreverde	1	0
1343	0101000020110F00008E9257273E7523416DCA15EC7E705041	1264	5258	7755	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	1.7	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche secche;	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\7755.JPG	\N	1264	2019	28/01/2019	\N	\N	Caduca	1	0
1344	0101000020110F000065AA60342F752341F914008D87705041	1265	5259	7792	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7792.JPG	\N	1265	2019	28/01/2019	\N	\N	Sempreverde	1	0
1345	0101000020110F0000CA4FAAFD25752341D8BB3FB286705041	1266	5260	7793	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7793.JPG	\N	1266	2019	28/01/2019	\N	\N	Sempreverde	1	0
1346	0101000020110F00000742B2C0FB74234132E6AEB984705041	1267	5261	7795	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	strozzatura;	\N	monconi;	\N	\N	\N	Cartellonistica; Sede Stradale; Edificio;	\N	desktop/Foto\\7795.JPG	\N	1267	2019	28/01/2019	\N	\N	Sempreverde	1	0
1347	0101000020110F0000D5CF9BAAF3742341CFDA6D6384705041	1268	5262	7796	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7796.JPG	\N	1268	2019	28/01/2019	\N	\N	Sempreverde	1	0
1349	0101000020110F0000CA4FAABDEE7423418CBE82EC84705041	1270	5264	7798	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7798.JPG	\N	1270	2019	28/01/2019	\N	\N	Sempreverde	1	0
1350	0101000020110F0000C6DCB5B49D85234141B797A82D655041	1271	331	639	Albero	FICUS SP.	CATANZARO LIDO	-	Piazza	IV Fortuna, Lido	Piazza Venezia	Isolato	0	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	tagli impropri;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\639.JPG	\N	1271	2018	25/09/2018	\N	\N	-	1	0
1351	0101000020110F0000BE9F1A0FEE742341F437A1FA84705041	1272	5265	7799	Albero	CUPRESSUS SEMPERVIRENS HORIZONTALIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	strozzatura;	\N	monconi;	\N	\N	\N	Sede Stradale; Edificio;	\N	desktop/Foto\\7799.JPG	\N	1272	2019	28/01/2019	\N	\N	Sempreverde	1	0
1352	0101000020110F0000FFB27BC2D1742341E353008C7D705041	1273	5266	7801	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche secche; monconi; seccume localizzato;	\N	\N	inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\7801.JPG	\N	1273	2019	28/01/2019	\N	\N	Sempreverde	1	0
1353	0101000020110F0000529B3859D87423417689EA877E705041	1274	5267	7802	Albero	TILIA CORDATA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	monconi;	\N	\N	ferite; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\7802.JPG	\N	1274	2019	28/01/2019	\N	\N	Sempreverde	1	0
1354	0101000020110F0000ED9E3C9CD57423412BDEC88E7F705041	1275	5268	7803	Albero	TILIA CORDATA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	monconi;	\N	\N	ferite; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\7803.JPG	\N	1275	2019	28/01/2019	\N	\N	Sempreverde	1	0
1355	0101000020110F0000FE9AAC31DF742341587380D07F705041	1276	5269	7804	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7804.JPG	\N	1276	2019	28/01/2019	\N	\N	Sempreverde	1	0
1356	0101000020110F0000179F0230D27423412D6002E979705041	1277	5270	7805	Albero	QUERCUS ILEX	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	3	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	carie; cavit�; ferite; insetti lignivori; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\7805.JPG	\N	1277	2019	28/01/2019	\N	\N	Sempreverde	1	0
1357	0101000020110F0000276BD4E302882341111E6D50F6675041	1585	5559	7455	Albero	POPULUS NIGRA	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7455.JPG	\N	1585	2019	25/01/2019	\N	\N	Caduca	1	0
1358	0101000020110F0000713D0A870E88234125236705F5675041	1586	5560	7456	Albero	CITRUS LIMONUM	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7456.JPG	\N	1586	2019	25/01/2019	\N	\N	Sempreverde	1	0
1359	0101000020110F00008733BFDAD4872341A089B073DE675041	1587	5561	7457	Albero	CEDRUS ATLANTICA	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7457.JPG	\N	1587	2019	25/01/2019	\N	\N	Sempreverde	1	0
1360	0101000020110F00009B38B98FD3872341C7681D33E1675041	1588	5562	7458	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7458.JPG	\N	1588	2019	25/01/2019	\N	\N	Caduca	1	0
1361	0101000020110F0000361FD706DA872341E94317E8DF675041	1589	5563	7459	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7459.JPG	\N	1589	2019	25/01/2019	\N	\N	Caduca	1	0
1362	0101000020110F0000A9FB0014E387234143CA4F4ADE675041	1590	5564	7460	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7460.JPG	\N	1590	2019	25/01/2019	\N	\N	Caduca	1	0
1363	0101000020110F000043E21E8BE98723413F912783DC675041	1591	5565	7461	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7461.JPG	\N	1591	2019	25/01/2019	\N	\N	Caduca	1	0
1364	0101000020110F0000B6BE4898F28723413A58FFBBDA675041	1592	5566	7462	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7462.JPG	\N	1592	2019	25/01/2019	\N	\N	Caduca	1	0
1365	0101000020110F0000849ECD0A0F882341DB8AFD75D3675041	1593	5567	7466	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7466.JPG	\N	1593	2019	25/01/2019	\N	\N	Caduca	1	0
1366	0101000020110F0000CE7003AE1A88234161545209D1675041	1594	5568	7467	Albero	CELTIS AUSTRALIS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7467.JPG	\N	1594	2019	25/01/2019	\N	\N	Caduca	1	0
1367	0101000020110F0000E010AA34ED8623414E2844902C655041	1595	350	658	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\658.JPG	\N	1595	2018	25/09/2018	\N	\N	Sempreverde	1	0
1368	0101000020110F000062156FF4318823416F1283DAC6675041	1596	5569	7469	Albero	MELIA AZEDARACH	ARANCETO	-	Aiuola stradale	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	carie; ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7469.JPG	\N	1596	2019	25/01/2019	\N	\N	Caduca	1	0
1369	0101000020110F0000033E3F9C27882341C898BB3CC5675041	1597	5570	7470	Albero	LIGUSTRUM JAPONICA	ARANCETO	-	Aiuola stradale	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\7470.JPG	\N	1597	2019	25/01/2019	\N	\N	Sempreverde	1	0
1370	0101000020110F0000DC114E8BB9882341FC1873EBD4675041	1598	5571	7472	Palma	WASHINGTONIA ROBUSTA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7472.JPG	\N	1598	2019	25/01/2019	\N	\N	Sempreverde	1	0
1371	0101000020110F00003602F1EABF882341F1BA7E1FD4675041	1599	5572	7473	Palma	WASHINGTONIA ROBUSTA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7473.JPG	\N	1599	2019	25/01/2019	\N	\N	Sempreverde	1	0
1372	0101000020110F0000698CD611E78823416362F329D1675041	1600	5573	7474	Albero	SCHINUS MOLLE	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7474.JPG	\N	1600	2019	25/01/2019	\N	\N	Sempreverde	1	0
1373	0101000020110F0000618907D4C0882341F8A57EA0D6675041	1601	5574	7475	Albero	SCHINUS MOLLE	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7475.JPG	\N	1601	2019	25/01/2019	\N	\N	Sempreverde	1	0
1374	0101000020110F00007E3507D8CA8823419CBF0917DC675041	1602	5575	7476	Albero	SCHINUS MOLLE	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\7476.JPG	\N	1602	2019	25/01/2019	\N	\N	Sempreverde	1	0
1375	0101000020110F0000DA1B7C61C5882341A5A0DBC3D7675041	1603	5576	7477	Albero	PINUS PINEA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-11-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7477.JPG	\N	1603	2024	25/11/2024	\N	\N	Sempreverde	1	0
1376	0101000020110F0000DA1B7C61C588234155185B06DE675041	1604	5577	7478	Albero	PINUS PINEA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-11-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7478.JPG	\N	1604	2024	25/11/2024	\N	\N	Sempreverde	1	0
1377	0101000020110F0000C85EEFEEC9882341E466B827DA675041	1605	5578	7479	Albero	PINUS PINEA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2024-11-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7479.JPG	\N	1605	2024	25/11/2024	\N	\N	Sempreverde	1	0
1378	0101000020110F0000698CD611E7882341E370E6FBE0675041	1606	5579	7480	Albero	PINUS PINEA	ARANCETO	-	-	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Asola	0	0	-1	-	0	\N	Tipico	0	\N	2024-11-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti;	\N	\N	ferite;	\N	\N	\N	Marciapiede;	\N	desktop/Foto\\7480.JPG	\N	1606	2024	25/11/2024	\N	\N	Sempreverde	1	0
1379	0101000020110F0000F4328A35A08323411366DA809A6A5041	1607	5580	7483	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature;	\N	\N	cavit�;	\N	\N	\N	Cartellonistica; Sede Stradale; Cavi Aerei; Illuminazione pubblica;	\N	desktop/Foto\\7483.JPG	\N	1607	2019	25/01/2019	\N	\N	Sempreverde	1	0
1380	0101000020110F00007FDE546496832341A9F6E94E9D6A5041	1608	5581	7484	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature;	\N	\N	cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7484.JPG	\N	1608	2019	25/01/2019	\N	\N	Sempreverde	1	0
1381	0101000020110F00008B71FEF686832341033E3F2AA16A5041	1609	5582	7485	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2020-11-27	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Pessimo	CLASSE D	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature;	\N	\N	carie; cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei; Illuminazione pubblica;	\N	desktop/Foto\\7485.JPG	\N	1609	2020	27/11/2020	\N	\N	Sempreverde	1	0
1382	0101000020110F0000AB5B3DE763832341228E75FBAA6A5041	1610	5583	7487	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con cercine di legatura; branche con ferite; branche con fratture/incrinature;	\N	\N	carie; cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei; Illuminazione pubblica;	\N	desktop/Foto\\7487.JPG	\N	1610	2019	25/01/2019	\N	\N	Sempreverde	1	0
1383	0101000020110F00005EF415E45C832341033E3FBCAC6A5041	1611	5584	7488	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con cercine di legatura; branche con ferite; branche con fratture/incrinature;	\N	\N	carie; cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei; Utenze Sotterranee; Illuminazione pubblica;	\N	desktop/Foto\\7488.JPG	\N	1611	2019	25/01/2019	\N	\N	Sempreverde	1	0
1384	0101000020110F0000DE938735F08623417C0A80492B655041	1612	351	659	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\659.JPG	\N	1612	2018	25/09/2018	\N	\N	Sempreverde	2	0
1385	0101000020110F0000F5D6C0764D8323418B54184BB16A5041	1613	5585	7489	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con cercine di legatura; branche con ferite; branche con fratture/incrinature;	carie; cavit�;	\N	carie; cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei; Utenze Sotterranee; Illuminazione pubblica;	\N	desktop/Foto\\7489.JPG	\N	1613	2019	25/01/2019	\N	\N	Sempreverde	1	0
1386	0101000020110F000052616C516C832341B8CCE9E0A86A5041	1614	5586	7486	Albero	TILIA CORDATA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2020-11-27	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Pessimo	CLASSE D	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature;	\N	\N	carie; cavit�; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei; Illuminazione pubblica;	\N	desktop/Foto\\7486.JPG	\N	1614	2020	27/11/2020	\N	\N	Sempreverde	1	0
1387	0101000020110F0000C959D8F37F8323419ACE4EF8A36A5041	1615	5587	7490	Albero	PLATANUS ACERIFOLIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	viale cassiodoro	Filare	10	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Fine turno	Cattivo	CLASSE D	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	photos/Albero/5587/IMG_1900_562.jpeg	\N	1615	2024	25/01/2024	\N	\N	Caduca	1	0
1388	0101000020110F0000ABB2EFCA84802341535C55DC456A5041	1616	5588	6267	Albero	POPULUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Angitola	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-11-25	5	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Cattivo	CLASSE D	\N	branche con carie; branche con carpofori; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	ferite;	\N	carie; cavit�; necrosi corticale;	\N	\N	\N	Cavi Aerei; Edificio;	\N	desktop/Foto\\6267.JPG	\N	1616	2024	25/11/2024	\N	\N	Caduca	1	0
1389	0101000020110F000083FA968981802341AE122C68476A5041	1617	5589	6268	Albero	POPULUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Angitola	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-11-25	5	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Cattivo	CLASSE D	\N	branche con carie; branche con carpofori; branche con cavit�; branche con ferite; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	ferite;	\N	carie; cavit�; necrosi corticale;	\N	\N	\N	Cavi Aerei; Edificio;	\N	desktop/Foto\\6268.JPG	\N	1617	2024	25/11/2024	\N	\N	Caduca	1	0
1390	0101000020110F000083FA9689818023415D8AABAC466A5041	1618	5590	6269	Albero	PINUS HALEPENSIS	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Angitola	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-11-25	8	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	capitozzatura; essudati;	\N	\N	\N	Cavi Aerei; Edificio;	\N	desktop/Foto\\6269.JPG	\N	1618	2024	25/11/2024	\N	\N	Sempreverde	1	0
1391	0101000020110F0000F46C563DBB7F2341F98381F7536A5041	1619	5591	6271	Albero	OLEA EUROPAEA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6271.JPG	\N	1619	2019	29/01/2019	\N	\N	Sempreverde	1	0
1392	0101000020110F0000C3B645A9A97F234119045612536A5041	1620	5592	6272	Albero	NERIUM OLEANDER	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6272.JPG	\N	1620	2019	29/01/2019	\N	\N	Sempreverde	1	0
1393	0101000020110F0000AF25E4A39C7F23417A36ABE8526A5041	1621	5593	6273	Albero	NERIUM OLEANDER	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6273.JPG	\N	1621	2019	29/01/2019	\N	\N	Sempreverde	1	0
1394	0101000020110F0000D3DEE0BB987F2341933A01B9536A5041	1622	5594	6274	Albero	THUJA OCCIDENTALIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Buono	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6274.JPG	\N	1622	2019	29/01/2019	\N	\N	Sempreverde	1	0
1395	0101000020110F00001BBB44B5A77F23412FA35800566A5041	1623	5595	6275	Albero	PINUS PINEA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-11-25	0	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	essudati; inclinazione ingiustificata; monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\6275.JPG	\N	1623	2024	25/11/2024	\N	\N	Sempreverde	1	0
1396	0101000020110F00000B293FD9A17F234152D504A1576A5041	1624	5596	6276	Albero	CERATONIA SILIQUA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche protese; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\6276.JPG	\N	1624	2019	29/01/2019	\N	\N	-	1	0
1397	0101000020110F0000BBB88D569B7F2341E40F0618596A5041	1625	5597	6277	Albero	LAURUS NOBILIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6277.JPG	\N	1625	2019	29/01/2019	\N	\N	Sempreverde	1	0
1398	0101000020110F000028D53E7D927F2341A6D5900C596A5041	1626	5598	6280	Albero	LAURUS NOBILIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6280.JPG	\N	1626	2019	29/01/2019	\N	\N	Sempreverde	1	0
1399	0101000020110F00006D9049E6857F2341007498AF586A5041	1627	5599	6281	Albero	LAURUS NOBILIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	fumaggine; branche con ferite; branche con fratture/incrinature;	\N	\N	monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6281.JPG	\N	1627	2019	29/01/2019	\N	\N	Sempreverde	1	0
1451	0101000020110F00009A9482FE357E2341DAE6C6C6806F5041	1370	5357	8387	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8387.JPG	\N	1370	2019	30/01/2019	\N	\N	Sempreverde	2	0
1400	0101000020110F0000828B1525747F23418C4AEAD8586A5041	1628	5600	6282	Albero	LAURUS NOBILIS	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; fumaggine;	\N	\N	monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6282.JPG	\N	1628	2019	29/01/2019	\N	\N	Sempreverde	1	0
1401	0101000020110F0000B1A71D6ED8862341639CBFD3F4645041	1629	22	233	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2024-11-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Cattivo	Cattivo	CLASSE D	\N	branche con fratture/incrinature;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\233.JPG	\N	1629	2024	25/11/2024	\N	\N	Sempreverde	1	0
1402	0101000020110F00006BF129D0F3862341FD87F4152A655041	1630	352	660	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\660.JPG	\N	1630	2018	25/09/2018	\N	\N	Sempreverde	3	0
1403	0101000020110F00008AB0E1997A7F2341465F41C4586A5041	1631	5601	6283	Albero	PITTOSPORUM TOBIRA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; fumaggine;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6283.JPG	\N	1631	2019	29/01/2019	\N	\N	Sempreverde	1	0
1404	0101000020110F0000034356877E7F234163B9A5BB586A5041	1632	5602	6284	Albero	PITTOSPORUM TOBIRA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; fumaggine;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6284.JPG	\N	1632	2019	29/01/2019	\N	\N	Sempreverde	1	0
1405	0101000020110F0000DDEA39D95C7F23411990BDF2586A5041	1633	5603	6286	Albero	NERIUM OLEANDER	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; fumaggine;	\N	\N	monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6286.JPG	\N	1633	2019	29/01/2019	\N	\N	Sempreverde	1	0
1406	0101000020110F00009609BF84527F234143908300596A5041	1634	5604	6287	Albero	NERIUM OLEANDER	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Casolini	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; fumaggine;	\N	\N	monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6287.JPG	\N	1634	2019	29/01/2019	\N	\N	Sempreverde	1	0
1407	0101000020110F0000800EF335507F234169520A946E6A5041	1635	5605	6288	Albero	PLATANUS ACERIFOLIA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	0	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; fumaggine; seccume diffuso;	\N	\N	cavit�; monconi;	\N	\N	\N	Lampione; Sede Stradale; Cavi Aerei; Camminamento;	\N	photos/Albero/5605/IMG_1887_549.jpeg	\N	1635	2024	25/01/2024	\N	\N	Caduca	1	0
1408	0101000020110F0000EC2FBB67597F23411DE6CBDB716A5041	1636	5606	6289	Albero	PLATANUS ACERIFOLIA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Santa Maria	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	0	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; fumaggine; seccume diffuso;	\N	\N	cavit�; monconi;	\N	\N	\N	Lampione; Sede Stradale; Cavi Aerei; Camminamento;	\N	photos/Albero/5606/IMG_1888_550.jpeg	\N	1636	2024	25/01/2024	\N	\N	Caduca	1	0
1409	0101000020110F0000B8E4B843148023415227A0BB756A5041	1637	5607	6290	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6290.JPG	\N	1637	2019	29/01/2019	\N	\N	Sempreverde	1	0
1410	0101000020110F000047ACC56712802341DFF8DA8B766A5041	1638	5608	6291	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6291.JPG	\N	1638	2019	29/01/2019	\N	\N	Sempreverde	1	0
1411	0101000020110F00004968CB7911802341EC12D579776A5041	1639	5609	6292	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6292.JPG	\N	1639	2019	29/01/2019	\N	\N	Sempreverde	1	0
1412	0101000020110F00004DBED9260F802341B988EF58786A5041	1640	5610	6293	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6293.JPG	\N	1640	2019	29/01/2019	\N	\N	Sempreverde	1	0
1413	0101000020110F00005036E54A0D80234146EBA864796A5041	1641	5611	6294	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6294.JPG	\N	1641	2019	29/01/2019	\N	\N	Sempreverde	1	0
1414	0101000020110F0000E0DBF4F70A802341A27F82617A6A5041	1642	5612	6295	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6295.JPG	\N	1642	2019	29/01/2019	\N	\N	Sempreverde	1	0
1415	0101000020110F0000E43103A508802341EE3D5C5E7B6A5041	1643	5613	6296	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6296.JPG	\N	1643	2019	29/01/2019	\N	\N	Sempreverde	1	0
1416	0101000020110F0000E6CB0B4007802341FB57564C7C6A5041	1644	5614	6297	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6297.JPG	\N	1644	2019	29/01/2019	\N	\N	Sempreverde	1	0
1417	0101000020110F000075931864058023418929911C7D6A5041	1645	5615	6298	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6298.JPG	\N	1645	2019	29/01/2019	\N	\N	Sempreverde	1	0
1418	0101000020110F000076711BED04802341569FABFB7D6A5041	1646	5616	6299	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6299.JPG	\N	1646	2019	29/01/2019	\N	\N	Sempreverde	1	0
1419	0101000020110F0000DD2406D1F6862341562B131C29655041	1647	353	661	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\661.JPG	\N	1647	2018	25/09/2018	\N	\N	Sempreverde	3	0
1420	0101000020110F0000A7AE7C96F57F2341984C1578816A5041	1648	5617	6301	Albero	CALLISTEMON CITRINUS	GIARDINI GUGLIELMO RANIERI	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6301.JPG	\N	1648	2019	29/01/2019	\N	\N	-	1	0
1421	0101000020110F000037548C43F37F23416553AE92826A5041	1649	5618	6302	Albero	CALLISTEMON CITRINUS	GIARDINI GUGLIELMO RANIERI	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6302.JPG	\N	1649	2019	29/01/2019	\N	\N	-	1	0
1422	0101000020110F00003C889D79F07F23414DDBBFD6846A5041	1650	5619	6303	Albero	CALLISTEMON CITRINUS	GIARDINI GUGLIELMO RANIERI	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6303.JPG	\N	1650	2019	29/01/2019	\N	\N	-	1	0
1423	0101000020110F000040DEAB26EE7F23419A9999D3856A5041	1651	5620	6304	Albero	CALLISTEMON CITRINUS	GIARDINI GUGLIELMO RANIERI	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6304.JPG	\N	1651	2019	29/01/2019	\N	\N	-	1	0
1424	0101000020110F00006891EDECE37F2341300DC3517F6A5041	1652	5621	6309	Ceppaia	-	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2020-09-11	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	photos/Albero/5621/thb_176_WhatsApp Image 2020-09-11 at 13.23.57.jpeg	\N	1652	2020	11/09/2020	\N	\N	-	2	0
1425	0101000020110F0000D061BE5CEB7F2341309E418D7F6A5041	1653	5622	6310	Albero	CEDRUS DEODARA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	4.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	strozzatura;	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Sede Stradale; Camminamento;	\N	photos/Albero/5622/IMG_1889_551.jpeg	\N	1653	2024	25/01/2024	\N	\N	Sempreverde	1	0
1426	0101000020110F00003ACC9767F17F2341B0E600AB7F6A5041	1654	5623	6311	Albero	CEDRUS DEODARA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	4.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	strozzatura;	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Sede Stradale; Camminamento;	\N	photos/Albero/5623/IMG_1890_561.jpeg	\N	1654	2024	25/01/2024	\N	\N	Sempreverde	1	0
1427	0101000020110F0000A0E062C5F97F2341BE4D7FE67F6A5041	1655	5624	6312	Albero	CEDRUS DEODARA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Risorgimento	Gruppo	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	4.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	strozzatura;	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Sede Stradale; Camminamento;	\N	photos/Albero/5624/IMG_1891_553.jpeg	\N	1655	2024	25/01/2024	\N	\N	Sempreverde	1	0
1428	0101000020110F000051DA1BCC7D8123412A5778D1756A5041	1656	5625	6313	Albero	CEDRUS DEODARA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	insetti lignivori;	\N	\N	\N	Sede Stradale; Camminamento;	\N	photos/Albero/5625/IMG_1896_554.jpeg	\N	1656	2024	25/01/2024	\N	\N	Sempreverde	1	0
1429	0101000020110F000026361FE7CD8123415B2558FC7B6A5041	1657	5626	6315	Albero	CEDRUS DEODARA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; processionaria - Traumatocampa pityocampa; seccume localizzato;	\N	\N	essudati; ferite; monconi; necrosi corticale;	\N	\N	\N	Cavi Aerei;	\N	photos/Albero/5626/IMG_1892_555.jpeg	\N	1657	2024	25/01/2024	\N	\N	Sempreverde	1	0
1430	0101000020110F00006A87BF66D5812341DB6D17F27E6A5041	1658	5627	6316	Albero	CEDRUS DEODARA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; processionaria - Traumatocampa pityocampa; seccume localizzato;	\N	\N	essudati; ferite; monconi; necrosi corticale;	\N	\N	\N	Cavi Aerei;	\N	photos/Albero/5627/IMG_1893_556.jpeg	\N	1658	2024	25/01/2024	\N	\N	Sempreverde	1	0
1431	0101000020110F0000CF49EF9BE3812341EEEBC0637F6A5041	1659	5628	6317	Albero	CEDRUS DEODARA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Buono	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; processionaria - Traumatocampa pityocampa; seccume localizzato;	\N	\N	essudati; ferite; monconi; necrosi corticale;	\N	\N	\N	Cavi Aerei;	\N	photos/Albero/5628/IMG_1894_557.jpeg	\N	1659	2024	25/01/2024	\N	\N	Sempreverde	1	0
1432	0101000020110F0000BE6A6522E9812341BFB7E94D7E6A5041	1660	5629	6318	Albero	CEDRUS DEODARA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-01-25	6	3) 12m = 16m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; processionaria - Traumatocampa pityocampa; seccume localizzato;	\N	\N	essudati; ferite; monconi; necrosi corticale;	\N	\N	\N	Cavi Aerei;	\N	photos/Albero/5629/IMG_1895_558.jpeg	\N	1660	2024	25/01/2024	\N	\N	Sempreverde	1	0
1433	0101000020110F000004560E1DCD8123417F130AD37C6A5041	1661	5630	6319	Albero	NERIUM OLEANDER	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6319.JPG	\N	1661	2019	29/01/2019	\N	\N	Sempreverde	1	0
1434	0101000020110F00009EB5DBBECA812341BFB7E94D7E6A5041	1662	5631	6320	Albero	NERIUM OLEANDER	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6320.JPG	\N	1662	2019	29/01/2019	\N	\N	Sempreverde	1	0
1435	0101000020110F000004CAA6BC786B23414BC807E19C6E5041	1354	5343	8346	Albero	CALLISTEMON CITRINUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1354	2019	30/01/2019	\N	\N	-	1	0
1436	0101000020110F000084D899B28D6B23411973D7FAA36E5041	1355	5344	8352	Albero	CALLISTEMON CITRINUS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8352.JPG	\N	1355	2019	30/01/2019	\N	\N	-	1	0
1437	0101000020110F0000807D74BAD38623417DE882CEF5645041	1356	21	232	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\232.JPG	\N	1356	2018	24/09/2018	\N	\N	Sempreverde	1	0
1438	0101000020110F0000B936547C1E8623416F47382135655041	1357	336	644	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\644.JPG	\N	1357	2018	25/09/2018	\N	\N	Sempreverde	1	0
1439	0101000020110F00005E9D63B04C6B23414C1AA389966E5041	1358	5345	8369	Ceppaia	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Barlam da Seminara	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1358	2019	30/01/2019	\N	\N	-	2	0
1440	0101000020110F000075E5B38C167E2341D5045179856F5041	1359	5346	8376	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8376.JPG	\N	1359	2019	30/01/2019	\N	\N	Sempreverde	1	0
1441	0101000020110F00008AABCA2E1E7E2341B3EA736F846F5041	1360	5347	8377	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8377.JPG	\N	1360	2019	30/01/2019	\N	\N	Sempreverde	1	0
1442	0101000020110F00008F705AC0257E23413CA06C60836F5041	1361	5348	8378	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8378.JPG	\N	1361	2019	30/01/2019	\N	\N	Sempreverde	1	0
1443	0101000020110F000048C494382E7E2341D23AAA00826F5041	1362	5349	8379	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8379.JPG	\N	1362	2019	30/01/2019	\N	\N	Sempreverde	1	0
1444	0101000020110F0000A0371559347E23414018780E816F5041	1363	5350	8380	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8380.JPG	\N	1363	2019	30/01/2019	\N	\N	Sempreverde	1	0
1445	0101000020110F000075B0FE4F387E2341758E016D806F5041	1364	5351	8381	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8381.JPG	\N	1364	2019	30/01/2019	\N	\N	Sempreverde	1	0
1446	0101000020110F0000AB2171FF3C7E23411956F1A87F6F5041	1365	5352	8382	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8382.JPG	\N	1365	2019	30/01/2019	\N	\N	Sempreverde	1	0
1447	0101000020110F000033E197BA467E2341D82AC15C7D6F5041	1366	5353	8383	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8383.JPG	\N	1366	2019	30/01/2019	\N	\N	Sempreverde	1	0
1448	0101000020110F0000B37BF2604F7E2341204608057B6F5041	1367	5354	8384	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8384.JPG	\N	1367	2019	30/01/2019	\N	\N	Sempreverde	1	0
1449	0101000020110F000060CD01D2507E2341B5FD2BD9796F5041	1368	5355	8385	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8385.JPG	\N	1368	2019	30/01/2019	\N	\N	Sempreverde	1	0
1450	0101000020110F000089247A19507E234167EDB6DD776F5041	1369	5356	8386	Albero	TILIA CORDATA	CATANZARO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8386.JPG	\N	1369	2019	30/01/2019	\N	\N	Sempreverde	1	0
1453	0101000020110F000048F949651B732341890794E977705041	1372	5359	8440	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8440.JPG	\N	1372	2019	28/01/2019	\N	\N	Sempreverde	1	0
1454	0101000020110F00008D45D3692273234178B4712876705041	1373	5360	8441	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8441.JPG	\N	1373	2019	28/01/2019	\N	\N	Sempreverde	1	0
1455	0101000020110F000009F9A0371B8623417FFB3A1C36655041	1374	337	645	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	Edificio;	\N	desktop/Foto\\645.JPG	\N	1374	2018	25/09/2018	\N	\N	Sempreverde	1	0
1456	0101000020110F000086E63AAD27732341598B4F6774705041	1375	5361	8442	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8442.JPG	\N	1375	2019	28/01/2019	\N	\N	Sempreverde	1	0
1457	0101000020110F0000EFACDD9636732341C2C0739F74705041	1376	5362	8443	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8443.JPG	\N	1376	2019	28/01/2019	\N	\N	Sempreverde	1	0
1458	0101000020110F00000CC85EBF43732341C2C0739F74705041	1377	5363	8444	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8444.JPG	\N	1377	2019	28/01/2019	\N	\N	Sempreverde	1	0
1459	0101000020110F0000E10B938953732341C2C0739F74705041	1378	5364	8445	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8445.JPG	\N	1378	2019	28/01/2019	\N	\N	Sempreverde	1	0
1460	0101000020110F00004AD23573627323416FF085BB74705041	1379	5365	8446	Albero	QUERCUS ILEX	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche con ferite; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8446.JPG	\N	1379	2019	28/01/2019	\N	\N	Sempreverde	1	0
1461	0101000020110F0000F65D11EC93712341E5D539F8BC705041	1380	5366	8447	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8447.JPG	\N	1380	2019	28/01/2019	\N	\N	Sempreverde	1	0
1462	0101000020110F00004A0C02FB96712341CCEEC9FBBD705041	1381	5367	8448	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	Edificio;	\N	desktop/Foto\\8448.JPG	\N	1381	2019	28/01/2019	\N	\N	Sempreverde	1	0
1463	0101000020110F00003E3F8C008F712341E2E995F2BE705041	1382	5368	8449	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche secche;	ferite;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8449.JPG	\N	1382	2019	28/01/2019	\N	\N	Sempreverde	1	0
1464	0101000020110F0000A18499A6957123419A5FCD75C0705041	1383	5369	8450	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche secche;	ferite;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8450.JPG	\N	1383	2019	28/01/2019	\N	\N	Sempreverde	1	0
1465	0101000020110F000079060D1D97712341F0332EE0C0705041	1384	5370	8451	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche secche;	ferite;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8451.JPG	\N	1384	2019	28/01/2019	\N	\N	Sempreverde	1	0
1466	0101000020110F0000B1A20603A47123416ABC74F5C0705041	1385	5371	8452	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche secche;	ferite;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8452.JPG	\N	1385	2019	28/01/2019	\N	\N	Sempreverde	1	0
1467	0101000020110F0000DAACFA5C9D712341624A245FC2705041	1386	5372	8453	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-23	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/5372/thb_208_WhatsApp Image 2020-09-23 at 13.25.14 (1).jpeg	\N	1386	2020	23/09/2020	\N	\N	Sempreverde	2	0
1468	0101000020110F0000FBAE084E9A7123418BA6B3C1C1705041	1387	5373	8454	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche;	ferite;	\N	ferite; ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\8454.JPG	\N	1387	2019	28/01/2019	\N	\N	Sempreverde	1	0
1469	0101000020110F0000F06DFA238D71234142CF6659BE705041	1388	5374	8455	Ceppaia	ROBINIA SP	CATANZARO	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8455.JPG	\N	1388	2019	28/01/2019	\N	\N	-	2	0
1470	0101000020110F0000F25EB5E2CF7023416D9049DCC4705041	1389	5375	8456	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8456.JPG	\N	1389	2019	28/01/2019	\N	\N	-	1	0
1471	0101000020110F0000E8F69226CA70234124287E88C6705041	1390	5376	8457	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi; necrosi corticale;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8457.JPG	\N	1390	2019	28/01/2019	\N	\N	-	1	0
1472	0101000020110F0000CF6BECF217862341D1CB282C37655041	1391	338	646	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Venezia	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	Edificio;	\N	desktop/Foto\\646.JPG	\N	1391	2018	25/09/2018	\N	\N	Sempreverde	1	0
1473	0101000020110F000045477279C7702341FFCA4AEBC7705041	1392	5377	8458	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8458.JPG	\N	1392	2019	28/01/2019	\N	\N	-	1	0
1474	0101000020110F000016F6B4D3CC70234183346329C9705041	1393	5378	8459	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8459.JPG	\N	1393	2019	28/01/2019	\N	\N	-	1	0
1475	0101000020110F0000FF0417DBD4702341D0D03F5BCA705041	1394	5379	8460	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8460.JPG	\N	1394	2019	28/01/2019	\N	\N	-	1	0
1476	0101000020110F00004DD6A867D6702341554D105FC9705041	1395	5380	8461	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8461.JPG	\N	1395	2019	28/01/2019	\N	\N	-	1	0
1477	0101000020110F000007F01618E270234173F4F8F7C7705041	1396	5381	8462	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8462.JPG	\N	1396	2019	28/01/2019	\N	\N	-	1	0
1478	0101000020110F000032721686F170234182734680C7705041	1397	5382	8463	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8463.JPG	\N	1397	2019	28/01/2019	\N	\N	-	1	0
1479	0101000020110F0000AA0EB9E9EB70234191F29308C7705041	1398	5383	8464	Albero	MORUS SP.	PARCO VIALE PIO X	-	Parco	II Centro Storico, Stadio, San Leonardo	Viale Pio X	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; monconi;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8464.JPG	\N	1398	2019	28/01/2019	\N	\N	-	1	0
1480	0101000020110F0000DFF8DA033A7023410C3CF71200715041	1399	5384	8465	Albero	ARBUTUS UNEDO	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	afidi; branche con ferite;	ferite;	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8465.JPG	\N	1399	2019	28/01/2019	\N	\N	-	1	0
1481	0101000020110F00006DFFCA5A597023413DD521BD03715041	1400	5385	8466	Albero	GREVILLEA ROBUSTA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; giallume diffuso;	ferite;	\N	carie; decorticazione; ferite; insetti lignivori; necrosi corticale;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8466.JPG	\N	1400	2019	28/01/2019	\N	\N	Sempreverde	1	0
1482	0101000020110F0000B6DB2ED42870234130815B0DFE705041	1401	5386	8467	Albero	GREVILLEA ROBUSTA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite; ginocchiatura;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8467.JPG	\N	1401	2019	28/01/2019	\N	\N	Sempreverde	1	0
1483	0101000020110F00006C9560D12770234137FDD9C9FC705041	1402	5387	8468	Albero	LAGERSTROEMIA INDICA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8468.JPG	\N	1402	2019	28/01/2019	\N	\N	Caduca	1	0
1484	0101000020110F00008048BFBD20702341FD87F48BFD705041	1403	5388	8469	Ceppaia	LAGERSTROEMIA INDICA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8469.JPG	\N	1403	2019	28/01/2019	\N	\N	Caduca	2	0
1485	0101000020110F00000E4FAF14407023412849D742FA705041	1404	5389	8470	Albero	GREVILLEA ROBUSTA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	ferite;	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8470.JPG	\N	1404	2019	28/01/2019	\N	\N	Sempreverde	1	0
1519	0101000020110F00006362F351C07423419CA223C51D705041	1438	5421	8504	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8504.JPG	\N	1438	2019	26/01/2019	\N	\N	Sempreverde	3	0
1486	0101000020110F000043E21E2B4870234199F56260F9705041	1405	5390	8471	Albero	TILIA CORDATA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	ferite;	\N	carie; cavit�; ferite; insetti lignivori;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8471.JPG	\N	1405	2019	28/01/2019	\N	\N	Sempreverde	1	0
1487	0101000020110F00009B559F6B5F7023415648F957F6705041	1406	5391	8472	Albero	TILIA CORDATA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	ferite;	\N	carie; cavit�; ferite; insetti lignivori;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8472.JPG	\N	1406	2019	28/01/2019	\N	\N	Sempreverde	1	0
1488	0101000020110F00009CA223394D702341232D955DF8705041	1407	5392	8473	Albero	LIQUIDAMBAR STYRACIFLUA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8473.JPG	\N	1407	2019	28/01/2019	\N	\N	Caduca	1	0
1489	0101000020110F0000BD00FBE8978623411F4B1F5249655041	1408	339	647	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	Edificio;	\N	desktop/Foto\\647.JPG	\N	1408	2018	25/09/2018	\N	\N	Sempreverde	1	0
1490	0101000020110F000046990D826770234185251EF4F4705041	1409	5393	8474	Albero	ACACIA DEALBATA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche protese;	ferite;	\N	ferite; ginocchiatura;	\N	\N	\N	Recinzione;	\N	desktop/Foto\\8474.JPG	\N	1409	2019	28/01/2019	\N	\N	Caduca	1	0
1491	0101000020110F000016F6B4A373702341556AF6D0F3705041	1410	5394	8475	Albero	MELIA AZEDARACH	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8475.JPG	\N	1410	2019	28/01/2019	\N	\N	Caduca	1	0
1492	0101000020110F000096CFF2BC7C702341EE7728CEF2705041	1411	5395	8476	Albero	MELIA AZEDARACH	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8476.JPG	\N	1411	2019	28/01/2019	\N	\N	Caduca	1	0
1493	0101000020110F0000821C94D08370234188635D52F4705041	1412	5396	8477	Albero	CEDRUS ATLANTICA GLAUCA	CATANZARO	-	Parco	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Teti	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2.5	3) 12m = 16m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8477.JPG	\N	1412	2019	28/01/2019	\N	\N	-	1	0
1494	0101000020110F00007429AE8A35762341FE9AACD56C6F5041	1413	5397	8479	Albero	CEDRUS ATLANTICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	3	4) 16m = 23m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8479.JPG	\N	1413	2019	26/01/2019	\N	\N	Sempreverde	1	0
1495	0101000020110F00001F4B1FEA3C762341C902262E6D6F5041	1414	5398	6134	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1414	2019	26/01/2019	\N	\N	Sempreverde	1	0
1496	0101000020110F0000FFEC475A917623411973D744756F5041	1415	5399	8481	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-10-29	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8481.JPG	\N	1415	2019	29/10/2019	\N	\N	Sempreverde	2	0
1497	0101000020110F0000E94317F47274234184F0681F07705041	1416	5400	8482	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8482.JPG	\N	1416	2019	26/01/2019	\N	\N	Sempreverde	1	0
1498	0101000020110F00003255307A6B7423414A07EB7F06705041	1417	5401	8483	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8483.JPG	\N	1417	2019	26/01/2019	\N	\N	Sempreverde	1	0
1499	0101000020110F0000F08AE07F647423411FF46CE005705041	1418	5402	8484	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8484.JPG	\N	1418	2019	26/01/2019	\N	\N	Sempreverde	1	0
1500	0101000020110F0000282CF1904F7423411D03B25104705041	1419	5403	8485	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8485.JPG	\N	1419	2019	26/01/2019	\N	\N	Sempreverde	1	0
1501	0101000020110F0000FD30429846742341D5264E9203705041	1420	5404	8486	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8486.JPG	\N	1420	2019	26/01/2019	\N	\N	Sempreverde	1	0
1518	0101000020110F00003659A39EBD7423412592E8091D705041	1437	5420	8503	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8503.JPG	\N	1437	2019	26/01/2019	\N	\N	Sempreverde	1	0
1502	0101000020110F00001CEBE2A634742341611A861302705041	1421	5405	8487	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8487.JPG	\N	1421	2019	26/01/2019	\N	\N	Sempreverde	1	0
1503	0101000020110F00000AD7A3B028742341183E225401705041	1422	5406	8488	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8488.JPG	\N	1422	2019	26/01/2019	\N	\N	Sempreverde	1	0
1504	0101000020110F0000E0DBF4B71F742341DF37BE9400705041	1423	5407	8489	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8489.JPG	\N	1423	2019	26/01/2019	\N	\N	Sempreverde	1	0
1505	0101000020110F00000EF8FC4017742341B37BF20000705041	1424	5408	8490	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8490.JPG	\N	1424	2019	26/01/2019	\N	\N	Sempreverde	1	0
1506	0101000020110F0000118DEE509D8623411557957147655041	1425	340	648	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\648.JPG	\N	1425	2018	25/09/2018	\N	\N	Sempreverde	3	0
1507	0101000020110F00003D7E6F53107423415227A07FFF6F5041	1426	5409	8491	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8491.JPG	\N	1426	2019	26/01/2019	\N	\N	Sempreverde	1	0
1508	0101000020110F000015C616D208742341276BD4EBFE6F5041	1427	5410	8492	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8492.JPG	\N	1427	2019	26/01/2019	\N	\N	Sempreverde	1	0
1509	0101000020110F000074D2FBF6FA73234165C22FE9FD6F5041	1428	5411	8493	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8493.JPG	\N	1428	2019	26/01/2019	\N	\N	Sempreverde	1	0
1510	0101000020110F000061E0B9C73C742341B3EA73D102705041	1429	5412	8494	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8494.JPG	\N	1429	2019	26/01/2019	\N	\N	Sempreverde	3	0
1511	0101000020110F00008C101ECD5A7423419773290E05705041	1430	5413	8495	Fallanza	LIGUSTRUM JAPONICA	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Filare	5	Tornello senza cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8495.JPG	\N	1430	2019	26/01/2019	\N	\N	Sempreverde	3	0
1512	0101000020110F000013B875E779742341DC9DB54118705041	1431	5414	8496	Albero	CEDRUS ATLANTICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	essudati; monconi;	\N	\N	\N	Recinzione; Camminamento; Pavimentazione;	\N	desktop/Foto\\8496.JPG	\N	1431	2019	26/01/2019	\N	\N	Sempreverde	1	0
1513	0101000020110F00000A80F1EC71742341DD24064119705041	1432	5415	8497	Albero	CRYPTOMERIA JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Recinzione; Camminamento; Pavimentazione;	\N	desktop/Foto\\8497.JPG	\N	1432	2019	26/01/2019	\N	\N	Sempreverde	1	0
1514	0101000020110F00005D8AAB2AAB74234150AA7DCE17705041	1433	5416	8498	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione; Camminamento; Pavimentazione;	\N	desktop/Foto\\8498.JPG	\N	1433	2019	26/01/2019	\N	\N	Sempreverde	1	0
1515	0101000020110F00000E8464D1B2742341D9942BB819705041	1434	5417	8500	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8500.JPG	\N	1434	2019	26/01/2019	\N	\N	Sempreverde	1	0
1516	0101000020110F0000A7B39351B7742341DD989EE61A705041	1435	5418	8501	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8501.JPG	\N	1435	2019	26/01/2019	\N	\N	Sempreverde	1	0
1517	0101000020110F00006AC18B5EBB742341E09C11151C705041	1436	5419	8502	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8502.JPG	\N	1436	2019	26/01/2019	\N	\N	Sempreverde	1	0
1520	0101000020110F000023BE1353DB742341FA7E6AA01F705041	1439	5422	8505	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2024-01-26	5	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; insetti lignivori; monconi; seccume diffuso;	\N	\N	ferite; monconi; tumori;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8505.JPG	\N	1439	2024	26/01/2024	\N	\N	Caduca	1	0
1521	0101000020110F00000C76C306E7742341FD82DDCE20705041	1440	5423	8506	Ceppaia	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-09-10	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	photos/Albero/5423/thb_182_WhatsApp Image 2020-09-10 at 15.50.06.jpeg	\N	1440	2019	10/09/2019	\N	\N	Caduca	2	0
1522	0101000020110F0000569A94E2D074234105A3920612705041	1441	5424	8507	Ceppaia	PINUS PINEA	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2021-07-20	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8507.JPG	\N	1441	2021	20/07/2021	\N	\N	Sempreverde	2	0
1523	0101000020110F00004AEF1B1FA28623414339D12A46655041	1442	341	649	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\649.JPG	\N	1442	2018	25/09/2018	\N	\N	Sempreverde	1	0
1524	0101000020110F0000886874A7C47423413541D4E913705041	1443	5425	8508	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con cavit�; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	strozzatura;	\N	carpofori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8508.JPG	\N	1443	2019	26/01/2019	\N	\N	Caduca	1	0
1525	0101000020110F0000BE9F1A0FE8742341A83AE41A1D705041	1444	5426	8509	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con cavit�; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	strozzatura;	\N	carpofori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8509.JPG	\N	1444	2019	26/01/2019	\N	\N	Caduca	1	0
1526	0101000020110F00002DCF830BF2742341B3D2A4CE1E705041	1445	5427	8510	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con cavit�; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	strozzatura;	\N	carpofori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8510.JPG	\N	1445	2019	26/01/2019	\N	\N	Caduca	1	0
1527	0101000020110F0000800EF3A50975234175B0FE991F705041	1446	5428	8511	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-26	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con carie; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	strozzatura;	\N	carpofori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8511.JPG	\N	1446	2019	26/01/2019	\N	\N	Caduca	1	0
1528	0101000020110F0000C2C0733FE67523413C1405C231705041	1447	5429	8512	Albero	-	CATANZARO	-	Area sportiva	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Prato	0	0	-1	-	0	\N	-	0	\N	2019-01-26	7	3) 12m = 16m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con fratture/incrinature; branche protese; monconi; seccume diffuso;	strozzatura;	\N	carie; carpofori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\8512.JPG	\N	1447	2019	26/01/2019	\N	\N	-	1	0
1529	0101000020110F000088F4DB670A762341BB7EC1CC39705041	1448	5430	8513	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Cattivo	CLASSE D	3C	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8513.JPG	\N	1448	2019	26/01/2019	\N	\N	Caduca	1	0
1530	0101000020110F0000191C25FF05762341200C3CF339705041	1449	5431	8514	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8514.JPG	\N	1449	2019	26/01/2019	\N	\N	Caduca	1	0
1531	0101000020110F000089416095FF752341C959D8593A705041	1450	5432	8515	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	Cavi Aerei; Recinzione;	\N	desktop/Foto\\8515.JPG	\N	1450	2019	26/01/2019	\N	\N	Caduca	1	0
1532	0101000020110F000071AC8B5BAE752341FCA9F1743F705041	1451	5433	8516	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	ferite; monconi;	\N	\N	\N	\N	\N	photos/Albero/5433/IMG_1988_624.jpeg	\N	1451	2024	26/01/2024	\N	\N	Caduca	1	0
1533	0101000020110F0000E6965643A7752341C18BBE3E40705041	1452	5434	8517	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	cavit�; ferite; insetti lignivori; monconi;	\N	\N	\N	\N	\N	photos/Albero/5434/IMG_1989_625.jpeg	\N	1452	2024	26/01/2024	\N	\N	Caduca	1	0
1534	0101000020110F00003D6189979E752341876D8B0841705041	1453	5435	8518	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	cavit�; ferite; insetti lignivori; monconi;	\N	\N	\N	\N	\N	photos/Albero/5435/IMG_1990_626.jpeg	\N	1453	2024	26/01/2024	\N	\N	Caduca	1	0
1908	0101000020110F00007368915D717B234158CA328ACD6C5041	1829	5788	8820	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1829	2018	06/12/2018	\N	\N	Sempreverde	1	0
1535	0101000020110F0000091687D38E75234109C4EB8242705041	1454	5436	8519	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	cavit�; ferite; insetti lignivori; monconi;	\N	\N	\N	\N	\N	photos/Albero/5436/IMG_1991_627.jpeg	\N	1454	2024	26/01/2024	\N	\N	Caduca	1	0
1536	0101000020110F0000FA618400837523419F5912E443705041	1455	5437	8520	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	cavit�; ferite; insetti lignivori; monconi;	\N	\N	\N	\N	\N	photos/Albero/5437/IMG_1992_628.jpeg	\N	1455	2024	26/01/2024	\N	\N	Caduca	1	0
1537	0101000020110F00009A081BEE6C752341DBBFB25A46705041	1456	5438	8521	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	ferite; monconi;	\N	\N	\N	\N	\N	photos/Albero/5438/IMG_1993_629.jpeg	\N	1456	2024	26/01/2024	\N	\N	Caduca	1	0
1538	0101000020110F00009A42E7D565752341A1A17F2447705041	1457	5439	8522	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	ferite; monconi;	\N	\N	\N	\N	\N	photos/Albero/5439/IMG_1994_630.jpeg	\N	1457	2024	26/01/2024	\N	\N	Caduca	1	0
1539	0101000020110F00003A75E5F35D7523415BB1BF2048705041	1458	5440	8523	Albero	PLATANUS ACERIFOLIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	6	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con cavit�; branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	ferite; strozzatura;	\N	cavit�; ferite; monconi;	\N	\N	\N	\N	\N	photos/Albero/5440/IMG_1995_631.jpeg	\N	1458	2024	26/01/2024	\N	\N	Caduca	1	0
1540	0101000020110F00000EA14AEDA686234180F10CE444655041	1459	342	650	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\650.JPG	\N	1459	2018	25/09/2018	\N	\N	Sempreverde	1	0
1541	0101000020110F0000126BF1B9D37323416FD39F6F71705041	1460	5441	8524	Albero	QUERCUS ILEX	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8524.JPG	\N	1460	2019	26/01/2019	\N	\N	Sempreverde	1	0
1542	0101000020110F00003411362CEA73234184D899746F705041	1461	5442	8525	Albero	QUERCUS ILEX	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8525.JPG	\N	1461	2019	26/01/2019	\N	\N	Sempreverde	1	0
1543	0101000020110F000043E21E6BFE73234198DD93796D705041	1462	5443	8526	Albero	QUERCUS ILEX	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	capitozzatura; ginocchiatura; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8526.JPG	\N	1462	2019	26/01/2019	\N	\N	Sempreverde	1	0
1544	0101000020110F0000BED0AF3A2E7523410E213C017D705041	1463	5444	8527	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8527.JPG	\N	1463	2019	28/01/2019	\N	\N	Sempreverde	2	0
1545	0101000020110F000053793BF21F752341EAEC64747A705041	1464	5445	8528	Albero	POPULUS NIGRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	1.7	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi;	\N	\N	ginocchiatura; monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8528.JPG	\N	1464	2019	28/01/2019	\N	\N	Caduca	1	0
1546	0101000020110F00003ED00AEC1C752341B98D06027A705041	1465	5446	8529	Albero	AILANTHUS ALTISSIMA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; monconi;	carie; cavit�; marciume radicale;	\N	cavit�; ferite; ginocchiatura; monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8529.JPG	\N	1465	2019	28/01/2019	\N	\N	Caduca	1	0
1547	0101000020110F0000E92B48D31075234128F2242D7B705041	1466	5447	8530	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-01-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8530.JPG	\N	1466	2019	28/01/2019	\N	\N	Sempreverde	2	0
1548	0101000020110F00002B6A306D0C75234105DD5ECC7A705041	1467	5448	8531	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2020-10-21	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8531.JPG	\N	1467	2020	21/10/2020	\N	\N	Sempreverde	2	0
1549	0101000020110F0000736891ED0675234166BD18FA78705041	1468	5449	8532	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8532.JPG	\N	1468	2019	28/01/2019	\N	\N	Sempreverde	1	0
1550	0101000020110F0000CA4FAA8D0575234182AD125279705041	1469	5450	8533	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8533.JPG	\N	1469	2019	28/01/2019	\N	\N	Sempreverde	1	0
1551	0101000020110F00007FDE54B401752341A43671C479705041	1470	5451	8534	Albero	PITTOSPORUM TOBIRA	CATANZARO	-	Cimitero	II Centro Storico, Stadio, San Leonardo	Via Paglia	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8534.JPG	\N	1470	2019	28/01/2019	\N	\N	Sempreverde	1	0
1552	0101000020110F0000FB05BBE15376234102D4D48E6F6F5041	1471	5452	8480	Albero	CUPRESSUS SP.	CATANZARO	-	Aiuola	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-26	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche codominanti; monconi; seccume diffuso;	\N	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8480.JPG	\N	1471	2019	26/01/2019	\N	\N	-	1	0
1553	0101000020110F00002098A337AF7423415ABBEDB418705041	1472	5453	8499	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Paglia	Filare	5	Tornello senza cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-26	5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; monconi; seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Recinzione; Camminamento; Pavimentazione;	\N	desktop/Foto\\8499.JPG	\N	1472	2019	26/01/2019	\N	\N	Sempreverde	1	0
1554	0101000020110F000097E2AA222E9623412E0439EEDC665041	1473	5454	8432	Albero	EUCALYPTUS CAMALDULENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Viale Crotone	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-30	4	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Pessimo	CLASSE D	3C	branche con carie; branche con cavit�; branche con ferite; giallume diffuso; seccume diffuso;	contrafforti scoperti; strozzatura;	\N	ferite;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\8432.JPG	\N	1473	2019	30/01/2019	\N	\N	Sempreverde	1	0
1555	0101000020110F0000603C833624962341EFACDDF0D0665041	1474	5455	8433	Albero	EUCALYPTUS CAMALDULENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Viale Crotone	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	4	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	monconi;	\N	\N	\N	Cartellonistica;	\N	desktop/Foto\\8433.JPG	\N	1474	2019	30/01/2019	\N	\N	Sempreverde	1	0
1556	0101000020110F000047ACC5470F9623414E97C510CF665041	1475	5456	8434	Albero	EUCALYPTUS CAMALDULENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Viale Crotone	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	4	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	monconi;	\N	\N	\N	Cartellonistica;	\N	desktop/Foto\\8434.JPG	\N	1475	2019	30/01/2019	\N	\N	Sempreverde	1	0
1557	0101000020110F000080D426EEA9862341BDA9489D43655041	1476	343	651	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\651.JPG	\N	1476	2018	25/09/2018	\N	\N	Sempreverde	1	0
1558	0101000020110F0000E3361A10FB9523412041F1A5CC665041	1477	5457	8435	Albero	EUCALYPTUS CAMALDULENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Viale Crotone	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-30	4	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	contrafforti scoperti; strozzatura;	\N	\N	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\8435.JPG	\N	1477	2019	30/01/2019	\N	\N	Sempreverde	1	0
1559	0101000020110F00005DDC467348812341A7AE7C02446D5041	1478	5458	6355	Albero	-	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con fratture/incrinature; monconi;	strozzatura;	\N	carie; cavit�; insetti lignivori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\6355.JPG	\N	1478	2019	29/01/2019	\N	\N	-	1	0
1560	0101000020110F000098A3C77F438123414DD6A88B436D5041	1479	5459	6356	Albero	-	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con fratture/incrinature; monconi;	strozzatura;	\N	carie; cavit�; insetti lignivori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\6356.JPG	\N	1479	2019	29/01/2019	\N	\N	-	1	0
1561	0101000020110F0000481B478C3E81234102D4D414436D5041	1480	5460	6357	Albero	-	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con fratture/incrinature; monconi;	strozzatura;	\N	carie; cavit�; insetti lignivori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\6357.JPG	\N	1480	2019	29/01/2019	\N	\N	-	1	0
1562	0101000020110F00007E1D38373A812341B7D1009E426D5041	1481	5461	6358	Albero	-	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con fratture/incrinature; monconi;	strozzatura;	\N	carie; cavit�; insetti lignivori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\6358.JPG	\N	1481	2019	29/01/2019	\N	\N	-	1	0
1563	0101000020110F0000BDA948A534812341FEF15E13426D5041	1482	5462	6359	Albero	-	CAVA CUCULERA	-	Via	-	Via Leonardo Da Vinci	Filare	3	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con fratture/incrinature; monconi;	strozzatura;	\N	carie; cavit�; insetti lignivori; monconi; necrosi corticale;	\N	\N	\N	\N	\N	desktop/Foto\\6359.JPG	\N	1482	2019	29/01/2019	\N	\N	-	1	0
1564	0101000020110F0000EFACDDA6F4802341DC80CFF14A6D5041	1483	5463	6361	Albero	MELIA AZEDARACH	PARCO VIA LEONDARDO DA VINCI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6361.JPG	\N	1483	2019	29/01/2019	\N	\N	Caduca	1	0
1565	0101000020110F0000E3C7982BFA8023413D9B55414C6D5041	1484	5464	6362	Ceppaia	PRUNUS SP.	PARCO VIA LEONDARDO DA VINCI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-11-12	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6362.JPG	\N	1484	2019	12/11/2019	\N	\N	-	2	0
1566	0101000020110F0000B07268C1F58023419947FE524C6D5041	1485	5465	6363	Ceppaia	PRUNUS SP.	PARCO VIA LEONDARDO DA VINCI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-11-12	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6363.JPG	\N	1485	2019	12/11/2019	\N	\N	-	2	0
1567	0101000020110F0000E3C7982BFA8023413A234AAB4C6D5041	1486	5466	6364	Ceppaia	PRUNUS SP.	PARCO VIA LEONDARDO DA VINCI	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via Leonardo Da Vinci	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-11-12	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6364.JPG	\N	1486	2019	12/11/2019	\N	\N	-	2	0
1568	0101000020110F000049A297613D83234113D55BD3316D5041	1487	5467	6365	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche;	ferite;	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\6365.JPG	\N	1487	2019	29/01/2019	\N	\N	Sempreverde	1	0
1569	0101000020110F0000693A3B193F832341CC62623D306D5041	1488	5468	6366	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	Acari; branche secche;	ferite;	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\6366.JPG	\N	1488	2019	29/01/2019	\N	\N	Sempreverde	1	0
1570	0101000020110F00003B8DB4743D8323418ECC23B32E6D5041	1489	5469	6367	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche;	ferite;	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\6367.JPG	\N	1489	2019	29/01/2019	\N	\N	Sempreverde	1	0
1571	0101000020110F00003B8DB4743D83234132772D432D6D5041	1490	5470	6368	Albero	QUERCUS ILEX	CAVA CUCULERA	-	Via	-	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	branche secche;	ferite;	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\6368.JPG	\N	1490	2019	29/01/2019	\N	\N	Sempreverde	1	0
1572	0101000020110F000025404DFD5183234164231093316D5041	1491	5471	6369	Albero	ACER SP.	CAVA CUCULERA	-	Via	-	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6369.JPG	\N	1491	2019	29/01/2019	\N	\N	-	1	0
1573	0101000020110F00005166830C358F23416A183E9CAD6D5041	1492	5472	8389	Albero	FICUS SP.	CAVA CUCULERA	-	Via	-	Via Fiume Ancinale	Gruppo	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-30	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\8389.JPG	\N	1492	2019	30/01/2019	\N	\N	-	1	0
1574	0101000020110F0000295C8F22AE8623411366DA1C42655041	1493	344	652	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	7	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\652.JPG	\N	1493	2018	25/09/2018	\N	\N	Sempreverde	1	0
1575	0101000020110F00005166830C358F2341B2852045AC6D5041	1494	5473	8390	Albero	FICUS SP.	CAVA CUCULERA	-	Via	-	Via Fiume Ancinale	Gruppo	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-30	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\8390.JPG	\N	1494	2019	30/01/2019	\N	\N	-	1	0
1576	0101000020110F00002FA86F19338F2341268DD1CEAA6D5041	1495	5474	8391	Albero	FICUS SP.	CAVA CUCULERA	-	Via	-	Via Fiume Ancinale	Gruppo	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-30	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\8391.JPG	\N	1495	2019	30/01/2019	\N	\N	-	1	0
1577	0101000020110F000045F0BFE53A8F234162156F90AA6D5041	1496	5475	8392	Albero	FICUS SP.	CAVA CUCULERA	-	Via	-	Via Fiume Ancinale	Gruppo	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8392.JPG	\N	1496	2019	30/01/2019	\N	\N	-	1	0
1578	0101000020110F00000113B8353E8F2341761A6953666D5041	1497	5476	8393	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8393.JPG	\N	1497	2019	30/01/2019	\N	\N	Sempreverde	1	0
1579	0101000020110F0000F0332E3C3D8F234110E9B7C9676D5041	1498	5477	8394	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8394.JPG	\N	1498	2019	30/01/2019	\N	\N	Sempreverde	1	0
1580	0101000020110F0000F0332E3C3D8F23419CE10640696D5041	1499	5478	8395	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8395.JPG	\N	1499	2019	30/01/2019	\N	\N	Sempreverde	1	0
1581	0101000020110F0000F0332E3C3D8F234136B055B66A6D5041	1500	5479	8396	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8396.JPG	\N	1500	2019	30/01/2019	\N	\N	Sempreverde	1	0
1582	0101000020110F0000F0332E3C3D8F2341C1A8A42C6C6D5041	1501	5480	8397	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8397.JPG	\N	1501	2019	30/01/2019	\N	\N	Sempreverde	1	0
1583	0101000020110F0000DE54A4423C8F2341793BC2836D6D5041	1502	5481	8398	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8398.JPG	\N	1502	2019	30/01/2019	\N	\N	Sempreverde	1	0
1584	0101000020110F0000F0332E3C3D8F2341053411FA6E6D5041	1503	5482	8399	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	\N	\N	1503	2019	30/01/2019	\N	\N	Sempreverde	1	0
1585	0101000020110F0000F0332E3C3D8F2341813E918F706D5041	1504	5483	8400	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8400.JPG	\N	1504	2019	30/01/2019	\N	\N	Sempreverde	1	0
1586	0101000020110F0000F0332E3C3D8F234148BF7DC7716D5041	1505	5484	8401	Albero	SCHINUS MOLLE	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Saul Greco	Filare	6	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8401.JPG	\N	1505	2019	30/01/2019	\N	\N	Sempreverde	1	0
1587	0101000020110F000085CE6B5C948D23419F026070F96C5041	1506	5485	8402	Albero	GLEDITSIA TRICANTHOS	CAVA CUCULERA	-	Via	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; monconi; seccume localizzato;	strozzatura;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8402.JPG	\N	1506	2019	30/01/2019	\N	\N	Caduca	1	0
1588	0101000020110F000089B5F8449F8E234132ACE259F06C5041	1507	5486	8404	Albero	QUERCUS ILEX	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8404.JPG	\N	1507	2019	30/01/2019	\N	\N	Sempreverde	1	0
1589	0101000020110F0000835149BDB38E2341FFE7304FE86C5041	1508	5487	8405	Albero	QUERCUS ILEX	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	ferite;	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8405.JPG	\N	1508	2019	30/01/2019	\N	\N	Sempreverde	1	0
1590	0101000020110F00007CED9935C88E2341EBFF1C5CE66C5041	1509	5488	8406	Albero	PRUNUS LAUROCERASUS	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8406.JPG	\N	1509	2019	30/01/2019	\N	\N	Sempreverde	1	0
1591	0101000020110F0000C8410963DC862341D7A3700B32655041	1510	345	653	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2.5	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\653.JPG	\N	1510	2018	25/09/2018	\N	\N	Sempreverde	1	0
1592	0101000020110F00008ECC232FC98E23413064750BE46C5041	1511	5489	8407	Albero	ACER SP.	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	cercine di legatura;	\N	\N	\N	\N	\N	desktop/Foto\\8407.JPG	\N	1511	2019	30/01/2019	\N	\N	-	1	0
1593	0101000020110F00004E6210E8D38E23413064750BE46C5041	1512	5490	8408	Albero	ACER SP.	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	cercine di legatura; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8408.JPG	\N	1512	2019	30/01/2019	\N	\N	-	1	0
1594	0101000020110F0000CDE49B8DE18E23414E2844ECE36C5041	1513	5491	8409	Albero	ACER SP.	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	cercine di legatura; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8409.JPG	\N	1513	2019	30/01/2019	\N	\N	-	1	0
1595	0101000020110F0000D3F6AF2CF08E23418AB0E1ADE36C5041	1514	5492	8410	Albero	ACER SP.	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	cercine di legatura; ferite;	\N	\N	\N	\N	\N	desktop/Foto\\8410.JPG	\N	1514	2019	30/01/2019	\N	\N	-	1	0
1596	0101000020110F000099F562B8018F234101C11C31E36C5041	1515	5493	8411	Albero	MELIA AZEDARACH	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8411.JPG	\N	1515	2019	30/01/2019	\N	\N	Caduca	1	0
1597	0101000020110F000030BB27DFFB8E2341DA209362E56C5041	1516	5494	8412	Albero	SCHINUS MOLLE	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Manufatto; Camminamento;	\N	desktop/Foto\\8412.JPG	\N	1516	2019	30/01/2019	\N	\N	Sempreverde	1	0
1598	0101000020110F0000DBA2CC36EC8E23410395F15DE86C5041	1517	5495	8420	Palma	PHOENIX CANARIENSIS	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	punteruolo - R. ferrugineus;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\8420.JPG	\N	1517	2019	30/01/2019	\N	\N	Sempreverde	1	0
1599	0101000020110F0000CB9C2ECBF08E2341BCE82BD0E66C5041	1518	5496	8421	Albero	ACER SP.	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8421.JPG	\N	1518	2019	30/01/2019	\N	\N	-	1	0
1600	0101000020110F0000CD237FF0FB8E234197395DA2EB6C5041	1519	5497	8422	Albero	LIGUSTRUM JAPONICA	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8422.JPG	\N	1519	2019	30/01/2019	\N	\N	Sempreverde	1	0
1601	0101000020110F0000A9F6E9F8F48E2341D751D5E8F16C5041	1520	5498	8423	Albero	LIGUSTRUM JAPONICA	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8423.JPG	\N	1520	2019	30/01/2019	\N	\N	Sempreverde	1	0
1602	0101000020110F0000EAE74D35F28E23411405FA08F36C5041	1521	5499	8424	Albero	LIGUSTRUM JAPONICA	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8424.JPG	\N	1521	2019	30/01/2019	\N	\N	Sempreverde	1	0
1603	0101000020110F0000E02D9070D28E23414278B4D9F46C5041	1522	5500	8425	Albero	QUERCUS ILEX	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\8425.JPG	\N	1522	2019	30/01/2019	\N	\N	Sempreverde	1	0
1604	0101000020110F00007D0569E6088F2341AB3E57F1F36C5041	1523	5501	8426	Albero	ROBINIA PSEUDOACACIA	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-30	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE D	4	branche codominanti; branche con ferite; seccume diffuso;	cavit�;	\N	cavit�;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8426.JPG	\N	1523	2019	30/01/2019	\N	\N	Caduca	1	0
1605	0101000020110F0000605969E2128F23411405FA08F36C5041	1524	5502	8427	Albero	ROBINIA PSEUDOACACIA	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-30	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	cavit�;	\N	cavit�;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8427.JPG	\N	1524	2019	30/01/2019	\N	\N	Caduca	1	0
1606	0101000020110F00007094BCEAC38E2341D9B111C2F56C5041	1525	5503	8429	Palma	-	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	cavit�;	\N	cavit�;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8429.JPG	\N	1525	2019	30/01/2019	\N	\N	-	1	0
1607	0101000020110F0000D89E59129B8E234190149103F26C5041	1526	5504	8430	Palma	-	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	cavit�;	\N	cavit�;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8430.JPG	\N	1526	2019	30/01/2019	\N	\N	-	1	0
1608	0101000020110F0000569FABFDDF862341ED8156FE30655041	1527	346	654	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\654.JPG	\N	1527	2018	25/09/2018	\N	\N	Sempreverde	3	0
1609	0101000020110F00008B89CDB7948E2341D443349AF36C5041	1528	5505	8431	Palma	-	CAVA SANTOIANNI	-	Piazza	-	Via Fiume Savuto	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; seccume diffuso;	cavit�;	\N	cavit�;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\8431.JPG	\N	1528	2019	30/01/2019	\N	\N	-	1	0
1610	0101000020110F0000CB6779DEB770234107B64A0E79715041	1529	5506	8692	Ceppaia	ACER SP.	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2021-08-28	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	photos/Albero/5506/thb_WhatsApp Image 2021-08-28 at 13.04.31_304.jpeg	\N	1529	2021	28/08/2021	\N	\N	-	2	0
1611	0101000020110F0000232D9577AD702341DC291D467B715041	1530	5507	8693	Albero	ACER SP.	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche secche; monconi;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1530	2019	28/01/2019	\N	\N	-	1	0
1612	0101000020110F00002A5778B7A5702341C555657F7C715041	1531	5508	8694	Albero	ACER SP.	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche secche; monconi;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1531	2019	28/01/2019	\N	\N	-	1	0
1613	0101000020110F0000758E01B99B70234140FB919E7D715041	1532	5509	8695	Albero	ACER SP.	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche secche; monconi;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1532	2019	28/01/2019	\N	\N	-	1	0
1614	0101000020110F00001A170E74A27023414F4013317C715041	1533	5510	8696	Albero	NERIUM OLEANDER	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	\N	\N	carie; cavit�; ferite; inclinazione ingiustificata; insetti lignivori; necrosi corticale;	\N	\N	\N	Camminamento;	\N	\N	\N	1533	2019	28/01/2019	\N	\N	Sempreverde	1	0
1615	0101000020110F00000135B55CB27023414E6210E277715041	1534	5511	8697	Albero	NERIUM OLEANDER	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1534	2019	28/01/2019	\N	\N	Sempreverde	1	0
1616	0101000020110F000036E50A4FA57023413468E88D7B715041	1535	5512	8698	Albero	CEDRUS DEODARA	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con essudati/gomme; branche con ferite; branche secche; seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1535	2019	28/01/2019	\N	\N	Sempreverde	1	0
1617	0101000020110F000014ED2A34AA702341FEB792477A715041	1536	5513	8699	Albero	CEDRUS LIBANI	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	3	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	\N	\N	1536	2019	28/01/2019	\N	\N	Sempreverde	1	0
1618	0101000020110F0000D8D825EAAF7023411EF9836776715041	1537	5514	8689	Albero	PITTOSPORUM TOBIRA	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; monconi;	\N	\N	cavit�; ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1537	2019	28/01/2019	\N	\N	Sempreverde	1	0
1619	0101000020110F00008F537494BD7023412041F1CF76715041	1538	5515	8690	Albero	PITTOSPORUM TOBIRA	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; insetti lignivori; monconi;	\N	\N	cavit�; ferite; ginocchiatura;	\N	\N	\N	Camminamento;	\N	\N	\N	1538	2019	28/01/2019	\N	\N	Sempreverde	1	0
1620	0101000020110F0000A86F99C3BC702341910F7A5277715041	1539	5516	8691	Albero	ACER SP.	PONTEGRANDE	-	Giardino	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Ettore Vitale	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-28	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche codominanti; branche secche; monconi;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1539	2019	28/01/2019	\N	\N	-	1	0
1621	0101000020110F000091B8C7E21F892341F775E04C1B685041	1540	5517	7407	Albero	EUCALYPTUS CAMALDULENSIS	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7407.JPG	\N	1540	2019	25/01/2019	\N	\N	Sempreverde	1	0
1622	0101000020110F0000F7E461412F89234158CA324219685041	1541	5518	7409	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7409.JPG	\N	1541	2019	25/01/2019	\N	\N	Caduca	1	0
1623	0101000020110F000060764F6E3A892341E8D9ACFA18685041	1542	5519	7410	Albero	ACACIA SALIGNA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche protese; monconi; tagli impropri;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7410.JPG	\N	1542	2019	25/01/2019	\N	\N	Sempreverde	1	0
1624	0101000020110F0000D00F236440892341DBC4C95318685041	1543	5520	7411	Albero	ACACIA SALIGNA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche protese; monconi; tagli impropri;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7411.JPG	\N	1543	2019	25/01/2019	\N	\N	Sempreverde	1	0
1625	0101000020110F0000532289FEE2862341B1C403DE2F655041	1544	347	655	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\655.JPG	\N	1544	2018	25/09/2018	\N	\N	Sempreverde	3	0
1626	0101000020110F000003CFBD872B892341570916E919685041	1545	5521	7408	Albero	ACACIA DEALBATA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7408.JPG	\N	1545	2019	25/01/2019	\N	\N	Caduca	1	0
1627	0101000020110F0000567DAEE63E892341FE65F77616685041	1546	5522	7412	Albero	ACACIA DEALBATA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7412.JPG	\N	1546	2019	25/01/2019	\N	\N	Caduca	1	0
1628	0101000020110F0000C8073D9B458923412046084115685041	1547	5523	7413	Albero	ACACIA DEALBATA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7413.JPG	\N	1547	2019	25/01/2019	\N	\N	Caduca	1	0
1629	0101000020110F0000BF0E9C134A8923418121ABE114685041	1548	5524	7414	Albero	POPULUS ALBA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7414.JPG	\N	1548	2019	25/01/2019	\N	\N	Caduca	1	0
1630	0101000020110F00004D840D5F438923411F85EBE715685041	1549	5525	7415	Albero	POPULUS ALBA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7415.JPG	\N	1549	2019	25/01/2019	\N	\N	Caduca	1	0
1631	0101000020110F00007E52EDC32D8923416284F02214685041	1550	5526	7416	Albero	POPULUS ALBA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Tornello con cordolo	0	0	-1	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7416.JPG	\N	1550	2019	25/01/2019	\N	\N	Caduca	1	0
1632	0101000020110F0000357BA0455289234114B35E4C13685041	1551	5527	7417	Albero	OLEA EUROPAEA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\7417.JPG	\N	1551	2019	25/01/2019	\N	\N	Sempreverde	1	0
1633	0101000020110F0000DF32A75BFA8823412827DA0D09685041	1552	5528	7418	Ceppaia	FICUS ELASTICA	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2020-01-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	photos/Albero/5528/thb_246_WhatsApp Image 2020-01-10 at 17.53.08.jpeg	\N	1552	2020	10/01/2020	\N	\N	Sempreverde	2	0
1634	0101000020110F0000F46C563D928823417407B131FD675041	1553	5529	7420	Albero	CERCIS SILIQUASTRUM	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7420.JPG	\N	1553	2019	25/01/2019	\N	\N	Caduca	1	0
1635	0101000020110F0000064CE066AE882341C1FF5624F4675041	1554	5530	7421	Albero	ALBIZIA JULIBRISSIN	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7421.JPG	\N	1554	2019	25/01/2019	\N	\N	Caduca	1	0
1636	0101000020110F00005114E863AC8823413E05C0C6F5675041	1555	5531	7422	Albero	ALBIZIA JULIBRISSIN	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7422.JPG	\N	1555	2019	25/01/2019	\N	\N	Caduca	1	0
1637	0101000020110F0000D93D79B8E588234106D8478FFB675041	1556	5532	7423	Albero	GLEDITSIA TRICANTHOS	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7423.JPG	\N	1556	2019	25/01/2019	\N	\N	Caduca	1	0
1638	0101000020110F000040DEABA6D9882341EB6E9ED2FD675041	1557	5533	7424	Albero	GLEDITSIA TRICANTHOS	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\7424.JPG	\N	1557	2019	25/01/2019	\N	\N	Caduca	1	0
1639	0101000020110F000054E3A57BBC88234162D68B73FE675041	1558	5534	7425	Albero	-	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7425.JPG	\N	1558	2019	25/01/2019	\N	\N	-	1	0
1640	0101000020110F0000BB61DBC2EC882341486DE2B600685041	1559	5535	7426	Ceppaia	CUPRESSUS SP.	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-01-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/5535/thb_248_WhatsApp Image 2020-01-10 at 15.47.25.jpeg	\N	1559	2020	10/01/2020	\N	\N	-	2	0
1641	0101000020110F0000EB1C03E201892341F08AE051FD675041	1560	5536	7427	Albero	CUPRESSUS SP.	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\7427.JPG	\N	1560	2019	25/01/2019	\N	\N	-	1	0
1642	0101000020110F0000C55565FFE58623410A6822E42E655041	1561	348	656	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2.5	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\656.JPG	\N	1561	2018	25/09/2018	\N	\N	Sempreverde	1	0
1643	0101000020110F00009031776D608923414D4A41F700685041	1562	5537	7428	Albero	CEDRUS ATLANTICA	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	ferite; ginocchiatura;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7428.JPG	\N	1562	2019	25/01/2019	\N	\N	Sempreverde	1	0
1644	0101000020110F0000EFC9C3524E8923412F86727C04685041	1563	5538	7429	Albero	CEDRUS ATLANTICA	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7429.JPG	\N	1563	2019	25/01/2019	\N	\N	Sempreverde	1	0
1645	0101000020110F0000C616823C3F89234190A0F8DF06685041	1564	5539	7430	Albero	CEDRUS ATLANTICA	ARANCETO	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	\N	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto; Recinzione;	\N	desktop/Foto\\7430.JPG	\N	1564	2019	25/01/2019	\N	\N	Sempreverde	1	0
1646	0101000020110F0000D99942B76D882341349D9D6A16685041	1565	5540	7434	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7434.JPG	\N	1565	2019	25/01/2019	\N	\N	Caduca	1	0
1647	0101000020110F0000164D673765882341D595CF0216685041	1566	5541	7435	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7435.JPG	\N	1566	2019	25/01/2019	\N	\N	Caduca	1	0
1648	0101000020110F0000F6B4C33F5B88234111FC6F4315685041	1567	5542	7436	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7436.JPG	\N	1567	2019	25/01/2019	\N	\N	Caduca	1	0
1649	0101000020110F00008D5DA24A4E88234188D7F5A314685041	1568	5543	7437	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7437.JPG	\N	1568	2019	25/01/2019	\N	\N	Caduca	1	0
1650	0101000020110F0000056EDD5D378823418464016513685041	1569	5544	7438	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7438.JPG	\N	1569	2019	25/01/2019	\N	\N	Caduca	1	0
1651	0101000020110F000076543561338823414772F90117685041	1570	5545	7439	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento;	\N	desktop/Foto\\7439.JPG	\N	1570	2019	25/01/2019	\N	\N	Caduca	1	0
1652	0101000020110F000002486DA2E587234161C3D30710685041	1571	5546	7440	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7440.JPG	\N	1571	2019	25/01/2019	\N	\N	Caduca	1	0
1653	0101000020110F000002486DA2E5872341C93CF24512685041	1572	5547	7441	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7441.JPG	\N	1572	2019	25/01/2019	\N	\N	Caduca	1	0
1654	0101000020110F000049A297A1E687234124D1CBA413685041	1573	5548	7442	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Filare	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche protese;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cartellonistica; Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7442.JPG	\N	1573	2019	25/01/2019	\N	\N	Caduca	1	0
1655	0101000020110F000022E0109AEF8723416D1CB1C413685041	1574	5549	7443	Albero	MELIA AZEDARACH	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche protese;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7443.JPG	\N	1574	2019	25/01/2019	\N	\N	Caduca	1	0
1656	0101000020110F0000B5C35F93F78723418464016513685041	1575	5550	7444	Albero	GLEDITSIA TRICANTHOS	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche codominanti; branche con ferite;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Cavi Aerei;	\N	desktop/Foto\\7444.JPG	\N	1575	2019	25/01/2019	\N	\N	Caduca	1	0
1657	0101000020110F00009AB1686A28882341CC457CAB0B685041	1576	5551	7445	Albero	EUCALYPTUS CAMALDULENSIS	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7445.JPG	\N	1576	2019	25/01/2019	\N	\N	Sempreverde	1	0
1658	0101000020110F0000C3D84270218823414D840DCD09685041	1577	5552	7446	Albero	EUCALYPTUS CAMALDULENSIS	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\7446.JPG	\N	1577	2019	25/01/2019	\N	\N	Sempreverde	1	0
1698	0101000020110F000084471B375D722341B62DCA1AD06F5041	1889	5844	8896	Albero	QUERCUS CERRIS	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Scuola Agraria	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-13	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1889	2018	13/12/2018	\N	\N	Caduca	1	0
1659	0101000020110F000053B3079AE98623418AE596B02D655041	1578	349	657	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\657.JPG	\N	1578	2018	25/09/2018	\N	\N	Sempreverde	1	0
1660	0101000020110F000063D17446538823411092056A0D685041	1579	5553	7449	Albero	CARPINUS BETULUS	ARANCETO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-01-25	1	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	ferite;	\N	\N	\N	Sede Stradale;	\N	desktop/Foto\\7449.JPG	\N	1579	2019	25/01/2019	\N	\N	Caduca	1	0
1661	0101000020110F0000465F412A1A88234180D42612EE675041	1580	5554	7450	Albero	CARPINUS BETULUS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature;	\N	\N	capitozzatura; ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7450.JPG	\N	1580	2019	25/01/2019	\N	\N	Caduca	1	0
1662	0101000020110F0000903177CD2588234153910AE1EE675041	1581	5555	7451	Albero	CARPINUS BETULUS	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	3.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7451.JPG	\N	1581	2019	25/01/2019	\N	\N	Caduca	1	0
1663	0101000020110F0000EE08A72530882341274EEEAFEF675041	1582	5556	7452	Albero	ROBINIA PSEUDOACACIA	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7452.JPG	\N	1582	2019	25/01/2019	\N	\N	Caduca	1	0
1664	0101000020110F0000C5FEB2BB32882341CEC7B54DF1675041	1583	5557	7453	Albero	POPULUS NIGRA	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE D	4	branche con ferite; branche con fratture/incrinature;	\N	\N	carie; ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7453.JPG	\N	1583	2019	25/01/2019	\N	\N	Caduca	1	0
1665	0101000020110F00002EAD8614F287234196E7C1E3F3675041	1584	5558	7454	Albero	POPULUS NIGRA	ARANCETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	Via Teano	Isolato	0	Buco nell'asfalto	0	0	-1	-	0	\N	-	0	\N	2019-01-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale; Manufatto;	\N	desktop/Foto\\7454.JPG	\N	1584	2019	25/01/2019	\N	\N	Caduca	1	0
1666	0101000020110F0000734BAB11798D234130815BB9E46D5041	1856	5813	8849	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1856	2018	05/12/2018	\N	\N	Sempreverde	1	0
1667	0101000020110F000060EAE7CD7E8D23410DAB785FE66D5041	1857	5814	8850	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1857	2018	05/12/2018	\N	\N	Sempreverde	1	0
1668	0101000020110F000086AC6ED5868D2341BA66F26FE46D5041	1858	5815	8851	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1858	2018	05/12/2018	\N	\N	Sempreverde	1	0
1669	0101000020110F00002332AC02588C2341BDA9483BD36D5041	1859	5816	8852	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1859	2018	05/12/2018	\N	\N	Sempreverde	1	0
1670	0101000020110F0000FB05BB515E8C234164062A05D46D5041	1860	5817	8853	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1860	2018	05/12/2018	\N	\N	Sempreverde	1	0
1671	0101000020110F0000745E6377388C2341DBBFB24CD26D5041	1861	5818	8854	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1861	2018	05/12/2018	\N	\N	Sempreverde	2	0
1672	0101000020110F00005DBF60775F8C2341BF7D1D26D06D5041	1862	5819	8855	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1862	2018	05/12/2018	\N	\N	Sempreverde	2	0
1673	0101000020110F0000ACADD8AF748C2341BF6037ACD66D5041	1863	5820	8856	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1863	2018	05/12/2018	\N	\N	Sempreverde	2	0
1674	0101000020110F00000DFD13AC708C2341A3CC061FDC6D5041	1864	5821	8857	Palma	WASHINGTONIA FILIFERA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1864	2018	05/12/2018	\N	\N	Sempreverde	1	0
1675	0101000020110F0000D443340A608C23411BBB4453D96D5041	1865	5822	8858	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1865	2018	05/12/2018	\N	\N	Sempreverde	2	0
1676	0101000020110F000083177D55898C2341A3CC061FDC6D5041	1866	5823	8859	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1866	2018	05/12/2018	\N	\N	Sempreverde	2	0
1677	0101000020110F0000E73A8D64728C2341A583F58FDF6D5041	1867	5824	8860	Ceppaia	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Gruppo	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1867	2018	05/12/2018	\N	\N	Sempreverde	2	0
1678	0101000020110F0000B9A5D5C070872341FF78AF5616655041	1868	366	674	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\674.JPG	\N	1868	2018	25/09/2018	\N	\N	Sempreverde	3	0
1679	0101000020110F0000FA27B8688B7A23414C6C3EF2B86D5041	1869	5825	8867	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1869	2018	14/11/2018	\N	\N	Sempreverde	1	0
1680	0101000020110F0000A88C7FEF867A2341FBAE082CB86D5041	1870	5826	8868	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1870	2018	14/11/2018	\N	\N	Sempreverde	1	0
1681	0101000020110F00007A707726837A234182E7DE91B76D5041	1871	5827	8869	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1871	2018	14/11/2018	\N	\N	Sempreverde	1	0
1682	0101000020110F0000F7E461317F7A23419CF9D570B76D5041	1872	5828	8870	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1872	2018	14/11/2018	\N	\N	Sempreverde	1	0
1683	0101000020110F000099D87CEC7B7A23414BE5EDC8B76D5041	1873	5829	8871	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1873	2018	14/11/2018	\N	\N	Sempreverde	1	0
1684	0101000020110F000082CAF8077A7A2341AA9A2084B86D5041	1874	5830	8872	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1874	2018	14/11/2018	\N	\N	Sempreverde	1	0
1685	0101000020110F0000F08AE0AF797A2341FB57564AB96D5041	1875	5831	8873	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1875	2018	14/11/2018	\N	\N	Sempreverde	1	0
1686	0101000020110F000065A549D97E7A2341903177C3B96D5041	1876	5832	8874	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1876	2018	14/11/2018	\N	\N	Sempreverde	1	0
1687	0101000020110F0000C85EEFDE847A2341903177C3B96D5041	1877	5833	8875	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1877	2018	14/11/2018	\N	\N	Sempreverde	1	0
1688	0101000020110F0000B9AAEC7B887A2341E1455F6BB96D5041	1878	5834	8876	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Lilio	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1878	2018	14/11/2018	\N	\N	Sempreverde	1	0
1689	0101000020110F00006284F0080179234149A297CB8F6D5041	1879	5835	8877	Albero	TILIA CORDATA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Lucrezia della Valle	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-19	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	ferite; strozzatura;	\N	ferite;	\N	\N	\N	Sede Stradale;	\N	\N	\N	1879	2018	19/10/2018	\N	\N	Sempreverde	1	0
1690	0101000020110F0000CBB91467A2782341E0675C64A16D5041	1880	5836	8878	Albero	TILIA CORDATA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Lucrezia della Valle	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-03	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1880	2018	03/10/2018	\N	\N	Sempreverde	1	0
1691	0101000020110F00008E93C7E5647723417A13CBE7D26D5041	1881	5837	8879	Albero	PINUS HALEPENSIS	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Lucrezia della Valle	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2024-11-25	5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE D	\N	branche con ferite; monconi; seccume diffuso;	strozzatura;	\N	essudati; ginocchiatura;	Radici superficiali; sollevamento zolla;	\N	\N	Sede Stradale; Manufatto;	\N	\N	\N	1881	2024	25/11/2024	\N	\N	Sempreverde	1	0
1692	0101000020110F00001F80D43642772341FCE3BDB2BB6F5041	1883	5839	8882	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	\N	\N	\N	\N	\N	\N	\N	\N	1883	2018	06/12/2018	\N	\N	Sempreverde	1	0
1693	0101000020110F0000B9196E10487723413FA9F683BC6F5041	1884	5840	8883	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	\N	\N	\N	\N	\N	\N	\N	\N	1884	2018	06/12/2018	\N	\N	Sempreverde	1	0
1694	0101000020110F0000F207038F758723413142789615655041	1885	367	675	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\675.JPG	\N	1885	2018	25/09/2018	\N	\N	Sempreverde	3	0
1695	0101000020110F0000D4D4B2B54C77234146CEC29CBD6F5041	1886	5841	8884	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	\N	\N	\N	\N	\N	\N	\N	\N	1886	2018	06/12/2018	\N	\N	Sempreverde	1	0
1696	0101000020110F00002B8716794A77234104392813BF6F5041	1887	5842	8885	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	\N	\N	\N	\N	\N	\N	\N	\N	1887	2018	06/12/2018	\N	\N	Sempreverde	1	0
1697	0101000020110F0000D1915CDE317723412E73BA2EC16F5041	1888	5843	8886	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Pascali	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	\N	\N	\N	\N	Edificio;	\N	\N	\N	1888	2018	06/12/2018	\N	\N	Sempreverde	1	0
1699	0101000020110F00003D7E6F732E7323418E588BBFBC6F5041	1890	5845	8898	Albero	LAGERSTROEMIA INDICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Vinicio Cortese	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-13	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; seccume localizzato;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1890	2018	13/12/2018	\N	\N	Caduca	1	0
1700	0101000020110F0000EA3E006934832341FD9FC320746A5041	1891	5846	8911	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Cattivo	CLASSE D	3C	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso; seccume localizzato;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione; Camminamento;	\N	\N	\N	1891	2018	05/12/2018	\N	\N	Caduca	1	0
1701	0101000020110F0000F224E9DA33832341C555655D736A5041	1892	5847	8912	Albero	ROBINIA PSEUDOACACIA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Magna Grecia	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Cattivo	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume diffuso; seccume localizzato;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Recinzione; Camminamento;	\N	\N	\N	1892	2018	05/12/2018	\N	\N	Caduca	1	0
1702	0101000020110F0000E9D4950FEA822341C22FF55F3A6D5041	1893	5848	8916	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1893	2019	31/01/2019	\N	\N	Sempreverde	1	0
1703	0101000020110F0000FB743C56D7822341B51A12BD3A6D5041	1894	5849	8917	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	Illuminazione pubblica;	\N	\N	\N	1894	2019	31/01/2019	\N	\N	Sempreverde	1	0
1704	0101000020110F000082C5E19CC4822341982F2F1A3B6D5041	1895	5850	8918	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1895	2019	31/01/2019	\N	\N	Sempreverde	1	0
1705	0101000020110F0000956588E3B18223417C444C773B6D5041	1896	5851	8919	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1896	2019	31/01/2019	\N	\N	Sempreverde	1	0
1706	0101000020110F00001CB62D2A9F8223416F2F69D43B6D5041	1897	5852	8920	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1897	2019	31/01/2019	\N	\N	Sempreverde	1	0
1707	0101000020110F0000FF21FDB66E822341D3307C1C3D6D5041	1898	5853	8922	Albero	CUPRESSUS ARIZONICA "CONICA"	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	\N	\N	1898	2019	31/01/2019	\N	\N	Sempreverde	1	0
1708	0101000020110F00003EE8D97C6982234166DAFE8B3D6D5041	1899	5854	8923	Albero	CUPRESSUS ARIZONICA "CONICA"	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Illuminazione pubblica;	\N	\N	\N	1899	2019	31/01/2019	\N	\N	Sempreverde	1	0
1709	0101000020110F0000226C787A64822341967840193F6D5041	1900	5855	8924	Albero	FICUS CARICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	0.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1900	2019	31/01/2019	\N	\N	Caduca	1	0
1710	0101000020110F00002A8C2DF4628223419D802614406D5041	1901	5856	8925	Albero	MORUS L.	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1901	2019	31/01/2019	\N	\N	Caduca	1	0
1711	0101000020110F00008D0B0722EC8623411618B2E0F7645041	1902	23	234	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2024-11-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Cattivo	Cattivo	CLASSE D	\N	\N	\N	\N	inclinazione ingiustificata; insetti lignivori; carpofori;	\N	\N	\N	\N	\N	desktop/Foto\\234.JPG	\N	1902	2024	25/11/2024	\N	\N	Sempreverde	1	0
1712	0101000020110F00004DDBBF22578B2341978BF8D883655041	1903	368	714	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\714.JPG	\N	1903	2018	26/09/2018	\N	\N	Sempreverde	3	0
1713	0101000020110F0000CEC29EC6608223419413ED2A416D5041	1904	5864	8926	Fallanza	-	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1904	2019	31/01/2019	\N	\N	-	3	0
1714	0101000020110F000017B7D1D05E822341D5CA846B426D5041	1905	5857	8927	Albero	LAGERSTROEMIA INDICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1905	2019	31/01/2019	\N	\N	Caduca	1	0
1715	0101000020110F000060AB04DB5C822341EA043497436D5041	1906	5859	8928	Albero	TILIA CORDATA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1906	2019	31/01/2019	\N	\N	Sempreverde	1	0
1716	0101000020110F00004F5DF91C5B8223415839B4EC446D5041	1907	5863	8929	Ceppaia	-	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1907	2019	31/01/2019	\N	\N	-	2	0
1717	0101000020110F0000A99F37E55A822341B1338516456D5041	1908	5860	8930	Albero	FICUS CARICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	0.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1908	2019	31/01/2019	\N	\N	Caduca	1	0
1718	0101000020110F00004F5DF91C5B8223412C9ACE9C466D5041	1909	5861	8931	Albero	PRUNUS ARMENIACA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1909	2019	31/01/2019	\N	\N	Caduca	1	0
1719	0101000020110F000004E275AD5A8223416B0E102A486D5041	1910	5858	8932	Albero	LAGERSTROEMIA INDICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	1.8	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1910	2019	31/01/2019	\N	\N	Caduca	1	0
1720	0101000020110F00005F24B4755A8223414DA1F30A4A6D5041	1911	5862	8933	Albero	LIGUSTRUM JAPONICA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Ridola	Filare	2	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-31	0.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1911	2019	31/01/2019	\N	\N	Sempreverde	1	0
1721	0101000020110F000069520A8A6D882341EAB29828F7675041	1912	5865	8935	Albero	POPULUS SP.	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-08	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	Sede Stradale;	\N	\N	\N	1912	2019	08/01/2019	\N	\N	Caduca	1	0
1722	0101000020110F0000309E41438F882341B0C91AA7F1675041	1913	5866	8936	Albero	LAURUS NOBILIS	ARANCETO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Piazza Castelfidardo	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-08	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1913	2019	08/01/2019	\N	\N	Sempreverde	1	0
1723	0101000020110F0000118DEE806E92234174B5159FB5665041	1914	5867	8937	Albero	PINUS PINEA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Gemelli	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	Pessimo	CLASSE D	\N	branche con ferite; monconi; seccume diffuso;	\N	\N	essudati; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale;	\N	photos/Albero/5867/IMG_1958_594.jpeg	\N	1914	2024	26/01/2024	\N	\N	Sempreverde	1	0
1724	0101000020110F0000FE2B2B0D68922341A0371589B6665041	1915	5868	8938	Albero	PINUS PINEA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Gemelli	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2024-01-26	4	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	rimozione del secco	branche con ferite; monconi; seccume diffuso;	\N	\N	essudati;	\N	\N	\N	Sede Stradale;	\N	photos/Albero/5868/IMG_1959_595.jpeg	\N	1915	2024	26/01/2024	\N	\N	Sempreverde	1	0
1725	0101000020110F0000F62345D40C7A23418D5DA25C176E5041	1916	5869	8939	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Masciari	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite; branche secche; seccume diffuso;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1916	2018	29/12/2018	\N	\N	Sempreverde	1	0
1726	0101000020110F0000EA0434A15C8B2341CB10C78884655041	1917	369	715	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\715.JPG	\N	1917	2018	26/09/2018	\N	\N	Sempreverde	3	0
1727	0101000020110F000085083864638B23416E861B4685655041	1918	370	716	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\716.JPG	\N	1918	2018	26/09/2018	\N	\N	Sempreverde	3	0
1728	0101000020110F000026DF6C936A8B2341B1E1E9F585655041	1919	371	717	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\717.JPG	\N	1919	2018	26/09/2018	\N	\N	Sempreverde	1	0
1729	0101000020110F00004339D12E728B2341B471C4C086655041	1920	372	718	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	monconi; tagli impropri;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\718.JPG	\N	1920	2018	26/09/2018	\N	\N	Sempreverde	1	0
1730	0101000020110F00002310AF0B868B2341D3872EEC89655041	1921	373	721	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\721.JPG	\N	1921	2018	26/09/2018	\N	\N	Caduca	1	0
1731	0101000020110F00004E97C574918B234176FD82A98A655041	1922	374	723	Albero	NERIUM OLEANDER	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Cattivo	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\723.JPG	\N	1922	2018	26/09/2018	\N	\N	Sempreverde	1	0
1732	0101000020110F000074EACA37988B23414968CB4B8B655041	1923	375	724	Albero	ERYTHRINA CRISTA-GALLI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	contrafforti scoperti;	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\724.JPG	\N	1923	2018	26/09/2018	\N	\N	Sempreverde	1	0
1733	0101000020110F0000139B8FABA08B23414DF8A5168C655041	1924	376	726	Albero	PITTOSPORUM TOBIRA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\726.JPG	\N	1924	2018	26/09/2018	\N	\N	Sempreverde	1	0
1734	0101000020110F000011532269698C2341596E69D9A0655041	1925	377	731	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Cartellonistica; Marciapiede; Illuminazione pubblica;	\N	desktop/Foto\\731.JPG	\N	1925	2018	26/09/2018	\N	\N	Caduca	1	0
1735	0101000020110F00006E3480A7808C234111AAD4E8A2655041	1926	378	732	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Tornello senza cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con carie; branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\732.JPG	\N	1926	2018	26/09/2018	\N	\N	Caduca	1	0
1736	0101000020110F0000A98768A48B8C2341865AD304A4655041	1927	379	733	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	8	Tornello senza cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\733.JPG	\N	1927	2018	26/09/2018	\N	\N	Caduca	1	0
1737	0101000020110F00005665DFE5978C23412B306449A5655041	1928	380	734	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	8	Tornello senza cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\734.JPG	\N	1928	2018	26/09/2018	\N	\N	Caduca	1	0
1738	0101000020110F000017BCE86BA58C234132207B9BA6655041	1929	381	735	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	8	Tornello senza cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\735.JPG	\N	1929	2018	26/09/2018	\N	\N	Caduca	1	0
1739	0101000020110F0000596952CAB38C2341780B2416A8655041	1930	382	736	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	8	Tornello senza cordolo	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Arredo urbano;	\N	desktop/Foto\\736.JPG	\N	1930	2018	26/09/2018	\N	\N	Caduca	1	0
1740	0101000020110F00002063EE8A898C234145BB0AE59E655041	1931	383	741	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\741.JPG	\N	1931	2018	26/09/2018	\N	\N	Sempreverde	1	0
1741	0101000020110F000039454722FB86234182CAF8FBFA645041	1932	24	235	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2024-11-25	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Cattivo	Cattivo	CLASSE D	\N	branche con carpofori;	\N	\N	carpofori; inclinazione ingiustificata; insetti lignivori;	\N	\N	\N	\N	\N	desktop/Foto\\235.JPG	\N	1932	2024	25/11/2024	\N	\N	Sempreverde	1	0
1742	0101000020110F00003563D1C48D8C234101309EF19D655041	1933	384	742	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\742.JPG	\N	1933	2018	26/09/2018	\N	\N	Sempreverde	1	0
1743	0101000020110F00008CD65145D0812341CC0BB0997E6A5041	1663	5632	6321	Albero	NERIUM OLEANDER	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6321.JPG	\N	1663	2019	29/01/2019	\N	\N	Sempreverde	1	0
1744	0101000020110F0000BF7D1D38F9862341AFCE312228655041	1664	354	662	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\662.JPG	\N	1664	2018	25/09/2018	\N	\N	Sempreverde	3	0
1745	0101000020110F000036EA21FAE5812341D95F76E57E6A5041	1665	5633	6322	Albero	NERIUM OLEANDER	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6322.JPG	\N	1665	2019	29/01/2019	\N	\N	Sempreverde	1	0
1746	0101000020110F0000CFDA6D87E9812341AA2B9FCF7D6A5041	1666	5634	6323	Albero	NERIUM OLEANDER	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6323.JPG	\N	1666	2019	29/01/2019	\N	\N	Sempreverde	1	0
1747	0101000020110F00008CF84E1CDC812341B77F651B7E6A5041	1667	5635	6324	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6324.JPG	\N	1667	2019	29/01/2019	\N	\N	Sempreverde	1	0
1748	0101000020110F000047C9AB73E0812341F207037D7F6A5041	1668	5636	6325	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6325.JPG	\N	1668	2019	29/01/2019	\N	\N	Sempreverde	1	0
1749	0101000020110F0000DF6C73C3F5812341959F54517D6A5041	1669	5637	6326	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6326.JPG	\N	1669	2019	29/01/2019	\N	\N	Sempreverde	1	0
1750	0101000020110F0000022B87B6EA8123418E75712B7D6A5041	1670	5638	6327	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; branche secche; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6327.JPG	\N	1670	2019	29/01/2019	\N	\N	Sempreverde	1	0
1751	0101000020110F0000257A1995E5812341CC0BB0997E6A5041	1671	5639	6328	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-01-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6328.JPG	\N	1671	2020	25/01/2020	\N	\N	Sempreverde	2	0
1752	0101000020110F0000BDFBE30DEF812341D44334CC7E6A5041	1672	5640	6329	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-01-25	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6329.JPG	\N	1672	2020	25/01/2020	\N	\N	Sempreverde	2	0
1753	0101000020110F0000F207038FD88123415D33F9087C6A5041	1673	5641	6330	Ceppaia	CEDRUS DEODARA	SANTA MARIA	-	Edifici comunali	III Sala, Siano, Santa Maria, Germaneto	Via Molise	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	-	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6330.JPG	\N	1673	2019	29/01/2019	\N	\N	Sempreverde	2	0
1754	0101000020110F000035D252B979842341DF1AD88EC86A5041	1674	5642	6333	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6333.JPG	\N	1674	2019	29/01/2019	\N	\N	Sempreverde	1	0
1755	0101000020110F0000F65D11FC7B842341B728B39DC76A5041	1675	5643	6334	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6334.JPG	\N	1675	2019	29/01/2019	\N	\N	Sempreverde	1	0
1756	0101000020110F000087BF263B7B8423414EB4ABC4C66A5041	1676	5644	6335	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6335.JPG	\N	1676	2019	29/01/2019	\N	\N	Sempreverde	1	0
1757	0101000020110F0000D4601AE669842341DAFE9585C76A5041	1677	5645	6336	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6336.JPG	\N	1677	2019	29/01/2019	\N	\N	Sempreverde	1	0
1758	0101000020110F0000211FF45C6284234120240BE6C76A5041	1678	5646	6337	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6337.JPG	\N	1678	2019	29/01/2019	\N	\N	Sempreverde	1	0
1759	0101000020110F0000CFF753434D8423419D11A537C96A5041	1679	5647	6338	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche protese; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6338.JPG	\N	1679	2019	29/01/2019	\N	\N	Sempreverde	1	0
1760	0101000020110F00007CED99F541842341BF6037B0C96A5041	1680	5648	6339	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	ferite; polloni radicali;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6339.JPG	\N	1680	2019	29/01/2019	\N	\N	Sempreverde	1	0
1761	0101000020110F0000BD00FB38FC862341C5AC171527655041	1681	355	663	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\663.JPG	\N	1681	2018	25/09/2018	\N	\N	Sempreverde	3	0
1762	0101000020110F0000C45F9395278423410AA2EE19CB6A5041	1682	5649	6340	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	ferite; polloni radicali;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6340.JPG	\N	1682	2019	29/01/2019	\N	\N	Sempreverde	1	0
1763	0101000020110F000033E1978A1E84234150C7637ACB6A5041	1683	5650	6341	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	ferite; polloni radicali;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6341.JPG	\N	1683	2019	29/01/2019	\N	\N	Sempreverde	1	0
1764	0101000020110F000011018740168423416440F6F2CB6A5041	1684	5651	6342	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con ferite;	ferite; polloni radicali;	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6342.JPG	\N	1684	2019	29/01/2019	\N	\N	Sempreverde	1	0
1765	0101000020110F0000A2629C7F15842341857CD0B5C76A5041	1685	5652	6343	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	ferite; ginocchiatura; inclinazione ingiustificata; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6343.JPG	\N	1685	2019	29/01/2019	\N	\N	Sempreverde	1	0
1766	0101000020110F00001F2E392E0784234153D0EDCDC76A5041	1686	5653	6344	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	cavit�; ferite; ginocchiatura; inclinazione ingiustificata; insetti lignivori; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6344.JPG	\N	1686	2019	29/01/2019	\N	\N	Sempreverde	1	0
1767	0101000020110F0000FD4D28E4FE832341CBA14516C86A5041	1687	5654	6345	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche secche; branche con ferite; branche con fratture/incrinature;	ferite; polloni radicali;	\N	ferite; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6345.JPG	\N	1687	2019	29/01/2019	\N	\N	Sempreverde	1	0
1768	0101000020110F000019E25857F483234199F5622EC86A5041	1688	5655	6346	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	cavit�; ferite; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6346.JPG	\N	1688	2019	29/01/2019	\N	\N	Sempreverde	1	0
1769	0101000020110F0000E99AC987E7832341CFBD871FC96A5041	1689	5656	6347	Albero	NERIUM OLEANDER	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; branche secche; fumaggine; seccume diffuso;	ferite; polloni radicali;	\N	ferite; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6347.JPG	\N	1689	2019	29/01/2019	\N	\N	Sempreverde	1	0
1770	0101000020110F00009CF9D5DCF8832341FD4D28FEC76A5041	1690	5657	6348	Albero	ULMUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche codominanti; branche protese;	ferite;	\N	ferite; insetti lignivori; monconi;	\N	\N	\N	Recinzione; Camminamento;	\N	desktop/Foto\\6348.JPG	\N	1690	2019	29/01/2019	\N	\N	-	1	0
1771	0101000020110F000013D55BA36784234157EC2FD7C86A5041	1691	5658	6349	Albero	ULMUS SP.	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2024-01-25	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con fratture/incrinature; branche protese; branche secche;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	photos/Albero/5658/IMG_1902_563.jpeg	\N	1691	2024	25/01/2024	\N	\N	-	1	0
1772	0101000020110F0000895E46D1568423413485CE19CE6A5041	1692	5659	6350	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con fratture/incrinature; branche secche;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6350.JPG	\N	1692	2019	29/01/2019	\N	\N	Sempreverde	1	0
1773	0101000020110F000043E21EDB608423415F24B4E9CA6A5041	1693	5660	6351	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con fratture/incrinature; branche secche;	ferite;	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6351.JPG	\N	1693	2019	29/01/2019	\N	\N	Sempreverde	1	0
1774	0101000020110F0000B0C91A553484234117F19D88CE6A5041	1694	5661	6352	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con fratture/incrinature; branche secche;	ferite;	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6352.JPG	\N	1694	2019	29/01/2019	\N	\N	Sempreverde	1	0
1775	0101000020110F00002497FFD0238423410C3CF73ECF6A5041	1695	5662	6353	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	branche con fratture/incrinature; branche secche;	ferite;	\N	ferite; inclinazione ingiustificata; monconi;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6353.JPG	\N	1695	2019	29/01/2019	\N	\N	Sempreverde	1	0
1776	0101000020110F0000E0F3C3081D842341AE81AD5CCD6A5041	1696	5663	6354	Ceppaia	LIGUSTRUM JAPONICA	SANTA MARIA	-	Parco	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-12-17	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	desktop/Foto\\6354.JPG	\N	1696	2019	17/12/2019	\N	\N	Sempreverde	2	0
1777	0101000020110F00004165FCFBDF842341F146E6B3A36A5041	1697	5664	8180	Albero	SCHINUS MOLLE	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con fratture/incrinature; branche secche; seccume diffuso;	ferite; strozzatura;	\N	carie; ferite; ginocchiatura; inclinazione ingiustificata; insetti lignivori; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8180.JPG	\N	1697	2019	29/01/2019	\N	\N	Sempreverde	1	0
1778	0101000020110F0000E65773B037872341D6AD9EC51D655041	1698	356	664	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-25	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\664.JPG	\N	1698	2018	25/09/2018	\N	\N	Sempreverde	1	0
1779	0101000020110F0000B493C1E1E2842341EB39E909A36A5041	1699	5665	8181	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	carie; insetti lignivori; lesioni aperte; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\8181.JPG	\N	1699	2019	29/01/2019	\N	\N	Sempreverde	1	0
1780	0101000020110F000075CDE44BE58423419B030441A26A5041	1700	5666	8182	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via della Resistenza	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-29	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche secche; monconi; seccume diffuso;	\N	\N	carie; insetti lignivori; lesioni aperte; monconi;	\N	\N	\N	\N	\N	\N	\N	1700	2019	29/01/2019	\N	\N	Sempreverde	1	0
1781	0101000020110F0000799274EDCC652341228E75093D6A5041	1701	5667	6386	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Gruppo	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; giallume diffuso;	ferite;	\N	decorticazione; ferite; monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6386.JPG	\N	1701	2019	30/01/2019	\N	\N	-	1	0
1782	0101000020110F000013F2411FE7652341F4893C1F396A5041	1702	5668	6387	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Gruppo	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6387.JPG	\N	1702	2019	30/01/2019	\N	\N	-	1	0
1783	0101000020110F000078D15730FB652341F9BD4D17346A5041	1703	5669	6389	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	giallume diffuso; monconi; seccume localizzato;	cavit�;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6389.JPG	\N	1703	2019	30/01/2019	\N	\N	-	1	0
1784	0101000020110F00003064750BF365234168058620366A5041	1704	5670	6388	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6388.JPG	\N	1704	2019	30/01/2019	\N	\N	-	1	0
1785	0101000020110F0000D74CBEF901662341984C150E326A5041	1705	5671	6390	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6390.JPG	\N	1705	2019	30/01/2019	\N	\N	-	1	0
1786	0101000020110F00004DD6A86707662341DEB06DD92F6A5041	1706	5672	6391	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6391.JPG	\N	1706	2019	30/01/2019	\N	\N	-	1	0
1787	0101000020110F0000AD510F310E662341C993A4FB2D6A5041	1707	5673	6392	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6392.JPG	\N	1707	2019	30/01/2019	\N	\N	-	1	0
1788	0101000020110F000052616CB11766234182AD12402A6A5041	1708	5674	6393	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6393.JPG	\N	1708	2019	30/01/2019	\N	\N	-	1	0
1789	0101000020110F0000543A581F1D6623415EBA4962286A5041	1709	5675	6394	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6394.JPG	\N	1709	2019	30/01/2019	\N	\N	-	1	0
1790	0101000020110F00006EFAB39F26662341499D8084266A5041	1710	5676	6395	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6395.JPG	\N	1710	2019	30/01/2019	\N	\N	-	1	0
1791	0101000020110F0000CD751A692D6623418E01D94F246A5041	1711	5677	6396	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6396.JPG	\N	1711	2019	30/01/2019	\N	\N	-	1	0
1792	0101000020110F0000535C55163566234153E8BCF2226A5041	1712	5678	6397	Albero	CERATONIA SILIQUA	GERMANETO	-	Parcheggio	III Sala, Siano, Santa Maria, Germaneto	SP46	Filare	6	Prato	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite; monconi; seccume localizzato;	cavit�;	\N	monconi;	\N	\N	\N	\N	\N	desktop/Foto\\6397.JPG	\N	1712	2019	30/01/2019	\N	\N	-	1	0
1793	0101000020110F000059DDEA5901612341145CACAA47705041	1713	5679	6399	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6399.JPG	\N	1713	2019	30/01/2019	\N	\N	Sempreverde	1	0
1794	0101000020110F00001E50366500612341F224E9E646705041	1714	5680	6400	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6400.JPG	\N	1714	2019	30/01/2019	\N	\N	Sempreverde	1	0
1795	0101000020110F00003BE466183D8723414B3CA0181D655041	1715	357	665	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\665.JPG	\N	1715	2018	25/09/2018	\N	\N	Sempreverde	3	0
1796	0101000020110F0000A6F27644FF602341CA4FAA3346705041	1716	5681	6401	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6401.JPG	\N	1716	2019	30/01/2019	\N	\N	Sempreverde	1	0
1797	0101000020110F00007155D9A7FE602341AF94656A45705041	1717	5682	6402	Fallanza	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6402.JPG	\N	1717	2019	30/01/2019	\N	\N	Sempreverde	3	0
1798	0101000020110F000030D80D5BFD6023418D5DA2A644705041	1718	5683	6403	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6403.JPG	\N	1718	2019	30/01/2019	\N	\N	Sempreverde	1	0
1799	0101000020110F0000EB1C0332FB602341A306D3B643705041	1719	5684	6404	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6404.JPG	\N	1719	2019	30/01/2019	\N	\N	Sempreverde	1	0
1800	0101000020110F0000B08F4E3DFA60234181CF0FF342705041	1720	5685	6405	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6405.JPG	\N	1720	2019	30/01/2019	\N	\N	Sempreverde	1	0
1801	0101000020110F000075029A48F96023415F984C2F42705041	1721	5686	6406	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6406.JPG	\N	1721	2019	30/01/2019	\N	\N	Sempreverde	1	0
1802	0101000020110F00003A75E553F86023414C37896B41705041	1722	5687	6407	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	branche con ferite;	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\6407.JPG	\N	1722	2019	30/01/2019	\N	\N	Sempreverde	1	0
1803	0101000020110F0000FFE7305FF76023412A00C6A740705041	1723	5688	6408	Albero	TILIA CORDATA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6408.JPG	\N	1723	2019	30/01/2019	\N	\N	Sempreverde	1	0
1804	0101000020110F0000DF15C16FF9602341A54E406B42705041	1724	5689	6409	Albero	LAGUNARIA PATERSONII	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6409.JPG	\N	1724	2019	30/01/2019	\N	\N	Sempreverde	1	0
1805	0101000020110F00000395F11FFA602341EF8FF73643705041	1725	5690	6410	Albero	LAGUNARIA PATERSONII	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Candela	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\6410.JPG	\N	1725	2019	30/01/2019	\N	\N	Sempreverde	1	0
1806	0101000020110F0000465F41DAC061234179060DFD3D705041	1726	5691	8290	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8290.JPG	\N	1726	2019	30/01/2019	\N	\N	Sempreverde	1	0
1807	0101000020110F0000B8CCE942C361234149D74C103D705041	1727	5692	8291	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8291.JPG	\N	1727	2019	30/01/2019	\N	\N	Sempreverde	1	0
1808	0101000020110F00002176A6A0C9612341990D32AD3C705041	1728	5693	8292	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8292.JPG	\N	1728	2019	30/01/2019	\N	\N	Sempreverde	1	0
1809	0101000020110F0000CE70039ECE612341F224E9783D705041	1729	5694	8293	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica; Edificio;	\N	desktop/Foto\\8293.JPG	\N	1729	2019	30/01/2019	\N	\N	Sempreverde	1	0
1810	0101000020110F0000670A9D77D46123418E23D60A3F705041	1730	5695	8294	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica; Edificio;	\N	desktop/Foto\\8294.JPG	\N	1730	2019	30/01/2019	\N	\N	Sempreverde	1	0
1811	0101000020110F00005513443DBD612341CCD1E31541705041	1731	5696	8295	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Cavi Aerei;	\N	desktop/Foto\\8295.JPG	\N	1731	2019	30/01/2019	\N	\N	Sempreverde	1	0
1812	0101000020110F00008F705A80428723411366DA7E1C655041	1732	358	666	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\666.JPG	\N	1732	2018	25/09/2018	\N	\N	Sempreverde	3	0
1813	0101000020110F0000B07268C1BD6123419CA2232940705041	1733	5697	8296	Albero	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	Tipico	0	\N	2019-01-30	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\8296.JPG	\N	1733	2019	30/01/2019	\N	\N	Sempreverde	1	0
1814	0101000020110F0000B7627FB9CC612341F5DBD7E940705041	1734	5698	8297	Fallanza	LIGUSTRUM JAPONICA	PONTEGRANDE	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Smaldone	Gruppo	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-30	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1734	2019	30/01/2019	\N	\N	Sempreverde	3	0
1815	0101000020110F0000450DA6A13C6623411101878CD76F5041	1735	5699	8298	Albero	PINUS PINEA	PONTEGRANDE	-	Via	-	Via Misasi	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-01-30	5	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con fratture/incrinature; branche secche; monconi;	\N	\N	monconi;	\N	\N	\N	Cartellonistica; Lampione; Cavi Aerei; Edificio;	\N	desktop/Foto\\8298.JPG	\N	1735	2019	30/01/2019	\N	\N	Sempreverde	1	0
1816	0101000020110F0000F168E3083F792341F7E461BB7A6C5041	1736	5700	8601	Albero	PINUS PINEA	CATANZARO	-	Via	-	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-02-06	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1736	2019	06/02/2019	\N	\N	Sempreverde	1	0
1817	0101000020110F0000C93CF2E742792341B79734007B6C5041	1737	5701	8602	Albero	PINUS PINEA	CATANZARO	-	Via	-	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-02-06	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1737	2019	06/02/2019	\N	\N	Sempreverde	1	0
1818	0101000020110F000095826E4FFF792341B9C7D21B8B6E5041	1738	5702	8603	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Discesa Cavour	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-16	1.9	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	ferite;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\8603.JPG	\N	1738	2019	16/01/2019	\N	\N	Sempreverde	1	0
1819	0101000020110F0000D95A5F24AD85234133333329F7655041	1739	5703	8604	Albero	QUERCUS ILEX	FORTUNA	-	Via	-	Via Stretto Antico	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica; Camminamento; Edificio;	\N	\N	\N	1739	2019	07/02/2019	\N	\N	Sempreverde	1	0
1820	0101000020110F0000CF83BB53AD852341F86BB2FCF4655041	1740	5704	8605	Albero	QUERCUS ILEX	FORTUNA	-	Via	-	Via Stretto Antico	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica; Camminamento; Edificio;	\N	\N	\N	1740	2019	07/02/2019	\N	\N	Sempreverde	1	0
1821	0101000020110F000050FC1883AD852341BEA431D0F2655041	1741	5705	8606	Albero	QUERCUS ILEX	FORTUNA	-	Via	-	Via Stretto Antico	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica; Camminamento; Edificio;	\N	\N	\N	1741	2019	07/02/2019	\N	\N	Sempreverde	1	0
1822	0101000020110F0000462575B2AD85234183DDB0A3F0655041	1742	5706	8607	Albero	QUERCUS ILEX	FORTUNA	-	Via	-	Via Stretto Antico	Filare	6	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume localizzato;	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica; Camminamento; Edificio;	\N	\N	\N	1742	2019	07/02/2019	\N	\N	Sempreverde	1	0
1823	0101000020110F00009A9482FE9C9223417C2C7DB82C665041	1743	5707	8611	Albero	OLEA EUROPAEA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Caprera	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con cavit�; branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Sede Stradale; Camminamento;	\N	\N	\N	1743	2019	07/02/2019	\N	\N	Sempreverde	1	0
1824	0101000020110F00002F6EA3719792234122A644862E665041	1744	5708	8612	Albero	OLEA EUROPAEA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Caprera	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1744	2019	07/02/2019	\N	\N	Sempreverde	1	0
1825	0101000020110F0000B16D5196759223419352D08338665041	1745	5709	8613	Albero	EUCALYPTUS CAMALDULENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Caprera	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2019-02-07	0.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Recinzione; Camminamento;	\N	\N	\N	1745	2019	07/02/2019	\N	\N	Sempreverde	1	0
1826	0101000020110F0000BC79AA33EE602341D82AC1C465705041	1746	5710	8616	Palma	PHOENIX CANARIENSIS	GAGLIANO	-	Via	-	Via Scerbo	Isolato	0	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1746	2019	07/02/2019	\N	\N	Sempreverde	1	0
1827	0101000020110F00005743E2CE5D7A2341795DBF0E316E5041	1748	5712	8626	Albero	TILIA CORDATA	CATANZARO	-	Via	-	Via Pistoia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con cavit�;	\N	\N	ferite;	\N	\N	\N	Cavi Aerei; Recinzione; Camminamento; Edificio;	\N	\N	\N	1748	2019	07/02/2019	\N	\N	Sempreverde	1	0
1828	0101000020110F0000FE26148248872341AFCE31981B655041	1749	359	667	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\667.JPG	\N	1749	2018	25/09/2018	\N	\N	Sempreverde	3	0
1829	0101000020110F0000560E2DE25E7A2341D5EC81F0326E5041	1750	5713	8627	Albero	TILIA CORDATA	CATANZARO	-	Via	-	Via Pistoia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con cavit�;	\N	\N	ferite;	\N	\N	\N	Recinzione;	\N	\N	\N	1750	2019	07/02/2019	\N	\N	Sempreverde	1	0
1830	0101000020110F000054573E6B467A2341D218AD37306E5041	1751	5714	8628	Albero	TILIA CORDATA	CATANZARO	-	Via	-	Via Pistoia	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale;	\N	\N	\N	1751	2019	07/02/2019	\N	\N	Sempreverde	1	0
1831	0101000020110F0000991249A49B7A2341695721DB306E5041	1752	5715	8629	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Via	-	Discesa S. Francesco di Paola	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	strozzatura;	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Camminamento; Edificio;	\N	\N	\N	1752	2019	07/02/2019	\N	\N	Sempreverde	1	0
1832	0101000020110F00003E05C028AA7A2341B9AAECC9306E5041	1753	5716	8630	Ceppaia	LIGUSTRUM JAPONICA	CATANZARO	-	Via	-	Discesa S. Francesco di Paola	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Camminamento; Edificio;	\N	\N	\N	1753	2019	07/02/2019	\N	\N	Sempreverde	2	0
1833	0101000020110F00009C16BC48F37A2341C1ADBBE3306E5041	1754	5717	8631	Ceppaia	NERIUM OLEANDER	CATANZARO	-	Via	-	Discesa S. Francesco di Paola	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2020-10-26	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Sede Stradale; Camminamento; Edificio;	\N	\N	\N	1754	2020	26/10/2020	\N	\N	Sempreverde	2	0
1834	0101000020110F00005B99F02B417B2341BDE31473786E5041	1755	5718	8633	Albero	QUERCUS ILEX	CATANZARO	-	Via	-	Via Fiorentino	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Cavi Aerei; Illuminazione pubblica;	\N	\N	\N	1755	2019	15/01/2019	\N	\N	Sempreverde	1	0
1835	0101000020110F0000E17A14CEF07A234146EBA898726E5041	1756	5719	8634	Ceppaia	FICUS SP.	CATANZARO	-	Via	-	Via Eroi 1799	Isolato	0	-	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1756	2019	07/02/2019	\N	\N	-	2	0
1836	0101000020110F000067278303907B2341170E84425E6E5041	1757	5720	8635	Ceppaia	-	CATANZARO	-	Via	-	Vicolo Agricoltori	Isolato	0	-	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1757	2019	07/02/2019	\N	\N	-	2	0
1837	0101000020110F00005E807D34C87B23414694F6145C6E5041	1758	5721	8636	Albero	QUERCUS ILEX	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Vicolo Agricoltori	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-02-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Sede Stradale; Camminamento;	\N	\N	\N	1758	2019	07/02/2019	\N	\N	Sempreverde	1	0
1838	0101000020110F0000EFACDD06C995234164E943A3096E5041	1759	5722	8637	Albero	ROBINIA PSEUDOACACIA	PETRICCIOLO ALLI	-	Via	-	Via Petricciolo All�	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-18	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1759	2019	18/01/2019	\N	\N	Caduca	1	0
1839	0101000020110F00008FC70CD4B695234164E943A3096E5041	1760	5723	8638	Albero	ROBINIA PSEUDOACACIA	PETRICCIOLO ALLI	-	Via	-	Via Petricciolo All�	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-18	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1760	2019	18/01/2019	\N	\N	Caduca	1	0
1840	0101000020110F00008FC70C94AB9523416E348083096E5041	1761	5724	8639	Albero	ROBINIA PSEUDOACACIA	PETRICCIOLO ALLI	-	Via	-	Via Petricciolo All�	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-18	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1761	2019	18/01/2019	\N	\N	Caduca	1	0
1841	0101000020110F0000F5BEF1557295234115C6168E096E5041	1762	5725	8640	Albero	ROBINIA PSEUDOACACIA	PETRICCIOLO ALLI	-	Via	-	Via Petricciolo All�	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-18	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1762	2019	18/01/2019	\N	\N	Caduca	1	0
1842	0101000020110F0000A6D079BD68952341C6A2E978096E5041	1763	5726	8641	Albero	ROBINIA PSEUDOACACIA	PETRICCIOLO ALLI	-	Via	-	Via Petricciolo All�	Filare	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-18	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1763	2019	18/01/2019	\N	\N	Caduca	1	0
1843	0101000020110F0000594C6C5EFD8323416FD8B6E8BE675041	1764	5727	8644	Albero	MELIA AZEDARACH	CORVO	-	Via	-	Via Brigata Catanzaro	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-02-07	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1764	2019	07/02/2019	\N	\N	Caduca	1	0
1844	0101000020110F0000F2EA1C33378423418065A58DC2675041	1765	5728	8645	Albero	MELIA AZEDARACH	CORVO	-	Via	-	Via Brigata Catanzaro	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-02-07	1.8	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1765	2019	07/02/2019	\N	\N	Caduca	1	0
1845	0101000020110F00008907941D4F8723419ED2C1C41A655041	1766	360	668	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\668.JPG	\N	1766	2018	25/09/2018	\N	\N	Sempreverde	3	0
1846	0101000020110F00006FF59CA4F879234130D80DF9796E5041	1767	5729	8648	Palma	TRACHYCARPUS FORTUNEI	PIAZZA CAVOUR	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Cavour	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	\N	\N	1767	2019	07/02/2019	\N	\N	Sempreverde	1	0
1847	0101000020110F0000D89E5902FF7923419B20EA74796E5041	1768	5730	8649	Palma	TRACHYCARPUS FORTUNEI	PIAZZA CAVOUR	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Cavour	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	\N	\N	1768	2019	07/02/2019	\N	\N	Sempreverde	1	0
1848	0101000020110F00006631B199FC792341D122DB3D796E5041	1769	5731	8650	Palma	TRACHYCARPUS FORTUNEI	PIAZZA CAVOUR	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Cavour	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	\N	\N	1769	2019	07/02/2019	\N	\N	Sempreverde	1	0
1849	0101000020110F000076374FA5027B2341CA37DB94456E5041	1770	5732	8660	Albero	CEDRUS ATLANTICA "GLAUCA"	CATANZARO	-	Piazza	-	Piazza Marconi	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-02-07	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	\N	\N	\N	capitozzatura; ginocchiatura;	\N	\N	\N	Manufatto; Camminamento;	\N	\N	\N	1770	2019	07/02/2019	\N	\N	Sempreverde	1	0
1850	0101000020110F0000E4DA50A19F732341ACA8C144AC6F5041	1771	5733	8661	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MONTENERO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Montenero	Filare	3	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1771	2019	15/01/2019	\N	\N	Sempreverde	1	0
1851	0101000020110F0000CAFD0EF5977323415E2EE2EFAC6F5041	1772	5734	8662	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MONTENERO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Montenero	Filare	3	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1772	2019	15/01/2019	\N	\N	Sempreverde	1	0
1852	0101000020110F0000B020CD48907323410FB4029BAD6F5041	1773	5735	8663	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MONTENERO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Montenero	Filare	3	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1773	2019	15/01/2019	\N	\N	Sempreverde	1	0
1853	0101000020110F00007C6132E5707323416D567D44B16F5041	1774	5736	8664	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MONTENERO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Montenero	Filare	3	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Manufatto;	\N	\N	\N	1774	2019	15/01/2019	\N	\N	Sempreverde	1	0
1854	0101000020110F00008ACDC7B56C7323417CED997BB06F5041	1775	5737	8665	Albero	MAGNOLIA GRANDIFLORA	PIAZZA MONTENERO	-	Piazza	II Centro Storico, Stadio, San Leonardo	Piazza Montenero	Filare	3	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-15	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento; Manufatto;	\N	\N	\N	1775	2019	15/01/2019	\N	\N	Sempreverde	1	0
1855	0101000020110F0000FB57566A82782341A5BDC15DC66E5041	1776	5738	8666	Albero	SALIX BABYLONICA	CATANZARO	-	Via	-	Corso Mazzini	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-11-07	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto; Camminamento;	\N	\N	\N	1776	2018	07/11/2018	\N	\N	Caduca	1	0
1856	0101000020110F00001F1153223A73234101DE0265B3745041	1777	5739	8738	Albero	LAGERSTROEMIA INDICA	SANT'ELIA	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Monte Reventino	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-03	1.8	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	1777	2018	03/12/2018	\N	\N	Caduca	1	0
1857	0101000020110F0000D3BCE384437323414B9352DAB0745041	1778	5740	8739	Palma	PHOENIX CANARIENSIS	SANT'ELIA	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Monte Reventino	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-12-03	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Camminamento;	\N	\N	\N	1778	2018	03/12/2018	\N	\N	Sempreverde	1	0
1858	0101000020110F0000A6F276F4417323417EE36B87AD745041	1779	5741	8741	Fallanza	-	SANT'ELIA	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Monte Reventino	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-12-03	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1779	2018	03/12/2018	\N	\N	-	3	0
1859	0101000020110F0000F7E461B143732341952BBC39AC745041	1780	5742	8742	Fallanza	-	SANT'ELIA	-	Piazza	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via Monte Reventino	Filare	3	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-12-03	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1780	2018	03/12/2018	\N	\N	-	3	0
1860	0101000020110F0000882EA87F8A7E23411C7C6140486A5041	1781	5743	8743	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Ranieri	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-10	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Manufatto; Camminamento;	\N	\N	\N	1781	2019	10/01/2019	\N	\N	Sempreverde	1	0
1861	0101000020110F0000882EA83F877E2341B56CAD4B476A5041	1782	5744	8744	Albero	LIGUSTRUM JAPONICA	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Ranieri	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-10	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Manufatto; Camminamento;	\N	\N	\N	1782	2019	10/01/2019	\N	\N	Sempreverde	1	0
1862	0101000020110F00006E6E4C1F558723417E0052F119655041	1783	361	669	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\669.JPG	\N	1783	2018	25/09/2018	\N	\N	Sempreverde	3	0
1863	0101000020110F0000C3BB5CF4917E23413012DAF0476A5041	1784	5745	8745	Albero	ACER SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Ranieri	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-10	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	\N	\N	1784	2019	10/01/2019	\N	\N	-	1	0
1864	0101000020110F00003A4030478F7E2341AB21713F476A5041	1785	5746	8746	Albero	ACER SP.	SANTA MARIA	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via Ranieri	Gruppo	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-10	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	seccume localizzato;	\N	\N	ferite;	\N	\N	\N	Manufatto; Recinzione; Camminamento;	\N	\N	\N	1785	2019	10/01/2019	\N	\N	-	1	0
1865	0101000020110F00003659A32EA5752341527E52ABDD6E5041	1786	5747	8750	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Carlo V	-	0	-	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1786	2019	23/01/2019	\N	\N	-	3	0
1866	0101000020110F0000C47C7951AA75234109168739DC6E5041	1787	5748	8751	Fallanza	-	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Carlo V	-	0	-	0	0	0	-	0	\N	-	0	\N	2019-01-23	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1787	2019	23/01/2019	\N	\N	-	3	0
1867	0101000020110F0000EA95B20CB3752341A7CB62E0DA6E5041	1788	5749	8752	Albero	ROBINIA PSEUDOACACIA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Carlo V	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2019-01-23	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	\N	\N	cavit�; ferite;	\N	\N	\N	Camminamento;	\N	\N	\N	1788	2019	23/01/2019	\N	\N	Caduca	1	0
1868	0101000020110F000009FEB7D2A0762341A4A5F2E2F86E5041	1789	5750	8756	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Via Boerio	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-11-07	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1789	2018	07/11/2018	\N	\N	Sempreverde	2	0
1869	0101000020110F0000C3D32B259B762341B2463DF6F96E5041	1790	5751	8757	Albero	NERIUM OLEANDER	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Via Boerio	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-11-07	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1790	2018	07/11/2018	\N	\N	Sempreverde	1	0
1870	0101000020110F00000E15E3BCA8762341E1EEACB9F96E5041	1791	5752	8758	Albero	NERIUM OLEANDER	CATANZARO	-	Aiuola spartitraffico	II Centro Storico, Stadio, San Leonardo	Via Boerio	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-11-07	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE B	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1791	2018	07/11/2018	\N	\N	Sempreverde	1	0
1871	0101000020110F0000BE9F1AEF2D75234126361FC3AC6F5041	1792	5753	8761	Albero	LIGUSTRUM JAPONICA	CATANZARO	-	Scuola	II Centro Storico, Stadio, San Leonardo	Via Daniele	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-10	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite; strozzatura;	\N	ferite;	\N	\N	\N	\N	\N	\N	\N	1792	2018	10/10/2018	\N	\N	Sempreverde	1	0
1872	0101000020110F0000B0AC34C954752341B1A71DF4AF6F5041	1793	5754	8762	Albero	SCHINUS MOLLE	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Broussard	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-11-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Camminamento; Edificio;	\N	\N	\N	1793	2018	07/11/2018	\N	\N	Sempreverde	1	0
1873	0101000020110F000036936F1676752341FE60E005B06F5041	1794	5755	8763	Albero	SCHINUS MOLLE	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via Broussard	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-11-07	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	Manufatto; Camminamento; Edificio;	\N	\N	\N	1794	2018	07/11/2018	\N	\N	Sempreverde	1	0
1874	0101000020110F00000950539BD2712341B6F814EA546F5041	1795	5756	8770	Albero	NERIUM OLEANDER	CATANZARO	-	Via	-	Via Crispi	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-11-09	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con carie; branche con cavit�; branche con ferite; fumaggine; seccume localizzato;	ferite; strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	\N	\N	1795	2018	09/11/2018	\N	\N	Sempreverde	1	0
1875	0101000020110F00008D9C85CDDC7123411F4B1F84546F5041	1796	5757	8771	Albero	NERIUM OLEANDER	CATANZARO	-	Via	-	Via Crispi	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-11-09	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con carie; branche con cavit�; branche con ferite; fumaggine; seccume localizzato;	ferite; strozzatura;	\N	\N	\N	\N	\N	Camminamento; Edificio;	\N	\N	\N	1796	2018	09/11/2018	\N	\N	Sempreverde	1	0
1876	0101000020110F00008599B6FFE6712341889D291E546F5041	1797	5758	8772	Albero	NERIUM OLEANDER	CATANZARO	-	Via	-	Via Crispi	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-11-09	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con carie; branche con cavit�; branche con ferite; fumaggine; seccume localizzato;	ferite; strozzatura;	\N	\N	\N	\N	\N	Edificio; Camminamento;	\N	\N	\N	1797	2018	09/11/2018	\N	\N	Sempreverde	1	0
1877	0101000020110F0000B74599FD5A772341956071EC276D5041	1798	5759	8777	Albero	PINUS HALEPENSIS	CATANZARO	-	Via	-	Via Gariano	Gruppo	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-11-17	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	Radici superficiali;	\N	\N	Marciapiede; Recinzione;	\N	\N	\N	1798	2018	17/11/2018	\N	\N	Sempreverde	1	0
1878	0101000020110F000098DD93376277234152448639286D5041	1799	5760	8778	Albero	PINUS HALEPENSIS	CATANZARO	-	Via	-	Via Gariano	Gruppo	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-11-17	3	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite; ginocchiatura; inclinazione ingiustificata;	Radici superficiali;	\N	\N	Marciapiede; Recinzione;	\N	\N	\N	1799	2018	17/11/2018	\N	\N	Sempreverde	1	0
1879	0101000020110F0000DD2406215B872341F38E534419655041	1800	362	670	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\670.JPG	\N	1800	2018	25/09/2018	\N	\N	Sempreverde	3	0
1880	0101000020110F0000F207031FBD6723419083123CAD6F5041	1801	5761	8780	Ceppaia	PHOENIX CANARIENSIS	CATANZARO	-	Via	-	Via Misasi	-	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	-	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1801	2019	07/01/2019	\N	\N	Sempreverde	2	0
1881	0101000020110F000074B5156BA2782341BBED4207126F5041	1802	5762	8785	Albero	FICUS CARICA	CATANZARO	-	Via	-	Via Acri	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Manufatto; Camminamento;	\N	\N	\N	1802	2018	06/12/2018	\N	\N	Caduca	1	0
1882	0101000020110F0000936FB6B96F9523418FE4F20FBD665041	1803	5763	8786	Albero	POPULUS SP.	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Dandolo	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-11-14	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche codominanti; branche con carie; branche con cavit�; branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Illuminazione pubblica; Camminamento;	\N	\N	\N	1803	2018	14/11/2018	\N	\N	Caduca	1	0
1883	0101000020110F00004E97C524007723417940D976D56E5041	1804	5764	8787	Albero	MAGNOLIA GRANDIFLORA	CATANZARO	-	Via	II Centro Storico, Stadio, San Leonardo	Via De Grazia	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2019-01-21	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	ferite; monconi;	\N	\N	\N	Camminamento;	\N	\N	\N	1804	2019	21/01/2019	\N	\N	Sempreverde	1	0
1884	0101000020110F0000207BBDBBD87D2341D52137455A705041	1805	5765	8790	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1805	2019	07/01/2019	\N	\N	Sempreverde	1	0
1885	0101000020110F0000B32440BDCA7D2341EA211A9F58705041	1806	5766	8791	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1806	2019	07/01/2019	\N	\N	Sempreverde	1	0
1886	0101000020110F000046CEC2BEBC7D23410EF8FCF856705041	1807	5767	8792	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1807	2019	07/01/2019	\N	\N	Sempreverde	1	0
1887	0101000020110F0000D97745C0AE7D234123F8DF5255705041	1808	5768	8793	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1808	2019	07/01/2019	\N	\N	Sempreverde	1	0
1888	0101000020110F0000E8C1DD99B47D2341D8B6288754705041	1809	5769	8794	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1809	2019	07/01/2019	\N	\N	Sempreverde	1	0
1889	0101000020110F000094BC3AE7C07D23416CEC129955705041	1810	5770	8795	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1810	2019	07/01/2019	\N	\N	Sempreverde	1	0
1890	0101000020110F000041B79734CD7D2341FF21FDAA56705041	1811	5771	8796	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1811	2019	07/01/2019	\N	\N	Sempreverde	1	0
1891	0101000020110F00006362F381D97D23419357E7BC57705041	1812	5772	8797	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1812	2019	07/01/2019	\N	\N	Sempreverde	1	0
1892	0101000020110F0000105D50CFE57D2341268DD1CE58705041	1813	5773	8798	Albero	LIGUSTRUM JAPONICA	SIANO	-	Piazza	III Sala, Siano, Santa Maria, Germaneto	Via dei Gelsomini	Filare	6	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-01-07	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1813	2019	07/01/2019	\N	\N	Sempreverde	1	0
1893	0101000020110F0000EFC9C3B2CD7C23410057B2BBE2705041	1814	5774	8800	Albero	MAGNOLIA GRANDIFLORA	SIANO	-	Aiuola spartitraffico	III Sala, Siano, Santa Maria, Germaneto	Via Galiani	Isolato	0	Aiuola Spartitraffico	0	0	0	-	0	\N	-	0	\N	2018-12-10	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1814	2018	10/12/2018	\N	\N	Sempreverde	1	0
1894	0101000020110F00003F355E1A75732341B1BFEC8C16715041	1815	5775	8801	Albero	QUERCUS ROBUR	PONTEPICCOLO	-	Via	I - Sant'Elia, Pontegrande, Pontepiccolo, Gagliano, MaterDomini, Sant'Antonio	Via della Quercia	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-04	1.5	2) 6m = 12m	4) >100cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite; branche con fratture/incrinature; branche protese; seccume diffuso;	ferite; strozzatura;	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Sede Stradale; Racchiuso in Manufatto; Recinzione;	\N	\N	\N	1815	2018	04/12/2018	\N	\N	Caduca	1	0
1895	0101000020110F00000395F18F46792341DB50316A7B6C5041	1816	5776	8802	Albero	PINUS SP.	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Gruppo	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-11-25	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Manufatto;	\N	\N	\N	1816	2024	25/11/2024	\N	\N	-	1	0
1896	0101000020110F000031B1F98860872341E292E37018655041	1817	363	671	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\671.JPG	\N	1817	2018	25/09/2018	\N	\N	Sempreverde	3	0
1897	0101000020110F0000E7357649AE7923414F064727926C5041	1818	5777	8803	Palma	PHOENIX CANARIENSIS	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1818	2018	05/12/2018	\N	\N	Sempreverde	1	0
1898	0101000020110F00002DEC69F7B879234174469498906C5041	1819	5778	8804	Palma	PHOENIX CANARIENSIS	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1819	2018	05/12/2018	\N	\N	Sempreverde	1	0
1899	0101000020110F0000F9BD4D8FB97923412DEC694B8C6C5041	1820	5779	8805	Ceppaia	PINUS HALEPENSIS	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2024-11-25	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	branche con ferite; branche con fratture/incrinature; seccume localizzato;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	\N	\N	1820	2024	25/11/2024	\N	\N	Sempreverde	2	0
1900	0101000020110F0000E561A1E6E27A234148FE60ECA16C5041	1821	5780	8812	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1821	2018	06/12/2018	\N	\N	Sempreverde	1	0
1901	0101000020110F0000D1967339ED7A2341A4A5F2C8B26C5041	1822	5781	8813	Albero	CALLISTEMON CITRINUS	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede;	\N	\N	\N	1822	2018	06/12/2018	\N	\N	-	1	0
1902	0101000020110F0000F8C264AAF07A234153910A21B36C5041	1823	5782	8814	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1823	2018	06/12/2018	\N	\N	Sempreverde	1	0
1903	0101000020110F0000103B5318E97A23410D37E0D3AE6C5041	1824	5783	8815	Albero	CUPRESSUS SP.	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1824	2018	06/12/2018	\N	\N	-	1	0
1904	0101000020110F00009161155F3C7B234116139B97BC6C5041	1825	5784	8816	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1825	2018	06/12/2018	\N	\N	Sempreverde	1	0
1905	0101000020110F0000A0151862477B2341F0BF9534C06C5041	1826	5785	8817	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1826	2018	06/12/2018	\N	\N	Sempreverde	1	0
1906	0101000020110F00006C787AC5537B23410E10CCADC46C5041	1827	5786	8818	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1827	2018	06/12/2018	\N	\N	Sempreverde	1	0
1909	0101000020110F00007AC212DF767B23412F698CD4CE6C5041	1830	5789	8821	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1830	2018	06/12/2018	\N	\N	Sempreverde	1	0
1910	0101000020110F0000A9DE1A68847B234132207B45D26C5041	1831	5792	8822	Albero	ROBINIA PSEUDOACACIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1831	2018	06/12/2018	\N	\N	Caduca	1	0
1911	0101000020110F0000179F02D08D7B234134D769B6D56C5041	1832	5793	8823	Albero	ROBINIA PSEUDOACACIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1832	2018	06/12/2018	\N	\N	Caduca	1	0
1912	0101000020110F000061E0B987967B2341F3936A69D96C5041	1833	5790	8824	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1833	2018	06/12/2018	\N	\N	Sempreverde	1	0
1913	0101000020110F0000118DEEF0658723415721E5C317655041	1834	364	672	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\672.JPG	\N	1834	2018	25/09/2018	\N	\N	Sempreverde	3	0
1914	0101000020110F000068D0D09FA07B2341CC406506DD6C5041	1835	5795	8825	Albero	POPULUS SP.	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1835	2018	06/12/2018	\N	\N	Caduca	1	0
1915	0101000020110F0000163598E6A57B2341A6ED5FA3E06C5041	1836	5794	8826	Albero	ROBINIA PSEUDOACACIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1836	2018	06/12/2018	\N	\N	Caduca	1	0
1916	0101000020110F0000384A5E2DAB7B23414B766C82E46C5041	1837	5791	8827	Albero	KOELREUTERIA	SALA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fares	Isolato	0	Prato margine strada	0	0	0	-	0	\N	-	0	\N	2018-12-06	1.6	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1837	2018	06/12/2018	\N	\N	Sempreverde	1	0
1917	0101000020110F0000014D849D9A8F23416D90491C74665041	1838	5796	8832	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Milazzo	Isolato	0	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-10-10	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1838	2018	10/10/2018	\N	\N	Sempreverde	1	0
1918	0101000020110F00009D685781998F23419274CD7077665041	1839	5797	8833	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Milazzo	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	\N	strozzatura;	\N	capitozzatura;	\N	\N	\N	Sede Stradale; Marciapiede; Camminamento;	\N	\N	\N	1839	2018	05/12/2018	\N	\N	Sempreverde	1	0
1919	0101000020110F00004A41B7A7978F234137FDD94B78665041	1840	5798	8834	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Milazzo	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	seccume localizzato;	strozzatura;	\N	capitozzatura;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Camminamento;	\N	\N	\N	1840	2018	05/12/2018	\N	\N	Sempreverde	1	0
1920	0101000020110F0000836918CE958F2341DB85E62679665041	1841	5799	8835	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Milazzo	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume localizzato;	strozzatura;	\N	capitozzatura; carpofori;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Camminamento;	\N	\N	\N	1841	2018	05/12/2018	\N	\N	Sempreverde	1	0
1921	0101000020110F0000314278F4938F2341800EF3017A665041	1842	5800	8836	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Milazzo	Filare	2	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-12-05	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume localizzato;	strozzatura;	\N	capitozzatura; carpofori;	\N	\N	\N	Sede Stradale; Marciapiede; Cavi Aerei; Camminamento;	\N	\N	\N	1842	2018	05/12/2018	\N	\N	Sempreverde	1	0
1922	0101000020110F0000C2DD594B738F234170B1A23CBC6D5041	1843	5801	8837	Albero	ROBINIA PSEUDOACACIA	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fiume Tacina	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-08	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	strozzatura;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	Marciapiede; Cavi Aerei; Illuminazione pubblica;	\N	\N	\N	1843	2018	08/10/2018	\N	\N	Caduca	1	0
1923	0101000020110F0000A37554857A8F2341BA6B09DFBB6D5041	1844	5802	8838	Albero	ROBINIA PSEUDOACACIA	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fiume Tacina	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-08	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	strozzatura;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	Marciapiede; Cavi Aerei;	\N	\N	\N	1844	2018	08/10/2018	\N	\N	Caduca	1	0
1924	0101000020110F0000EE258D41A78F23413F7441FDB86D5041	1845	5803	8839	Albero	ROBINIA PSEUDOACACIA	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fiume Tacina	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-08	2.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	strozzatura;	\N	decorticazione; ferite; necrosi corticale;	\N	\N	\N	Marciapiede; Cavi Aerei;	\N	\N	\N	1845	2018	08/10/2018	\N	\N	Caduca	1	0
1925	0101000020110F0000CFBD877BAE8F2341EDB60B37B86D5041	1846	5804	8840	Albero	ROBINIA PSEUDOACACIA	CAVA CUCULERA	-	Via	III Sala, Siano, Santa Maria, Germaneto	Via Fiume Tacina	Isolato	0	Buco nell'asfalto	0	0	0	-	0	\N	-	0	\N	2018-10-08	2.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con carie; branche con ferite; branche con fratture/incrinature;	strozzatura;	\N	cavit�; decorticazione; ferite; necrosi corticale;	\N	\N	\N	Marciapiede; Cavi Aerei; Illuminazione pubblica; Recinzione;	\N	\N	\N	1846	2018	08/10/2018	\N	\N	Caduca	1	0
1926	0101000020110F0000C5E6E3FAA97F23419E0C8EB0D06E5041	1847	5805	8841	Palma	WASHINGTONIA ROBUSTA	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale dei Tulipani	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-15	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1847	2018	15/12/2018	\N	\N	Sempreverde	1	0
1927	0101000020110F00008481E7FE7A8C23417407B15DBD6D5041	1848	5806	8842	Palma	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Isolato	0	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Pessimo	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1848	2018	05/12/2018	\N	\N	Sempreverde	1	0
1928	0101000020110F000021C841D9798C234130478F07C36D5041	1849	5807	8843	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1849	2018	05/12/2018	\N	\N	Sempreverde	1	0
1929	0101000020110F0000BF0E9CB3788C2341569FABE5C56D5041	1850	5808	8844	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1850	2018	05/12/2018	\N	\N	Sempreverde	1	0
1930	0101000020110F00004AEF1BBF6A872341CDAFE61617655041	1851	365	673	Fallanza	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Fiume	Filare	6	Tornello con cordolo	0	0	0	-	0	\N	-	0	\N	2018-09-25	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Marciapiede; Edificio;	\N	desktop/Foto\\673.JPG	\N	1851	2018	25/09/2018	\N	\N	Sempreverde	3	0
1931	0101000020110F00005C55F68D778C234193E34E7BC96D5041	1852	5809	8845	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1852	2018	05/12/2018	\N	\N	Sempreverde	1	0
1932	0101000020110F00000E677ED5758C23412D211FB6CD6D5041	1853	5810	8846	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1853	2018	05/12/2018	\N	\N	Sempreverde	1	0
1933	0101000020110F00005BEB8B247C8C234108AC1C5ED16D5041	1854	5811	8847	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1854	2018	05/12/2018	\N	\N	Sempreverde	1	0
1934	0101000020110F000083177D55898C234106D84773D46D5041	1855	5812	8848	Albero	PHOENIX CANARIENSIS	SIANO	-	Via	III Sala, Siano, Santa Maria, Germaneto	Viale Tulipani	Filare	15	Asola	0	0	0	-	0	\N	-	0	\N	2018-12-05	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	1855	2018	05/12/2018	\N	\N	Sempreverde	1	0
1935	0101000020110F0000B1DCD2EA7C9B23418D9C852177665041	2163	600	1325	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	2	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.5	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata; torsioni;	\N	\N	\N	\N	\N	desktop/Foto\\1325.JPG	\N	2163	2018	27/09/2018	\N	\N	Sempreverde	1	0
1936	0101000020110F0000DC291D3C6D9B23412254A9A56D665041	2164	601	1127	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1127.JPG	\N	2164	2018	27/09/2018	\N	\N	Sempreverde	1	0
1937	0101000020110F0000A94D9C6C969B234119E2581170665041	2165	602	1133	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1133.JPG	\N	2165	2018	27/09/2018	\N	\N	Sempreverde	1	0
1938	0101000020110F0000253B3692969B23418143A8D874665041	2166	603	1330	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1330.JPG	\N	2166	2018	27/09/2018	\N	\N	Sempreverde	1	0
1939	0101000020110F0000B728B3A1989B2341FCE3BD8074665041	2167	604	1331	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1331.JPG	\N	2167	2018	27/09/2018	\N	\N	Sempreverde	1	0
1940	0101000020110F000009FEB782949B23410B98C07574665041	2168	605	1332	Palma	WASHINGTONIA FILIFERA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1332.JPG	\N	2168	2018	27/09/2018	\N	\N	Sempreverde	1	0
1941	0101000020110F00009F02602C319B23414A29E8AC72665041	2169	606	1329	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1329.JPG	\N	2169	2018	27/09/2018	\N	\N	Sempreverde	1	0
1942	0101000020110F000097E2AA22B59B2341240B981A75665041	2170	607	1335	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1335.JPG	\N	2170	2018	27/09/2018	\N	\N	Sempreverde	1	0
1943	0101000020110F0000971C77CA20872341F0A2AFFCFE645041	2171	38	252	Albero	ROBINIA PSEUDOACACIA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\252.JPG	\N	2171	2018	24/09/2018	\N	\N	Caduca	1	0
1944	0101000020110F000002D9EB5DC89B2341FFCF61F675665041	2172	608	1336	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	punteruolo - R. ferrugineus;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1336.JPG	\N	2172	2018	27/09/2018	\N	\N	Sempreverde	1	0
1945	0101000020110F000043041CD2D79B2341E9482EC776665041	2173	609	1337	Ceppaia	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2019-09-27	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1337.JPG	\N	2173	2019	27/09/2019	\N	\N	Sempreverde	2	0
1946	0101000020110F0000EC51B88EE59B2341C30DF8A277665041	2174	610	1338	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1338.JPG	\N	2174	2018	27/09/2018	\N	\N	Sempreverde	1	0
1947	0101000020110F0000903177CDA99B2341A88C7F7D75665041	2175	611	1339	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1339.JPG	\N	2175	2018	27/09/2018	\N	\N	Sempreverde	1	0
1948	0101000020110F00006E179A5BB19B23410E8464EB75665041	2176	612	1340	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1340.JPG	\N	2176	2018	27/09/2018	\N	\N	Sempreverde	1	0
1949	0101000020110F0000C1ADBBE9B89B234164E9436F76665041	2177	613	1341	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1341.JPG	\N	2177	2018	27/09/2018	\N	\N	Sempreverde	1	0
1950	0101000020110F000017653618BF9B2341CAE028DD76665041	2178	614	1342	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\1342.JPG	\N	2178	2018	27/09/2018	\N	\N	Sempreverde	1	0
1951	0101000020110F0000EB8B84F6C59B23415D16133577665041	2179	615	1343	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\1343.JPG	\N	2179	2018	27/09/2018	\N	\N	Sempreverde	1	0
1952	0101000020110F0000C0B2D2D4CC9B2341E275FD8C77665041	2180	616	1344	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\1344.JPG	\N	2180	2018	27/09/2018	\N	\N	Sempreverde	1	0
1953	0101000020110F000094D920B3D39B234138DBDC1078665041	2181	617	1345	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\1345.JPG	\N	2181	2018	27/09/2018	\N	\N	Sempreverde	1	0
1954	0101000020110F0000F12E17F1DB9B2341DBA2CC5278665041	2182	618	1346	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1346.JPG	\N	2182	2018	27/09/2018	\N	\N	Sempreverde	1	0
1955	0101000020110F0000E292E3DEE49B23415070B1C078665041	2183	619	1347	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1347.JPG	\N	2183	2018	27/09/2018	\N	\N	Sempreverde	1	0
1956	0101000020110F000065E42CDCEF9B2341F437A10279665041	2184	620	1348	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\1348.JPG	\N	2184	2018	27/09/2018	\N	\N	Sempreverde	1	0
1957	0101000020110F0000560E2D62189C2341FE26143E7B665041	2185	621	1350	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1350.JPG	\N	2185	2018	27/09/2018	\N	\N	Sempreverde	1	0
1958	0101000020110F0000738577D9FA9B2341499D808679665041	2186	622	1349	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\1349.JPG	\N	2186	2018	27/09/2018	\N	\N	Sempreverde	1	0
1959	0101000020110F00003EB324A0209C234146B6F3C17B665041	2187	623	1351	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1351.JPG	\N	2187	2018	27/09/2018	\N	\N	Sempreverde	1	0
1960	0101000020110F0000B9196EF0348723410FD6FF7301655041	2188	39	255	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\255.JPG	\N	2188	2020	10/09/2020	\N	\N	Caduca	2	0
1961	0101000020110F000042959AED2A9C2341D9EBDD197C665041	2189	624	1352	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1352.JPG	\N	2189	2018	27/09/2018	\N	\N	Sempreverde	1	0
1962	0101000020110F0000A8A965DB339C2341207BBD9D7C665041	2190	625	1353	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1353.JPG	\N	2190	2018	27/09/2018	\N	\N	Sempreverde	1	0
1963	0101000020110F0000868F88693B9C234176E09C217D665041	2191	626	1354	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\1354.JPG	\N	2191	2018	27/09/2018	\N	\N	Sempreverde	1	0
1964	0101000020110F00006475ABF7429C2341ADDD76BB7D665041	2192	627	1355	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\1355.JPG	\N	2192	2018	27/09/2018	\N	\N	Sempreverde	1	0
1985	0101000020110F0000890CABE8D68C234140C1C53EB0655041	2213	647	1382	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\1382.JPG	\N	2213	2018	26/09/2018	\N	\N	Sempreverde	1	0
1965	0101000020110F00000DC347B4509C234187A240977E665041	2193	628	1356	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1356.JPG	\N	2193	2018	27/09/2018	\N	\N	Sempreverde	1	0
1966	0101000020110F0000F5673FF2589C2341B0C91A317F665041	2194	629	1357	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1357.JPG	\N	2194	2018	27/09/2018	\N	\N	Sempreverde	1	0
1967	0101000020110F0000C98E8DD05F9C23412497FF9E7F665041	2195	630	1358	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\1358.JPG	\N	2195	2018	27/09/2018	\N	\N	Sempreverde	1	0
1968	0101000020110F00002FA358BE689C23416C26DF2280665041	2196	631	1359	Ceppaia	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2020-09-10	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/631/thb_141_WhatsApp Image 2020-09-10 at 13.34.53.jpeg	\N	2196	2020	10/09/2020	\N	\N	Sempreverde	2	0
1969	0101000020110F00003485CE0B739C2341FF5BC97A80665041	2197	632	1360	Ceppaia	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola stradale	0	0	0	-	0	\N	-	0	\N	2020-09-08	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/632/thb_142_WhatsApp Image 2020-09-08 at 13.28.49.jpeg	\N	2197	2020	08/09/2020	\N	\N	Sempreverde	2	0
1970	0101000020110F0000910F7AF6178D2341751F805EAD655041	2198	633	776	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\776.JPG	\N	2198	2018	26/09/2018	\N	\N	Sempreverde	1	0
1971	0101000020110F0000AB048B73FF8C23415CC98E41AB655041	2199	634	774	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\774.JPG	\N	2199	2018	26/09/2018	\N	\N	Sempreverde	1	0
1972	0101000020110F00007DB3CD1DE88C2341BADA8A47AE655041	2200	635	1364	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1364.JPG	\N	2200	2018	26/09/2018	\N	\N	Sempreverde	1	0
1973	0101000020110F000062670A9DDA8C2341481B4772AD655041	2201	636	1363	Albero	GREVILLEA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche codominanti;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1363.JPG	\N	2201	2018	26/09/2018	\N	\N	Sempreverde	1	0
1974	0101000020110F000039D1AE52F18C2341E4F736F9AE655041	2202	637	1365	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-02-13	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	3C	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/637/thb_1_1365.jpg	\N	2202	2019	13/02/2019	\N	\N	Caduca	2	0
1975	0101000020110F00003A75E5D3D88C23417F4DD66CAF655041	2203	638	1366	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\1366.JPG	\N	2203	2018	26/09/2018	\N	\N	Caduca	1	0
1976	0101000020110F00003B360231E58C234155F65D1BB0655041	2204	639	1367	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	\N	\N	torsioni;	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\1367.JPG	\N	2204	2018	26/09/2018	\N	\N	Caduca	1	0
1977	0101000020110F000070B6B981058723410551F7D5FC645041	2205	40	246	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\246.JPG	\N	2205	2018	24/09/2018	\N	\N	Sempreverde	1	0
1978	0101000020110F00003F5244A6018D2341B0FECF25B2655041	2206	640	1368	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature;	contrafforti scoperti;	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\1368.JPG	\N	2206	2018	26/09/2018	\N	\N	Caduca	1	0
1979	0101000020110F00008D7F9F71038D234189247A2FB4655041	2207	641	1369	Ceppaia	ROBINIA PSEUDOACACIA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	-	0	\N	2019-04-15	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	Edificio;	\N	photos/Albero/641/63_WhatsApp Image 2019-04-15 at 16.48.22 (4).jpeg	\N	2207	2019	15/04/2019	\N	\N	Caduca	2	0
1980	0101000020110F0000249C16EC4A8D2341028239D4B8655041	2208	642	1370	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2.5	2) 6m = 12m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Manufatto; Edificio;	\N	desktop/Foto\\1370.JPG	\N	2208	2018	26/09/2018	\N	\N	Caduca	1	0
1981	0101000020110F00002AE3DF876D8D2341DCF46719BB655041	2209	643	1371	Albero	PLATANUS ACERIFOLIA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	1.5	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C/D	\N	branche codominanti; branche con ferite;	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\1371.JPG	\N	2209	2018	26/09/2018	\N	\N	Caduca	1	0
1982	0101000020110F00001878EECD438D234194DE37A8B8655041	2210	644	1373	Albero	ARAUCARIA HETEROPHYLLA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1373.JPG	\N	2210	2018	26/09/2018	\N	\N	Sempreverde	1	0
1983	0101000020110F000026DF6CB3078D2341E0844226B1655041	2211	645	1379	Albero	FICUS ELASTICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Buono	CLASSE B	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1379.JPG	\N	2211	2018	26/09/2018	\N	\N	Sempreverde	1	0
1984	0101000020110F0000C9B08A47E98C2341BF7D1D04B2655041	2212	646	1380	Ceppaia	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\1380.JPG	\N	2212	2018	26/09/2018	\N	\N	Sempreverde	2	0
1986	0101000020110F0000FE43FAEDD28C23412FA86FBFAF655041	2214	648	1383	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	seccume localizzato;	\N	\N	\N	\N	\N	\N	Edificio;	\N	desktop/Foto\\1383.JPG	\N	2214	2018	26/09/2018	\N	\N	Sempreverde	1	0
1987	0101000020110F0000B77A4E8A1C8923411B8178EF49655041	2215	649	676	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\676.JPG	\N	2215	2018	26/09/2018	\N	\N	Sempreverde	1	0
1988	0101000020110F00008E06F06649892341C8D287C64D655041	2216	650	677	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\677.JPG	\N	2216	2018	26/09/2018	\N	\N	Sempreverde	1	0
1989	0101000020110F0000C72E517DC48A234125CCB4AF74655041	2217	651	694	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	2) 6m = 12m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\694.JPG	\N	2217	2018	26/09/2018	\N	\N	Sempreverde	1	0
1990	0101000020110F000057B26323C98A2341C7116B2975655041	2218	652	695	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\695.JPG	\N	2218	2018	26/09/2018	\N	\N	Sempreverde	1	0
1991	0101000020110F0000EE08A735CE8A234139622DBE75655041	2219	653	696	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	3	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\696.JPG	\N	2219	2018	26/09/2018	\N	\N	Sempreverde	1	0
1992	0101000020110F0000855FEA47D38A23419CDCEF5276655041	2220	654	697	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\697.JPG	\N	2220	2018	26/09/2018	\N	\N	Sempreverde	3	0
1993	0101000020110F0000A4DFBE9ED98A2341DD0720BF76655041	2221	655	698	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\698.JPG	\N	2221	2018	26/09/2018	\N	\N	Sempreverde	1	0
1994	0101000020110F00009CE1064C1687234108556A32FF645041	2222	41	256	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\256.JPG	\N	2222	2018	24/09/2018	\N	\N	Sempreverde	1	0
1995	0101000020110F0000BD8C6289DF8A23417077D63877655041	2223	656	699	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\699.JPG	\N	2223	2018	26/09/2018	\N	\N	Sempreverde	3	0
1996	0101000020110F0000D6390674E58A234112BD8CB277655041	2224	657	700	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\700.JPG	\N	2224	2018	26/09/2018	\N	\N	Sempreverde	1	0
1997	0101000020110F000073637AF2EA8A2341E527D55478655041	2225	658	701	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\701.JPG	\N	2225	2018	26/09/2018	\N	\N	Sempreverde	3	0
1998	0101000020110F0000153AAF21F28A2341889D291279655041	2226	659	702	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\702.JPG	\N	2226	2018	26/09/2018	\N	\N	Sempreverde	3	0
1999	0101000020110F0000A96A8278F88A23412B137ECF79655041	2227	660	703	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\703.JPG	\N	2227	2018	26/09/2018	\N	\N	Sempreverde	1	0
2000	0101000020110F00004A41B7A7FF8A23415F984C7F7A655041	2228	661	704	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\704.JPG	\N	2228	2018	26/09/2018	\N	\N	Sempreverde	3	0
2001	0101000020110F000063EE5A92058B234101DE02F97A655041	2229	662	705	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\705.JPG	\N	2229	2018	26/09/2018	\N	\N	Sempreverde	3	0
2002	0101000020110F00000118CF100B8B2341732EC58D7B655041	2230	663	706	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; insetti lignivori; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\706.JPG	\N	2230	2018	26/09/2018	\N	\N	Sempreverde	1	0
2003	0101000020110F00002098A367118B234116A4194B7C655041	2231	664	707	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\707.JPG	\N	2231	2018	26/09/2018	\N	\N	Sempreverde	3	0
2004	0101000020110F0000BB9BA72A188B23414A29E8FA7C655041	2232	665	708	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\708.JPG	\N	2232	2018	26/09/2018	\N	\N	Sempreverde	3	0
2005	0101000020110F0000DA1B7C811E8B23414C8924827D655041	2233	666	709	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\709.JPG	\N	2233	2018	26/09/2018	\N	\N	Sempreverde	3	0
2006	0101000020110F0000F0A2AFB0258B23415FEFFE4C7E655041	2234	667	710	Fallanza	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	-	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\710.JPG	\N	2234	2018	26/09/2018	\N	\N	Sempreverde	3	0
2007	0101000020110F0000984C154C2D8B2341C4995F257F655041	2235	668	711	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\711.JPG	\N	2235	2018	26/09/2018	\N	\N	Sempreverde	1	0
2008	0101000020110F0000417DCBDC378B2341D72FD83380655041	2236	669	712	Albero	LAGUNARIA PATERSONII	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Asola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\712.JPG	\N	2236	2018	26/09/2018	\N	\N	Sempreverde	1	0
2009	0101000020110F00008A592FF63590234155302A2DF7655041	2237	670	914	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\914.JPG	\N	2237	2018	26/09/2018	\N	\N	Sempreverde	1	0
2010	0101000020110F0000B3EA7315AA8C23418E06F0E6A0655041	1934	385	744	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\744.JPG	\N	1934	2018	26/09/2018	\N	\N	Caduca	1	0
2011	0101000020110F0000C6C4E693AF8C234161713889A1655041	1935	386	745	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\745.JPG	\N	1935	2018	26/09/2018	\N	\N	Sempreverde	1	0
2012	0101000020110F0000DE718A7EB58C2341F4E0EE02A2655041	1936	387	746	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\746.JPG	\N	1936	2018	26/09/2018	\N	\N	Sempreverde	1	0
2013	0101000020110F0000FEF15ED5BB8C23416631B197A2655041	1937	388	747	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\747.JPG	\N	1937	2018	26/09/2018	\N	\N	Sempreverde	1	0
2014	0101000020110F000099F56298C28C23419AB67F47A3655041	1938	389	748	Ceppaia	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-10	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/389/thb_137_WhatsApp Image 2020-09-10 at 13.35.10.jpeg	\N	1938	2020	10/09/2020	\N	\N	Sempreverde	2	0
2015	0101000020110F0000CF66D587948C234145BB0AE59E655041	1939	390	739	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\739.JPG	\N	1939	2018	26/09/2018	\N	\N	Sempreverde	1	0
2016	0101000020110F000012143FE6A28C2341EB909B29A0655041	1940	391	743	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\743.JPG	\N	1940	2018	26/09/2018	\N	\N	Caduca	1	0
2017	0101000020110F00006A6AD94A9B8C2341A375546B9E655041	1941	392	752	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	branche codominanti; branche con carie; branche con ferite; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\752.JPG	\N	1941	2018	26/09/2018	\N	\N	Caduca	1	0
2018	0101000020110F000039EE949EAC8C23417BA0151CA0655041	1942	393	753	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\753.JPG	\N	1942	2018	26/09/2018	\N	\N	Caduca	1	0
2019	0101000020110F000060C8EA56B68C2341EF2076F4A0655041	1943	394	754	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Cattivo	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\754.JPG	\N	1943	2018	26/09/2018	\N	\N	Caduca	1	0
2020	0101000020110F0000919BE136BF8C234162A1D6CCA1655041	1944	395	755	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\755.JPG	\N	1944	2018	26/09/2018	\N	\N	Caduca	1	0
2021	0101000020110F00002C9FE5F9C58C2341350C1F6FA2655041	1945	396	756	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	lesioni aperte;	\N	\N	\N	\N	\N	desktop/Foto\\756.JPG	\N	1945	2018	26/09/2018	\N	\N	Caduca	1	0
2022	0101000020110F000072F90F09D68C23410D37E01FA4655041	1946	397	757	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	lesioni aperte;	\N	\N	\N	\N	\N	desktop/Foto\\757.JPG	\N	1946	2018	26/09/2018	\N	\N	Caduca	1	0
2023	0101000020110F000037FDD93FE58C23415682C521A6655041	1947	398	759	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	lesioni aperte;	\N	\N	\N	\N	\N	desktop/Foto\\759.JPG	\N	1947	2018	26/09/2018	\N	\N	Caduca	1	0
2024	0101000020110F000014D04438DD8C234150C24C13A5655041	1948	399	758	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\758.JPG	\N	1948	2018	26/09/2018	\N	\N	Caduca	1	0
2025	0101000020110F0000F5BEF1D5FF862341475513DAFB645041	1949	25	236	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	1	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\236.JPG	\N	1949	2018	24/09/2018	\N	\N	Sempreverde	1	0
2026	0101000020110F0000D8D30E6FEC8C2341FA27B822A7655041	1950	400	760	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\760.JPG	\N	1950	2018	26/09/2018	\N	\N	Caduca	1	0
2027	0101000020110F0000DAE6C6A4968C2341A01518E49D655041	1951	401	750	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\750.JPG	\N	1951	2018	26/09/2018	\N	\N	Sempreverde	1	0
2028	0101000020110F0000D122DBD9CE8C23410F971CA7A4655041	1952	402	765	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	Cartellonistica; Illuminazione pubblica;	\N	desktop/Foto\\765.JPG	\N	1952	2018	26/09/2018	\N	\N	Sempreverde	1	0
2029	0101000020110F00001E503655DF8C234127BD6F80A6655041	1953	403	767	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\767.JPG	\N	1953	2018	26/09/2018	\N	\N	Sempreverde	1	0
2030	0101000020110F0000452A8C0DE98C2341FD87F4A9A7655041	1954	404	768	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\768.JPG	\N	1954	2018	26/09/2018	\N	\N	Sempreverde	1	0
2031	0101000020110F00005A2A6F47ED8C23413FE3C259A8655041	1955	405	769	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\769.JPG	\N	1955	2018	26/09/2018	\N	\N	Sempreverde	1	0
2032	0101000020110F000079CC4075D68C234183177D7FA5655041	1956	406	766	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\766.JPG	\N	1956	2018	26/09/2018	\N	\N	Sempreverde	1	0
2033	0101000020110F00009357E788F98C2341183E224EAA655041	1957	407	773	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\773.JPG	\N	1957	2018	26/09/2018	\N	\N	Sempreverde	1	0
2034	0101000020110F00006F2A5281F18C234173689109A9655041	1958	408	770	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\770.JPG	\N	1958	2018	26/09/2018	\N	\N	Sempreverde	1	0
2035	0101000020110F0000B43C0FFE1F8D2341A774B0CAAD655041	1959	409	777	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\777.JPG	\N	1959	2018	26/09/2018	\N	\N	Sempreverde	1	0
2036	0101000020110F0000DA8F14C1268D234179AF5A29AE655041	1960	410	778	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\778.JPG	\N	1960	2018	26/09/2018	\N	\N	Sempreverde	1	0
2037	0101000020110F00000A2E5644F88C23414013619DA8655041	1961	411	761	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\761.JPG	\N	1961	2018	26/09/2018	\N	\N	Caduca	1	0
2038	0101000020110F0000F25EB5820F8D23415DF92C85AB655041	1962	412	782	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	6	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Cattivo	CLASSE C/D	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\782.JPG	\N	1962	2018	26/09/2018	\N	\N	Caduca	1	0
2039	0101000020110F0000B4C8763EC78C2341DAE1AFB3A3655041	1963	413	749	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\749.JPG	\N	1963	2018	26/09/2018	\N	\N	Sempreverde	1	0
2040	0101000020110F0000FB96390D308D2341488AC800AE655041	1964	414	783	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\783.JPG	\N	1964	2018	26/09/2018	\N	\N	Sempreverde	1	0
2041	0101000020110F00001EC4CE14388D2341AB048B95AE655041	1965	415	784	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\784.JPG	\N	1965	2018	26/09/2018	\N	\N	Sempreverde	1	0
2042	0101000020110F00003ED00AAC078723410BEF729DFD645041	1966	26	237	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\237.JPG	\N	1966	2018	24/09/2018	\N	\N	Sempreverde	1	0
2043	0101000020110F0000D847A72E458D234191D5AD02B0655041	1967	416	785	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\785.JPG	\N	1967	2018	26/09/2018	\N	\N	Sempreverde	1	0
2044	0101000020110F000021C841F9538D234197C5C454B1655041	1968	417	788	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\788.JPG	\N	1968	2018	26/09/2018	\N	\N	Sempreverde	1	0
2045	0101000020110F000034A2B477598D2341DA209304B2655041	1969	418	789	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\789.JPG	\N	1969	2018	26/09/2018	\N	\N	Sempreverde	1	0
2046	0101000020110F0000D1CB28F65E8D2341DC80CF8BB2655041	1970	419	790	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\790.JPG	\N	1970	2018	26/09/2018	\N	\N	Sempreverde	1	0
2047	0101000020110F0000BF9A03443F8D23412315C638B0655041	1971	420	779	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\779.JPG	\N	1971	2018	26/09/2018	\N	\N	Sempreverde	1	0
2048	0101000020110F00006CCF2CB9658D234110069E3BB3655041	1972	421	791	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\791.JPG	\N	1972	2018	26/09/2018	\N	\N	Caduca	1	0
2049	0101000020110F000031D3F6EF748D2341B70BCDC3B4655041	1973	422	793	Ceppaia	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-09-26	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\793.JPG	\N	1973	2018	26/09/2018	\N	\N	Caduca	2	0
2050	0101000020110F0000C1560996798D2341C971A78EB5655041	1974	423	794	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	ferite;	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\794.JPG	\N	1974	2018	26/09/2018	\N	\N	Caduca	1	0
2051	0101000020110F0000115322996E8D2341226C7806B4655041	1975	424	792	Ceppaia	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-10	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	photos/Albero/424/thb_138_WhatsApp Image 2020-09-10 at 13.35.09.jpeg	\N	1975	2020	10/09/2020	\N	\N	Sempreverde	2	0
2052	0101000020110F0000D656ECCF7D8D2341FDF6753EB6655041	1976	425	795	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\795.JPG	\N	1976	2018	26/09/2018	\N	\N	Sempreverde	1	0
2053	0101000020110F0000D9B11198098D234130647527AC655041	1977	426	775	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\775.JPG	\N	1977	2018	26/09/2018	\N	\N	Sempreverde	1	0
2054	0101000020110F00003B53E80C778D2341FDF6753EB6655041	1978	427	797	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\797.JPG	\N	1978	2018	26/09/2018	\N	\N	Sempreverde	1	0
2055	0101000020110F00000057B243868D2341B8921DD5B8655041	1979	428	798	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\798.JPG	\N	1979	2018	26/09/2018	\N	\N	Sempreverde	1	0
2056	0101000020110F0000A98768D4908D2341BF823427BA655041	1980	429	799	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\799.JPG	\N	1980	2018	26/09/2018	\N	\N	Sempreverde	1	0
2057	0101000020110F00005F5E803D9C8D2341D4484B79BB655041	1981	430	800	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\800.JPG	\N	1981	2018	26/09/2018	\N	\N	Sempreverde	1	0
2058	0101000020110F0000780B2428A28D2341758E01F3BB655041	1982	431	801	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\801.JPG	\N	1982	2018	26/09/2018	\N	\N	Sempreverde	1	0
2059	0101000020110F00005ED72FA805872341A8C64B6BFD645041	1983	27	238	Ceppaia	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-09-24	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\238.JPG	\N	1983	2018	24/09/2018	\N	\N	Sempreverde	2	0
2060	0101000020110F00001D2098D3B38D2341CA32C451BD655041	1984	432	806	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	carpofori;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\806.JPG	\N	1984	2018	26/09/2018	\N	\N	Sempreverde	1	0
2061	0101000020110F00006DAD2F62C98D2341F91400F7BC655041	1985	433	811	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\811.JPG	\N	1985	2018	26/09/2018	\N	\N	Sempreverde	1	0
2062	0101000020110F0000863DED80CC8D23415019FF6CBD655041	1986	434	812	Ceppaia	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	-	0	\N	2019-11-13	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\812.JPG	\N	1986	2019	13/11/2019	\N	\N	Sempreverde	2	0
2063	0101000020110F0000518880E3BE8D2341D9B111ECBD655041	1987	435	807	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\807.JPG	\N	1987	2018	26/09/2018	\N	\N	Sempreverde	1	0
2064	0101000020110F00007FDE5464EF8D23410118CF80C1655041	1988	436	814	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\814.JPG	\N	1988	2018	26/09/2018	\N	\N	Sempreverde	1	0
2065	0101000020110F00007DAEB6C21E8E2341AFB14BBEC7655041	1989	437	817	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\817.JPG	\N	1989	2018	26/09/2018	\N	\N	Caduca	1	0
2066	0101000020110F0000F5D6C036F48D2341E6CB0BB0C0655041	1990	438	818	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	ferite;	\N	\N	\N	\N	\N	desktop/Foto\\818.JPG	\N	1990	2018	26/09/2018	\N	\N	Caduca	1	0
2067	0101000020110F000028F224B9FC8D23416440F692C1655041	1991	439	819	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\819.JPG	\N	1991	2018	26/09/2018	\N	\N	Caduca	1	0
2068	0101000020110F00002F6EA3C10B8E234139B9DFEBC2655041	1992	440	820	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\820.JPG	\N	1992	2018	26/09/2018	\N	\N	Caduca	1	0
2069	0101000020110F000003B2D75BE08D234134113660BF655041	1993	441	813	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	fillossera; fumaggine; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\813.JPG	\N	1993	2018	26/09/2018	\N	\N	Sempreverde	1	0
2070	0101000020110F000019C5724B108E2341E40F0674C3655041	1994	442	821	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	fillossera; fumaggine; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\821.JPG	\N	1994	2018	26/09/2018	\N	\N	Sempreverde	1	0
2071	0101000020110F0000BEF6CCB2138E23419F3C2CFCC3655041	1995	443	822	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	fillossera; fumaggine; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\822.JPG	\N	1995	2018	26/09/2018	\N	\N	Sempreverde	1	0
2072	0101000020110F0000910A63AB178E2341E94317A4C4655041	1996	444	823	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con carpofori; seccume diffuso;	\N	\N	ferite; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\823.JPG	\N	1996	2018	26/09/2018	\N	\N	Sempreverde	1	0
2073	0101000020110F00001878EE2D1C8E23419AB16834C5655041	1997	445	824	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Mediocre	CLASSE C	\N	insetti lignivori; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\824.JPG	\N	1997	2018	26/09/2018	\N	\N	Sempreverde	1	0
2074	0101000020110F0000DF6C73F3258E2341C87BD5F4C5655041	1998	446	826	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\826.JPG	\N	1998	2018	26/09/2018	\N	\N	Sempreverde	1	0
2075	0101000020110F000070B1A2962B8E234179E92685C6655041	1999	447	827	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE B	\N	fillossera; seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\827.JPG	\N	1999	2018	26/09/2018	\N	\N	Sempreverde	1	0
2076	0101000020110F0000BC7493480087234146425B94FC645041	2000	28	239	Ceppaia	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	3	Aiuola	0	0	0	-	0	\N	-	0	\N	2018-09-24	0	-	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\239.JPG	\N	2000	2018	24/09/2018	\N	\N	Sempreverde	2	0
2077	0101000020110F0000DFE00B33F68D234172BF432DC2655041	2001	448	815	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\815.JPG	\N	2001	2018	26/09/2018	\N	\N	Sempreverde	1	0
2078	0101000020110F000078978BF82E8E23414DBED986C9655041	2002	449	830	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\830.JPG	\N	2002	2018	26/09/2018	\N	\N	Sempreverde	1	0
2079	0101000020110F0000B81E853B348E23415474240BCA655041	2003	450	831	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\831.JPG	\N	2003	2018	26/09/2018	\N	\N	Sempreverde	1	0
2080	0101000020110F0000DE02099A318E2341FAB83666C8655041	2004	451	829	Albero	CERATONIA SILIQUA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Morto in piedi	-	CLASSE D	4	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\829.JPG	\N	2004	2018	26/09/2018	\N	\N	-	1	0
2081	0101000020110F00002E56D4A03D8E23413D0FEEAAC9655041	2005	452	834	Albero	CERATONIA SILIQUA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\834.JPG	\N	2005	2018	26/09/2018	\N	\N	-	1	0
2082	0101000020110F0000C8EA56FF3A8E23415A2A6F8FCA655041	2006	453	832	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\832.JPG	\N	2006	2018	26/09/2018	\N	\N	Sempreverde	1	0
2083	0101000020110F00000DFD138C518E2341D6AD9EE3CA655041	2007	454	837	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\837.JPG	\N	2007	2018	26/09/2018	\N	\N	Sempreverde	1	0
2084	0101000020110F000015E3FCED548E23415A2A6F8FCA655041	2008	455	838	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\838.JPG	\N	2008	2018	26/09/2018	\N	\N	Sempreverde	1	0
2085	0101000020110F00004E284450208E23410E15E30CC6655041	2009	456	825	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\825.JPG	\N	2009	2018	26/09/2018	\N	\N	Sempreverde	1	0
2086	0101000020110F0000B2BAD5936F8E2341492EFF8DCC655041	2010	457	841	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\841.JPG	\N	2010	2018	26/09/2018	\N	\N	Sempreverde	1	0
2087	0101000020110F0000A1849926768E23412A914433CD655041	2011	458	842	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\842.JPG	\N	2011	2018	26/09/2018	\N	\N	Sempreverde	1	0
2088	0101000020110F0000908829417C8E23410AF489D8CD655041	2012	459	843	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\843.JPG	\N	2012	2018	26/09/2018	\N	\N	Sempreverde	1	0
2089	0101000020110F0000202922F3808E23417F6ABC50CE655041	2013	460	844	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	carpofori; lesione aperta;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\844.JPG	\N	2013	2018	26/09/2018	\N	\N	Sempreverde	1	0
2090	0101000020110F0000B0C91AA5858E2341C22FF5D7CE655041	2014	461	845	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\845.JPG	\N	2014	2018	26/09/2018	\N	\N	Sempreverde	1	0
2091	0101000020110F0000B5A679478B8E234129D02750CF655041	2015	462	846	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	ginocchiatura;	\N	\N	\N	\N	\N	desktop/Foto\\846.JPG	\N	2015	2018	26/09/2018	\N	\N	Sempreverde	1	0
2092	0101000020110F0000BABDA471908E23416C9560D7CF655041	2016	463	847	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\847.JPG	\N	2016	2018	26/09/2018	\N	\N	Sempreverde	1	0
2093	0101000020110F0000C38190ECED862341D97C5C33FA645041	2017	29	240	Palma	PHOENIX CANARIENSIS	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	3) 50cm=100cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Mediocre	Mediocre	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\240.JPG	\N	2017	2018	24/09/2018	\N	\N	Sempreverde	1	0
2094	0101000020110F00007C9BFE6C988E2341B8E4B8A9D0655041	2018	464	848	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\848.JPG	\N	2018	2018	26/09/2018	\N	\N	Sempreverde	1	0
2095	0101000020110F0000E0DBF4779F8E23416896045ED1655041	2019	465	849	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	\N	\N	\N	\N	Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\849.JPG	\N	2019	2018	26/09/2018	\N	\N	Sempreverde	1	0
2096	0101000020110F00000C0742D26B8E2341016A6A8DCD655041	2020	466	852	Ceppaia	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	-	0	\N	2020-09-10	0	-	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\852.JPG	\N	2020	2020	10/09/2020	\N	\N	Caduca	2	0
2097	0101000020110F0000312592D87A8E23412E1C0805CF655041	2021	467	854	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\854.JPG	\N	2021	2018	26/09/2018	\N	\N	Caduca	1	0
2098	0101000020110F0000FAD51CB0588E234161E0B913CB655041	2022	468	839	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\839.JPG	\N	2022	2018	26/09/2018	\N	\N	Sempreverde	1	0
2099	0101000020110F0000CEA5B89A958E2341158C4AA0D1655041	2023	469	858	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\858.JPG	\N	2023	2018	26/09/2018	\N	\N	Sempreverde	1	0
2100	0101000020110F000060C8EAF69C8E2341DC291D7CD2655041	2024	470	859	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\859.JPG	\N	2024	2018	26/09/2018	\N	\N	Sempreverde	1	0
2101	0101000020110F000069006F61A18E23414434BAF9D2655041	2025	471	860	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\860.JPG	\N	2025	2018	26/09/2018	\N	\N	Sempreverde	1	0
2102	0101000020110F0000D50968C2A78E23412098A367D3655041	2026	472	861	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\861.JPG	\N	2026	2018	26/09/2018	\N	\N	Sempreverde	1	0
2103	0101000020110F0000AC8BDBB8A98E2341AD4CF891D4655041	2027	473	862	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\862.JPG	\N	2027	2018	26/09/2018	\N	\N	Sempreverde	1	0
2104	0101000020110F0000A1B94E73A78E234108725012D2655041	2028	474	850	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Illuminazione pubblica; Camminamento;	\N	desktop/Foto\\850.JPG	\N	2028	2018	26/09/2018	\N	\N	Sempreverde	1	0
2105	0101000020110F00001366DACEC88E2341E319340CD7655041	2029	475	871	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\871.JPG	\N	2029	2018	26/09/2018	\N	\N	Sempreverde	1	0
2106	0101000020110F0000FB3F8769F38E2341022B87FCD9655041	2030	476	874	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\874.JPG	\N	2030	2018	26/09/2018	\N	\N	Sempreverde	1	0
2107	0101000020110F0000ABCFD526FC8E2341D34D6274DA655041	2031	477	875	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	10	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	branche con ferite;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\875.JPG	\N	2031	2018	26/09/2018	\N	\N	Sempreverde	1	0
2108	0101000020110F00004E0B5E64E38E234162D68B13D9655041	2032	478	873	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\873.JPG	\N	2032	2018	26/09/2018	\N	\N	Sempreverde	1	0
2109	0101000020110F000060764FBE3A8F2341459E24FFDF655041	2033	479	878	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Mediocre	CLASSE C	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\878.JPG	\N	2033	2018	26/09/2018	\N	\N	Caduca	1	0
2110	0101000020110F0000C1CAA125DF862341B3EF8AAEF7645041	2034	30	229	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\229.JPG	\N	2034	2018	24/09/2018	\N	\N	Sempreverde	1	0
2111	0101000020110F000046EBA89A238F234191274903DE655041	2035	480	877	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\877.JPG	\N	2035	2018	26/09/2018	\N	\N	Sempreverde	1	0
2112	0101000020110F00001AC05B20118F23412788BA93DC655041	2036	481	876	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	10	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Mediocre	CLASSE C	\N	branche con ferite; fillossera; fumaggine;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\876.JPG	\N	2036	2018	26/09/2018	\N	\N	Sempreverde	1	0
2113	0101000020110F000027A5A00B588F2341F7E461E5E2655041	2037	482	881	Albero	QUERCUS ILEX	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	5	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	fillossera; fumaggine; seccume diffuso;	ferite;	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\881.JPG	\N	2037	2018	26/09/2018	\N	\N	Sempreverde	1	0
2114	0101000020110F00008542040C538F23414A07EB71E2655041	2038	483	880	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	carpofori; inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\880.JPG	\N	2038	2018	26/09/2018	\N	\N	Sempreverde	1	0
2115	0101000020110F000054C6BF6F5C8F234197C5C44EE3655041	2039	484	882	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\882.JPG	\N	2039	2018	26/09/2018	\N	\N	Sempreverde	1	0
2116	0101000020110F0000016A6A79628F234129D027B8E3655041	2040	485	883	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	ferite;	\N	\N	\N	Camminamento;	\N	desktop/Foto\\883.JPG	\N	2040	2018	26/09/2018	\N	\N	Sempreverde	1	0
2117	0101000020110F00000B410E6A678F2341FE43FA0FE4655041	2041	486	884	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\884.JPG	\N	2041	2018	26/09/2018	\N	\N	Sempreverde	1	0
2118	0101000020110F0000B8E4B8736D8F23416891ED8AE4655041	2042	487	885	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; branche con fratture/incrinature; seccume diffuso;	\N	\N	\N	\N	\N	\N	Illuminazione pubblica;	\N	desktop/Foto\\885.JPG	\N	2042	2018	26/09/2018	\N	\N	Sempreverde	1	0
2119	0101000020110F00001422E0F0728F2341809F7117E5655041	2043	488	886	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\886.JPG	\N	2043	2018	26/09/2018	\N	\N	Sempreverde	1	0
2120	0101000020110F00009E7B0F87798F2341A583F5A3E5655041	2044	489	887	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Mediocre	CLASSE C	\N	seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\887.JPG	\N	2044	2018	26/09/2018	\N	\N	Sempreverde	1	0
2121	0101000020110F00004B1FBA907F8F23410FD1E81EE6655041	2045	490	888	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	lesioni aperte;	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\888.JPG	\N	2045	2018	26/09/2018	\N	\N	Sempreverde	1	0
2122	0101000020110F0000DE54A4628E8F23412237C38FE7655041	2046	491	890	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	Manufatto;	\N	desktop/Foto\\890.JPG	\N	2046	2018	26/09/2018	\N	\N	Sempreverde	1	0
2123	0101000020110F000026DF6CB3868F234126DF6CABE6655041	2047	492	889	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\889.JPG	\N	2047	2018	26/09/2018	\N	\N	Sempreverde	1	0
2124	0101000020110F00008AB0E159A48F23413D44A393E9655041	2048	493	895	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\895.JPG	\N	2048	2018	26/09/2018	\N	\N	Sempreverde	1	0
2125	0101000020110F0000F52D731AAF8F234133F96689EA655041	2049	494	896	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\896.JPG	\N	2049	2018	26/09/2018	\N	\N	Caduca	1	0
2126	0101000020110F0000A27F820BB38E2341B7D100CCD5655041	2050	495	864	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\864.JPG	\N	2050	2018	26/09/2018	\N	\N	Sempreverde	1	0
2127	0101000020110F000087BF260BEF862341BB0A29ADFA645041	2051	31	242	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\242.JPG	\N	2051	2018	24/09/2018	\N	\N	Sempreverde	1	0
2128	0101000020110F0000B1A206A3D28F23413C889D91EE655041	2052	496	901	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\901.JPG	\N	2052	2018	26/09/2018	\N	\N	Sempreverde	1	0
2129	0101000020110F000010AFEBC7D88F23418481E72EEF655041	2053	497	902	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\902.JPG	\N	2053	2018	26/09/2018	\N	\N	Sempreverde	1	0
2130	0101000020110F0000D3BCE364EA8F2341BC79AAF9F0655041	2054	498	904	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\904.JPG	\N	2054	2018	26/09/2018	\N	\N	Sempreverde	1	0
2131	0101000020110F0000213CDAA8E48F2341F7C77B69F0655041	2055	499	903	Palma	WASHINGTONIA ROBUSTA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	4	Aiuola	0	0	-1	-	0	\N	Tipico	0	\N	2018-09-26	0	2) 6m = 12m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	Manufatto;	\N	desktop/Foto\\903.JPG	\N	2055	2018	26/09/2018	\N	\N	Sempreverde	1	0
2132	0101000020110F0000A5660F54E38F2341A69BC4C2EE655041	2056	500	898	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	ferite;	\N	lesione aperta;	\N	\N	\N	\N	\N	desktop/Foto\\898.JPG	\N	2056	2018	26/09/2018	\N	\N	Sempreverde	1	0
2133	0101000020110F0000AD2F126A1E90234103435695F5655041	2057	501	912	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\912.JPG	\N	2057	2018	26/09/2018	\N	\N	Sempreverde	1	0
2134	0101000020110F0000BEBC004B2A902341F67F0E67F6655041	2058	502	913	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	0	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-26	2	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C/D	\N	branche con ferite; seccume diffuso;	\N	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	desktop/Foto\\913.JPG	\N	2058	2018	26/09/2018	\N	\N	Sempreverde	1	0
2135	0101000020110F0000B324403D6E982341BCB376013A665041	2059	503	973	Ceppaia	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Prato	0	0	0	-	0	\N	-	0	\N	2019-11-12	0	-	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	-	-	-	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\973.JPG	\N	2059	2019	12/11/2019	\N	\N	Sempreverde	2	0
2136	0101000020110F00008A3C49DA799823411B6492EF3C665041	2060	504	992	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	Cartellonistica;	\N	\N	\N	2060	2018	27/09/2018	\N	\N	Sempreverde	1	0
2137	0101000020110F00001A170EF4A898234163D174703C665041	2061	505	993	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2061	2018	27/09/2018	\N	\N	Sempreverde	1	0
2138	0101000020110F0000E3FC4D38C09823413F355E4A3D665041	2062	506	994	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	Cartellonistica;	\N	\N	\N	2062	2018	27/09/2018	\N	\N	Sempreverde	1	0
2139	0101000020110F0000C51B9907C7982341BF9A03B240665041	2063	507	995	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C	\N	\N	\N	\N	capitozzatura; lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2063	2018	27/09/2018	\N	\N	Sempreverde	1	0
2140	0101000020110F000058CA32C49A9823416B2BF60346665041	2064	508	996	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2064	2018	27/09/2018	\N	\N	Sempreverde	1	0
2141	0101000020110F00005C72DC69A498234103603C9546665041	2065	509	997	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2065	2018	27/09/2018	\N	\N	Sempreverde	1	0
2142	0101000020110F000021B07208B2982341F8FC300247665041	2066	510	999	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Cattivo	CLASSE C	\N	\N	\N	\N	inclinazione ingiustificata; lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2066	2018	27/09/2018	\N	\N	Sempreverde	1	0
2143	0101000020110F0000238447EBD6982341B3CD8DB53E665041	2067	511	1000	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.5	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2067	2018	27/09/2018	\N	\N	Caduca	1	0
2144	0101000020110F00001B12F7C82C872341747B493B55655041	2068	2	201	Albero	LIGUSTRUM JAPONICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Corace	Filare	5	Tornello con cordolo	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Costipato	Buono	Buono	CLASSE B	\N	\N	ferite;	\N	inclinazione ingiustificata;	\N	\N	\N	Edificio;	\N	desktop/Foto\\201.JPG	\N	2068	2018	24/09/2018	\N	\N	Sempreverde	1	0
2145	0101000020110F0000EE5F5989F58623411D8F1984FB645041	2069	32	243	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\243.JPG	\N	2069	2018	24/09/2018	\N	\N	Sempreverde	1	0
2146	0101000020110F0000C347C444E298234111363C913E665041	2070	512	1001	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2070	2018	27/09/2018	\N	\N	Sempreverde	1	0
2147	0101000020110F0000BAF770190F992341D595CF0C41665041	2071	513	1002	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2071	2018	27/09/2018	\N	\N	Sempreverde	1	0
2148	0101000020110F00003A06647F3C992341ECFA05D143665041	2072	514	1003	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2072	2018	27/09/2018	\N	\N	Sempreverde	1	0
2149	0101000020110F000085B185404B99234155FB747444665041	2073	515	1004	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2073	2018	27/09/2018	\N	\N	Sempreverde	1	0
2150	0101000020110F00004AEF1BDF589923414A9869E144665041	2074	516	1005	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2074	2018	27/09/2018	\N	\N	Sempreverde	1	0
2151	0101000020110F00002EE23B91849923410EF8FC5C47665041	2075	517	1006	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2075	2018	27/09/2018	\N	\N	Sempreverde	1	0
2152	0101000020110F0000B1C403BA969923413D61897F48665041	2076	518	1007	Albero	TAMARIX GALLICA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Pessimo	CLASSE C/D	\N	branche con fratture/incrinature;	\N	\N	ginocchiatura; inclinazione ingiustificata;	\N	\N	\N	\N	\N	\N	\N	2076	2018	27/09/2018	\N	\N	Sempreverde	1	0
2153	0101000020110F000078B9886F6E9923413CF71E1646665041	2077	519	1008	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	branche con fratture/incrinature;	\N	\N	lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2077	2018	27/09/2018	\N	\N	Caduca	1	0
2154	0101000020110F0000DE8E704AAC992341A796AD574A665041	2078	520	1014	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE C	\N	\N	ferite;	\N	lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2078	2018	27/09/2018	\N	\N	Caduca	1	0
2155	0101000020110F0000F5F3A612B79923418E9257F94B665041	2079	521	1015	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2079	2018	27/09/2018	\N	\N	Caduca	1	0
2156	0101000020110F00000135B5CCC99923416B60AB3C4F665041	2080	522	1016	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2080	2018	27/09/2018	\N	\N	Caduca	1	0
2157	0101000020110F0000A1DB4B7ABA992341535C55DE50665041	2081	523	1019	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2081	2018	27/09/2018	\N	\N	Caduca	1	0
2158	0101000020110F00000118CF20AF992341EA5BE63A50665041	2082	524	1020	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2082	2018	27/09/2018	\N	\N	Caduca	1	0
2159	0101000020110F0000C38190DC97992341D3F6AF764D665041	2083	525	1022	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2083	2018	27/09/2018	\N	\N	Caduca	1	0
2160	0101000020110F00009E07779795992341A48D23544C665041	2084	526	1023	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2084	2018	27/09/2018	\N	\N	Caduca	1	0
2161	0101000020110F00005CACA8219A992341C7293A7A4B665041	2085	527	1024	Albero	CERATONIA SILIQUA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE B	\N	\N	ferite;	\N	inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2085	2018	27/09/2018	\N	\N	-	1	0
2162	0101000020110F0000E44EE9C0F986234191B8C734FC645041	2086	33	244	Palma	TRACHYCARPUS FORTUNEI	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Filare	3	Aiuola	0	0	0	-	0	\N	Tipico	0	\N	2018-09-24	0	1) <= 6m	2) 20cm=50cm	0	0	0	0	-	0	0	-	0	0	0	0	Idoneo	Buono	Buono	CLASSE B	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	desktop/Foto\\244.JPG	\N	2086	2018	24/09/2018	\N	\N	Sempreverde	1	0
2163	0101000020110F00003A234A4B97992341255D33214A665041	2087	528	1013	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE C	\N	\N	ferite;	\N	lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2087	2018	27/09/2018	\N	\N	Caduca	1	0
2164	0101000020110F00006AA4A5F276992341B22E6E1F4B665041	2088	529	1027	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Buono	CLASSE C	\N	\N	ferite;	\N	lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2088	2018	27/09/2018	\N	\N	Caduca	1	0
2165	0101000020110F00008A7615926F992341D595CF1049665041	2089	530	1029	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Mediocre	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2089	2018	27/09/2018	\N	\N	Caduca	1	0
2166	0101000020110F000083DDB07D6699234177F86B0048665041	2090	531	1030	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Mediocre	Cattivo	CLASSE C	\N	\N	ferite;	\N	ginocchiatura; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2090	2018	27/09/2018	\N	\N	Caduca	1	0
2167	0101000020110F00009C33A2B470992341255D33214A665041	2091	532	1031	Albero	ACACIA SALIGNA	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	0	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Buono	Pessimo	CLASSE D	4	scosciatura;	\N	\N	lesione aperta;	\N	\N	\N	\N	\N	\N	\N	2091	2018	27/09/2018	\N	\N	Sempreverde	1	0
2168	0101000020110F00001EF98331689923417862D6694A665041	2092	533	1028	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2092	2018	27/09/2018	\N	\N	Caduca	1	0
2169	0101000020110F000085B185404B9923419BC9375B48665041	2093	534	1033	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Pessimo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2093	2018	27/09/2018	\N	\N	Caduca	1	0
2170	0101000020110F000003CFBD1739992341D595CF1049665041	2094	535	1035	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2094	2018	27/09/2018	\N	\N	Caduca	1	0
2171	0101000020110F00003A06647F3C992341A52C43EE47665041	2095	536	1034	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.6	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2095	2018	27/09/2018	\N	\N	Caduca	1	0
2172	0101000020110F0000EE5A42BE2D992341ED64703A46665041	2096	537	1036	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2096	2018	27/09/2018	\N	\N	Caduca	1	0
2173	0101000020110F0000A1BE658E1F99234148C4941248665041	2097	538	1037	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	2	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2097	2018	27/09/2018	\N	\N	Caduca	1	0
2174	0101000020110F000073F4F8FD09992341E2CCAF7245665041	2098	539	1039	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N	2098	2018	27/09/2018	\N	\N	Caduca	1	0
2175	0101000020110F0000F8AA95E9009923416B2BF60346665041	2099	540	1040	Albero	MELIA AZEDARACH	CATANZARO LIDO	-	Via	IV Fortuna, Lido	Via Lungomare	Isolato	0	Aiuola stradale	0	0	0	-	0	\N	Tipico	0	\N	2018-09-27	1.7	1) <= 6m	1) <= 20cm	0	0	0	0	-	0	0	-	0	0	0	0	Ricoperto	Cattivo	Cattivo	CLASSE C/D	\N	\N	ferite;	\N	ginocchiatura; inclinazione ingiustificata; lesioni aperte;	\N	\N	\N	\N	\N	\N	\N