package com.progetto.VEBS.service;

import java.util.List;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.PoligonoSezioneCensuariaMapper;
import com.progetto.VEBS.model.dto.PoligonoSezioneCensuariaDTO;
import com.progetto.VEBS.model.entity.PoligonoSezioneCensuaria;
import com.progetto.VEBS.model.repository.PoligonoSezioneCensuariaRepository;

@Service
public class PoligonoSezioneCensuariaService {

	@Autowired
	private PoligonoSezioneCensuariaMapper mapper;
	
	@Autowired
	private PoligonoSezioneCensuariaRepository poligonoSezioneCensuariaRepository;

	public List<PoligonoSezioneCensuariaDTO> getAllPoligoniComuni() {
	    return poligonoSezioneCensuariaRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public PoligonoSezioneCensuariaDTO getPoligonoComuneById(Integer id) {
	    return poligonoSezioneCensuariaRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void savePoligono(PoligonoSezioneCensuariaDTO poligono_sezione_censuaria) {
		poligonoSezioneCensuariaRepository.save(mapper.toEntity(poligono_sezione_censuaria));			
	}

	public void deletePoligonoComuneById(Integer id) throws ResourceNotFoundException {
		poligonoSezioneCensuariaRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		poligonoSezioneCensuariaRepository.deleteById(id);
	}

	public void updatePoligonoComune(PoligonoSezioneCensuariaDTO poligono_sezione_censuaria_dto) throws ResourceNotFoundException {
		PoligonoSezioneCensuaria poligono = poligonoSezioneCensuariaRepository.findById(poligono_sezione_censuaria_dto.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(poligono_sezione_censuaria_dto.getGeometria());
			poligono.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligono.setId(poligono_sezione_censuaria_dto.getId());
		poligono.setCodice_regione(poligono_sezione_censuaria_dto.getCodice_regione());
		poligono.setCodice_procom(poligono_sezione_censuaria_dto.getCodice_procom());
		poligono.setCodice_sez(poligono_sezione_censuaria_dto.getCodice_sez());
		poligono.setCodice_tipo_s(poligono_sezione_censuaria_dto.getCodice_tipo_s());
		poligono.setTipo_localita(poligono_sezione_censuaria_dto.getTipo_localita());
		poligono.setPopolazione(poligono_sezione_censuaria_dto.getPopolazione());
		poligono.setFamiglie(poligono_sezione_censuaria_dto.getFamiglie());
		poligono.setAbitanti(poligono_sezione_censuaria_dto.getAbitanti());
		poligono.setEdifici(poligono_sezione_censuaria_dto.getEdifici());
		poligono.setPerimetro(poligono_sezione_censuaria_dto.getPerimetro());
		poligono.setArea(poligono_sezione_censuaria_dto.getArea());

		poligonoSezioneCensuariaRepository.saveAndFlush(poligono);
	}
}
