package com.progetto.VEBS.service;

import java.util.List;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.PoligonoPopolazioneMapper;
import com.progetto.VEBS.model.dto.PoligonoPopolazioneDTO;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.model.entity.PoligonoPopolazione;
import com.progetto.VEBS.model.repository.PoligonoPopolazioneRepository;

@Service
public class PoligonoPopolazioneService {

	@Autowired
	private PoligonoPopolazioneMapper mapper;
	
	@Autowired
	private PoligonoPopolazioneRepository poligonoPopolazioneRepository;

	public List<PoligonoPopolazioneDTO> getAllPoligoniPopolazione() {
	    return poligonoPopolazioneRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public PoligonoPopolazioneDTO getPoligonoPopolazioneById(Integer id) {
	    return poligonoPopolazioneRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public PoligonoPopolazione savePoligono(PoligonoPopolazioneDTO poligono_pop) {
	    return poligonoPopolazioneRepository.save(mapper.toEntity(poligono_pop));				
	}

	public PoligonoPopolazione deletePoligonoPopolazioneById(Integer id) throws ResourceNotFoundException {
		PoligonoPopolazione poligono = poligonoPopolazioneRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		poligonoPopolazioneRepository.deleteById(id);
		return poligono;
	}

	public void updatePoligonoPopolazione(PoligonoPopolazioneDTO poligono_pop_dto) throws ResourceNotFoundException {
		PoligonoPopolazione poligono = poligonoPopolazioneRepository.findById(poligono_pop_dto.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(poligono_pop_dto.getGeometria());
			poligono.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligono.setId(poligono_pop_dto.getId());
		poligono.setPop(poligono_pop_dto.getPop());
		poligono.setPop_finale(poligono_pop_dto.getPop_finale());
		poligono.setSez(poligono_pop_dto.getSez());
		poligono.setCod_tipo_s(poligono_pop_dto.getCod_tipo_s());
		poligono.setTipo_loc(poligono_pop_dto.getTipo_loc());
		poligono.setProcom(poligono_pop_dto.getProcom());
		poligono.setComune(poligono_pop_dto.getComune());
		poligono.setCentroide_wkt(poligono_pop_dto.getCentroide_wkt());
		poligono.setArea_verde(poligono_pop_dto.getArea_verde());
		poligono.setArea_blu(poligono_pop_dto.getArea_blu());
		poligono.setIncidenza_arborea(poligono_pop_dto.getIncidenza_arborea());
		
		poligonoPopolazioneRepository.saveAndFlush(poligono);
	}
}
