package com.progetto.VEBS.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.PoligonoAreaVerdeMapper;
import com.progetto.VEBS.model.dto.PoligonoAreaVerdeDTO;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.model.repository.PoligonoAreaVerdeRepository;

@Service
public class PoligonoAreaVerdeService {

	@Autowired
	private PoligonoAreaVerdeMapper mapper;
	
	@Autowired
	private PoligonoAreaVerdeRepository poligonoAreaVerdeRepository;

	public List<PoligonoAreaVerdeDTO> getAllPoligoniAreeVerdi() {
	    return poligonoAreaVerdeRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public PoligonoAreaVerdeDTO getPoligonoAreaVerdeById(Integer id) {
	    return poligonoAreaVerdeRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void savePoligono(PoligonoAreaVerdeDTO poligono_area_verde) {
	    poligonoAreaVerdeRepository.save(mapper.toEntity(poligono_area_verde));			
	}

	public void deletePoligonoAreaVerdeById(Integer id) throws ResourceNotFoundException {
		poligonoAreaVerdeRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		poligonoAreaVerdeRepository.deleteById(id);
	}

	public void updatePoligonoAreaVerde(PoligonoAreaVerdeDTO poligono_area_verde_dto) throws ResourceNotFoundException {
		PoligonoAreaVerde poligono = poligonoAreaVerdeRepository.findById(poligono_area_verde_dto.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato")); 
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(poligono_area_verde_dto.getGeometria());
			poligono.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligono.setId(poligono_area_verde_dto.getId());
		poligono.setNome(poligono_area_verde_dto.getNome());
		poligono.setDensita_alberi(poligono_area_verde_dto.getDensita_alberi());
		poligono.setArea(poligono_area_verde_dto.getArea());

		poligonoAreaVerdeRepository.saveAndFlush(poligono);
	}

	public Map<String,Object> getFieldsPoligoniAreeVerdi() {
		Map<String,Object> fields = new HashMap();
		for(Field field : PoligonoAreaVerde.class.getDeclaredFields()){
			fields.put(field.getName(),null);
		}
		return fields;
	}
}
