package com.progetto.VEBS.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.IngressoMapper;
import com.progetto.VEBS.model.dto.IngressoDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.AreaVerde;
import com.progetto.VEBS.model.entity.Ingresso;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.model.repository.AreaBluRepository;
import com.progetto.VEBS.model.repository.AreaVerdeRepository;
import com.progetto.VEBS.model.repository.IngressoRepository;

@Service
public class IngressoService {

	@Autowired
	private IngressoMapper mapper;

	@Autowired
	private IngressoRepository ingressoRepository;

	@Autowired
	private AreaVerdeRepository areaVerdeRepository;

	@Autowired
	private AreaBluRepository areaBluRepository;

	public List<IngressoDTO> getAllIngressi() {
		return ingressoRepository.findAll().stream().map(mapper::toDTO).collect(Collectors.toList());
	}

	public IngressoDTO getIngressoById(Integer id) {
		return ingressoRepository.findById(id).map(mapper::toDTO).orElse(null);
	}

	public void saveIngresso(IngressoDTO ingresso_area_verde) {
		
		ingressoRepository.save(mapper.toEntity(ingresso_area_verde));
	}

	public Ingresso deleteIngressoById(Integer id) throws ResourceNotFoundException {
		Ingresso ingresso = ingressoRepository.findById(id)
				.orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));
		ingressoRepository.deleteById(id);
		return ingresso;
	}

	public void update(IngressoDTO ingresso_dto) throws ResourceNotFoundException {

		Ingresso ingresso = ingressoRepository.findById(ingresso_dto.getId())
				.orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));

		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(ingresso_dto.getGeometria());
			ingresso.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ingresso.setId(ingresso_dto.getId());
		ingresso.setNome(ingresso_dto.getNome());
		ingresso.setArea_verde(ingresso_dto.getArea_verde());
		ingresso.setArea_blu(ingresso_dto.getArea_blu());

		ingressoRepository.saveAndFlush(ingresso);
	}

	public Map<String, Object> getFieldsIngressi() {
		Map<String, Object> fields = new HashMap();
		for (Field field : Ingresso.class.getDeclaredFields()) {
			fields.put(field.getName(), null);
		}
		return fields;
	}

	public void updateIngressoPolAreaVerdeAreaBlu(IngressoDTO ingresso_dto, Integer id_area_verde,
			Integer id_area_blu) {

		Ingresso ingresso = new Ingresso();

		// controllo id area verde se 0, id non valido, se != 0 id valido faccio la query custom per ricavarmi l'oggetto area verde
		if (!id_area_verde.equals(0)) {
			AreaVerde area_verde = areaVerdeRepository.findByIdEvenPolNull(id_area_verde);
			ingresso.setArea_verde(area_verde);
		}
		
		// controllo id area blu se 0, id non valido, se != 0 id valido faccio la query per ricavarmi l'oggetto area blu
		if (!id_area_blu.equals(0)) {
			AreaBlu area_blu = areaBluRepository.getReferenceById(id_area_blu);
			ingresso.setArea_blu(area_blu);
		};

		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(ingresso_dto.getGeometria());
			ingresso.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ingresso.setId(ingresso_dto.getId());
		ingresso.setNome(ingresso_dto.getNome());

		ingressoRepository.saveAndFlush(ingresso);
	}
	
	public void saveIngressoPolAreaVerdeAreaBlu(IngressoDTO ingresso_dto, Integer id_area_verde,
			Integer id_area_blu) {

		Ingresso ingresso = new Ingresso();

		// controllo id area verde se 0, id non valido, se != 0 id valido faccio la query custom per ricavarmi l'oggetto area verde
		if (!id_area_verde.equals(0)) {
			AreaVerde area_verde = areaVerdeRepository.findByIdEvenPolNull(id_area_verde);
			ingresso.setArea_verde(area_verde);
		}
		
		// controllo id area blu se 0, id non valido, se != 0 id valido faccio la query per ricavarmi l'oggetto area blu
		if (!id_area_blu.equals(0)) {
			AreaBlu area_blu = areaBluRepository.getReferenceById(id_area_blu);
			ingresso.setArea_blu(area_blu);
		};

		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(ingresso_dto.getGeometria());
			ingresso.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ingresso.setNome(ingresso_dto.getNome());
		ingresso.setData(ingresso_dto.getData());

		ingressoRepository.saveAndFlush(ingresso);
	}

	public List<Map<String,Object>> getIngressiAreeVerdiRaggio(String geomWKT, Integer raggio) {
		
		List<Object[]> ingressi = ingressoRepository.getPointsWithinDistance(geomWKT, raggio);
		
		List<Map<String,Object>> result = new ArrayList(); 
		
		for(Object[] ingresso : ingressi) {
			Map<String,Object> val = new HashMap();
			val.put("id", ingresso[0]);
			val.put("latitudine", ingresso[1]);
			val.put("longitudine", ingresso[2]);
			result.add(val);
		}
		
		return result;
	}

}
