package com.progetto.VEBS.service;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Service;

import com.progetto.VEBS.mapper.AreaBluMapper;
import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.model.repository.AreaBluRepository;

@Service
public class AreaBluService {

	@Autowired
	private AreaBluMapper mapper;

	@Autowired
	private AreaBluRepository areaBluRepository;

	public List<AreaBluDTO> getAllAreeBlu() {
	    return areaBluRepository.findAll().stream()
	        .map(mapper::toDTO)
	        .collect(Collectors.toList());
	}

	public AreaBluDTO getAreaBluById(Integer id) {
	    return areaBluRepository.findById(id).map(mapper::toDTO)
	            .orElse(null);
	}

	public void saveAreaBlu(AreaBluDTO areablu) {
	    areaBluRepository.save(mapper.toEntity(areablu));
	}

	public void deleteAreaBluById(Integer id) throws ResourceNotFoundException {
		areaBluRepository.findById(id).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));
		areaBluRepository.deleteById(id);
	}

	public void updateAreaBlu(AreaBluDTO areabluDTO) throws ResourceNotFoundException {
		AreaBlu areablu = areaBluRepository.findById(areabluDTO.getId()).orElseThrow(() -> new ResourceNotFoundException("Record non trovato"));;
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(areabluDTO.getGeometria());
			areablu.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		areablu.setId(areabluDTO.getId());
		areablu.setNome(areabluDTO.getNome());
		
		areaBluRepository.saveAndFlush(areablu);
	}

	public Map<String, Object> getFieldsAreeBlu() {
		Map<String,Object> fields = new HashMap();
		for(Field field : AreaBlu.class.getDeclaredFields()){
			fields.put(field.getName(),null);
		}
		return fields;
	}

	public List<AreaBluDTO> getAllAreeBluFromComune(String comune) {
		return areaBluRepository.findByComune(comune).stream().map(mapper::toDTO).collect(Collectors.toList());
	}
}
