package com.progetto.VEBS.model.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.progetto.VEBS.model.entity.PoligonoComune;

@Repository
public interface PoligonoComuneRepository extends JpaRepository<PoligonoComune, Integer>{

	@Query(value = "SELECT p.comune FROM poligono_comune p WHERE ST_Within( ST_GeomFromText(:geomWKT,3857), p.geom )", nativeQuery = true)
	List<Object[]> getNamePolygonComuneFromGeometry(@Param("geomWKT") String geomWKT);

	
}
