package com.progetto.VEBS.model.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.progetto.VEBS.model.entity.Ingresso;

@Repository
public interface IngressoRepository extends JpaRepository<Ingresso, Integer>{

	
	@Query(value = "SELECT id, ST_X(geometria), ST_Y(geometria) FROM ingresso as i \r\n"
			+ "	WHERE ST_Distance(ST_GeomFromText(:geomWKT,3857), i.geometria) <= :distance", nativeQuery = true)
	List<Object[]> getPointsWithinDistance(@Param("geomWKT") String geomWKT, @Param("distance") Integer distance);


	@Query(value = "SELECT COUNT(*) FROM ingresso AS i JOIN area_verde AS av ON (i.area_verde = av.id) WHERE av.comune = :name", nativeQuery = true)
	Integer getNumIngressiFromName(String name);
}
