package com.progetto.VEBS.model.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaBlu;
import com.progetto.VEBS.model.entity.AreaVerde;


@Repository
public interface AreaVerdeRepository extends JpaRepository<AreaVerde, Integer> {

	@Query(value = "SELECT * FROM area_verde a WHERE a.id = :id", nativeQuery = true)
	AreaVerde findByIdEvenPolNull(@Param("id") Integer id);
	
	@Query(value = "SELECT id, nome FROM area_verde", nativeQuery = true)
	List<Object[]> getIdNomeFromAreeVerdi();

	@Query(value = "SELECT COUNT(*) FROM area_verde WHERE comune = :name", nativeQuery = true)
	Integer getNumAreeVerdiFromName(String name);

	@Query(value = "SELECT * FROM area_verde WHERE comune = :comune", nativeQuery = true)
	List<AreaVerde> findByComune(String comune);
}
