package com.progetto.VEBS.model.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.progetto.VEBS.model.dto.AreaBluDTO;
import com.progetto.VEBS.model.entity.AreaBlu;

@Repository
public interface AreaBluRepository extends JpaRepository<AreaBlu, Integer>{


	@Query(value = "SELECT COUNT(*) FROM area_blu WHERE comune = :name", nativeQuery = true)
	Integer getNumAreeBluFromName(String name);
	
	@Query(value = "SELECT * FROM area_blu WHERE comune = :comune", nativeQuery = true)
	List<AreaBlu> findByComune(String comune);
}
