package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

@Entity
@Table(name = "poligono_popolazione")
public class PoligonoPopolazione {
	
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column(name = "geometria", columnDefinition = "geometry(Polygon, 3857)")
    private Geometry geometria;

    @Column(name = "sez")
    private Integer sez;

    @Column(name = "pop")
    private Integer pop;
    
    @Column(name = "cod_tipo_s")
    private Integer cod_tipo_s;
    
    @Column(name = "tipo_loc")
    private Integer tipo_loc;
    
    @Column(name = "pop_finale")
    private Integer pop_finale;
    
    @Column(name = "procom")
    private Integer procom;
    
    @Column(name = "comune")
    private String comune;
    
    @Column(name = "centroide_wkt")
    private String centroide_wkt;

    @ManyToOne
    @JoinColumn(name = "area_verde", referencedColumnName="id", nullable = false)
    private AreaVerde area_verde;

    @ManyToOne
    @JoinColumn(name = "area_blu", referencedColumnName="id", nullable = false)
    private AreaBlu area_blu;
    
    @ManyToOne
    @JoinColumn(name = "incidenza_arborea", referencedColumnName="id",  nullable = false)
    private IncidenzaArborea incidenza_arborea;
    
    @Column(name = "data")
    private Date data;

    public void PoligonoPopolazione() {}

    // Getter e Setter
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSez() {
        return sez;
    }

    public void setSez(Integer sez) {
        this.sez = sez;
    }

    public Integer getPop() {
        return pop;
    }

    public void setPop(Integer pop) {
        this.pop = pop;
    }

    public Integer getCod_tipo_s() {
        return cod_tipo_s;
    }

    public void setCod_tipo_s(Integer cod_tipo_s) {
        this.cod_tipo_s = cod_tipo_s;
    }

    public Integer getTipo_loc() {
        return tipo_loc;
    }

    public void setTipo_loc(Integer tipo_loc) {
        this.tipo_loc = tipo_loc;
    }

    public Integer getPop_finale() {
        return pop_finale;
    }

    public void setPop_finale(Integer pop_finale) {
        this.pop_finale = pop_finale;
    }

    public Integer getProcom() {
        return procom;
    }

    public void setProcom(Integer procom) {
        this.procom = procom;
    }

    public String getCentroide_wkt() {
        return centroide_wkt;
    }

    public void setCentroide_wkt(String centroide_wkt) {
        this.centroide_wkt = centroide_wkt;
    }

    public String getComune() {
        return comune;
    }

    public void setComune(String comune) {
        this.comune = comune;
    }

    public Geometry getGeometria() {
        return geometria;
    }

    public void setGeometria(Geometry geometria) {
        this.geometria = geometria;
    }

    public AreaVerde getArea_verde() {
        return area_verde;
    }

    public void setArea_verde(AreaVerde area_verde) {
        this.area_verde = area_verde;
    }

    public AreaBlu getArea_blu() {
        return area_blu;
    }

    public void setArea_blu(AreaBlu area_blu) {
        this.area_blu = area_blu;
    }

    public IncidenzaArborea getIncidenza_arborea() {
        return incidenza_arborea;
    }

    public void setIncidenza_arborea(IncidenzaArborea incidenza_arborea) {
        this.incidenza_arborea = incidenza_arborea;
    }

    public Date getData() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }
}
