package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.locationtech.jts.geom.Geometry;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Table(name = "poligono_area_verde")
public class PoligonoAreaVerde {

	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column(name = "nome")
    private String nome;

    @Column(name = "densita_alberi")
    private Double densita_alberi;
    
    @JsonIgnore
    @Column(name = "geometria", columnDefinition = "geometry(MultiPolygon, 3857)")
    private Geometry geometria;
    
    @Column(name = "area")
    private Double area;

    @Column(name = "comune")
    private String comune;
    
    @Column(name = "data")
    private Date data;
    
    // aggiungere campo comune che si trova nel database

    public void PoligonoAreaVerde() {}

    // Getter e Setter
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getDensita_alberi() {
        return densita_alberi;
    }

    public void setDensita_alberi(Double densita_alberi) {
        this.densita_alberi = densita_alberi;
    }

    public Geometry getGeometria() {
        return geometria;
    }

    public void setGeometria(Geometry geometria) {
        this.geometria = geometria;
    }

    public Double getArea() {
        return area;
    }

    public void setArea(Double area) {
        this.area = area;
    }

    public Date getData() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public String getComune() {
        return comune;
    }

    public void setComune(String comune) {
        this.comune = comune;
    }
	
}
