package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

@Entity
@Table(name = "ingresso")
public class Ingresso {

	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column(name = "nome")
    private String nome;

    @Column(name = "geometria", columnDefinition = "geometry(Point, 3857)")
    private Geometry geometria;

    @Column(name = "data")
    private Date data;

    @ManyToOne
    @JoinColumn(name = "area_verde", referencedColumnName="id")
    private AreaVerde area_verde;
    
    @ManyToOne
    @JoinColumn(name = "area_blu", referencedColumnName="id")
    private AreaBlu  area_blu;
    
    //sistemare attributi tabella e classe

    public void IngressoAreaVerde() {}

    // Getter e Setter
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Geometry getGeometria() {
        return geometria;
    }

    public void setGeometria(Geometry geometria) {
        this.geometria = geometria;
    }

    public AreaVerde getArea_verde() {
        return area_verde;
    }

    public void setArea_verde(AreaVerde area_verde) {
        this.area_verde = area_verde;
    }

    public AreaBlu getArea_blu() {
        return area_blu;
    }

    public void setArea_blu(AreaBlu area_blu) {
        this.area_blu = area_blu;
    }

    public Date getData() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }
}
