package com.progetto.VEBS.model.entity;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.locationtech.jts.geom.Geometry;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Table(name = "area_verde")
public class AreaVerde {
	
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column(name = "nome")
    private String nome;

    @Column(name = "densita_alberi")
    private Double densita_alberi;

    @JsonIgnore
    @Column(name = "geometria", columnDefinition = "geometry(MultiPolygon, 3857)")
    private Geometry geometria;

    @Column(name = "area")
    private Double area;

    @Column(name = "comune")
    private String comune;
    
    @Column(name = "ubicazione")
    private String ubicazione;
    
    @Column(name= "data")
    private Date data;

    @ManyToOne
    @JoinColumn(name = "poligono_area_verde", nullable = false)
    private PoligonoAreaVerde poligono_area_verde;

    //mancano campi della tabella ( comune, ubicazione )

    public void AreaVerde() {}

    // Getter e Setter
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Double getDensita_alberi() {
        return densita_alberi;
    }

    public void setDensita_alberi(Double densita_alberi) {
        this.densita_alberi = densita_alberi;
    }

    public Geometry getGeometria() {
        return geometria;
    }

    public void setGeometria(Geometry geometria) {
        this.geometria = geometria;
    }

    public Double getArea() {
        return area;
    }

    public void setArea(Double area) {
        this.area = area;
    }

    public String getComune() {
        return comune;
    }

    public void setComune(String comune) {
        this.comune = comune;
    }

    public String getUbicazione() {
        return ubicazione;
    }

    public void setUbicazione(String ubicazione) {
        this.ubicazione = ubicazione;
    }

    public PoligonoAreaVerde getPoligono_area_verde() {
        return poligono_area_verde;
    }

    public void setPoligono_area_verde(PoligonoAreaVerde poligono_area_verde) {
        this.poligono_area_verde = poligono_area_verde;
    }

    public Date getData() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }
}
