package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.PoligonoSezioneCensuariaDTO;
import com.progetto.VEBS.model.entity.PoligonoPopolazione;
import com.progetto.VEBS.model.entity.PoligonoSezioneCensuaria;

@Mapper(componentModel = "spring")
public interface PoligonoSezioneCensuariaMapper {
	
	default PoligonoSezioneCensuariaDTO toDTO(PoligonoSezioneCensuaria entity) {
		if ( entity == null ) {
            return null;
        }
		PoligonoSezioneCensuariaDTO poligonoSezioneCensuariaDTO = new PoligonoSezioneCensuariaDTO();
		poligonoSezioneCensuariaDTO.setId(entity.getId());
		poligonoSezioneCensuariaDTO.setCodice_regione(entity.getCodice_regione());
		poligonoSezioneCensuariaDTO.setCodice_procom(entity.getCodice_procom());
		poligonoSezioneCensuariaDTO.setGeometria(entity.getGeometria().toText());
		poligonoSezioneCensuariaDTO.setCodice_sez(entity.getCodice_sez());
		poligonoSezioneCensuariaDTO.setCodice_tipo_s(entity.getCodice_tipo_s());
		poligonoSezioneCensuariaDTO.setTipo_localita(entity.getTipo_localita());
		poligonoSezioneCensuariaDTO.setPopolazione(entity.getPopolazione());
		poligonoSezioneCensuariaDTO.setFamiglie(entity.getFamiglie());
		poligonoSezioneCensuariaDTO.setAbitanti(entity.getAbitanti());
		poligonoSezioneCensuariaDTO.setEdifici(entity.getEdifici());
		poligonoSezioneCensuariaDTO.setPerimetro(entity.getPerimetro());
		poligonoSezioneCensuariaDTO.setArea(entity.getArea());
        return poligonoSezioneCensuariaDTO;
	}

	
	default PoligonoSezioneCensuaria toEntity(PoligonoSezioneCensuariaDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		PoligonoSezioneCensuaria poligonoSezioneCensuaria = new PoligonoSezioneCensuaria();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getGeometria());
			poligonoSezioneCensuaria.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligonoSezioneCensuaria.setId(dto.getId());
		poligonoSezioneCensuaria.setCodice_regione(dto.getCodice_regione());
		poligonoSezioneCensuaria.setCodice_procom(dto.getCodice_procom());
		poligonoSezioneCensuaria.setCodice_sez(dto.getCodice_sez());
		poligonoSezioneCensuaria.setCodice_tipo_s(dto.getCodice_tipo_s());
		poligonoSezioneCensuaria.setTipo_localita(dto.getTipo_localita());
		poligonoSezioneCensuaria.setPopolazione(dto.getPopolazione());
		poligonoSezioneCensuaria.setFamiglie(dto.getFamiglie());
		poligonoSezioneCensuaria.setAbitanti(dto.getAbitanti());
		poligonoSezioneCensuaria.setEdifici(dto.getEdifici());
		poligonoSezioneCensuaria.setPerimetro(dto.getPerimetro());
		poligonoSezioneCensuaria.setArea(dto.getArea());
        return poligonoSezioneCensuaria;
	}
}
