package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.PoligonoPopolazioneDTO;
import com.progetto.VEBS.model.entity.PoligonoPopolazione;

@Mapper(componentModel = "spring")
public interface PoligonoPopolazioneMapper {

	default PoligonoPopolazioneDTO toDTO(PoligonoPopolazione entity) {
		if ( entity == null ) {
            return null;
        }
		PoligonoPopolazioneDTO poligonoPopolazioneDTO = new PoligonoPopolazioneDTO();
		poligonoPopolazioneDTO.setId(entity.getId());
		poligonoPopolazioneDTO.setPop(entity.getPop());
		poligonoPopolazioneDTO.setGeometria(entity.getGeometria().toText());
		poligonoPopolazioneDTO.setPop_finale(entity.getPop_finale());
		poligonoPopolazioneDTO.setSez(entity.getSez());
		poligonoPopolazioneDTO.setCod_tipo_s(entity.getCod_tipo_s());
		poligonoPopolazioneDTO.setTipo_loc(entity.getTipo_loc());
		poligonoPopolazioneDTO.setProcom(entity.getProcom());
		poligonoPopolazioneDTO.setComune(entity.getComune());
		poligonoPopolazioneDTO.setCentroide_wkt(entity.getCentroide_wkt());
		poligonoPopolazioneDTO.setArea_verde(entity.getArea_verde());
		poligonoPopolazioneDTO.setArea_blu(entity.getArea_blu());
		poligonoPopolazioneDTO.setIncidenza_arborea(entity.getIncidenza_arborea());
        return poligonoPopolazioneDTO;
	}

	
	default PoligonoPopolazione toEntity(PoligonoPopolazioneDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		PoligonoPopolazione poligonoPopolazione = new PoligonoPopolazione();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getGeometria());
			poligonoPopolazione.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligonoPopolazione.setId(dto.getId());
		poligonoPopolazione.setArea_verde(dto.getArea_verde());
		poligonoPopolazione.setArea_blu(dto.getArea_blu());
		poligonoPopolazione.setIncidenza_arborea(dto.getIncidenza_arborea());
		poligonoPopolazione.setPop_finale(dto.getPop_finale());
		poligonoPopolazione.setSez(dto.getSez());
		poligonoPopolazione.setCod_tipo_s(dto.getCod_tipo_s());
		poligonoPopolazione.setTipo_loc(dto.getTipo_loc());
		poligonoPopolazione.setProcom(dto.getProcom());
		poligonoPopolazione.setComune(dto.getComune());
		poligonoPopolazione.setCentroide_wkt(dto.getCentroide_wkt());
		poligonoPopolazione.setPop(dto.getPop());
        return poligonoPopolazione;
	}
}
