package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.PoligonoComuneDTO;
import com.progetto.VEBS.model.entity.PoligonoComune;

@Mapper(componentModel = "spring")
public interface PoligonoComuneMapper {
	
	default PoligonoComuneDTO toDTO(PoligonoComune entity) {
		if ( entity == null ) {
            return null;
        }
		PoligonoComuneDTO poligonoComuneDTO = new PoligonoComuneDTO();
		poligonoComuneDTO.setId(entity.getId());
		poligonoComuneDTO.setCodice_procom(entity.getCodice_procom());
		poligonoComuneDTO.setCodice_procom_t(entity.getCodice_procom_t());
		poligonoComuneDTO.setGeometria(entity.getGeometria().toText());
		poligonoComuneDTO.setCodice_regione(entity.getCodice_regione());
		poligonoComuneDTO.setComune(entity.getComune());
		poligonoComuneDTO.setPerimetro(entity.getPerimetro());
		poligonoComuneDTO.setArea(entity.getArea());
        return poligonoComuneDTO;
	}

	
	default PoligonoComune toEntity(PoligonoComuneDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		PoligonoComune poligonoComune = new PoligonoComune();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getGeometria());
			poligonoComune.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		poligonoComune.setId(dto.getId());
		poligonoComune.setCodice_procom(dto.getCodice_procom());
		poligonoComune.setCodice_procom_t(dto.getCodice_procom_t());
		poligonoComune.setCodice_regione(dto.getCodice_regione());
		poligonoComune.setComune(dto.getComune());
		poligonoComune.setPerimetro(dto.getPerimetro());
		poligonoComune.setArea(dto.getArea());
        return poligonoComune;
	}
}
