package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.PoligonoAreaVerdeDTO;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;

@Mapper(componentModel = "spring")
public interface PoligonoAreaVerdeMapper {

	default PoligonoAreaVerdeDTO toDTO(PoligonoAreaVerde entity) {
		if ( entity == null ) {
            return null;
        }
		PoligonoAreaVerdeDTO poligonoAreaVerdeDTO = new PoligonoAreaVerdeDTO();
		poligonoAreaVerdeDTO.setId(entity.getId());
		poligonoAreaVerdeDTO.setNome(entity.getNome());
		poligonoAreaVerdeDTO.setDensita_alberi(entity.getDensita_alberi());
		poligonoAreaVerdeDTO.setGeometria(entity.getGeometria().toText());
		poligonoAreaVerdeDTO.setArea(entity.getArea());
		poligonoAreaVerdeDTO.setComune(entity.getComune());
		poligonoAreaVerdeDTO.setData(entity.getData());
        return poligonoAreaVerdeDTO;
	}

	
	default PoligonoAreaVerde toEntity(PoligonoAreaVerdeDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		PoligonoAreaVerde poligonoAreaVerde = new PoligonoAreaVerde();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getGeometria());
			poligonoAreaVerde.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		poligonoAreaVerde.setId(dto.getId());
		poligonoAreaVerde.setNome(dto.getNome());
		poligonoAreaVerde.setDensita_alberi(dto.getDensita_alberi());
		poligonoAreaVerde.setArea(dto.getArea());
		poligonoAreaVerde.setComune(dto.getComune());
		poligonoAreaVerde.setData(dto.getData());
        return poligonoAreaVerde;
	}

}
