package com.progetto.VEBS.mapper;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapstruct.Mapper;

import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.entity.AreaVerde;

//Questa tipologia di classi serve per convertire le classi entità con le classi dto e viceversa
@Mapper(componentModel = "spring")
public interface AreaVerdeMapper {
	
	default AreaVerdeDTO toDTO(AreaVerde entity) {
		if ( entity == null ) {
            return null;
        }
		AreaVerdeDTO areaVerdeDTO = new AreaVerdeDTO();
		areaVerdeDTO.setId(entity.getId());
		areaVerdeDTO.setNome(entity.getNome());
		areaVerdeDTO.setDensita_alberi(entity.getDensita_alberi());
		areaVerdeDTO.setGeometria(entity.getGeometria().toText());
		areaVerdeDTO.setArea(entity.getArea());
		areaVerdeDTO.setComune(entity.getComune());
		areaVerdeDTO.setUbicazione(entity.getUbicazione());
		areaVerdeDTO.setPoligono_area_verde(entity.getPoligono_area_verde());
		areaVerdeDTO.setData(entity.getData());
        return areaVerdeDTO;
	}

	
	default AreaVerde toEntity(AreaVerdeDTO dto) {
		if ( dto == null ) {
            return null;
        }
		
		AreaVerde areaVerde = new AreaVerde();
		
		WKTReader reader = new WKTReader();
		Geometry geom;
		try {
			geom = reader.read(dto.getGeometria());
			areaVerde.setGeometria(geom);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		areaVerde.setId(dto.getId());
		areaVerde.setNome(dto.getNome());
		areaVerde.setDensita_alberi(dto.getDensita_alberi());
		areaVerde.setArea(dto.getArea());
		areaVerde.setComune(dto.getComune());
		areaVerde.setUbicazione(dto.getUbicazione());
		areaVerde.setPoligono_area_verde(dto.getPoligono_area_verde());
		areaVerde.setData(dto.getData());
        return areaVerde;
	}
}
