package com.progetto.VEBS.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.PoligonoSezioneCensuariaDTO;
import com.progetto.VEBS.service.PoligonoSezioneCensuariaService;

@RestController
@CrossOrigin(origins = "http://localhost:5173")
@RequestMapping("/polsezcens")
public class PoligonoSezioneCensuariaController {

	 @Autowired
	  private final PoligonoSezioneCensuariaService poligonoSezioneCensuariaService;

	  public PoligonoSezioneCensuariaController(PoligonoSezioneCensuariaService poligonoSezioneCensuariaService) {
	    this.poligonoSezioneCensuariaService = poligonoSezioneCensuariaService;
	  }
	  
	  @GetMapping()
	  List<PoligonoSezioneCensuariaDTO> getAll() {
		  return poligonoSezioneCensuariaService.getAllPoligoniComuni();
	  }

	  @GetMapping("/{id_poligono}")
	  PoligonoSezioneCensuariaDTO getById(@PathVariable Integer id_poligono) {
	    return poligonoSezioneCensuariaService.getPoligonoComuneById(id_poligono);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody PoligonoSezioneCensuariaDTO poligono_comune) { 
		  poligonoSezioneCensuariaService.savePoligono(poligono_comune);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_poligono}")
	  HttpStatus deleteRecord(@PathVariable Integer id_poligono) {
		  poligonoSezioneCensuariaService.deletePoligonoComuneById(id_poligono);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody PoligonoSezioneCensuariaDTO poligono) {
		  poligonoSezioneCensuariaService.updatePoligonoComune(poligono);
		  return HttpStatus.OK;
	  }
}
