package com.progetto.VEBS.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.PoligonoAreaVerdeDTO;
import com.progetto.VEBS.model.dto.PoligonoPopolazioneDTO;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.model.entity.PoligonoPopolazione;
import com.progetto.VEBS.service.PoligonoPopolazioneService;

@RestController
@CrossOrigin(origins = "http://localhost:5173")
@RequestMapping("/polpop")
public class PoligonoPopolazioneController {
	
	 @Autowired
	  private final PoligonoPopolazioneService poligonoPopolazioneService;

	  public PoligonoPopolazioneController(PoligonoPopolazioneService poligonoPopolazioneService) {
	    this.poligonoPopolazioneService = poligonoPopolazioneService;
	  }
	  
	  @GetMapping()
	  List<PoligonoPopolazioneDTO> getAll() {
		  return poligonoPopolazioneService.getAllPoligoniPopolazione();
	  }

	  @GetMapping("/{id}")
	  PoligonoPopolazioneDTO getById(@PathVariable Integer id) {
	    return poligonoPopolazioneService.getPoligonoPopolazioneById(id);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody PoligonoPopolazioneDTO poligono_pop) { 
		  poligonoPopolazioneService.savePoligono(poligono_pop);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_poligono}")
	  HttpStatus deleteRecord(@PathVariable Integer id_poligono) {
		  poligonoPopolazioneService.deletePoligonoPopolazioneById(id_poligono);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody PoligonoPopolazioneDTO poligono) {
		  poligonoPopolazioneService.updatePoligonoPopolazione(poligono);
		  return HttpStatus.OK;
	  }
}
