package com.progetto.VEBS.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.PoligonoAreaVerdeDTO;
import com.progetto.VEBS.model.dto.PoligonoComuneDTO;
import com.progetto.VEBS.service.PoligonoAreaVerdeService;
import com.progetto.VEBS.service.PoligonoComuneService;

@RestController
@CrossOrigin(origins = "http://localhost:5173")
@RequestMapping("/polcomune")
public class PoligonoComuneController {

	 @Autowired
	  private final PoligonoComuneService poligonoComuneService;

	  public PoligonoComuneController(PoligonoComuneService poligonoComuneService) {
	    this.poligonoComuneService = poligonoComuneService;
	  }
	  
	  @GetMapping()
	  List<PoligonoComuneDTO> getAll() {
		  return poligonoComuneService.getAllPoligoniComuni();
	  }

	  @GetMapping("/{id_poligono}")
	  PoligonoComuneDTO getById(@PathVariable Integer id_poligono) {
	    return poligonoComuneService.getPoligonoComuneById(id_poligono);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody PoligonoComuneDTO poligono_comune) { 
		  poligonoComuneService.savePoligono(poligono_comune);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_poligono}")
	  HttpStatus deleteRecord(@PathVariable Integer id_poligono) {
		  poligonoComuneService.deletePoligonoComuneById(id_poligono);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody PoligonoComuneDTO poligono) {
		  poligonoComuneService.updatePoligonoComune(poligono);
		  return HttpStatus.OK;
	  }
	  
	  @GetMapping("/getcomunefromgeometry/{geom}/")
	  List<Map<String,Object>>  getGeometryComune(@PathVariable String geom) {
		  return poligonoComuneService.getComuneFromGeometry(geom);
	  }
	  
	  @GetMapping("/getstatsnumerosita/{name}/{type}")
	  List<Map<String,Object>> getStatsNumerosita(@PathVariable String name, @PathVariable String type) {
		  return poligonoComuneService.getStatsNumerositaElementi(name);
	  }
}
