package com.progetto.VEBS.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.PoligonoAreaVerdeDTO;
import com.progetto.VEBS.model.entity.Ingresso;
import com.progetto.VEBS.model.entity.PoligonoAreaVerde;
import com.progetto.VEBS.service.PoligonoAreaVerdeService;

@RestController
@CrossOrigin(origins = "http://localhost:5173")
@RequestMapping("/polareaverde")
public class PoligonoAreaVerdeController {

	  @Autowired
	  private final PoligonoAreaVerdeService poligonoAreaVerdeService;

	  public PoligonoAreaVerdeController(PoligonoAreaVerdeService poligonoAreaVerdeService) {
	    this.poligonoAreaVerdeService = poligonoAreaVerdeService;
	  }
	  
	  @GetMapping()
	  List<PoligonoAreaVerdeDTO> getAll() {
		  return poligonoAreaVerdeService.getAllPoligoniAreeVerdi();
	  }

	  @GetMapping("/{id_poligono}")
	  PoligonoAreaVerdeDTO getById(@PathVariable Integer id_poligono) {
	    return poligonoAreaVerdeService.getPoligonoAreaVerdeById(id_poligono);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody PoligonoAreaVerdeDTO poligono_area_verde) { 
		  poligonoAreaVerdeService.savePoligono(poligono_area_verde);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_poligono}")
	  HttpStatus deleteRecord(@PathVariable Integer id_poligono) {
		  poligonoAreaVerdeService.deletePoligonoAreaVerdeById(id_poligono);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody PoligonoAreaVerdeDTO poligono) {
		  poligonoAreaVerdeService.updatePoligonoAreaVerde(poligono);
		  return HttpStatus.OK;
	  }

	  @GetMapping("/fieldstring")
	  Map<String,Object> getFormFields() {
		  return poligonoAreaVerdeService.getFieldsPoligoniAreeVerdi();
	  }
}
