package com.progetto.VEBS.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.progetto.VEBS.model.dto.AreaVerdeDTO;
import com.progetto.VEBS.model.dto.IncidenzaArboreaDTO;
import com.progetto.VEBS.model.entity.AreaVerde;
import com.progetto.VEBS.model.entity.IncidenzaArborea;
import com.progetto.VEBS.service.IncidenzaArboreaService;

@RestController
@CrossOrigin(origins = "http://localhost:5173")
@RequestMapping("/incarb")
public class IncidenzaArboreaController {
	
	  @Autowired
	  private final IncidenzaArboreaService incidenzaArboreaService;

	  public IncidenzaArboreaController(IncidenzaArboreaService incidenzaArboreaService) {
	    this.incidenzaArboreaService = incidenzaArboreaService;
	  }

	  @GetMapping()
	  List<IncidenzaArboreaDTO> getAll() {
	        return incidenzaArboreaService.getAllIncidenzeArboree();
	  }

	  @GetMapping("/{id}")
	  IncidenzaArboreaDTO getById(@PathVariable Integer id) {
	    return incidenzaArboreaService.getIncidenzaArboreaById(id);
	  }
	  
	  @PostMapping("/save")
	  HttpStatus saveRecord(@RequestBody IncidenzaArboreaDTO incidenza_arborea) { 
		  incidenzaArboreaService.saveIncidenzaArborea(incidenza_arborea);
		  return HttpStatus.CREATED;
	  }
	  
	  @DeleteMapping("/delete/{id_incidenza}")
	  HttpStatus deleteRecord(@PathVariable Integer id_incidenza) throws Exception {
		  incidenzaArboreaService.deleteIncidenzaArboreaById(id_incidenza);
		  return HttpStatus.OK;
	  }
	  
	  @PatchMapping("/update")
	  HttpStatus updateRecord(@RequestBody IncidenzaArboreaDTO incidenza) throws Exception {
		  incidenzaArboreaService.updateIncidenzaArborea(incidenza);
		  return HttpStatus.OK;
	  }
}
