package com.progetto.VEBS;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;

@SpringBootApplication(scanBasePackages = {
	    "com.progetto.VEBS.mapper",
	    "com.progetto.VEBS.controller",
	    "com.progetto.VEBS.service",
	    "com.progetto.VEBS.repository",
	    "com.progetto.VEBS.configuration"
	})
/*
 * Questa è un'estensione di WebApplicationInitializer che esegue una SpringApplication da un archivio WAR tradizionale distribuito su un contenitore web. 
 * Questa classe collega i bean Servlet , Filter e ServletContextInitializer dal contesto applicativo al server.
 */
public class VebsApplication extends SpringBootServletInitializer {
	//Questo metodo usa SpringApplicationBuilder per registrare semplicemente la nostra classe come classe di configurazione dell'applicazione:
    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(VebsApplication.class);
    }
    
    public static void main(String[] args) {
        SpringApplication.run(VebsApplication.class, args);
    }

/*
 * Ora, se pacchettizziamo la nostra applicazione come WAR, potremo distribuirla su qualsiasi contenitore web in modo tradizionale, 
 * il che eseguirà anche la logica che abbiamo aggiunto nel metodo configure() .
 * Se vogliamo impacchettarlo come file JAR, dovremo aggiungere la stessa logica al metodo main() 
 * in modo che anche il contenitore incorporato possa rilevarlo.
 */
}
