/**
 * Classe che implementa le funzioni per il calcolo statistico
 */

import { click } from "ol/events/condition";
import { Select } from "ol/interaction";
import { singleClick } from "ol/events/condition";
import {
	getNumDataComune
} from '../utils/apicalls.js';

export function filterLayers(map, typePolygon) {
	if (!map) return;

	map.getLayers().forEach(layer => {
		const name = layer.values_.title;
		
		// evita di nascondere OSM
		if (name && name === "Openstreetmap") {
		  return;
		}
		if (name && name.startsWith(typePolygon)) {
			layer.setVisible(true);
		} else {
			layer.setVisible(false);
		}
	});
}


// Interazione selezione geometria
const selectGeometryStats = new Select({
	condition: singleClick,
});

export async function addOverlayStats(setStatsOverlayOpen, setDataStats, selectedFeatureStats, setAlertDialogOpen, setDescriptionAlertDialog) {

	if (selectedFeatureStats) {
		setDataStats(await fetchDataNumerosita(selectedFeatureStats.values_.comune));
		setStatsOverlayOpen(true);
	} else {
		setDescriptionAlertDialog("Errore, seleziona una geometria prima di visualizzare la statistica");
		setAlertDialogOpen(true);
	}

	return true;
}

export function addSelectInteraction(map, setSelectedFeatureStats) {

	map.addInteraction(selectGeometryStats);

	selectGeometryStats.on("select", async (e) => {
		const feature = e.selected[0];

		if (feature)
			setSelectedFeatureStats(feature);
	});
}

export function removeOverlay(map, setDataStats, setStatsOverlayOpen, setAlertDialogOpen, setDescriptionAlertDialog, setSelectedFeatureStats){
	
	map.removeInteraction(selectGeometryStats);
	setDataStats(null);
	setStatsOverlayOpen(false);
	setAlertDialogOpen(false);
	setSelectedFeatureStats(null);
	setDescriptionAlertDialog(null);
	
}

// funzione per la fetch dei dati per statistiche numerosità elementi
async function fetchDataNumerosita(comune) {

	try {
		const dataResp = await getNumDataComune(comune);
		const dataJson = await dataResp.json();

		return dataJson;
	} catch (err) {
		console.error("Errore nel fetch dei dati della statistica del comune:", err);
	}
}