/**
 *  Classe contenente i modali per la modifica dei dati
 */

import { Check, ChevronsUpDown } from "lucide-react"
import {
	Dialog, DialogHeader, DialogTitle, DialogDescription,
	DialogContent, DialogFooter, DialogClose
} from "../../components/ui/dialog";
import { Input } from "../../components/ui/input";
import { Label } from "../../components/ui/label";
import { Button } from "../../components/ui/button";
import {
	Popover,
	PopoverContent,
	PopoverTrigger,
} from "../../components/ui/popover";
import { cn } from "../../lib/utils"
import { Calendar } from "../../components/ui/calendar";
import {
	Command,
	CommandEmpty,
	CommandGroup,
	CommandInput,
	CommandItem,
	CommandList,
} from "../../components/ui/command"
import { getArea } from 'ol/sphere.js';
import { Checkbox } from "../../components/ui/checkbox"
import {
	Select,
	SelectTrigger,
	SelectValue,
	SelectContent,
	SelectItem
} from "../../components/ui/select"
import ModalTableSelector from "./Selector"

// Form per la modifica dati delle geometrie poligopni a
export const FormPoligonoAreaVerde = (open, onClose, handleSubmit, formData, handleChange, handleCancel, openDatePicker, setOpenDatePicker, date, setDate, area, setArea, areaButton, setAreaButton, setFormData) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:maxw[425px]">
					<DialogHeader>
						<DialogTitle>Modifica i dettagli del poligono</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al poligono.
						</DialogDescription>
					</DialogHeader>
					<div className="grid gap7 py4">
						<div className="flex flexcol gap2">
							<Label htmlFor="id" className="textxl fontmedium textgray700">Id</Label>
							<Input id="id" name="id" value={formData.id} onChange={handleChange} />
						</div>
						<div className="flex flexcol gap2">
							<Label htmlFor="nome" className="textxl fontmedium textgray700">Nome</Label>
							<Input id="nome" name="nome" value={formData.nome} onChange={handleChange} />
						</div>
						<div className="flex flexcol gap2">
							<Label htmlFor="densita_alberi" className="textxl fontmedium textgray700">Densità alberi</Label>
							<Input id="densita_alberi" name="densita_alberi" value={formData.densita_alberi} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area" className="textxl fontmedium textgray700">Area</Label>
							<Input disabled={Boolean(area)} id="area" name="area" value={formatArea(area)} onChange={handleChange} />
							{areaButton && (
								<Button
									onClick={() => formData.area = calculateArea(formData.geometry, setArea, setAreaButton, setFormData)}
									disabled={Boolean(formData.area)}
								>
									Calcola Area
								</Button>
							)}
						</div>
						<div className="flex flexcol gap2">
							<Label htmlFor="comune" className="textxl fontmedium textgray700">Comune</Label>
							<Input id="comune" name="comune" value={formData.comune} onChange={handleChange} />
						</div>
						<div className="flex flexcol gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formData.data ? formData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>
					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog>
	);
};

// Form per la modifica dati delle geometrie aree blu
export const FormAreaBlu = (open, onClose, handleSubmit, formData, handleChange, handleCancel, openDatePicker, setOpenDatePicker, date, setDate, area, setArea, areaButton, setAreaButton, setFormData) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:maxw[425px]">
					<DialogHeader>
						<DialogTitle>Modifica i dettagli del poligono</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al poligono.
						</DialogDescription>
					</DialogHeader>
					<div className="grid gap7 py4">
						<div className="flex flex-col gap2">
							<Label htmlFor="id" className="textxl fontmedium textgray700">Id</Label>
							<Input disabled id="id" name="id" value={formData.id || ''} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="nome" className="textxl fontmedium textgray700">Nome</Label>
							<Input id="nome" name="nome" value={formData.nome} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area" className="textxl fontmedium textgray700">Area</Label>
							<Input disabled={Boolean(area)} id="area" name="area" value={formatArea(area)} onChange={handleChange} />
							{areaButton && (
								<Button
									onClick={() => formData.area = calculateArea(formData.geometry, setArea, setAreaButton, setFormData)}
									disabled={Boolean(formData.area)}
								>
									Calcola Area
								</Button>
							)}
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="comune" className="textxl fontmedium textgray700">Comune</Label>
							<Input id="comune" name="comune" value={formData.comune} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formData.data ? formData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>
					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog>
	);
};


export const FormAreaVerde = (open, onClose, handleSubmit, formData, handleChange, handleCancel, openDatePicker, setOpenDatePicker, date, setDate, area, setArea, areaButton, setAreaButton, setFormData, poligonoChecked, setPoligonoChecked) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:maxw[425px]">
					<DialogHeader>
						<DialogTitle>Inserisci i dettagli del poligono</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al poligono.
						</DialogDescription>
					</DialogHeader>
					<div className="grid gap7 py4">
						<div className="flex flex-col gap2">
							<Label htmlFor="id" className="textxl fontmedium textgray700">Id</Label>
							<Input disabled id="id" name="id" value={formData.id || ''} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="nome" className="textxl fontmedium textgray700">Nome</Label>
							<Input id="nome" name="nome" value={formData.nome || ''} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="densita_alberi" className="textxl fontmedium textgray700">Densità alberi</Label>
							<Input id="densita_alberi" name="densita_alberi" value={formData.densita_alberi} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="ubicazione" className="textxl fontmedium textgray700">Ubicazione</Label>
							<Input id="ubicazione" name="ubicazione" value={formData.ubicazione} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area" className="textxl fontmedium textgray700">Area</Label>
							<Input disabled={Boolean(area)} id="area" name="area" value={formatArea(area)} onChange={handleChange} />
							{areaButton && (
								<Button
									onClick={() => formData.area = calculateArea(formData.geometry, setArea, setAreaButton, setFormData)}
									disabled={Boolean(formData.area)}
								>
									Calcola Area
								</Button>
							)}
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="comune" className="textxl fontmedium textgray700">Comune</Label>
							<Input id="comune" name="comune" value={formData.comune} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formData.data ? formData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>
						<div className="w-full p-6 flex justify-center">
							<div className="space-y-4">
								<div className="flex items-center gap-3">
									<Checkbox id="poligono_area_verde_check"
										checked={poligonoChecked}
										onCheckedChange={(checked) => {
											setPoligonoChecked(checked === true);
											setFormData((prev) => ({
												...prev,
												controllo_poligono: checked === true,
											}));
										}}
									/>
									<Label htmlFor="poligono_area_verde_check"> Salva come poligono area verde</Label>
								</div>
							</div>
						</div>
					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog>
	);
};

export const FormIngresso = (open, onClose, handleSubmit, formData, handleChange, handleCancel, openDatePicker, setOpenDatePicker, date, setDate, areeBlu,
	areeVerdi, valueAreaBlu, setValueAreaBlu, valueAreaVerde, setValueAreaVerde, push, setOpenSelector) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:maxw[425px]">
					<DialogHeader>
						<DialogTitle>Inserisci i dettagli dell'ingresso</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al punto.
						</DialogDescription>
					</DialogHeader>
					<div className="grid gap7 py4">
						<div className="flex flexcol gap2">
							<Label htmlFor="id" className="textxl fontmedium textgray700">Id</Label>
							<Input disabled id="id" name="id" value={formData.id || ''} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="nome" className="textxl fontmedium textgray700">Nome</Label>
							<Input id="nome" name="nome" value={formData.nome || ''} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area_blu" className="textxl fontmedium textgray700">Area blu</Label>

							<Button type="button" onClick={() =>
								push(
									<ModalTableSelector
										open={true}
										data={areeBlu}
										setValue={setValueAreaBlu}
										onClose={() => setOpenSelector(false)}
									/>
								)
							} onChange={handleChange}>
								{valueAreaBlu ? changeButtonValue(valueAreaBlu, formData, "area_blu") : "Seleziona Area blu"}
							</Button>

						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area_verde" className="textxl fontmedium textgray700">Area verde</Label>

							<Button type="button" onClick={() =>
								push(
									<ModalTableSelector
										open={true}
										data={areeVerdi}
										setValue={setValueAreaVerde}
										onClose={() => setOpenSelector(false)}
									/>
								)
							} onChange={handleChange}>
								{valueAreaVerde ? changeButtonValue(valueAreaVerde, formData, "area_verdi") : "Seleziona Area verdi"}
							</Button>

						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formData.data ? formData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>
					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog >
	);
};

export const FormDisegnoPoligono = (open, onClose, handleSubmit, handleCancel, formDrawGeometryData, handleChange, openDatePicker, setOpenDatePicker, date, setDate, tipiInserimentoGeometria, valueTipoGeometria, setValueTipoGeometria, comune) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:max-w-[425px]"
					// blocca click esterno al modale
					onInteractOutside={(e) => e.preventDefault()}
					onEscapeKeyDown={(e) => e.preventDefault()}
				>
					<DialogHeader>
						<DialogTitle>Inserisci i dettagli del poligono</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al poligono.
						</DialogDescription>
					</DialogHeader>

					<div className="grid gap-7 py-4">
						<div className="flex flex-col gap2">
							<Label htmlFor="tipo_poligono" className="textxl fontmedium textgray700">Tipo poligono</Label>
							<Select
								value={valueTipoGeometria ? valueTipoGeometria : ""}
								onValueChange={(val) => {
									setValueTipoGeometria(val)
									formDrawGeometryData.tipo_geometria = val;
								}
								}
							>
								<SelectTrigger className="w-[500px]">
									<SelectValue placeholder="Seleziona tipo geometria..." />
								</SelectTrigger>
								<SelectContent>
									{tipiInserimentoGeometria.map((tipo) => (
										<SelectItem key={tipo.id} value={tipo.id}>
											{tipo.nome}
										</SelectItem>
									))}
								</SelectContent>
							</Select>
						</div>

						<div className="flex flex-col gap-2">
							<Label htmlFor="nome" className="text-xl font-medium text-gray-700">Nome</Label>
							<Input id="nome" name="nome" value={formDrawGeometryData.nome} onChange={handleChange} />
						</div>
						{valueTipoGeometria === "Poligono area verde" && (
							<div className="flex flex-col gap-2">
								<Label htmlFor="densita_alberi" className="text-xl font-medium text-gray-700">Densità alberi</Label>
								<Input id="densita_alberi" name="densita_alberi" value={formDrawGeometryData.densita_alberi} onChange={handleChange} />
							</div>
						)}
						<div className="flex flex-col gap-2">
							<Label htmlFor="area" className="text-xl font-medium text-gray-700">Area</Label>
							<Input id="area" name="area" value={formatArea(formDrawGeometryData.area)} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap-2">
							<Label htmlFor="comune" className="text-xl font-medium text-gray-700">Comune di riferimento</Label>
							<Input disabled id="comune" name="comune" value={comune || ''} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formDrawGeometryData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formDrawGeometryData.data ? formDrawGeometryData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>

					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog>

	)
}

export const FormDisegnoPunto = (open, onClose, handleSubmit, handleCancel, formDrawGeometryData, handleChange, openDatePicker, setOpenDatePicker, date, setDate, areeBlu,
	areeVerdi, valueAreaBlu, setValueAreaBlu, valueAreaVerde, setValueAreaVerde, comune, push, setOpenSelector) => {
	return (
		<Dialog open={open} onOpenChange={onClose} onSubmit={handleSubmit}>
			<form>
				<DialogContent className="sm:max-w-[425px]"
					style={{ zIndex: 100, width: 500 }}
					// blocca click esterno al modale
					onInteractOutside={(e) => e.preventDefault()}
					onEscapeKeyDown={(e) => e.preventDefault()}
				>
					<DialogHeader>
						<DialogTitle>Inserisci i dettagli dell'ingresso</DialogTitle>
						<DialogDescription>
							Compila i campi e salva per associare i dati al punto.
						</DialogDescription>
					</DialogHeader>
					<div className="grid gap7 py4">
						<div className="flex flex-col gap2">
							<Label htmlFor="nome" className="textxl fontmedium textgray700">Nome</Label>
							<Input id="nome" name="nome" value={formDrawGeometryData.nome || ''} onChange={handleChange} />
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area_blu" className="textxl fontmedium textgray700">Area blu</Label>

							<Button type="button" onClick={() =>
								push(
									<ModalTableSelector
										open={true}
										data={areeBlu}
										setValue={setValueAreaBlu}
										onClose={() => setOpenSelector(false)}
									/>
								)
							} onChange={handleChange}>
								{valueAreaBlu ? changeButtonValue(valueAreaBlu, formDrawGeometryData, "area_blu") : "Seleziona Area blu"}
							</Button>

						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="area_verde" className="textxl fontmedium textgray700">Area verde</Label>

							<Button type="button" onClick={() =>
								push(
									<ModalTableSelector
										open={true}
										data={areeVerdi}
										setValue={setValueAreaVerde}
										onClose={() => setOpenSelector(false)}
									/>
								)}>{valueAreaVerde ? changeButtonValue(valueAreaVerde, formDrawGeometryData, "area_verde") : "Seleziona Area verde"}
							</Button>
						</div>
						<div className="flex flex-col gap2">
							<Label htmlFor="data" className="textxl fontmedium textgray700">Data</Label>
							<Popover open={openDatePicker} onOpenChange={setOpenDatePicker} value={formDrawGeometryData.data}>
								<PopoverTrigger asChild>
									<Button disabled
										variant="outline"
										id="date"
										className="w48 justify-between fontnormal"
									>
										{formDrawGeometryData.data ? formDrawGeometryData.data.toLocaleDateString() : "Seleziona data"}
									</Button>
								</PopoverTrigger>
								<PopoverContent className="wauto overflowhidden p0" align="start">
									<Calendar
										mode="single"
										selected={date}
										captionLayout="dropdown"
										onSelect={(date) => {
											setDate(date)
											setOpenDatePicker(false)
										}}
									/>
								</PopoverContent>
							</Popover>
						</div>

						<div className="flex flex-col gap2">

							<Label htmlFor="comune" className="textxl fontmedium textgray700">Comune di riferimento</Label>
							<Input disabled id="comune" name="comune" value={comune || ''} />

						</div>

					</div>
					<DialogFooter>
						<DialogClose asChild>
							<Button type="button" variant="outline" onClick={handleCancel}>Annulla</Button>
						</DialogClose>
						<Button type="button" onClick={handleSubmit}>Salva</Button>
					</DialogFooter>
				</DialogContent>
			</form>
		</Dialog >
	);
}

/*<Select
								value={valueAreaVerde ? valueAreaVerde : ""}
								onValueChange={(val) => {
									setValueAreaVerde(val)
									formDrawGeometryData.area_verde = val;
								}
								}
							>
								<SelectTrigger className="w-[500px]">
									<SelectValue placeholder="Seleziona area verde..." />
								</SelectTrigger>
								<SelectContent>
									{areeVerdi.map((areaVerde) => (
										<SelectItem key={areaVerde.id} value={areaVerde.id}>
											{areaVerde.nome}
										</SelectItem>
									))}
								</SelectContent>
							</Select>*/

function calculateArea(geometry, setArea, setAreaButton, setFormData) {
	var area;
	area = getArea(geometry);
	setArea(area);
	setAreaButton(false);
	setFormData((prev) => ({ ...prev, area: area }));
}

const formatArea = (value) => {
	if (!value) return "0 m²";
	return `${new Intl.NumberFormat("IT", {
		maximumFractionDigits: 2,
	}).format(value)} m²`;
};


function changeButtonValue(recordSelected, formGeometryData, area) {

	if (area === "area_blu")
		formGeometryData.area_blu = recordSelected.id;
	else
		formGeometryData.area_verde = recordSelected.id;

	return (recordSelected.nome === null) ? "Nome non definito" : recordSelected.nome;
}

