/**
 * Classe che definisce la mappa principale
 */

import VectorSource from "ol/source/Vector";
import VectorLayer from "ol/layer/Vector";
import GeoJSON from "ol/format/GeoJSON";
import { Style, Fill, Stroke, Circle } from "ol/style";
import { bbox } from "ol/loadingstrategy"


const key = 'yu9dNHW3LWkQvjqVbnXn';

const source = new VectorSource({wrapX: false});

export const drawLayer = new VectorLayer({
	source: source,
	displayInLayerSwitcher: false
})

//Layer aree verdi del comune di catanzaro
export const CZLayerAreeVerdiComune = new VectorLayer({
	title: 'Aree Verdi Catanzaro',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:area_verde_catanzaro_comune&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'blue',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer aree verdi del comune di casalecchio
export const layerAreeVerdiCasalecchioComune = new VectorLayer({
	title: 'Aree Verdi Casalecchio di Reno',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:area_verde_casalecchio_comune&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'blue',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer delle aree verdi dei comuni ricavate da openstreetmap
export const layerAreeVerdiOpenStreetMap = new VectorLayer({
	title: 'Aree Verdi OpenStreetMap',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:area_verde_osm&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'green',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer degli ingressi delle aree verdi e blu
export const layerIngressi = new VectorLayer({
	title: 'Ingressi',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:ingressi&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		image: new Circle({
			radius: 4,
			fill: new Fill({ color: 'red' }),
			stroke: new Stroke({ color: 'white', width: 1 })
		})
	})
});

//Layer centroidi edifici Catanzaro
export const CZLayerCentroidi = new VectorLayer({
	title: 'Edifici Catanzaro',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:edifici_pop_cz_view&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		image: new Circle({
			radius: 4,
			fill: new Fill({ color: 'black' }),
			stroke: new Stroke({ color: 'white', width: 1 })
		})
	})
});

//Layer confini amministrativi aquila
export const layerComuneAquila = new VectorLayer({
	title: 'Comune L\'Aquila',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:comune_aquila&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'grey',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer confini amministrativi catanzaro
export const layerComuneCatanzaro = new VectorLayer({
	title: 'Comune Catanzaro',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:comune_catanzaro&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'grey',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer confini amministrativi casalecchio
export const layerComuneCasalecchio = new VectorLayer({
	title: 'Comune Casalecchio di Reno',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:comune_casalecchio&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'grey',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer confini amministrativi terracina
export const layerComuneTerracina = new VectorLayer({
	title: 'Comune Terracina',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:comune_terracina&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'grey',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer confini amministrativi pescara
export const layerComunePescara = new VectorLayer({
	title: 'Comune Pescara',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:comune_pescara&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'grey',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});

//Layer delle sezioni censuarie dei comuni
export const layerSezioniCensuarie = new VectorLayer({
	title: 'Sezioni Censuarie',
	visible: true,
	source: new VectorSource({
		format: new GeoJSON(),
		url: function(extent) {
			return `http://localhost:8080/geoserver/Progetto_VeBS/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=Progetto_VeBS:sezioni_censuarie&outputFormat=application/json&srsname=EPSG:3857&bbox=${extent.join(',')},EPSG:3857`;
		},
		strategy: bbox
	}),
	style: new Style({
		stroke: new Stroke({
			color: 'black',
			width: 2
		}),
		fill: new Fill({
			color: 'rgba(0, 0, 255, 0.1)'
		})
	})
});


