/**
 * Classe che definisce le funzioni per le modifiche dei dati rappresentati sulla mappa
 */

import { Select } from "ol/interaction";
import PopupFeature from "./PopupFeature.js";
import { singleClick } from "ol/events/condition";

// Interazione selezione geometria
const selectGeometryPopup = new Select({
	condition: singleClick,
});

// aggiunta popup alle feature
export function addPopup(map) {

	// Aggiungo interazione alla mappa
	map.addInteraction(selectGeometryPopup);

	const popup = new PopupFeature({
		popupClass: 'default anim',
		positioning: 'auto',
		autoPan: true,
		offset: [0, -20],
		select: selectGeometryPopup,
		closeBox: true,
		template: {
			title: function() {
				return "Dettaglio";
			},
			attributes:
			{
				'nome': {
					title: 'Nome',
					visible: function(f) {
						return f.get('nome') !== null;
					}
				},
				'densita_alberi': {
					title: 'Densità alberi',
					visible: function(f) {
						return f.get('densita_alberi') !== null;
					}
				},
				'ubicazione': {
					title: 'Ubicazione',
					visible: function(f) {
						return f.get('ubicazione') !== null;
					}
				},
				'area': {
					title: 'Area',
					format: PopupFeature.localString,
					after: ` m<sup>2</sup>`,
					visible: function(f) {
						return formatArea(f.get('area')) !== null;
					}
				},
				'comune': {
					title: 'Comune',
					visible: function(f) {
						return f.get('comune') !== null;
					}
				},
				'fonte_dati': {
					title: 'Fonte dati',
					visible: function(f) {
						return f.get('fonte_dati') !== null;
					}
				},
				'id': {
					title: 'Id',
					visible: function(f) {
						return f.get('id') !== null;
					}
				},
				'area_verde': {
					title: 'Id area verde',
					visible: function(f) {
						return f.get('area_verde') !== null;
					}
				},
				'area_blu': {
					title: 'Id area blu',
					visible: function(f) {
						return f.get('area_blu') !== null;
					}
				},
			}
		}
	});

	// Aggiungo interazione alla mappa
	map.addInteraction(selectGeometryPopup);
	
	//setto attivo l'interaction
	selectGeometryPopup.setActive(true);

	// Aggiungo il popup alla mappa
	map.addOverlay(popup);
	
	return popup;
}

// rimuove popup e interazione alle feature
export function removePopup(map, popup) {
	
	map.removeControl(popup);
	map.removeInteraction(selectGeometryPopup);
	
}

const formatArea = (value) => {
	if (!value) return "0 m²";
	return `${new Intl.NumberFormat("IT", {
		maximumFractionDigits: 2,
	}).format(value)} m²`;
};