/**
 * Classe che implementa la funzionalità di calcolo percorsi
 */
import ContextMenu from "ol-contextmenu/dist/ol-contextmenu";
import Point from "ol/geom/Point.js"
import { getAllPointsWithinDistance } from "./apicalls.js";
import { Feature } from "ol";
import { LineString } from "ol/geom";
import { Vector as VectorLayer } from "ol/layer";
import { Vector as VectorSource } from "ol/source";
import { Stroke, Style } from "ol/style";

// Icone ol-contextmenu
var pinIcon = 'https://cdn.jsdelivr.net/gh/jonataswalker/ol-contextmenu@604befc46d737d814505b5d90fc171932f747043/examples/img/pin_drop.png';
var centerIcon = 'https://cdn.jsdelivr.net/gh/jonataswalker/ol-contextmenu@604befc46d737d814505b5d90fc171932f747043/examples/img/center.png';


const contextmenu = new ContextMenu({
	width: 200,
	items: [
		{
			text: 'Centra la mappa',
			icon: centerIcon,
			callback: ({ coordinate }) => map.getView().setCenter(coordinate),
		},
		{
			text: 'Coordinate del punto',
			icon: pinIcon,
			callback: (obj) => alert(obj.coordinate)
		},
	]
});

const routeLayer = new VectorLayer({
	title: 'Percorso',
	displayInLayerSwitcher: false
});

// creazione contextmenu
export function addContextMenu(map, setStartingPoint) {

	var feature;

	// creo un elemento del contextmenu per il calcolo e la visualizzazione del percorso da edificio a areaverde
	const selectStartingPointItem = {
		text: 'Seleziona partenza',
		icon: pinIcon,
		callback: selectStartingPoint
	};

	// aggiunta funzionalità opzionali al contextmenu
	contextmenu.on('open', function(e) {
		feature = map.forEachFeatureAtPixel(e.pixel, function(f, l) {
			return f;
		});

		if (feature) {
			if (feature.id_.startsWith("edifici_pop") && contextmenu.countItems() > 4) {
				contextmenu.pop();
				selectStartingPointItem.data = { point: feature}
				contextmenu.push(selectStartingPointItem);
			} else {
				if (contextmenu.countItems() > 4)
					contextmenu.pop();
				if (feature.id_.startsWith("edifici_pop")) {
					selectStartingPointItem.data = { point: feature}
					contextmenu.push(selectStartingPointItem);
				}
			}
		} else {
			if (contextmenu.countItems() > 4)
				contextmenu.pop();
		}

	});

	map.addControl(contextmenu);

	function selectStartingPoint(f) {
		setStartingPoint(f.data.point);
	}

	return contextmenu;
}


// funzionalità calcolo percorso verso area verde da contextmenu
export async function calculatePath(f, map, profile) {

	const centroideCoordinate = f.geometryChangeKey_.target.flatCoordinates;
	const ingressi = await fetchIngressiAreeVerdi(f.values_.building_c, 10000);
	var centroideCoordinatePoint = new Point(centroideCoordinate);
	var centroideCoordinatePointConvert = centroideCoordinatePoint.transform("EPSG:3857", "EPSG:4326");

	var minDistance = 0;
	var dataRoute;
	var dataRouteMinDistance;

	for (let ingresso of ingressi) {

		var ingressoCoordinatePoint = new Point([ingresso.latitudine, ingresso.longitudine])
		var ingressoCoordinatePointConvert = ingressoCoordinatePoint.transform("EPSG:3857", "EPSG:4326");
		dataRoute = await getRoute(centroideCoordinatePointConvert.getCoordinates(), ingressoCoordinatePointConvert.getCoordinates(), profile);
		var summaryDistance = dataRoute.features[0].properties.summary.distance;
		if (minDistance === 0) {
			minDistance = summaryDistance;
			dataRouteMinDistance = dataRoute;
		} else if (summaryDistance < minDistance) {
			minDistance = summaryDistance;
			dataRouteMinDistance = dataRoute;
		}
	}

	addRouteToMap(map, dataRouteMinDistance.features[0].geometry.coordinates);

}

export function changeItemRemovePathFunction(map, setStartingPoint){
	map.removeControl(contextmenu);
	map.removeLayer(routeLayer);
	setStartingPoint(null);
}

export function removePath(map){
	map.removeLayer(routeLayer);
}

async function fetchIngressiAreeVerdi(geomWKT, distance) {
	try {
		const ingressiAreeVerdiResp = await getAllPointsWithinDistance(geomWKT, distance);
		const ingressiAreeVerdiJson = await ingressiAreeVerdiResp.json();
		return ingressiAreeVerdiJson;
	} catch (err) {
		console.error("Errore nel fetch dei dati delle aree:", err);
	}
	return;
}

export async function getRoute(start, end, profile) {
	try {
		const response = await fetch("https://api.openrouteservice.org/v2/directions/" + profile + "/geojson", {
			method: "POST",
			headers: {
				"Accept": "application/json, application/geo+json, application/gpx+xml, img/png; charset=utf-8",
				"Content-Type": "application/json",
				"Authorization": "eyJvcmciOiI1YjNjZTM1OTc4NTExMTAwMDFjZjYyNDgiLCJpZCI6ImE4M2ExZWE5M2MyZTQ1YjA4ZmNlZjNlNjBlNmJiZWY2IiwiaCI6Im11cm11cjY0In0="
			},
			body: JSON.stringify({
				coordinates: [start, end]
			})
		});

		if (!response.ok) throw new Error("Errore API " + response.status);
		return await response.json();

	} catch (err) {
		console.error("Errore durante getRoute:", err);
		return null;
	}
};

export const addRouteToMap = (map, routeCoordinates) => {
	
	const route = new Feature({
		geometry: new LineString(routeCoordinates).transform("EPSG:4326", "EPSG:3857"),
	});

	route.setStyle(
		new Style({
			stroke: new Stroke({
				color: "#ff0000",
				width: 3,
			}),
		})
	);

	
	const routeSource = new VectorSource({
		features: [route],
	});

	routeLayer.setSource(routeSource);

	//var layer = map.getLayers(layer => (layer === routeLayer)? return layer : return null)
	
	map.addLayer(routeLayer);
};


