/*
*	Classe che definisce le chiamate api rest dell'applicazione
*/

import { distance } from "ol/coordinate";

// API Rest per i nomi dei campi
export function getStringOfForm(str) {
	return fetch('http://localhost:8081/VEBS/' + str + '/fieldstring', {
		method: 'GET'
	});
};

//API Rest per il salvataggio dati delle geometrie
export function handleFormDataDrawSubmit(data) {
	if (data.tipo_geometria === "Poligono area verde") {

		return fetch('http://localhost:8081/VEBS/polareaverde/save', {
			method: 'POST',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	} else if (data.tipo_geometria === "Area blu") {

		return fetch('http://localhost:8081/VEBS/areablu/save', {
			method: 'POST',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	} else {
		var area_verde = data.area_verde;
		var area_blu = data.area_blu;
		data.area_verde = null;
		data.area_blu = null;
		return fetch('http://localhost:8081/VEBS/ingresso/save/' + area_verde + '/' + area_blu, {
			method: 'POST',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	}
};

//API Rest per la gestione del salavataggio di modifiche delle geometrie selezionate
export function handleFormDataSubmit(data) {

	if (data.controllo_poligono && data.poligono_area_verde) {
		var id_poligono_area_verde = data.poligono_area_verde;
		data.poligono_area_verde = null;
		return fetch('http://localhost:8081/VEBS/' + data.tipo + '/update/polareaverde_update/' + id_poligono_area_verde, {
			method: 'PATCH',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	} else if (data.tipo === 'ingresso') {
		var area_verde = data.area_verde;
		var area_blu = data.area_blu;
		data.area_verde = null;
		data.area_blu = null;
		return fetch('http://localhost:8081/VEBS/' + data.tipo + '/update/' + area_verde + '/' + area_blu, {
			method: 'PATCH',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	} else if (data.controllo_poligono) {
		return fetch('http://localhost:8081/VEBS/' + data.tipo + '/update/polareaverde_create', {
			method: 'PATCH',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});

	} else {
		return fetch('http://localhost:8081/VEBS/' + data.tipo + '/update', {
			method: 'PATCH',
			headers: { 'Content-Type': 'application/json;charset=utf-8' },
			body: JSON.stringify(data)
		});
	}
};


//API Rest per ricavarsi l'insieme di aree verdi
export function getAllAreeVerdi() {
	return fetch('http://localhost:8081/VEBS/areaverde', {
		method: 'GET'
	});
};

//API Rest per ricavarsi l'insieme di aree verdi del comune specificato
export async function getAllAreeVerdiFromComune(comune) {
	return await fetch('http://localhost:8081/VEBS/areaverde/filterbycomune/' + comune, {
		method: 'GET'
	});
};

//API Rest per ricavarsi l'insieme degli id e dei nomi delle aree verdi
export function getAllIdNomeAreeVerdi() {
	return fetch('http://localhost:8081/VEBS/areaverde/get_all_id_nome', {
		method: 'GET'
	});
};

//API Rest per ricavarsi l'insieme di aree blu
export function getAllAreeBlu() {
	return fetch('http://localhost:8081/VEBS/areablu', {
		method: 'GET'
	});
};

//API Rest per ricavarsi l'insieme di aree blu del comune specificato
export async function getAllAreeBluFromComune(comune) {
	return await fetch('http://localhost:8081/VEBS/areablu/filterbycomune/' + comune, {
		method: 'GET'
	});
};

//API Rest per ricavarsi l'insieme di ingressi entro una distanza specifica
export async function getAllPointsWithinDistance(geomWKT, distance) {
	return await fetch('http://localhost:8081/VEBS/ingresso/getingressiareeverdi/' + geomWKT + '/' + distance + '/', {
		method: 'GET'
	});
};

//API Rest per ricavarsi il comune di riferimento per la geometria disegnata
export async function getComuneFromGeometry(geomWKT) {
	return await fetch('http://localhost:8081/VEBS/polcomune/getcomunefromgeometry/' + geomWKT + '/', {
		method: 'GET'
	});
};

//API Rest per statistiche numerosità dati per comune
export function getNumDataComune(comune,tipoStatistica) {
	return fetch('http://localhost:8081/VEBS/polcomune/getstatsnumerosita/' + comune + '/' + tipoStatistica + '/', {
		method: 'GET'
	});
};

//API Rest per ricavarsi un area verde dall' id
export async function getAreaVerdeFromId(id) {
	return await fetch('http://localhost:8081/VEBS/areaverde/' + id, {
		method: 'GET'
	});
};

//API Rest per ricavarsi un area blu dall' id
export async function getAreaBluFromId(id) {
	return await fetch('http://localhost:8081/VEBS/areablu/' + id, {
		method: 'GET'
	});
};

