/**
 * 
 */

import wellknown from "wellknown";

function WktPreview({ wkt, size = 5 }) {
  if (!wkt) return null;

  const geojson = wellknown(wkt);
  if (!geojson || !geojson.coordinates) return null;

  let coords = geojson.coordinates;

  // Per POLYGON: prendere solo l'anello esterno
  if (geojson.type === "Polygon") {
    coords = coords[0];
  }

  // Normalizzazione e scaling
  const xs = coords.map(c => c[0]);
  const ys = coords.map(c => c[1]);
  const minX = Math.min(...xs), maxX = Math.max(...xs);
  const minY = Math.min(...ys), maxY = Math.max(...ys);
  const scale = size / Math.max(maxX - minX || 1, maxY - minY || 1);

  const points = coords.map(([x, y]) => `${(x - minX) * scale},${size - (y - minY) * scale}`).join(" ");

  if (geojson.type === "Point") {
    const [x, y] = points.split(",");
    return <svg width={size} height={size} className="border rounded bg-white"><circle cx={x} cy={y} r={2} fill="blue" /></svg>;
  }

  if (geojson.type === "Polygon" || geojson.type === "LineString") {
    const Element = geojson.type === "Polygon" ? "polygon" : "polyline";
    return <svg width={size} height={size} className="border rounded bg-white"><Element points={points} fill={geojson.type === "Polygon" ? "rgba(0,0,255,0.2)" : "none"} stroke="blue" strokeWidth="1" /></svg>;
  }

  return null;
}

export default WktPreview
