/**
 * 
 */

import {
	Dialog,
	DialogContent,
	DialogDescription,
	DialogHeader,
	DialogTitle,
	DialogTrigger,
} from '../../components/ui/dialog';

import { Button } from '../../components/ui/button';
import { Badge } from '../../components/ui/badge';
import { Loader2, Search } from 'lucide-react';

import Table from 'react-bootstrap/Table';

import { useDialogStack } from '../components/DialogStackProvider';

import WktPreview from './WktPreview'

import React, { useState } from "react"
import WKT from "ol/format/WKT";


function ModalTableSelector({ open, setOpenSelector, loading, data, setValue, onClose }) {

	const { pop } = useDialogStack();

	const [selectedId, setSelectedId] = useState(null);
	const [selectedRecord, setSelectedRecord] = useState(null);
	
	const handleClose = () => {
		pop(); // Rimuove questo dialog dallo stack
	};

	const handleConfirm = () => {
		pop(); // Rimuove questo dialog dallo stack
		onClose();
	};

	const handleRowSelect = (record) => {
		setSelectedId(record.id);
		setSelectedRecord(record);
		setValue(record);
	}


	return (

		<Dialog open={open} onOpenChange={setOpenSelector} >
			<DialogContent
				className="max-w-4xl w-[1000px] max-h-[80vh] flex flex-col"
				style={{ zIndex: 101 }}
			>
				<DialogHeader >
					<DialogTitle>Seleziona un Record</DialogTitle>
					<DialogDescription className="divide-y divide-gray-300">
						Scegli un record dalla tabella sottostante. Clicca su una riga per selezionarla.
					</DialogDescription>
				</DialogHeader>

				<div className="flex-1 overflow-auto">
					{loading ? (
						<div className="flex items-center justify-center py-8">
							<Loader2 className="w-8 h-8 animate-spin" />
							<span className="ml-2">Caricamento dati...</span>
						</div>
					) : (
						<div className="border rounded-md">
							<div className="p-3 border-b bg-muted/30">
								<h4 className="font-medium">Lista dei record disponibili</h4>
							</div>
							<div className="overflow-x-auto">
								<Table responsive>
									<thead>
										<tr className="border-b bg-muted/20">
											{data && data.length > 0 &&
												Object.keys(data[0]).map((key) => (
													<th key={key} className="text-left p-3 font-medium">
														{key.charAt(0).toUpperCase() + key.slice(1)}
													</th>
												))}
										</tr>
									</thead>
									<tbody className="divide-y divide-gray-300">
										{data && data.map((record, rowIndex) => (
											<tr
												key={rowIndex}
												onClick={() => handleRowSelect(record)}
												className={`border-b divide-y divide-gray-300 cursor-pointer 
												    ${selectedId === record.id
														? "bg-blue-100 dark:bg-blue-900"
														: "hover:bg-muted/10"}`}
											>
												{Object.entries(record).map(([key, value], colIndex) => (
													<td key={colIndex} className="p-3">
														{key === "geometria" ? (
															<WktPreview wkt={value} size={60} />
														) : (
															value?.toString()
														)}
													</td>
												))}
											</tr>
										))}
									</tbody>
								</Table>
							</div>
						</div>
					)}
				</div>

				{selectedRecord && (
					<div className="border-t pt-4">
						<div className="bg-muted/30 p-3 rounded-md">
							<h4 className="font-medium mb-1">Record selezionato:</h4>
							<p className="text-sm text-muted-foreground">
								{selectedRecord.nome} (ID: {selectedId})
							</p>
						</div>
					</div>
				)}

				<div className="flex justify-end gap-2 border-t pt-4">
					<Button variant="outline" onClick={handleClose}>
						Annulla
					</Button>
					<Button
						onClick={handleConfirm}
						className="min-w-[100px]"
					>
						Conferma
					</Button>
				</div>
			</DialogContent>
		</Dialog >
	);
}

export default ModalTableSelector