/**
 * Classe che implementa l'overlay con all'interno il grafico
 */
import React, { useEffect, useRef } from "react"
import CirclePacking from "../utils/graphics.jsx"
import { Card, CardHeader, CardContent, CardTitle } from '../../components/ui/Card'



const StatsOverlay = ({ open, onClose, dataStats, typeGraphic }) => {
	if (!open) return null;
	
	let graphic;
	if (typeGraphic) {
	  switch (typeGraphic) {
	    case "Grafico circolare":
	      graphic = <CirclePacking data={dataStats[0]} />;
	      break;
	    default:
	      graphic = <CirclePacking data={dataStats[0]} />;
	      break;
	  }
	}

	return (
		<div
			className="fixed bottom-4 right-4 z-50"
		>
			<Card className="w-[320px] h-[320px] shadow-xl rounded-2xl">
				<CardHeader className="flex flex-row items-center justify-between p-3">
					<CardTitle className="text-sm font-semibold">
						{(dataStats[0].id) ? "Statistiche " + dataStats[0].id : "Statistiche"}
					</CardTitle>
					<button
						onClick={onClose}
						className="text-gray-500 hover:text-gray-800"
					>
						✕
					</button>
				</CardHeader>
				<CardContent className="h-[260px] p-2">
					{graphic}
				</CardContent>
			</Card>
		</div>
	)
};

export default StatsOverlay;