/*
 * File di configurazione della mappa iniziale
*/
import React, { useEffect, useRef } from "react"
import { Map, View } from "ol"
import Tile from "ol/layer/Tile"
import { OSM, ImageTile, XYZ } from "ol/source"
import LayerSwitcher from "ol-ext/control/LayerSwitcher"
import "ol-ext/control/LayerSwitcher.css"
import 'ol/ol.css'
import { fromLonLat } from "ol/proj"
import "ol-ext/overlay/Popup.css";
import {
	drawLayer
} from "../utils/map.js"
import {
	handleFormDataDrawSubmit,
	handleFormDataSubmit
} from "../utils/apicalls.js"

import DialogDrawDataComponent from "./DialogDrawDataComponent.jsx"
import DialogDataComponent from "./DialogDataComponent.jsx"
import AlertComponent from "../utils/alert.jsx"
import ModalTableSelector from "../utils/Selector.jsx"
import DialogStackProvider from "./DialogStackProvider.jsx"
import StatsOverlay from "./StatsComponent.jsx"

const key = 'yu9dNHW3LWkQvjqVbnXn';

// eslint-disable-next-line react-refresh/only-export-components
export var setModalDataOpen;
// eslint-disable-next-line react-refresh/only-export-components
export var setSelectedGeometryFeature;

function MapComponent({ setMap, dialogDrawDataOpen, setDialogDrawDataOpen, setSelectedFeature, selectedFeature, dialogDataOpen, setDialogDataOpen, alertDialogOpen, setAlertDialogOpen, descriptionAlertDialog, openSelector, setOpenSelector, data, dataStats, setStatsOverlayOpen, statsOverlayOpen, map, typeGraphic}) {
	const mapRef = useRef();

	setSelectedGeometryFeature = setSelectedFeature;
	setModalDataOpen = setDialogDataOpen;

	useEffect(() => {

		//Creo la mappa con 3 layer di base ( openstreetmap, satellite e un layer per disegnare )
		const map = new Map({
			target: mapRef.current,
			layers: [
				new Tile({
					source: new OSM(),
					title: 'Openstreetmap'
				}),
				new Tile({
					source: new ImageTile({
						url: 'https://api.maptiler.com/maps/satellite/{z}/{x}/{y}.jpg?key=' + key,
						tileSize: 512,
						maxZoom: 22,
					}),
					title: 'Satellite',
					visible: false,
				}),
				new Tile({
					source: new XYZ({
						url: 'https://mt0.google.com/vt/lyrs=y&x={x}&y={y}&z={z}',
					}),
					title: 'Google Maps',
					visible: false
				}),
				drawLayer
			],
			view: new View({
				center: fromLonLat([12.4964, 41.9028]), // Coordinate di Roma
				zoom: 4,
				extent: [266035.1308, 4336510.4757, 2575793.8761, 5961791.9342],
			}),
			controls: []
		})

		//setto la mappa globale anche per le altre classi
		setMap(map);

		// Inizializzo l'oggetto layerSwitcher
		const layerSwitcher = new LayerSwitcher({
			show_progress: true,
			extent: true,
			trash: true,
			reorder: true
		});

		// Aggiungo il layer Switcher alla mappa
		map.addControl(layerSwitcher);

		// Aggiungo i tooltips per la lunghezza dei poligoni alla mappa
		//addMeasureTooltips(map);


		return () => map.setTarget(undefined)
	}, [])

	return (

		<DialogStackProvider>
			<div>
				<div
					style={{ height: "100%", width: "100%" }}
					ref={mapRef}
					className="absolute inset-0"
				/>
				<DialogDrawDataComponent
					open={dialogDrawDataOpen}
					onClose={() => setDialogDrawDataOpen(false)}
					feature={selectedFeature}
					onSubmit={(data) => handleFormDataDrawSubmit(data)}
					map={map}
				/>
				<DialogDataComponent
					open={dialogDataOpen}
					onClose={() => setDialogDataOpen(false)}
					feature={selectedFeature}
					onSubmit={(data) => handleFormDataSubmit(data)}
				/>
				<AlertComponent
					open={alertDialogOpen}
					onClose={() => setAlertDialogOpen(false)}
					description={descriptionAlertDialog}
				/>
				<ModalTableSelector
					open={openSelector}
					onClose={() => setOpenSelector(false)}
					data={data}
				/>
				<StatsOverlay
					open={statsOverlayOpen}
					onClose={() => setStatsOverlayOpen(false)}
					dataStats={dataStats}
					typeGraphic={typeGraphic}
					map={map}
				/>
			</div>
		</DialogStackProvider>
	)
}

export default MapComponent

