/**
 *  Classe per la gestione dello stack dei dialog caricati
 */

import React, { useState } from 'react';

// Simulazione del DialogStack context
const DialogStackContext = React.createContext({
	push: (component) => { },
	pop: () => { },
	stack: []
});

// Provider per gestire lo stack di dialog
export const DialogStackProvider = ({ children }) => {
	const [stack, setStack] = useState([]);

	const push = (component) => {
		setStack(prev => [...prev, { id: Date.now(), component }]);
	};

	const pop = () => {
		setStack(prev => prev.slice(0, -1));
	};

	const value = { push, pop, stack };

	return (
		<DialogStackContext.Provider value={value}>
			{children}
			{/* Render dello stack di dialog */}
			{stack.map((item, index) => (
				<div key={item.id} style={{ zIndex: 100 + index }}>
					{typeof item.component === "function" ? item.component() : item.component}
				</div>
			))}
		</DialogStackContext.Provider>
	);
};

export default DialogStackProvider

// Hook per usare il dialog stack
export const useDialogStack = () => {
	const context = React.useContext(DialogStackContext);
	if (!context) {
		throw new Error('useDialogStack deve essere usato dentro DialogStackProvider');
	}
	return context;
};