import { formatDistance } from "./nn/_lib/formatDistance.js";
import { formatLong } from "./nn/_lib/formatLong.js";
import { formatRelative } from "./nn/_lib/formatRelative.js";
import { localize } from "./nn/_lib/localize.js";
import { match } from "./nn/_lib/match.js";

/**
 * @category Locales
 * @summary Norwegian Nynorsk locale.
 * @language Norwegian Nynorsk
 * @iso-639-2 nno
 * @author Mats Byrkjeland [@draperunner](https://github.com/draperunner)
 */
export const nn = {
  code: "nn",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
};

// Fallback for modularized imports:
export default nn;
