import { MouseEvent, MutableRefObject } from 'react';
import { CirclePackingDataProps, CirclePackingCommonProps, CirclePackingCustomLayerProps, ComputedDatum, MouseHandlers } from './types';
export declare const useCirclePacking: <Datum>({ data, id, value, valueFormat, width, height, padding, leavesOnly, colors, colorBy, inheritColorFromParent, childColor, }: {
    data: CirclePackingDataProps<Datum>["data"];
    id: CirclePackingCommonProps<Datum>["id"];
    value: CirclePackingCommonProps<Datum>["value"];
    valueFormat?: CirclePackingCommonProps<Datum>["valueFormat"];
    width: number;
    height: number;
    padding: CirclePackingCommonProps<Datum>["padding"];
    leavesOnly: CirclePackingCommonProps<Datum>["leavesOnly"];
    colors: CirclePackingCommonProps<Datum>["colors"];
    colorBy: CirclePackingCommonProps<Datum>["colorBy"];
    inheritColorFromParent: CirclePackingCommonProps<Datum>["inheritColorFromParent"];
    childColor: CirclePackingCommonProps<Datum>["childColor"];
}) => ComputedDatum<Datum>[];
export declare const useCirclePackingZoom: <Datum>(nodes: ComputedDatum<Datum>[], zoomedId: CirclePackingCommonProps<Datum>["zoomedId"], width: number, height: number) => ComputedDatum<Datum>[];
export declare const useCirclePackingLabels: <Datum>({ nodes, label, filter, skipRadius, textColor, }: {
    nodes: ComputedDatum<Datum>[];
    label: CirclePackingCommonProps<Datum>["label"];
    filter: CirclePackingCommonProps<Datum>["labelsFilter"];
    skipRadius: CirclePackingCommonProps<Datum>["labelsSkipRadius"];
    textColor: CirclePackingCommonProps<Datum>["labelTextColor"];
}) => {
    label: string | number;
    textColor: any;
    node: ComputedDatum<Datum>;
}[];
export declare const useNodeMouseHandlers: <Datum>(node: ComputedDatum<Datum>, { onMouseEnter, onMouseMove, onMouseLeave, onClick }: MouseHandlers<Datum>) => Partial<Record<"onMouseEnter" | "onMouseMove" | "onMouseLeave" | "onClick", (event: MouseEvent) => void>>;
export declare const useMouseCircleDetection: <Datum>({ nodes, canvasEl, margin, }: {
    nodes: ComputedDatum<Datum>[];
    canvasEl: MutableRefObject<HTMLCanvasElement | null>;
    margin: {
        top: number;
        left: number;
    };
}) => (event: MouseEvent) => ComputedDatum<Datum> | null | undefined;
/**
 * Memoize the context to pass to custom layers.
 */
export declare const useCirclePackingLayerContext: <Datum>({ nodes, }: {
    nodes: ComputedDatum<Datum>[];
}) => CirclePackingCustomLayerProps<Datum>;
//# sourceMappingURL=hooks.d.ts.map