import { SpringValue } from '@react-spring/web';
import { ComputedDatum, CircleComponent, MouseHandlers, CirclePackingCommonProps } from './types';
/**
 * A negative radius value is invalid for an SVG circle,
 * this custom interpolation makes sure it's either
 * positive or zero.
 */
export declare const interpolateRadius: (radiusValue: SpringValue<number>) => import("@react-spring/web").Interpolation<number, any>;
type CirclesProps<Datum> = {
    nodes: ComputedDatum<Datum>[];
    borderWidth: CirclePackingCommonProps<Datum>['borderWidth'];
    borderColor: CirclePackingCommonProps<Datum>['borderColor'];
    component: CircleComponent<Datum>;
    isInteractive: CirclePackingCommonProps<Datum>['isInteractive'];
    tooltip: CirclePackingCommonProps<Datum>['tooltip'];
} & MouseHandlers<Datum>;
export declare const Circles: <Datum>({ nodes, borderWidth, borderColor, component, isInteractive, onMouseEnter, onMouseMove, onMouseLeave, onClick, tooltip, }: CirclesProps<Datum>) => import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=Circles.d.ts.map