import {
  VectorRenderTile_default,
  VectorTile_default
} from "./chunk-2MLPVNPC.js";
import {
  Graticule_default
} from "./chunk-OEJB6FRX.js";
import {
  ImageCanvas_default
} from "./chunk-TVFF7CEL.js";
import "./chunk-NTUG3B7Q.js";
import "./chunk-6KOFJIRW.js";
import {
  ImageTile_default,
  TileRange_default,
  Tile_default
} from "./chunk-FSUETOXJ.js";
import "./chunk-YCPCBEQR.js";
import "./chunk-MBBF2OY4.js";
import "./chunk-HM3IY3H4.js";
import "./chunk-V7WRBSQ6.js";
import "./chunk-TW6HSYGK.js";
import {
  Feature_default
} from "./chunk-24RUVO6K.js";
import "./chunk-77SNIUMH.js";
import "./chunk-JFXZSSOM.js";
import "./chunk-SSPX56W7.js";
import {
  MapBrowserEventHandler_default,
  Map_default
} from "./chunk-OKY35EEM.js";
import {
  TileQueue_default
} from "./chunk-IB5MK4QP.js";
import {
  Kinetic_default
} from "./chunk-Q75E7BJS.js";
import "./chunk-UABYZKA2.js";
import "./chunk-5D2XPBR2.js";
import "./chunk-JDEWAWZ6.js";
import "./chunk-YB4TBLRJ.js";
import {
  View_default
} from "./chunk-TRTK4IFM.js";
import "./chunk-7GQYZ5UY.js";
import {
  Image_default
} from "./chunk-H5WJA5U2.js";
import "./chunk-ABYLXAPS.js";
import {
  Collection_default
} from "./chunk-XTZQTSWS.js";
import "./chunk-RW3V7S4F.js";
import "./chunk-LMC3RO5P.js";
import "./chunk-IJBK5CNT.js";
import {
  circular
} from "./chunk-FCPHVQUR.js";
import "./chunk-7O5CJMRQ.js";
import {
  get,
  getTransformFromProjections,
  identityTransform
} from "./chunk-Q35WOPMB.js";
import "./chunk-ZLPTRF2L.js";
import "./chunk-QFCIXVZ3.js";
import "./chunk-PCFFPN3V.js";
import {
  toRadians
} from "./chunk-54BTDBAD.js";
import {
  MapBrowserEvent_default,
  MapEvent_default
} from "./chunk-G7T2PXQM.js";
import "./chunk-LBNOBCQJ.js";
import {
  Overlay_default
} from "./chunk-STSQM3QE.js";
import "./chunk-6EWLK2BW.js";
import "./chunk-WACFU2LX.js";
import "./chunk-YC2HE67G.js";
import "./chunk-SRXHWJOY.js";
import "./chunk-BHVDQB66.js";
import {
  Disposable_default,
  Event_default,
  Object_default,
  Observable_default,
  VERSION,
  getUid
} from "./chunk-HTEWXYQ3.js";
import "./chunk-5RHQVMYD.js";
import "./chunk-LXKYWC5O.js";
import "./chunk-G3PMV62Z.js";

// node_modules/ol/Geolocation.js
var Property = {
  ACCURACY: "accuracy",
  ACCURACY_GEOMETRY: "accuracyGeometry",
  ALTITUDE: "altitude",
  ALTITUDE_ACCURACY: "altitudeAccuracy",
  HEADING: "heading",
  POSITION: "position",
  PROJECTION: "projection",
  SPEED: "speed",
  TRACKING: "tracking",
  TRACKING_OPTIONS: "trackingOptions"
};
var GeolocationErrorType = {
  /**
   * Triggered when a `GeolocationPositionError` occurs.
   * @event module:ol/Geolocation.GeolocationError#error
   * @api
   */
  ERROR: "error"
};
var GeolocationError = class extends Event_default {
  /**
   * @param {GeolocationPositionError} error error object.
   */
  constructor(error) {
    super(GeolocationErrorType.ERROR);
    this.code = error.code;
    this.message = error.message;
  }
};
var Geolocation = class extends Object_default {
  /**
   * @param {Options} [options] Options.
   */
  constructor(options) {
    super();
    this.on;
    this.once;
    this.un;
    options = options || {};
    this.position_ = null;
    this.transform_ = identityTransform;
    this.watchId_ = void 0;
    this.addChangeListener(Property.PROJECTION, this.handleProjectionChanged_);
    this.addChangeListener(Property.TRACKING, this.handleTrackingChanged_);
    if (options.projection !== void 0) {
      this.setProjection(options.projection);
    }
    if (options.trackingOptions !== void 0) {
      this.setTrackingOptions(options.trackingOptions);
    }
    this.setTracking(options.tracking !== void 0 ? options.tracking : false);
  }
  /**
   * Clean up.
   * @override
   */
  disposeInternal() {
    this.setTracking(false);
    super.disposeInternal();
  }
  /**
   * @private
   */
  handleProjectionChanged_() {
    const projection = this.getProjection();
    if (projection) {
      this.transform_ = getTransformFromProjections(
        get("EPSG:4326"),
        projection
      );
      if (this.position_) {
        this.set(Property.POSITION, this.transform_(this.position_));
      }
    }
  }
  /**
   * @private
   */
  handleTrackingChanged_() {
    if ("geolocation" in navigator) {
      const tracking = this.getTracking();
      if (tracking && this.watchId_ === void 0) {
        this.watchId_ = navigator.geolocation.watchPosition(
          this.positionChange_.bind(this),
          this.positionError_.bind(this),
          this.getTrackingOptions()
        );
      } else if (!tracking && this.watchId_ !== void 0) {
        navigator.geolocation.clearWatch(this.watchId_);
        this.watchId_ = void 0;
      }
    }
  }
  /**
   * @private
   * @param {GeolocationPosition} position position event.
   */
  positionChange_(position) {
    const coords = position.coords;
    this.set(Property.ACCURACY, coords.accuracy);
    this.set(
      Property.ALTITUDE,
      coords.altitude === null ? void 0 : coords.altitude
    );
    this.set(
      Property.ALTITUDE_ACCURACY,
      coords.altitudeAccuracy === null ? void 0 : coords.altitudeAccuracy
    );
    this.set(
      Property.HEADING,
      coords.heading === null ? void 0 : toRadians(coords.heading)
    );
    if (!this.position_) {
      this.position_ = [coords.longitude, coords.latitude];
    } else {
      this.position_[0] = coords.longitude;
      this.position_[1] = coords.latitude;
    }
    const projectedPosition = this.transform_(this.position_);
    this.set(Property.POSITION, projectedPosition.slice());
    this.set(Property.SPEED, coords.speed === null ? void 0 : coords.speed);
    const geometry = circular(this.position_, coords.accuracy);
    geometry.applyTransform(this.transform_);
    this.set(Property.ACCURACY_GEOMETRY, geometry);
    this.changed();
  }
  /**
   * @private
   * @param {GeolocationPositionError} error error object.
   */
  positionError_(error) {
    this.dispatchEvent(new GeolocationError(error));
  }
  /**
   * Get the accuracy of the position in meters.
   * @return {number|undefined} The accuracy of the position measurement in
   *     meters.
   * @observable
   * @api
   */
  getAccuracy() {
    return (
      /** @type {number|undefined} */
      this.get(Property.ACCURACY)
    );
  }
  /**
   * Get a geometry of the position accuracy.
   * @return {?import("./geom/Polygon.js").default} A geometry of the position accuracy.
   * @observable
   * @api
   */
  getAccuracyGeometry() {
    return (
      /** @type {?import("./geom/Polygon.js").default} */
      this.get(Property.ACCURACY_GEOMETRY) || null
    );
  }
  /**
   * Get the altitude associated with the position.
   * @return {number|undefined} The altitude of the position in meters above mean
   *     sea level.
   * @observable
   * @api
   */
  getAltitude() {
    return (
      /** @type {number|undefined} */
      this.get(Property.ALTITUDE)
    );
  }
  /**
   * Get the altitude accuracy of the position.
   * @return {number|undefined} The accuracy of the altitude measurement in
   *     meters.
   * @observable
   * @api
   */
  getAltitudeAccuracy() {
    return (
      /** @type {number|undefined} */
      this.get(Property.ALTITUDE_ACCURACY)
    );
  }
  /**
   * Get the heading as radians clockwise from North.
   * Note: depending on the browser, the heading is only defined if the `enableHighAccuracy`
   * is set to `true` in the tracking options.
   * @return {number|undefined} The heading of the device in radians from north.
   * @observable
   * @api
   */
  getHeading() {
    return (
      /** @type {number|undefined} */
      this.get(Property.HEADING)
    );
  }
  /**
   * Get the position of the device.
   * @return {import("./coordinate.js").Coordinate|undefined} The current position of the device reported
   *     in the current projection.
   * @observable
   * @api
   */
  getPosition() {
    return (
      /** @type {import("./coordinate.js").Coordinate|undefined} */
      this.get(Property.POSITION)
    );
  }
  /**
   * Get the projection associated with the position.
   * @return {import("./proj/Projection.js").default|undefined} The projection the position is
   *     reported in.
   * @observable
   * @api
   */
  getProjection() {
    return (
      /** @type {import("./proj/Projection.js").default|undefined} */
      this.get(Property.PROJECTION)
    );
  }
  /**
   * Get the speed in meters per second.
   * @return {number|undefined} The instantaneous speed of the device in meters
   *     per second.
   * @observable
   * @api
   */
  getSpeed() {
    return (
      /** @type {number|undefined} */
      this.get(Property.SPEED)
    );
  }
  /**
   * Determine if the device location is being tracked.
   * @return {boolean} The device location is being tracked.
   * @observable
   * @api
   */
  getTracking() {
    return (
      /** @type {boolean} */
      this.get(Property.TRACKING)
    );
  }
  /**
   * Get the tracking options.
   * See https://www.w3.org/TR/geolocation-API/#position-options.
   * @return {PositionOptions|undefined} PositionOptions as defined by
   *     the [HTML5 Geolocation spec
   *     ](https://www.w3.org/TR/geolocation-API/#position_options_interface).
   * @observable
   * @api
   */
  getTrackingOptions() {
    return (
      /** @type {PositionOptions|undefined} */
      this.get(Property.TRACKING_OPTIONS)
    );
  }
  /**
   * Set the projection to use for transforming the coordinates.
   * @param {import("./proj.js").ProjectionLike} projection The projection the position is
   *     reported in.
   * @observable
   * @api
   */
  setProjection(projection) {
    this.set(Property.PROJECTION, get(projection));
  }
  /**
   * Enable or disable tracking.
   * @param {boolean} tracking Enable tracking.
   * @observable
   * @api
   */
  setTracking(tracking) {
    this.set(Property.TRACKING, tracking);
  }
  /**
   * Set the tracking options.
   * See http://www.w3.org/TR/geolocation-API/#position-options.
   * @param {PositionOptions} options PositionOptions as defined by the
   *     [HTML5 Geolocation spec
   *     ](http://www.w3.org/TR/geolocation-API/#position_options_interface).
   * @observable
   * @api
   */
  setTrackingOptions(options) {
    this.set(Property.TRACKING_OPTIONS, options);
  }
};
var Geolocation_default = Geolocation;
export {
  Collection_default as Collection,
  Disposable_default as Disposable,
  Feature_default as Feature,
  Geolocation_default as Geolocation,
  Graticule_default as Graticule,
  Image_default as Image,
  ImageCanvas_default as ImageCanvas,
  ImageTile_default as ImageTile,
  Image_default as ImageWrapper,
  Kinetic_default as Kinetic,
  Map_default as Map,
  MapBrowserEvent_default as MapBrowserEvent,
  MapBrowserEventHandler_default as MapBrowserEventHandler,
  MapEvent_default as MapEvent,
  Object_default as Object,
  Observable_default as Observable,
  Overlay_default as Overlay,
  Tile_default as Tile,
  TileQueue_default as TileQueue,
  TileRange_default as TileRange,
  VERSION,
  VectorRenderTile_default as VectorRenderTile,
  VectorTile_default as VectorTile,
  View_default as View,
  getUid
};
//# sourceMappingURL=ol.js.map
