import {
  Popup_default
} from "./chunk-GMQRLERH.js";
import "./chunk-BL3RR72C.js";
import "./chunk-OKY35EEM.js";
import "./chunk-IB5MK4QP.js";
import "./chunk-Q75E7BJS.js";
import "./chunk-UABYZKA2.js";
import "./chunk-5D2XPBR2.js";
import "./chunk-JDEWAWZ6.js";
import "./chunk-YB4TBLRJ.js";
import "./chunk-TRTK4IFM.js";
import "./chunk-7GQYZ5UY.js";
import "./chunk-H5WJA5U2.js";
import {
  Interaction_default
} from "./chunk-ABYLXAPS.js";
import "./chunk-XTZQTSWS.js";
import "./chunk-RW3V7S4F.js";
import "./chunk-LMC3RO5P.js";
import "./chunk-IJBK5CNT.js";
import "./chunk-FCPHVQUR.js";
import "./chunk-7O5CJMRQ.js";
import "./chunk-Q35WOPMB.js";
import {
  getArea,
  getLength
} from "./chunk-ZLPTRF2L.js";
import "./chunk-QFCIXVZ3.js";
import "./chunk-PCFFPN3V.js";
import "./chunk-54BTDBAD.js";
import "./chunk-G7T2PXQM.js";
import "./chunk-LBNOBCQJ.js";
import "./chunk-STSQM3QE.js";
import "./chunk-6EWLK2BW.js";
import "./chunk-WACFU2LX.js";
import "./chunk-YC2HE67G.js";
import "./chunk-SRXHWJOY.js";
import "./chunk-BHVDQB66.js";
import {
  unByKey
} from "./chunk-HTEWXYQ3.js";
import "./chunk-5RHQVMYD.js";
import "./chunk-LXKYWC5O.js";
import "./chunk-G3PMV62Z.js";

// node_modules/ol-ext/overlay/Tooltip.js
var ol_Overlay_Tooltip = class olOverlayTooltip extends Popup_default {
  constructor(options) {
    options = options || {};
    options.popupClass = options.popupClass || options.className || "tooltips black";
    options.positioning = options.positioning || "center-left";
    options.stopEvent = !!options.stopEvent;
    super(options);
    this.set("maximumFractionDigits", options.maximumFractionDigits || 2);
    if (typeof options.formatLength === "function") this.formatLength = options.formatLength;
    if (typeof options.formatArea === "function") this.formatArea = options.formatArea;
    if (typeof options.getHTML === "function") this.getHTML = options.getHTML;
    this._interaction = new Interaction_default({
      handleEvent: (function(e) {
        if (e.type === "pointermove" || e.type === "click") {
          var info = this.getHTML(this._feature, this.get("info"));
          if (info) {
            this.show(e.coordinate, info);
          } else
            this.hide();
          this._coord = e.coordinate;
        }
        return true;
      }).bind(this)
    });
  }
  /**
   * Set the map instance the control is associated with
   * and add its controls associated to this map.
   * @param {_ol_Map_} map The map instance.
   */
  setMap(map) {
    if (this.getMap()) this.getMap().removeInteraction(this._interaction);
    super.setMap(map);
    if (this.getMap()) this.getMap().addInteraction(this._interaction);
  }
  /** Get the information to show in the tooltip
   * The area/length will be added if a feature is attached.
   * @param {ol.Feature|undefined} feature the feature
   * @param {string} info the info string
   * @api
   */
  getHTML(feature, info) {
    if (this.get("measure"))
      return this.get("measure") + (info ? "<br/>" + info : "");
    else
      return info || "";
  }
  /** Set the Tooltip info
   * If information is not null it will be set with a delay,
   * thus watever the information is inserted, the significant information will be set.
   * ie. ttip.setInformation('ok'); ttip.setInformation(null); will set 'ok'
   * ttip.set('info','ok'); ttip.set('info', null); will set null
   * @param {string} what The information to display in the tooltip, default remove information
   */
  setInfo(what) {
    if (!what) {
      this.set("info", "");
      this.hide();
    } else
      setTimeout((function() {
        this.set("info", what);
        this.show(this._coord, this.get("info"));
      }).bind(this));
  }
  /** Remove the current featue attached to the tip
   * Similar to setFeature() with no argument
   */
  removeFeature() {
    this.setFeature();
  }
  /** Format area to display in the popup.
   * Can be overwritten to display measure in a different unit (default: square-metter).
   * @param {number} area area in m2
   * @return {string} the formated area
   * @api
   */
  formatArea(area) {
    if (area > Math.pow(10, -1 * this.get("maximumFractionDigits"))) {
      if (area > 1e4) {
        return (area / 1e6).toLocaleString(void 0, { maximumFractionDigits: this.get("maximumFractionDigits)") }) + " km²";
      } else {
        return area.toLocaleString(void 0, { maximumFractionDigits: this.get("maximumFractionDigits") }) + " m²";
      }
    } else {
      return "";
    }
  }
  /** Format area to display in the popup
   * Can be overwritten to display measure in different unit (default: meter).
   * @param {number} length length in m
   * @return {string} the formated length
   * @api
   */
  formatLength(length) {
    if (length > Math.pow(10, -1 * this.get("maximumFractionDigits"))) {
      if (length > 100) {
        return (length / 1e3).toLocaleString(void 0, { maximumFractionDigits: this.get("maximumFractionDigits") }) + " km";
      } else {
        return length.toLocaleString(void 0, { maximumFractionDigits: this.get("maximumFractionDigits") }) + " m";
      }
    } else {
      return "";
    }
  }
  /** Set a feature associated with the tooltips, measure info on the feature will be added in the tooltip
   * @param {ol.Feature|ol.Event} feature an ol.Feature or an event (object) with a feature property
   */
  setFeature(feature) {
    if (feature && feature.feature)
      feature = feature.feature;
    this._feature = feature;
    if (this._listener) {
      this._listener.forEach(function(l) {
        unByKey(l);
      });
    }
    this._listener = [];
    this.set("measure", "");
    if (feature) {
      this._listener.push(feature.getGeometry().on("change", (function(e) {
        var geom = e.target;
        var measure;
        if (geom.getArea) {
          measure = this.formatArea(getArea(geom, { projection: this.getMap().getView().getProjection() }));
        } else if (geom.getLength) {
          measure = this.formatLength(getLength(geom, { projection: this.getMap().getView().getProjection() }));
        }
        this.set("measure", measure);
      }).bind(this)));
    }
  }
};
var Tooltip_default = ol_Overlay_Tooltip;
export {
  Tooltip_default as default
};
//# sourceMappingURL=ol-ext_overlay_Tooltip.js.map
