import {
  Button_default
} from "./chunk-DUXDYBNZ.js";
import "./chunk-BL3RR72C.js";
import "./chunk-OKY35EEM.js";
import "./chunk-IB5MK4QP.js";
import "./chunk-Q75E7BJS.js";
import "./chunk-UABYZKA2.js";
import "./chunk-5D2XPBR2.js";
import "./chunk-JDEWAWZ6.js";
import "./chunk-YB4TBLRJ.js";
import "./chunk-TRTK4IFM.js";
import "./chunk-7GQYZ5UY.js";
import "./chunk-H5WJA5U2.js";
import "./chunk-ABYLXAPS.js";
import "./chunk-XTZQTSWS.js";
import "./chunk-RW3V7S4F.js";
import "./chunk-LMC3RO5P.js";
import "./chunk-IJBK5CNT.js";
import "./chunk-FCPHVQUR.js";
import "./chunk-7O5CJMRQ.js";
import "./chunk-Q35WOPMB.js";
import "./chunk-ZLPTRF2L.js";
import "./chunk-QFCIXVZ3.js";
import "./chunk-PCFFPN3V.js";
import "./chunk-54BTDBAD.js";
import "./chunk-G7T2PXQM.js";
import "./chunk-LBNOBCQJ.js";
import "./chunk-6EWLK2BW.js";
import "./chunk-WACFU2LX.js";
import "./chunk-YC2HE67G.js";
import "./chunk-SRXHWJOY.js";
import "./chunk-BHVDQB66.js";
import "./chunk-HTEWXYQ3.js";
import "./chunk-5RHQVMYD.js";
import "./chunk-LXKYWC5O.js";
import "./chunk-G3PMV62Z.js";

// node_modules/ol-ext/control/Toggle.js
var ol_control_Toggle = class olcontrolToggle extends Button_default {
  constructor(options) {
    options = options || {};
    if (options.toggleFn) {
      options.onToggle = options.toggleFn;
    }
    options.handleClick = function() {
      self.toggle();
      if (options.onToggle) {
        options.onToggle.call(self, self.getActive());
      }
    };
    options.className = (options.className || "") + " ol-toggle";
    super(options);
    var self = this;
    this.interaction_ = options.interaction;
    if (this.interaction_) {
      this.interaction_.setActive(options.active);
      this.interaction_.on("change:active", function() {
        self.setActive(self.interaction_.getActive());
      });
    }
    this.set("title", options.title);
    this.set("autoActivate", options.autoActivate);
    if (options.bar)
      this.setSubBar(options.bar);
    this.setActive(options.active);
    this.setDisable(options.disable);
  }
  /**
   * Set the map instance the control is associated with
   * and add interaction attached to it to this map.
   * @param {_ol_Map_} map The map instance.
   */
  setMap(map) {
    if (!map && this.getMap()) {
      if (this.interaction_) {
        this.getMap().removeInteraction(this.interaction_);
      }
      if (this.subbar_)
        this.getMap().removeControl(this.subbar_);
    }
    super.setMap(map);
    if (map) {
      if (this.interaction_)
        map.addInteraction(this.interaction_);
      if (this.subbar_)
        map.addControl(this.subbar_);
    }
  }
  /** Get the subbar associated with a control
   * @return {ol_control_Bar}
   */
  getSubBar() {
    return this.subbar_;
  }
  /** Set the subbar associated with a control
   * @param {ol_control_Bar} [bar] a subbar if none remove the current subbar
   */
  setSubBar(bar) {
    var map = this.getMap();
    if (map && this.subbar_)
      map.removeControl(this.subbar_);
    this.subbar_ = bar;
    if (bar) {
      this.subbar_.setTarget(this.element);
      this.subbar_.element.classList.add("ol-option-bar");
      if (map)
        map.addControl(this.subbar_);
    }
  }
  /**
   * Test if the control is disabled.
   * @return {bool}
   * @api stable
   */
  getDisable() {
    var button = this.element.querySelector("button");
    return button && button.disabled;
  }
  /** Disable the control. If disable, the control will be deactivated too.
  * @param {bool} b disable (or enable) the control, default false (enable)
  */
  setDisable(b) {
    if (this.getDisable() == b) return;
    this.element.querySelector("button").disabled = b;
    if (b && this.getActive()) this.setActive(false);
    this.dispatchEvent({ type: "change:disable", key: "disable", oldValue: !b, disable: b });
  }
  /**
   * Test if the control is active.
   * @return {bool}.
   * @api stable
   */
  getActive() {
    return this.element.classList.contains("ol-active");
  }
  /** Toggle control state active/deactive
   */
  toggle() {
    if (this.getActive())
      this.setActive(false);
    else
      this.setActive(true);
  }
  /** Change control state
   * @param {bool} b activate or deactivate the control, default false
   */
  setActive(b) {
    if (this.interaction_)
      this.interaction_.setActive(b);
    if (this.subbar_)
      this.subbar_.setActive(b);
    if (this.getActive() === b)
      return;
    if (b)
      this.element.classList.add("ol-active");
    else
      this.element.classList.remove("ol-active");
    this.dispatchEvent({ type: "change:active", key: "active", oldValue: !b, active: b });
  }
  /** Set the control interaction
  * @param {_ol_interaction_} i interaction to associate with the control
  */
  setInteraction(i) {
    this.interaction_ = i;
  }
  /** Get the control interaction
  * @return {_ol_interaction_} interaction associated with the control
  */
  getInteraction() {
    return this.interaction_;
  }
};
var Toggle_default = ol_control_Toggle;
export {
  Toggle_default as default
};
//# sourceMappingURL=ol-ext_control_Toggle.js.map
