import {
  Heatmap_default,
  VectorTile_default
} from "./chunk-TMGKLIH2.js";
import {
  Image_default
} from "./chunk-BIHFQX2X.js";
import {
  Tile_default2 as Tile_default
} from "./chunk-LZJYKRSY.js";
import "./chunk-FSUETOXJ.js";
import {
  Vector_default
} from "./chunk-YCPCBEQR.js";
import "./chunk-MBBF2OY4.js";
import "./chunk-HM3IY3H4.js";
import "./chunk-V7WRBSQ6.js";
import "./chunk-TW6HSYGK.js";
import "./chunk-24RUVO6K.js";
import "./chunk-77SNIUMH.js";
import "./chunk-JFXZSSOM.js";
import "./chunk-SSPX56W7.js";
import {
  element_default
} from "./chunk-BL3RR72C.js";
import "./chunk-OKY35EEM.js";
import "./chunk-IB5MK4QP.js";
import "./chunk-Q75E7BJS.js";
import "./chunk-UABYZKA2.js";
import "./chunk-5D2XPBR2.js";
import "./chunk-JDEWAWZ6.js";
import "./chunk-YB4TBLRJ.js";
import "./chunk-TRTK4IFM.js";
import "./chunk-7GQYZ5UY.js";
import "./chunk-H5WJA5U2.js";
import "./chunk-ABYLXAPS.js";
import "./chunk-XTZQTSWS.js";
import "./chunk-RW3V7S4F.js";
import "./chunk-LMC3RO5P.js";
import "./chunk-IJBK5CNT.js";
import "./chunk-FCPHVQUR.js";
import "./chunk-7O5CJMRQ.js";
import "./chunk-Q35WOPMB.js";
import "./chunk-ZLPTRF2L.js";
import "./chunk-QFCIXVZ3.js";
import "./chunk-PCFFPN3V.js";
import "./chunk-54BTDBAD.js";
import "./chunk-G7T2PXQM.js";
import {
  Control_default
} from "./chunk-LBNOBCQJ.js";
import "./chunk-6EWLK2BW.js";
import "./chunk-WACFU2LX.js";
import "./chunk-YC2HE67G.js";
import {
  intersects
} from "./chunk-SRXHWJOY.js";
import "./chunk-BHVDQB66.js";
import {
  unByKey
} from "./chunk-HTEWXYQ3.js";
import "./chunk-5RHQVMYD.js";
import "./chunk-LXKYWC5O.js";
import "./chunk-G3PMV62Z.js";

// node_modules/ol-ext/control/LayerSwitcher.js
var ol_control_LayerSwitcher = class olcontrolLayerSwitcher extends Control_default {
  constructor(options) {
    options = options || {};
    var element = element_default.create("DIV", {
      className: options.switcherClass || "ol-layerswitcher"
    });
    super({
      element,
      target: options.target
    });
    var self = this;
    this.dcount = 0;
    this.show_progress = options.show_progress;
    this.oninfo = typeof options.oninfo == "function" ? options.oninfo : null;
    this.onextent = typeof options.onextent == "function" ? options.onextent : null;
    this.hasextent = options.extent || options.onextent;
    this.hastrash = options.trash;
    this.reordering = options.reordering !== false;
    this._layers = [];
    this._layerGroup = options.layerGroup && options.layerGroup.getLayers ? options.layerGroup : null;
    this.onchangeCheck = typeof options.onchangeCheck == "function" ? options.onchangeCheck : null;
    if (typeof options.displayInLayerSwitcher === "function") {
      this.displayInLayerSwitcher = options.displayInLayerSwitcher;
    }
    if (!options.target) {
      element.classList.add("ol-unselectable");
      element.classList.add("ol-control");
      element.classList.add(options.collapsed !== false ? "ol-collapsed" : "ol-forceopen");
      this.button = element_default.create("BUTTON", {
        type: "button",
        parent: element
      });
      this.button.addEventListener("touchstart", function(e) {
        element.classList.toggle("ol-forceopen");
        element.classList.add("ol-collapsed");
        self.dispatchEvent({ type: "toggle", collapsed: element.classList.contains("ol-collapsed") });
        e.preventDefault();
        self.overflow();
      });
      this.button.addEventListener("click", function() {
        element.classList.toggle("ol-forceopen");
        element.classList.add("ol-collapsed");
        self.dispatchEvent({ type: "toggle", collapsed: !element.classList.contains("ol-forceopen") });
        self.overflow();
      });
      if (options.mouseover) {
        element.addEventListener("mouseleave", function() {
          element.classList.add("ol-collapsed");
          self.dispatchEvent({ type: "toggle", collapsed: true });
        });
        element.addEventListener("mouseover", function() {
          element.classList.remove("ol-collapsed");
          self.dispatchEvent({ type: "toggle", collapsed: false });
        });
      }
      if (options.minibar)
        options.noScroll = true;
      if (!options.noScroll) {
        this.topv = element_default.create("DIV", {
          className: "ol-switchertopdiv",
          parent: element,
          click: function() {
            self.overflow("+50%");
          }
        });
        this.botv = element_default.create("DIV", {
          className: "ol-switcherbottomdiv",
          parent: element,
          click: function() {
            self.overflow("-50%");
          }
        });
      }
      this._noScroll = options.noScroll;
    }
    this.panel_ = element_default.create("UL", {
      className: "panel"
    });
    this.panelContainer_ = element_default.create("DIV", {
      className: "panel-container",
      html: this.panel_,
      parent: element
    });
    if (!options.target && !options.noScroll) {
      element_default.addListener(this.panel_, "mousewheel DOMMouseScroll onmousewheel", function(e) {
        if (self.overflow(Math.max(-1, Math.min(1, e.wheelDelta || -e.detail)))) {
          e.stopPropagation();
          e.preventDefault();
        }
      });
    }
    this.header_ = element_default.create("LI", {
      className: "ol-header",
      parent: this.panel_
    });
    this.set("drawDelay", options.drawDelay || 0);
    this.set("selection", options.selection);
    if (options.minibar) {
      setTimeout((function() {
        var mbar = element_default.scrollDiv(this.panelContainer_, {
          mousewheel: true,
          vertical: true,
          minibar: true
        });
        this.on(["drawlist", "toggle"], function() {
          mbar.refresh();
        });
      }).bind(this));
    }
  }
  /** Test if a layer should be displayed in the switcher
   * @param {ol.layer} layer
   * @return {boolean} true if the layer is displayed
   */
  displayInLayerSwitcher(layer) {
    return layer.get("displayInLayerSwitcher") !== false;
  }
  /**
   * Set the map instance the control is associated with.
   * @param {_ol_Map_} map The map instance.
   */
  setMap(map) {
    super.setMap(map);
    this.drawPanel();
    if (this._listener) {
      for (var i in this._listener) {
        unByKey(this._listener[i]);
      }
    }
    this._listener = null;
    if (map) {
      this._listener = {
        moveend: map.on("moveend", this.viewChange.bind(this)),
        size: map.on("change:size", this.overflow.bind(this))
      };
      if (this._layerGroup) {
        this._listener.change = this._layerGroup.getLayers().on("change:length", this.drawPanel.bind(this));
      } else {
        this._listener.change = map.getLayerGroup().getLayers().on("change:length", this.drawPanel.bind(this));
      }
    }
  }
  /** Show control
   */
  show() {
    this.element.classList.add("ol-forceopen");
    this.overflow();
    this.dispatchEvent({ type: "toggle", collapsed: false });
  }
  /** Hide control
   */
  hide() {
    this.element.classList.remove("ol-forceopen");
    this.overflow();
    this.dispatchEvent({ type: "toggle", collapsed: true });
  }
  /** Toggle control
   */
  toggle() {
    this.element.classList.toggle("ol-forceopen");
    this.overflow();
    this.dispatchEvent({ type: "toggle", collapsed: !this.isOpen() });
  }
  /** Is control open
   * @return {boolean}
   */
  isOpen() {
    return this.element.classList.contains("ol-forceopen");
  }
  /** Add a custom header
   * @param {Element|string} html content html
   */
  setHeader(html) {
    element_default.setHTML(this.header_, html);
  }
  /** Calculate overflow and add scrolls
   * @param {Number} dir scroll direction -1|0|1|'+50%'|'-50%'
   * @private
   */
  overflow(dir) {
    if (this.button && !this._noScroll) {
      if (element_default.hidden(this.panel_)) {
        element_default.setStyle(this.element, { height: "auto" });
        return;
      }
      var h = element_default.outerHeight(this.element);
      var hp = element_default.outerHeight(this.panel_);
      var dh = this.button.offsetTop + element_default.outerHeight(this.button);
      var top = this.panel_.offsetTop - dh;
      if (hp > h - dh) {
        element_default.setStyle(this.element, { height: "100%" });
        var li = this.panel_.querySelectorAll("li.ol-visible .li-content")[0];
        var lh = li ? 2 * element_default.getStyle(li, "height") : 0;
        switch (dir) {
          case 1:
            top += lh;
            break;
          case -1:
            top -= lh;
            break;
          case "+50%":
            top += Math.round(h / 2);
            break;
          case "-50%":
            top -= Math.round(h / 2);
            break;
          default:
            break;
        }
        if (top + hp <= h - 3 * dh / 2) {
          top = h - 3 * dh / 2 - hp;
          element_default.hide(this.botv);
        } else {
          element_default.show(this.botv);
        }
        if (top >= 0) {
          top = 0;
          element_default.hide(this.topv);
        } else {
          element_default.show(this.topv);
        }
        element_default.setStyle(this.panel_, { top: top + "px" });
        return true;
      } else {
        element_default.setStyle(this.element, { height: "auto" });
        element_default.setStyle(this.panel_, { top: 0 });
        element_default.hide(this.botv);
        element_default.hide(this.topv);
        return false;
      }
    } else
      return false;
  }
  /** Set the layer associated with a li
   * @param {Element} li
   * @param {ol.layer} layer
   * @private
   */
  _setLayerForLI(li, layer) {
    var listeners = [];
    if (layer.getLayers) {
      listeners.push(layer.getLayers().on("change:length", this.drawPanel.bind(this)));
    }
    if (li) {
      listeners.push(layer.on("change:opacity", (function() {
        this.setLayerOpacity(layer, li);
      }).bind(this)));
      listeners.push(layer.on("change:visible", (function() {
        this.setLayerVisibility(layer, li);
      }).bind(this)));
    }
    listeners.push(layer.on("propertychange", (function(e) {
      if (e.key === "displayInLayerSwitcher" || e.key === "openInLayerSwitcher" || e.key === "title" || e.key === "name") {
        this.drawPanel(e);
      }
    }).bind(this)));
    this._layers.push({ li, layer, listeners });
  }
  /** Set opacity for a layer
   * @param {ol.layer.Layer} layer
   * @param {Element} li the list element
   * @private
   */
  setLayerOpacity(layer, li) {
    var i = li.querySelector(".layerswitcher-opacity-cursor");
    if (i) {
      i.style.left = layer.getOpacity() * 100 + "%";
    }
    this.dispatchEvent({ type: "layer:opacity", layer });
  }
  /** Set visibility for a layer
   * @param {ol.layer.Layer} layer
   * @param {Element} li the list element
   * @api
   */
  setLayerVisibility(layer, li) {
    var i = li.querySelector(".ol-visibility");
    if (i) {
      i.checked = layer.getVisible();
    }
    if (layer.getVisible()) {
      li.classList.add("ol-visible");
    } else {
      li.classList.remove("ol-visible");
    }
    this.dispatchEvent({ type: "layer:visible", layer });
  }
  /** Clear layers associated with li
   * @private
   */
  _clearLayerForLI() {
    this._layers.forEach(function(li) {
      li.listeners.forEach(function(l) {
        unByKey(l);
      });
    });
    this._layers = [];
  }
  /** Get the layer associated with a li
   * @param {Element} li
   * @return {ol.layer}
   * @private
   */
  _getLayerForLI(li) {
    for (var i = 0, l; l = this._layers[i]; i++) {
      if (l.li === li) {
        return l.layer;
      }
    }
    return null;
  }
  /**
   * On view change hide layer depending on resolution / extent
   * @private
   */
  viewChange() {
    this.panel_.querySelectorAll("li").forEach((function(li) {
      var l = this._getLayerForLI(li);
      if (l) {
        if (this.testLayerVisibility(l)) {
          li.classList.remove("ol-layer-hidden");
        } else {
          li.classList.add("ol-layer-hidden");
        }
      }
    }).bind(this));
  }
  /** Get control panel
   * @api
   */
  getPanel() {
    return this.panelContainer_;
  }
  /** Draw the panel control (prevent multiple draw due to layers manipulation on the map with a delay function)
   * @api
   */
  drawPanel() {
    if (!this.getMap())
      return;
    var self = this;
    this.dcount++;
    setTimeout(function() {
      self.drawPanel_();
    }, this.get("drawDelay") || 0);
  }
  /** Delayed draw panel control
   * @private
   */
  drawPanel_() {
    if (--this.dcount || this.dragging_) {
      return;
    }
    var scrollTop = this.panelContainer_.scrollTop;
    this._clearLayerForLI();
    this.panel_.querySelectorAll("li").forEach((function(li) {
      if (!li.classList.contains("ol-header")) li.remove();
    }).bind(this));
    if (this._layerGroup) {
      this.drawList(this.panel_, this._layerGroup.getLayers());
    } else if (this.getMap()) {
      this.drawList(this.panel_, this.getMap().getLayers());
    }
    this.panelContainer_.scrollTop = scrollTop;
  }
  /** Change layer visibility according to the baselayer option
   * @param {ol.layer}
   * @param {Array<ol.layer>} related layers
   * @private
   */
  switchLayerVisibility(l, layers) {
    if (!l.get("baseLayer")) {
      l.setVisible(!l.getVisible());
    } else {
      if (!l.getVisible()) {
        l.setVisible(true);
      }
      layers.forEach(function(li) {
        if (l !== li && li.get("baseLayer") && li.getVisible()) {
          li.setVisible(false);
        }
      });
    }
  }
  /** Check if layer is on the map (depending on resolution / zoom and extent)
   * @param {ol.layer}
   * @return {boolean}
   * @private
   */
  testLayerVisibility(layer) {
    if (!this.getMap())
      return true;
    var res = this.getMap().getView().getResolution();
    var zoom = this.getMap().getView().getZoom();
    if (layer.getMaxResolution() <= res || layer.getMinResolution() >= res) {
      return false;
    } else if (layer.getMinZoom && (layer.getMinZoom() >= zoom || layer.getMaxZoom() < zoom)) {
      return false;
    } else {
      var ex0 = layer.getExtent();
      if (ex0) {
        var ex = this.getMap().getView().calculateExtent(this.getMap().getSize());
        return intersects(ex, ex0);
      }
      return true;
    }
  }
  /** Start ordering the list
  *	@param {event} e drag event
  *	@private
  */
  dragOrdering_(e) {
    e.stopPropagation();
    e.preventDefault();
    var self = this;
    var elt = e.currentTarget.parentNode.parentNode;
    var start = true;
    var panel = this.panel_;
    var pageY;
    var pageY0 = e.pageY || e.touches && e.touches.length && e.touches[0].pageY || e.changedTouches && e.changedTouches.length && e.changedTouches[0].pageY;
    var target, dragElt;
    var layer, group;
    elt.parentNode.classList.add("drag");
    function stop() {
      if (target) {
        var drop = layer;
        var isSelected = self.getSelection() === drop;
        if (drop && target) {
          var collection;
          if (group) {
            collection = group.getLayers();
          } else {
            collection = self._layerGroup ? self._layerGroup.getLayers() : self.getMap().getLayers();
          }
          var layers = collection.getArray();
          for (var i = 0; i < layers.length; i++) {
            if (layers[i] == drop) {
              collection.removeAt(i);
              break;
            }
          }
          for (var j = 0; j < layers.length; j++) {
            if (layers[j] === target) {
              if (i > j) {
                collection.insertAt(j, drop);
              } else {
                collection.insertAt(j + 1, drop);
              }
              break;
            }
          }
        }
        if (isSelected) self.selectLayer(drop);
        self.dispatchEvent({ type: "reorder-end", layer: drop, group });
      }
      elt.parentNode.querySelectorAll("li").forEach(function(li) {
        li.classList.remove("dropover");
        li.classList.remove("dropover-after");
        li.classList.remove("dropover-before");
      });
      elt.classList.remove("drag");
      elt.parentNode.classList.remove("drag");
      self.element.classList.remove("drag");
      if (dragElt)
        dragElt.remove();
      element_default.removeListener(document, "mousemove touchmove", move);
      element_default.removeListener(document, "mouseup touchend touchcancel", stop);
    }
    function move(e2) {
      pageY = e2.pageY || e2.touches && e2.touches.length && e2.touches[0].pageY || e2.changedTouches && e2.changedTouches.length && e2.changedTouches[0].pageY;
      if (start && Math.abs(pageY0 - pageY) > 2) {
        start = false;
        elt.classList.add("drag");
        layer = self._getLayerForLI(elt);
        target = false;
        group = self._getLayerForLI(elt.parentNode.parentNode);
        dragElt = element_default.create("LI", {
          className: "ol-dragover",
          html: elt.innerHTML,
          style: {
            position: "absolute",
            "z-index": 1e4,
            left: elt.offsetLeft,
            opacity: 0.5,
            width: element_default.outerWidth(elt),
            height: element_default.getStyle(elt, "height")
          },
          parent: panel
        });
        self.element.classList.add("drag");
        self.dispatchEvent({ type: "reorder-start", layer, group });
      }
      if (!start) {
        e2.preventDefault();
        e2.stopPropagation();
        element_default.setStyle(dragElt, { top: pageY - element_default.offsetRect(panel).top + panel.scrollTop + 5 });
        var li;
        if (!e2.touches) {
          li = e2.target;
          if (e2.target.shadowRoot) {
            li = e2.composedPath()[0];
          }
        } else {
          li = document.elementFromPoint(e2.touches[0].clientX, e2.touches[0].clientY);
          while (li.shadowRoot) {
            li = li.shadowRoot.elementFromPoint(e2.touches[0].clientX, e2.touches[0].clientY);
          }
        }
        if (li.classList.contains("ol-switcherbottomdiv")) {
          self.overflow(-1);
        } else if (li.classList.contains("ol-switchertopdiv")) {
          self.overflow(1);
        }
        while (li && li.tagName !== "LI") {
          li = li.parentNode;
        }
        if (!li || !li.classList.contains("dropover")) {
          elt.parentNode.querySelectorAll("li").forEach(function(li2) {
            li2.classList.remove("dropover");
            li2.classList.remove("dropover-after");
            li2.classList.remove("dropover-before");
          });
        }
        if (li && li.parentNode.classList.contains("drag") && li !== elt) {
          target = self._getLayerForLI(li);
          if (target && !target.get("allwaysOnTop") == !layer.get("allwaysOnTop")) {
            li.classList.add("dropover");
            li.classList.add(elt.offsetTop < li.offsetTop ? "dropover-after" : "dropover-before");
          } else {
            target = false;
          }
          element_default.show(dragElt);
        } else {
          target = false;
          if (li === elt)
            element_default.hide(dragElt);
          else
            element_default.show(dragElt);
        }
        if (!target)
          dragElt.classList.add("forbidden");
        else
          dragElt.classList.remove("forbidden");
      }
    }
    element_default.addListener(document, "mousemove touchmove", move);
    element_default.addListener(document, "mouseup touchend touchcancel", stop);
  }
  /** Change opacity on drag
  *	@param {event} e drag event
  *	@private
  */
  dragOpacity_(e) {
    e.stopPropagation();
    e.preventDefault();
    var self = this;
    var elt = e.target;
    var layer = this._getLayerForLI(elt.parentNode.parentNode.parentNode);
    if (!layer)
      return;
    var x = e.pageX || e.touches && e.touches.length && e.touches[0].pageX || e.changedTouches && e.changedTouches.length && e.changedTouches[0].pageX;
    var start = element_default.getStyle(elt, "left") - x;
    self.dragging_ = true;
    function stop() {
      element_default.removeListener(document, "mouseup touchend touchcancel", stop);
      element_default.removeListener(document, "mousemove touchmove", move);
      self.dragging_ = false;
    }
    function move(e2) {
      var x2 = e2.pageX || e2.touches && e2.touches.length && e2.touches[0].pageX || e2.changedTouches && e2.changedTouches.length && e2.changedTouches[0].pageX;
      var delta = (start + x2) / element_default.getStyle(elt.parentNode, "width");
      var opacity = Math.max(0, Math.min(1, delta));
      element_default.setStyle(elt, { left: opacity * 100 + "%" });
      elt.parentNode.nextElementSibling.innerHTML = Math.round(opacity * 100);
      layer.setOpacity(opacity);
    }
    element_default.addListener(document, "mouseup touchend touchcancel", stop);
    element_default.addListener(document, "mousemove touchmove", move);
  }
  /** Render a list of layer
   * @param {Elemen} element to render
   * @layers {Array{ol.layer}} list of layer to show
   * @api stable
   * @private
   */
  drawList(ul, collection) {
    var self = this;
    var layers = collection.getArray();
    var setVisibility = function(e) {
      e.stopPropagation();
      e.preventDefault();
      var l = self._getLayerForLI(this.parentNode.parentNode);
      self.switchLayerVisibility(l, collection);
      if (self.get("selection") && l.getVisible()) {
        self.selectLayer(l);
      }
      if (self.onchangeCheck) {
        self.onchangeCheck(l);
      }
    };
    function onInfo(e) {
      e.stopPropagation();
      e.preventDefault();
      var l = self._getLayerForLI(this.parentNode.parentNode);
      self.oninfo(l);
      self.dispatchEvent({ type: "info", layer: l });
    }
    function zoomExtent(e) {
      e.stopPropagation();
      e.preventDefault();
      var l = self._getLayerForLI(this.parentNode.parentNode);
      if (self.onextent) {
        self.onextent(l);
      } else {
        self.getMap().getView().fit(l.getExtent(), self.getMap().getSize());
      }
      self.dispatchEvent({ type: "extent", layer: l });
    }
    function removeLayer(e) {
      e.stopPropagation();
      e.preventDefault();
      var li = this.parentNode.parentNode.parentNode.parentNode;
      var layer, group = self._getLayerForLI(li);
      if (group) {
        layer = self._getLayerForLI(this.parentNode.parentNode);
        group.getLayers().remove(layer);
        if (group.getLayers().getLength() == 0 && !group.get("noSwitcherDelete")) {
          removeLayer.call(li.querySelectorAll(".layerTrash")[0], e);
        }
      } else {
        li = this.parentNode.parentNode;
        self.getMap().removeLayer(self._getLayerForLI(li));
      }
    }
    function createLi(layer) {
      if (!this.displayInLayerSwitcher(layer)) {
        this._setLayerForLI(null, layer);
        return;
      }
      var li = element_default.create("LI", {
        className: (layer.getVisible() ? "ol-visible " : " ") + (layer.get("baseLayer") ? "baselayer" : ""),
        parent: ul
      });
      this._setLayerForLI(li, layer);
      if (this._selectedLayer === layer) {
        li.classList.add("ol-layer-select");
      }
      var layer_buttons = element_default.create("DIV", {
        className: "ol-layerswitcher-buttons",
        parent: li
      });
      var d = element_default.create("DIV", {
        className: "li-content",
        parent: li
      });
      var input = element_default.create("INPUT", {
        type: layer.get("baseLayer") ? "radio" : "checkbox",
        className: "ol-visibility",
        checked: layer.getVisible(),
        click: function(e) {
          setVisibility.bind(this)(e);
          setTimeout(function() {
            e.target.checked = layer.getVisible();
          });
        },
        on: {
          // Set opacity on keydown
          keydown: (function(e) {
            switch (e.key) {
              // Change opacity on arrow
              case "ArrowLeft":
              case "ArrowRight": {
                e.preventDefault();
                e.stopPropagation();
                var delta = e.key === "ArrowLeft" ? -0.1 : 0.1;
                var opacity2 = Math.min(1, Math.max(0, layer.getOpacity() + delta));
                layer.setOpacity(opacity2);
                break;
              }
              // Select on enter
              case "Enter": {
                if (self.get("selection")) {
                  e.preventDefault();
                  e.stopPropagation();
                  self.selectLayer(layer);
                }
                break;
              }
              // Expend 
              case "-":
              case "+": {
                if (layer.getLayers) {
                  this._focus = layer;
                  layer.set("openInLayerSwitcher", !layer.get("openInLayerSwitcher"));
                }
              }
              // Move up dans down
              // fallthrough
              case "ArrowUp":
              case "ArrowDown": {
                if (e.ctrlKey && this.reordering) {
                  e.preventDefault();
                  e.stopPropagation();
                  var pos = collection.getArray().indexOf(layer);
                  if (pos > -1) {
                    if (e.key === "ArrowDown") {
                      if (pos > 0) {
                        collection.remove(layer);
                        collection.insertAt(pos - 1, layer);
                        self._focus = layer;
                        self.dispatchEvent({ type: "reorder-end", layer });
                      }
                    } else {
                      if (pos < collection.getLength() - 1) {
                        collection.remove(layer);
                        collection.insertAt(pos + 1, layer);
                        self._focus = layer;
                        self.dispatchEvent({ type: "reorder-end", layer });
                      }
                    }
                  }
                }
                break;
              }
              default: {
                var group = this._getLayerForLI(ul.parentNode);
                this.dispatchEvent({ type: "layer:keydown", key: e.key, group, li, layer, originalEvent: e });
              }
            }
          }).bind(this)
        },
        parent: d
      });
      if (layer === self._focus) {
        input.focus();
        self.overflow();
      }
      var label = element_default.create("LABEL", {
        title: layer.get("title") || layer.get("name"),
        click: setVisibility,
        style: {
          userSelect: "none"
        },
        parent: d
      });
      label.addEventListener("selectstart", function() {
        return false;
      });
      element_default.create("SPAN", {
        html: layer.get("title") || layer.get("name"),
        click: (function(e) {
          if (this.get("selection")) {
            e.stopPropagation();
            this.selectLayer(layer);
          }
        }).bind(this),
        parent: label
      });
      if (this.reordering) {
        if (i < layers.length - 1 && (layer.get("allwaysOnTop") || !layers[i + 1].get("allwaysOnTop")) || i > 0 && (!layer.get("allwaysOnTop") || layers[i - 1].get("allwaysOnTop"))) {
          element_default.create("DIV", {
            className: "layerup ol-noscroll",
            title: this.tip.up,
            on: { "mousedown touchstart": function(e) {
              self.dragOrdering_(e);
            } },
            parent: layer_buttons
          });
        }
      }
      if (layer.getLayers) {
        var nb = 0;
        layer.getLayers().forEach(function(l) {
          if (self.displayInLayerSwitcher(l))
            nb++;
        });
        if (nb) {
          element_default.create("DIV", {
            className: layer.get("openInLayerSwitcher") ? "collapse-layers" : "expend-layers",
            title: this.tip.plus,
            click: function() {
              var l = self._getLayerForLI(this.parentNode.parentNode);
              l.set("openInLayerSwitcher", !l.get("openInLayerSwitcher"));
            },
            parent: layer_buttons
          });
        }
      }
      if (this.oninfo) {
        element_default.create("DIV", {
          className: "layerInfo",
          title: this.tip.info,
          click: onInfo,
          parent: layer_buttons
        });
      }
      if (this.hastrash && !layer.get("noSwitcherDelete")) {
        element_default.create("DIV", {
          className: "layerTrash",
          title: this.tip.trash,
          click: removeLayer,
          parent: layer_buttons
        });
      }
      if (this.hasextent && layers[i].getExtent()) {
        var ex = layers[i].getExtent();
        if (ex.length == 4 && ex[0] < ex[2] && ex[1] < ex[3]) {
          element_default.create("DIV", {
            className: "layerExtent",
            title: this.tip.extent,
            click: zoomExtent,
            parent: layer_buttons
          });
        }
      }
      if (this.show_progress && layer instanceof Tile_default) {
        var p = element_default.create("DIV", {
          className: "layerswitcher-progress",
          parent: d
        });
        this.setprogress_(layer);
        layer.layerswitcher_progress = element_default.create("DIV", { parent: p });
      }
      var opacity = element_default.create("DIV", {
        className: "layerswitcher-opacity",
        // Click on the opacity line
        click: function(e) {
          if (e.target !== this)
            return;
          e.stopPropagation();
          e.preventDefault();
          var op = Math.max(0, Math.min(1, e.offsetX / element_default.getStyle(this, "width")));
          self._getLayerForLI(this.parentNode.parentNode).setOpacity(op);
          this.parentNode.querySelectorAll(".layerswitcher-opacity-label")[0].innerHTML = Math.round(op * 100);
        },
        parent: d
      });
      element_default.create("DIV", {
        className: "layerswitcher-opacity-cursor ol-noscroll",
        style: { left: layer.getOpacity() * 100 + "%" },
        on: {
          "mousedown touchstart": function(e) {
            self.dragOpacity_(e);
          }
        },
        parent: opacity
      });
      element_default.create("DIV", {
        className: "layerswitcher-opacity-label",
        html: Math.round(layer.getOpacity() * 100),
        parent: d
      });
      if (layer.getLayers) {
        li.classList.add("ol-layer-group");
        if (layer.get("openInLayerSwitcher") === true) {
          var ul2 = element_default.create("UL", {
            parent: li
          });
          this.drawList(ul2, layer.getLayers());
        }
      }
      li.classList.add(this.getLayerClass(layer));
      this.dispatchEvent({ type: "drawlist", layer, li });
    }
    for (var i = layers.length - 1; i >= 0; i--) {
      createLi.call(this, layers[i]);
    }
    this.viewChange();
    if (ul === this.panel_) {
      this.overflow("");
      this._focus = null;
    }
  }
  /** Select a layer
   * @param {ol.layer.Layer} layer
   * @returns {string} the layer classname
   * @api
   */
  getLayerClass(layer) {
    if (!layer)
      return "none";
    if (layer.getLayers)
      return "ol-layer-group";
    if (layer instanceof Vector_default)
      return "ol-layer-vector";
    if (layer instanceof VectorTile_default)
      return "ol-layer-vectortile";
    if (layer instanceof Tile_default)
      return "ol-layer-tile";
    if (layer instanceof Image_default)
      return "ol-layer-image";
    if (layer instanceof Heatmap_default)
      return "ol-layer-heatmap";
    if (layer.getFeatures)
      return "ol-layer-vectorimage";
    return "unknown";
  }
  /** Select a layer
   * @param {ol.layer.Layer} layer
   * @api
   */
  selectLayer(layer, silent) {
    if (!layer) {
      if (!this.getMap())
        return;
      layer = this.getMap().getLayers().item(this.getMap().getLayers().getLength() - 1);
    }
    this._selectedLayer = layer;
    if (this.element.querySelector("input.ol-visibility:focus")) {
      this._focus = layer;
    }
    this.drawPanel();
    if (!silent) {
      this.dispatchEvent({ type: "select", layer });
    }
  }
  /** Get selected layer
   * @returns {ol.layer.Layer}
   */
  getSelection() {
    return this._selectedLayer;
  }
  /** Handle progress bar for a layer
  *	@private
  */
  setprogress_(layer) {
    if (!layer.layerswitcher_progress) {
      var loaded = 0;
      var loading = 0;
      var draw = function() {
        if (loading === loaded) {
          loading = loaded = 0;
          element_default.setStyle(layer.layerswitcher_progress, { width: 0 });
        } else {
          element_default.setStyle(layer.layerswitcher_progress, { width: (loaded / loading * 100).toFixed(1) + "%" });
        }
      };
      layer.getSource().on("tileloadstart", function() {
        loading++;
        draw();
      });
      layer.getSource().on("tileloadend", function() {
        loaded++;
        draw();
      });
      layer.getSource().on("tileloaderror", function() {
        loaded++;
        draw();
      });
    }
  }
};
ol_control_LayerSwitcher.prototype.tip = {
  up: "up/down",
  down: "down",
  info: "informations...",
  extent: "zoom to extent",
  trash: "remove layer",
  plus: "expand/shrink"
};
var LayerSwitcher_default = ol_control_LayerSwitcher;
export {
  LayerSwitcher_default as default
};
//# sourceMappingURL=ol-ext_control_LayerSwitcher.js.map
