import {
  element_default
} from "./chunk-BL3RR72C.js";
import {
  Control_default
} from "./chunk-LBNOBCQJ.js";

// node_modules/ol-ext/control/Button.js
var ol_control_Button = class olcontrolButton extends Control_default {
  constructor(options) {
    options = options || {};
    var element = document.createElement("div");
    element.className = (options.className || "") + " ol-button ol-unselectable ol-control";
    super({
      element,
      target: options.target
    });
    var self = this;
    var bt = this.button_ = document.createElement(/ol-text-button/.test(options.className) ? "div" : "button");
    bt.type = "button";
    if (options.title)
      bt.title = options.title;
    if (options.name)
      bt.name = options.name;
    if (options.html instanceof Element)
      bt.appendChild(options.html);
    else
      bt.innerHTML = options.html || "";
    var evtFunction = function(e) {
      if (e && e.preventDefault) {
        e.preventDefault();
        e.stopPropagation();
      }
      if (options.handleClick) {
        options.handleClick.call(self, e);
      }
    };
    bt.addEventListener("click", evtFunction);
    element.appendChild(bt);
    if (!options.title && bt.firstElementChild) {
      bt.title = bt.firstElementChild.title;
    }
    if (options.title) {
      this.set("title", options.title);
    }
    if (options.title)
      this.set("title", options.title);
    if (options.name)
      this.set("name", options.name);
  }
  /** Set the control visibility
  * @param {boolean} b
  */
  setVisible(val) {
    if (val)
      element_default.show(this.element);
    else
      element_default.hide(this.element);
  }
  /**
   * Test if the control is disabled.
   * @return {bool}
   * @api stable
   */
  getDisable() {
    var button = this.element.querySelector("button");
    return button && button.disabled;
  }
  /** Disable the control button. 
   * @param {bool} b disable (or enable) the control, default false (enable)
   * @api stable
   */
  setDisable(b) {
    if (this.getDisable() == b) return;
    this.element.querySelector("button").disabled = b;
  }
  /**
   * Set the button title
   * @param {string} title
   */
  setTitle(title) {
    this.button_.setAttribute("title", title);
  }
  /**
   * Set the button html
   * @param {string} html
   */
  setHtml(html) {
    element_default.setHTML(this.button_, html);
  }
  /**
   * Get the button element
   * @returns {Element}
   */
  getButtonElement() {
    return this.button_;
  }
};
var Button_default = ol_control_Button;

export {
  Button_default
};
//# sourceMappingURL=chunk-DUXDYBNZ.js.map
