import {
  Map_default
} from "./chunk-OKY35EEM.js";
import {
  Object_default
} from "./chunk-HTEWXYQ3.js";

// node_modules/ol-ext/util/input/Base.js
var ol_ext_input_Base = class olextinputBase extends Object_default {
  constructor(options) {
    options = options || {};
    super();
    var input = this.input = options.input;
    if (!input) {
      input = this.input = document.createElement("input");
      if (options.type) {
        input.setAttribute("type", options.type);
      }
      if (options.min !== void 0) {
        input.setAttribute("min", options.min);
      }
      if (options.max !== void 0) {
        input.setAttribute("max", options.max);
      }
      if (options.step !== void 0) {
        input.setAttribute("step", options.step);
      }
      if (options.parent) {
        options.parent.appendChild(input);
      }
    }
    if (options.disabled) {
      input.disabled = true;
    }
    if (options.checked !== void 0) {
      input.checked = !!options.checked;
    }
    if (options.val !== void 0) {
      input.value = options.val;
    }
    if (options.hidden) {
      input.classList.add("ol-input-hidden");
    }
    input.addEventListener("focus", (function() {
      if (this.element)
        this.element.classList.add("ol-focus");
    }).bind(this));
    var tout;
    input.addEventListener("focusout", (function() {
      if (this.element) {
        if (tout)
          clearTimeout(tout);
        tout = setTimeout((function() {
          this.element.classList.remove("ol-focus");
        }).bind(this), 0);
      }
    }).bind(this));
  }
  /** Listen to drag event
   * @param {Element} elt
   * @param {function} cback when draggin on the element
   * @private
   */
  _listenDrag(elt, cback) {
    var handle = (function(e) {
      this.moving = true;
      this.element.classList.add("ol-moving");
      var listen = (function(e2) {
        if (e2.type === "pointerup") {
          document.removeEventListener("pointermove", listen);
          document.removeEventListener("pointerup", listen);
          document.removeEventListener("pointercancel", listen);
          setTimeout((function() {
            this.moving = false;
            this.element.classList.remove("ol-moving");
          }).bind(this));
        }
        if (e2.target === elt)
          cback(e2);
        e2.stopPropagation();
        e2.preventDefault();
      }).bind(this);
      document.addEventListener("pointermove", listen, false);
      document.addEventListener("pointerup", listen, false);
      document.addEventListener("pointercancel", listen, false);
      e.stopPropagation();
      e.preventDefault();
    }).bind(this);
    elt.addEventListener("mousedown", handle, false);
    elt.addEventListener("touchstart", handle, false);
  }
  /** Set the current value
   */
  setValue(v) {
    if (v !== void 0)
      this.input.value = v;
    this.input.dispatchEvent(new Event("change"));
  }
  /** Get the current getValue
   * @returns {string}
   */
  getValue() {
    return this.input.value;
  }
  /** Get the input element
   * @returns {Element}
   */
  getInputElement() {
    return this.input;
  }
};
var Base_default = ol_ext_input_Base;

// node_modules/ol-ext/util/input/Checkbox.js
var ol_ext_input_Checkbox = class olextinputCheckbox extends Base_default {
  constructor(options) {
    options = options || {};
    super(options);
    var label = this.element = document.createElement("label");
    if (options.html instanceof Element)
      label.appendChild(options.html);
    else if (options.html !== void 0)
      label.innerHTML = options.html;
    label.className = ("ol-ext-check ol-ext-checkbox " + (options.className || "")).trim();
    if (this.input.parentNode)
      this.input.parentNode.insertBefore(label, this.input);
    label.appendChild(this.input);
    label.appendChild(document.createElement("span"));
    if (options.after) {
      label.appendChild(document.createTextNode(options.after));
    }
    this.input.addEventListener("change", (function() {
      this.dispatchEvent({ type: "check", checked: this.input.checked, value: this.input.value });
    }).bind(this));
  }
  isChecked() {
    return this.input.checked;
  }
};
var Checkbox_default = ol_ext_input_Checkbox;

// node_modules/ol-ext/util/input/Switch.js
var ol_ext_input_Switch = class olextinputSwitch extends Checkbox_default {
  constructor(options) {
    options = options || {};
    super(options);
    this.element.className = ("ol-ext-toggle-switch " + (options.className || "")).trim();
  }
};
var Switch_default = ol_ext_input_Switch;

// node_modules/ol-ext/util/input/Radio.js
var ol_ext_input_Radio = class olextinputRadio extends Checkbox_default {
  constructor(options) {
    options = options || {};
    super(options);
    this.element.className = ("ol-ext-check ol-ext-radio " + (options.className || "")).trim();
  }
};
var Radio_default = ol_ext_input_Radio;

// node_modules/ol-ext/util/element.js
var ol_ext_element = {};
ol_ext_element.create = function(tagName, options) {
  options = options || {};
  var elt;
  if (tagName === "TEXT") {
    elt = document.createTextNode(options.html || "");
    if (options.parent) options.parent.appendChild(elt);
  } else {
    elt = document.createElement(tagName.toLowerCase());
    if (/button/i.test(tagName)) elt.setAttribute("type", "button");
    for (var attr in options) {
      switch (attr) {
        case "className": {
          if (options.className && options.className.trim) elt.setAttribute("class", options.className.trim());
          break;
        }
        case "text": {
          elt.innerText = options.text;
          break;
        }
        case "html": {
          if (options.html instanceof Element) elt.appendChild(options.html);
          else if (options.html !== void 0) elt.innerHTML = options.html;
          break;
        }
        case "parent": {
          if (options.parent) options.parent.appendChild(elt);
          break;
        }
        case "options": {
          if (/select/i.test(tagName)) {
            for (var i in options.options) {
              ol_ext_element.create("OPTION", {
                html: i,
                value: options.options[i],
                parent: elt
              });
            }
          }
          break;
        }
        case "style": {
          ol_ext_element.setStyle(elt, options.style);
          break;
        }
        case "change":
        case "click": {
          ol_ext_element.addListener(elt, attr, options[attr]);
          break;
        }
        case "on": {
          for (var e in options.on) {
            ol_ext_element.addListener(elt, e, options.on[e]);
          }
          break;
        }
        case "checked": {
          elt.checked = !!options.checked;
          break;
        }
        default: {
          elt.setAttribute(attr, options[attr]);
          break;
        }
      }
    }
  }
  return elt;
};
ol_ext_element.createSwitch = function(options) {
  var input = ol_ext_element.create("INPUT", {
    type: "checkbox",
    on: options.on,
    click: options.click,
    change: options.change,
    parent: options.parent
  });
  var opt = Object.assign({ input }, options || {});
  new Switch_default(opt);
  return input;
};
ol_ext_element.createCheck = function(options) {
  var input = ol_ext_element.create("INPUT", {
    name: options.name,
    type: options.type === "radio" ? "radio" : "checkbox",
    on: options.on,
    parent: options.parent
  });
  var opt = Object.assign({ input }, options || {});
  if (options.type === "radio") {
    new Radio_default(opt);
  } else {
    new Checkbox_default(opt);
  }
  return input;
};
ol_ext_element.setHTML = function(element, html) {
  if (html instanceof Element) element.appendChild(html);
  else if (html !== void 0) element.innerHTML = html;
};
ol_ext_element.appendText = function(element, text) {
  element.appendChild(document.createTextNode(text || ""));
};
ol_ext_element.addListener = function(element, eventType, fn, useCapture) {
  if (typeof eventType === "string") eventType = eventType.split(" ");
  eventType.forEach(function(e) {
    element.addEventListener(e, fn, useCapture);
  });
};
ol_ext_element.removeListener = function(element, eventType, fn) {
  if (typeof eventType === "string") eventType = eventType.split(" ");
  eventType.forEach(function(e) {
    element.removeEventListener(e, fn);
  });
};
ol_ext_element.show = function(element) {
  element.style.display = "";
};
ol_ext_element.hide = function(element) {
  element.style.display = "none";
};
ol_ext_element.hidden = function(element) {
  return ol_ext_element.getStyle(element, "display") === "none";
};
ol_ext_element.toggle = function(element) {
  element.style.display = element.style.display === "none" ? "" : "none";
};
ol_ext_element.setStyle = function(el, st) {
  for (var s in st) {
    switch (s) {
      case "top":
      case "left":
      case "bottom":
      case "right":
      case "minWidth":
      case "maxWidth":
      case "width":
      case "height": {
        if (typeof st[s] === "number") {
          el.style[s] = st[s] + "px";
        } else {
          el.style[s] = st[s];
        }
        break;
      }
      default: {
        el.style[s] = st[s];
      }
    }
  }
};
ol_ext_element.getStyle = function(el, styleProp) {
  var value, defaultView = (el.ownerDocument || document).defaultView;
  if (defaultView && defaultView.getComputedStyle) {
    styleProp = styleProp.replace(/([A-Z])/g, "-$1").toLowerCase();
    value = defaultView.getComputedStyle(el, null).getPropertyValue(styleProp);
  } else if (el.currentStyle) {
    styleProp = styleProp.replace(/-(\w)/g, function(str, letter) {
      return letter.toUpperCase();
    });
    value = el.currentStyle[styleProp];
    if (/^\d+(em|pt|%|ex)?$/i.test(value)) {
      return function(value2) {
        var oldLeft = el.style.left, oldRsLeft = el.runtimeStyle.left;
        el.runtimeStyle.left = el.currentStyle.left;
        el.style.left = value2 || 0;
        value2 = el.style.pixelLeft + "px";
        el.style.left = oldLeft;
        el.runtimeStyle.left = oldRsLeft;
        return value2;
      }(value);
    }
  }
  if (/px$/.test(value)) return parseInt(value);
  return value;
};
ol_ext_element.outerHeight = function(elt) {
  return elt.offsetHeight + ol_ext_element.getStyle(elt, "marginBottom");
};
ol_ext_element.outerWidth = function(elt) {
  return elt.offsetWidth + ol_ext_element.getStyle(elt, "marginLeft");
};
ol_ext_element.offsetRect = function(elt) {
  var rect = elt.getBoundingClientRect();
  return {
    top: rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0),
    left: rect.left + (window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0),
    height: rect.height || rect.bottom - rect.top,
    width: rect.width || rect.right - rect.left
  };
};
ol_ext_element.getFixedOffset = function(elt) {
  var offset = {
    left: 0,
    top: 0
  };
  var getOffset = function(parent) {
    if (!parent) return offset;
    if (ol_ext_element.getStyle(parent, "position") === "absolute" && ol_ext_element.getStyle(parent, "transform") !== "none") {
      var r = parent.getBoundingClientRect();
      offset.left += r.left;
      offset.top += r.top;
      return offset;
    }
    return getOffset(parent.offsetParent);
  };
  return getOffset(elt.offsetParent);
};
ol_ext_element.positionRect = function(elt, fixed) {
  var gleft = 0;
  var gtop = 0;
  var getRect = function(parent) {
    if (parent) {
      gleft += parent.offsetLeft;
      gtop += parent.offsetTop;
      return getRect(parent.offsetParent);
    } else {
      var r = {
        top: elt.offsetTop + gtop,
        left: elt.offsetLeft + gleft
      };
      if (fixed) {
        r.top -= window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
        r.left -= window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0;
      }
      r.bottom = r.top + elt.offsetHeight;
      r.right = r.top + elt.offsetWidth;
      return r;
    }
  };
  return getRect(elt.offsetParent);
};
ol_ext_element.scrollDiv = function(elt, options) {
  options = options || {};
  var pos = false;
  var speed = 0;
  var d, dt = 0;
  var onmove = typeof options.onmove === "function" ? options.onmove : function() {
  };
  var page = options.vertical ? "screenY" : "screenX";
  var scroll = options.vertical ? "scrollTop" : "scrollLeft";
  var moving = false;
  var scale, isbar;
  var updateCounter = 0;
  var updateMinibar = function() {
    if (scrollbar) {
      updateCounter++;
      setTimeout(updateMinibarDelay);
    }
  };
  var updateMinibarDelay = function() {
    if (scrollbar) {
      updateCounter--;
      if (updateCounter) return;
      var pheight = elt.clientHeight;
      var height = elt.scrollHeight;
      scale = pheight / height;
      scrollbar.style.height = scale * 100 + "%";
      scrollbar.style.top = elt.scrollTop / height * 100 + "%";
      scrollContainer.style.height = pheight + "px";
      if (pheight > height - 0.5) scrollContainer.classList.add("ol-100pc");
      else scrollContainer.classList.remove("ol-100pc");
    }
  };
  var onPointerDown = function(e) {
    if (e.target.classList.contains("ol-noscroll")) return;
    moving = false;
    pos = e[page];
    dt = /* @__PURE__ */ new Date();
    elt.classList.add("ol-move");
    e.preventDefault();
    window.addEventListener("pointermove", onPointerMove);
    ol_ext_element.addListener(window, ["pointerup", "pointercancel"], onPointerUp);
  };
  var onPointerMove = function(e) {
    if (pos !== false) {
      var delta = (isbar ? -1 / scale : 1) * (pos - e[page]);
      moving = moving || Math.round(delta);
      elt[scroll] += delta;
      d = /* @__PURE__ */ new Date();
      if (d - dt) {
        speed = (speed + delta / (d - dt)) / 2;
      }
      pos = e[page];
      dt = d;
      if (delta) onmove(true);
    } else {
      moving = true;
    }
  };
  var animate = function(to) {
    var step = to > 0 ? Math.min(100, to / 2) : Math.max(-100, to / 2);
    to -= step;
    elt[scroll] += step;
    if (-1 < to && to < 1) {
      if (moving) setTimeout(function() {
        elt.classList.remove("ol-move");
      });
      else elt.classList.remove("ol-move");
      moving = false;
      onmove(false);
    } else {
      setTimeout(function() {
        animate(to);
      }, 40);
    }
  };
  var scrollContainer, scrollbar;
  if (options.vertical && options.minibar) {
    var init = function(b) {
      elt.removeEventListener("pointermove", init);
      elt.parentNode.classList.add("ol-miniscroll");
      scrollbar = ol_ext_element.create("DIV");
      scrollContainer = ol_ext_element.create("DIV", {
        className: "ol-scroll",
        html: scrollbar
      });
      elt.parentNode.insertBefore(scrollContainer, elt);
      scrollbar.addEventListener("pointerdown", function(e) {
        isbar = true;
        onPointerDown(e);
      });
      if (options.mousewheel) {
        ol_ext_element.addListener(
          scrollContainer,
          ["mousewheel", "DOMMouseScroll", "onmousewheel"],
          function(e) {
            onMouseWheel(e);
          }
        );
        ol_ext_element.addListener(
          scrollbar,
          ["mousewheel", "DOMMouseScroll", "onmousewheel"],
          function(e) {
            onMouseWheel(e);
          }
        );
      }
      elt.parentNode.addEventListener("pointerenter", updateMinibar);
      window.addEventListener("resize", updateMinibar);
      if (b !== false) updateMinibar();
    };
    if (elt.parentNode) init(false);
    else elt.addEventListener("pointermove", init);
    elt.addEventListener("scroll", function() {
      updateMinibar();
    });
  }
  elt.style["touch-action"] = "none";
  elt.style["overflow"] = "hidden";
  elt.classList.add("ol-scrolldiv");
  ol_ext_element.addListener(elt, ["pointerdown"], function(e) {
    isbar = false;
    onPointerDown(e);
  });
  elt.addEventListener("click", function(e) {
    if (elt.classList.contains("ol-move")) {
      e.preventDefault();
      e.stopPropagation();
    }
  }, true);
  var onPointerUp = function(e) {
    dt = /* @__PURE__ */ new Date() - dt;
    if (dt > 100 || isbar) {
      speed = 0;
    } else if (dt > 0) {
      speed = ((speed || 0) + (pos - e[page]) / dt) / 2;
    }
    animate(options.animate === false ? 0 : speed * 200);
    pos = false;
    speed = 0;
    dt = 0;
    if (!elt.classList.contains("ol-move")) {
      elt.classList.add("ol-hasClick");
      setTimeout(function() {
        elt.classList.remove("ol-hasClick");
      }, 500);
    } else {
      elt.classList.remove("ol-hasClick");
    }
    isbar = false;
    window.removeEventListener("pointermove", onPointerMove);
    ol_ext_element.removeListener(window, ["pointerup", "pointercancel"], onPointerUp);
  };
  var onMouseWheel = function(e) {
    var delta = Math.max(-1, Math.min(1, e.wheelDelta || -e.detail));
    elt.classList.add("ol-move");
    elt[scroll] -= delta * 30;
    elt.classList.remove("ol-move");
    return false;
  };
  if (options.mousewheel) {
    ol_ext_element.addListener(
      elt,
      ["mousewheel", "DOMMouseScroll", "onmousewheel"],
      onMouseWheel
    );
  }
  return {
    refresh: updateMinibar
  };
};
ol_ext_element.dispatchEvent = function(eventName, element) {
  var event;
  try {
    event = new CustomEvent(eventName);
  } catch (e) {
    event = document.createEvent("CustomEvent");
    event.initCustomEvent(eventName, true, true, {});
  }
  element.dispatchEvent(event);
};
ol_ext_element.setCursor = function(elt, cursor) {
  if (elt instanceof Map_default) elt = elt.getTargetElement();
  if (!("ontouchstart" in window) && elt instanceof Element) {
    elt.style.cursor = cursor;
  }
};
var element_default = ol_ext_element;

export {
  element_default
};
//# sourceMappingURL=chunk-BL3RR72C.js.map
