/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import java.util.LinkedList;
import java.util.List;
import org.geolatte.geom.crs.trans.CoordinateOperation;

public class ConcatenatedOperation
implements CoordinateOperation {
    private final CoordinateOperation[] coordinateOperations;
    private double[][] buffers;

    private ConcatenatedOperation(List<CoordinateOperation> coordinateOperations) {
        this.coordinateOperations = coordinateOperations.toArray(new CoordinateOperation[coordinateOperations.size()]);
        this.setupIntermediateBuffers();
    }

    private void setupIntermediateBuffers() {
        this.buffers = new double[this.coordinateOperations.length + 1][];
        for (int idx = 0; idx < this.coordinateOperations.length - 1; ++idx) {
            if (this.coordinateOperations[idx].outCoordinateDimension() != this.coordinateOperations[idx + 1].inCoordinateDimension()) {
                throw new IllegalArgumentException("Coordinate dimensions don't match at step " + idx);
            }
            this.buffers[idx + 1] = new double[this.coordinateOperations[idx].outCoordinateDimension()];
        }
    }

    @Override
    public boolean isReversible() {
        for (CoordinateOperation s : this.coordinateOperations) {
            if (s.isReversible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int inCoordinateDimension() {
        return this.coordinateOperations[0].inCoordinateDimension();
    }

    @Override
    public int outCoordinateDimension() {
        return this.coordinateOperations[this.coordinateOperations.length - 1].outCoordinateDimension();
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        this.buffers[0] = inCoordinate;
        this.buffers[this.buffers.length - 1] = outCoordinate;
        for (int idx = 0; idx < this.coordinateOperations.length; ++idx) {
            CoordinateOperation t = this.coordinateOperations[idx];
            t.forward(this.buffers[idx], this.buffers[idx + 1]);
        }
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        this.buffers[0] = outCoordinate;
        this.buffers[this.buffers.length - 1] = inCoordinate;
        for (int idx = this.coordinateOperations.length - 1; idx >= 0; --idx) {
            CoordinateOperation t = this.coordinateOperations[idx];
            t.reverse(this.buffers[idx + 1], this.buffers[idx]);
        }
    }

    private static class Step
    implements CoordinateOperation {
        public static final int FORWARD = 1;
        public static final int REVERSE = 2;
        final CoordinateOperation coordinateOperation;
        final int direction;

        Step(CoordinateOperation t, int direction) {
            this.coordinateOperation = t;
            this.direction = direction;
        }

        @Override
        public boolean isReversible() {
            return this.coordinateOperation.isReversible();
        }

        @Override
        public int inCoordinateDimension() {
            if (this.direction == 1) {
                return this.coordinateOperation.inCoordinateDimension();
            }
            return this.coordinateOperation.outCoordinateDimension();
        }

        @Override
        public int outCoordinateDimension() {
            if (this.direction == 1) {
                return this.coordinateOperation.outCoordinateDimension();
            }
            return this.coordinateOperation.inCoordinateDimension();
        }

        @Override
        public void forward(double[] inCoordinate, double[] outCoordinate) {
            if (this.direction == 1) {
                this.coordinateOperation.forward(inCoordinate, outCoordinate);
            } else {
                this.coordinateOperation.reverse(inCoordinate, outCoordinate);
            }
        }

        @Override
        public void reverse(double[] inCoordinate, double[] outCoordinate) {
            if (this.direction == 1) {
                this.coordinateOperation.reverse(inCoordinate, outCoordinate);
            } else {
                this.coordinateOperation.forward(inCoordinate, outCoordinate);
            }
        }
    }

    public static class Builder {
        private List<CoordinateOperation> coordinateOperations = new LinkedList<CoordinateOperation>();

        public Builder forward(CoordinateOperation t) {
            this.coordinateOperations.add(new Step(t, 1));
            return this;
        }

        public Builder reverse(CoordinateOperation t) {
            this.coordinateOperations.add(new Step(t, 2));
            return this;
        }

        public ConcatenatedOperation build() {
            return new ConcatenatedOperation(this.coordinateOperations);
        }
    }
}

