/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.CrsWktTokenizer;
import org.geolatte.geom.codec.CrsWktVariant;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktNumberToken;
import org.geolatte.geom.codec.WktTextToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CartesianCoordinateSystem2D;
import org.geolatte.geom.crs.CartesianCoordinateSystem3D;
import org.geolatte.geom.crs.CompoundCoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.Datum;
import org.geolatte.geom.crs.Ellipsoid;
import org.geolatte.geom.crs.EllipsoidalAxis;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem2D;
import org.geolatte.geom.crs.Extension;
import org.geolatte.geom.crs.GeocentricCartesianCoordinateReferenceSystem;
import org.geolatte.geom.crs.GeodeticLatitudeCSAxis;
import org.geolatte.geom.crs.GeodeticLongitudeCSAxis;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.PrimeMeridian;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.Unit;
import org.geolatte.geom.crs.VerticalCoordinateReferenceSystem;
import org.geolatte.geom.crs.VerticalDatum;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CrsWktDecoder {
    private static final CrsWktVariant CRS_TOKENS = new CrsWktVariant();
    private int srid = 0;
    private final WktVariant wktVariant = CRS_TOKENS;
    protected WktToken currentToken;
    private CrsWktTokenizer tokenizer;

    public CoordinateReferenceSystem<? extends Position> decode(String wkt, int srid) {
        this.srid = srid;
        this.setTokenizer(new CrsWktTokenizer(wkt, this.getWktVariant()));
        this.nextToken();
        return this.decode();
    }

    private CoordinateReferenceSystem<? extends Position> decode() {
        if (this.currentToken == CrsWktVariant.PROJCS) {
            return this.decodeProjectedCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOGCS) {
            return this.decodeGeographicCrs();
        }
        if (this.currentToken == CrsWktVariant.GEOCCS) {
            return this.decodeGeocentricCrs();
        }
        if (this.currentToken == CrsWktVariant.COMPD_CS) {
            return this.decodeCompoundCrs();
        }
        if (this.currentToken == CrsWktVariant.VERT_CS) {
            return this.decodeVertCS();
        }
        throw new WktDecodeException("Expected Wkt Token PROJCS, GEOGCS, GEOCCS or COMPD_CS. Received  " + this.currentToken);
    }

    private GeocentricCartesianCoordinateReferenceSystem decodeGeocentricCrs() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Datum datum = this.decodeDatum();
        this.matchesElementSeparator();
        PrimeMeridian primem = this.decodePrimem();
        this.matchesElementSeparator();
        Unit unit = this.decodeUnit(true);
        CoordinateSystemAxis[] axes = this.decodeOptionalAxes(3, unit, GeocentricCartesianCoordinateReferenceSystem.class);
        CrsId cr = this.decodeOptionalAuthority(this.srid);
        this.matchesCloseList();
        GeocentricCartesianCoordinateReferenceSystem system = new GeocentricCartesianCoordinateReferenceSystem(cr, crsName, datum, primem, new CartesianCoordinateSystem3D((StraightLineAxis)axes[0], (StraightLineAxis)axes[1], (VerticalStraightLineAxis)axes[2]));
        return system;
    }

    private Geographic2DCoordinateReferenceSystem decodeGeographicCrs() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Datum datum = this.decodeDatum();
        this.matchesElementSeparator();
        PrimeMeridian primem = this.decodePrimem();
        this.matchesElementSeparator();
        Unit unit = this.decodeUnit(false);
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalAxes(2, unit, Geographic2DCoordinateReferenceSystem.class);
        CrsId cr = this.decodeOptionalAuthority(this.srid);
        this.matchesCloseList();
        Geographic2DCoordinateReferenceSystem system = new Geographic2DCoordinateReferenceSystem(cr, crsName, new EllipsoidalCoordinateSystem2D((EllipsoidalAxis)twinAxes[0], (EllipsoidalAxis)twinAxes[1]));
        system.setDatum(datum);
        system.setPrimeMeridian(primem);
        return system;
    }

    private ProjectedCoordinateReferenceSystem decodeProjectedCrs() {
        List<CrsParameter> parameters;
        Projection projection;
        Unit unit;
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        Geographic2DCoordinateReferenceSystem geogcs = this.decodeGeographicCrs();
        this.matchesElementSeparator();
        if (this.currentToken == CrsWktVariant.UNIT) {
            unit = this.decodeUnit(true);
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
        } else {
            projection = this.decodeProjection();
            parameters = this.decodeOptionalParameters();
            unit = this.decodeUnit(true);
        }
        CoordinateSystemAxis[] twinAxes = this.decodeOptionalAxes(2, unit, ProjectedCoordinateReferenceSystem.class);
        Extension extension = this.decodeOptionalExtension();
        CrsId crsId = this.decodeOptionalAuthority(this.srid);
        this.matchesCloseList();
        return new ProjectedCoordinateReferenceSystem(crsId, crsName, geogcs, projection, parameters, new CartesianCoordinateSystem2D((StraightLineAxis)twinAxes[0], (StraightLineAxis)twinAxes[1]), extension);
    }

    private <P extends Position> CompoundCoordinateReferenceSystem<P> decodeCompoundCrs() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        SingleCoordinateReferenceSystem head = (SingleCoordinateReferenceSystem)this.decode();
        this.matchesElementSeparator();
        SingleCoordinateReferenceSystem tail = (SingleCoordinateReferenceSystem)this.decode();
        CrsId cr = this.decodeOptionalAuthority(this.srid);
        return new CompoundCoordinateReferenceSystem(cr, crsName, head, tail);
    }

    private VerticalCoordinateReferenceSystem decodeVertCS() {
        String crsName = this.decodeName();
        this.matchesElementSeparator();
        VerticalDatum vdatum = this.decodeVertDatum();
        this.matchesElementSeparator();
        LinearUnit unit = (LinearUnit)this.decodeUnit(true);
        this.matchesElementSeparator();
        VerticalStraightLineAxis axis = (VerticalStraightLineAxis)this.decodeAxis(unit, VerticalCoordinateReferenceSystem.class);
        CrsId id = this.decodeOptionalAuthority();
        return new VerticalCoordinateReferenceSystem(id, crsName, vdatum, axis);
    }

    private VerticalDatum decodeVertDatum() {
        if (this.currentToken != CrsWktVariant.VERT_DATUM) {
            throw new WktDecodeException("Expected VERT_DATUM keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        int type = this.decodeInt();
        Extension extension = this.decodeOptionalExtension();
        CrsId authority = this.decodeOptionalAuthority(this.srid);
        this.matchesCloseList();
        return new VerticalDatum(authority, name, type, extension);
    }

    private List<CrsParameter> decodeOptionalParameters() {
        ArrayList<CrsParameter> parameters = new ArrayList<CrsParameter>();
        CrsParameter parameter = this.decodeOptionalParameter();
        while (parameter != null) {
            parameters.add(parameter);
            parameter = this.decodeOptionalParameter();
        }
        return parameters;
    }

    private CrsParameter decodeOptionalParameter() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PARAMETER) {
            return null;
        }
        this.nextToken();
        String name = this.decodeName();
        this.matchesElementSeparator();
        double value = this.decodeNumber();
        this.matchesCloseList();
        return new CrsParameter(name, value);
    }

    private Projection decodeProjection() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.PROJECTION) {
            throw new WktDecodeException("Expected PROJECTION keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Projection(crsId, name);
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] decodeOptionalAxes(int num, Unit unit, Class<T> crsClass) {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AXIS) {
            return this.defaultCRS(unit, crsClass);
        }
        CoordinateSystemAxis[] axes = new CoordinateSystemAxis[num];
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                this.matchesElementSeparator();
            }
            axes[i] = this.decodeAxis(unit, crsClass);
        }
        return axes;
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis[] defaultCRS(Unit unit, Class<T> crsClass) {
        if (Geographic2DCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new GeodeticLongitudeCSAxis("Lon", (AngularUnit)unit), new GeodeticLatitudeCSAxis("Lat", (AngularUnit)unit)};
        }
        if (ProjectedCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, (LinearUnit)unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, (LinearUnit)unit)};
        }
        if (GeocentricCartesianCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new CoordinateSystemAxis[]{new StraightLineAxis("X", CoordinateSystemAxisDirection.GeocentricX, (LinearUnit)unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.GeocentricY, (LinearUnit)unit), new StraightLineAxis("Z", CoordinateSystemAxisDirection.GeocentricZ, (LinearUnit)unit)};
        }
        throw new IllegalStateException("Can't create default for CrsRegistry of type " + crsClass.getCanonicalName());
    }

    private <T extends CoordinateReferenceSystem> CoordinateSystemAxis decodeAxis(Unit unit, Class<T> crsClass) {
        if (this.currentToken != CrsWktVariant.AXIS) {
            throw new WktDecodeException("Expected AXIS keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        CoordinateSystemAxisDirection direction = CoordinateSystemAxisDirection.valueOf(this.currentToken.toString());
        this.nextToken();
        this.matchesCloseList();
        if (Geographic2DCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            if (direction.equals((Object)CoordinateSystemAxisDirection.NORTH)) {
                return new GeodeticLatitudeCSAxis(name, (AngularUnit)unit);
            }
            if (direction.equals((Object)CoordinateSystemAxisDirection.EAST)) {
                return new GeodeticLongitudeCSAxis(name, (AngularUnit)unit);
            }
            throw new IllegalStateException("Axis in horizontal Geographic coordinate system is neither latitude, nor longitude");
        }
        if (ProjectedCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            if (direction == CoordinateSystemAxisDirection.UNKNOWN) {
                if (name.equalsIgnoreCase("X") || name.equalsIgnoreCase("Easting")) {
                    return new StraightLineAxis(name, direction, 0, unit);
                }
                return new StraightLineAxis(name, direction, 1, unit);
            }
            return new StraightLineAxis(name, direction, (LinearUnit)unit);
        }
        if (GeocentricCartesianCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            String normalizedName = name.toUpperCase();
            if (normalizedName.equalsIgnoreCase("GEOCENTRIC X")) {
                return new StraightLineAxis(name, CoordinateSystemAxisDirection.GeocentricX, (LinearUnit)unit);
            }
            if (normalizedName.equalsIgnoreCase("GEOCENTRIC Y")) {
                return new StraightLineAxis(name, CoordinateSystemAxisDirection.GeocentricY, (LinearUnit)unit);
            }
            return new VerticalStraightLineAxis(name, CoordinateSystemAxisDirection.GeocentricZ, (LinearUnit)unit);
        }
        if (VerticalCoordinateReferenceSystem.class.isAssignableFrom(crsClass)) {
            return new VerticalStraightLineAxis(name, direction, (LinearUnit)unit);
        }
        throw new IllegalStateException("Can't create default for CrsRegistry of type " + crsClass.getCanonicalName());
    }

    private Unit decodeUnit(boolean isLinear) {
        if (this.currentToken != CrsWktVariant.UNIT) {
            throw new WktDecodeException("Expected UNIT keyword, found " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double cf = this.decodeNumber();
        this.matchesElementSeparator();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return isLinear ? new LinearUnit(crsId, name, cf) : new AngularUnit(crsId, name, cf);
    }

    private PrimeMeridian decodePrimem() {
        if (this.currentToken != CrsWktVariant.PRIMEM) {
            throw new WktDecodeException("Expected PRIMEM keyword, received " + this.currentToken.toString());
        }
        String name = this.decodeName();
        this.matchesElementSeparator();
        double longitude = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new PrimeMeridian(crsId, name, longitude);
    }

    private Datum decodeDatum() {
        if (this.currentToken != CrsWktVariant.DATUM) {
            throw new WktDecodeException("Expected DATUM token.");
        }
        String datumName = this.decodeName();
        this.matchesElementSeparator();
        Ellipsoid ellipsoid = this.decodeSpheroid();
        double[] toWGS84 = this.decodeOptionalToWGS84();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Datum(crsId, ellipsoid, datumName, toWGS84);
    }

    private double[] decodeOptionalToWGS84() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.TOWGS84) {
            return new double[0];
        }
        this.nextToken();
        double[] toWGS = new double[7];
        this.matchesOpenList();
        for (int i = 0; i < 7; ++i) {
            toWGS[i] = this.decodeNumber();
            this.matchesElementSeparator();
        }
        this.matchesCloseList();
        return toWGS;
    }

    private Ellipsoid decodeSpheroid() {
        if (this.currentToken != CrsWktVariant.SPHEROID) {
            throw new WktDecodeException("Expected SPHEROID keyword, but received " + this.currentToken.toString());
        }
        String ellipsoidName = this.decodeName();
        this.matchesElementSeparator();
        double semiMajorAxis = this.decodeNumber();
        this.matchesElementSeparator();
        double inverseFlattening = this.decodeNumber();
        CrsId crsId = this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
        this.matchesCloseList();
        return new Ellipsoid(crsId, ellipsoidName, semiMajorAxis, inverseFlattening);
    }

    private CrsId decodeOptionalAuthority() {
        return this.decodeOptionalAuthority(CrsId.UNDEFINED.getCode());
    }

    private Extension decodeOptionalExtension() {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.EXTENSION) {
            return null;
        }
        this.nextToken();
        this.matchesOpenList();
        String prop = this.decodeText();
        this.matchesElementSeparator();
        String val = this.decodeText();
        this.matchesCloseList();
        return new Extension(prop, val);
    }

    private CrsId decodeOptionalAuthority(int srid) {
        this.matchesElementSeparator();
        if (this.currentToken != CrsWktVariant.AUTHORITY) {
            return new CrsId("EPSG", srid);
        }
        this.nextToken();
        this.matchesOpenList();
        String authority = this.decodeText();
        this.matchesElementSeparator();
        int value = this.decodeInt();
        this.matchesCloseList();
        return new CrsId(authority, value);
    }

    private String decodeName() {
        this.nextToken();
        this.matchesOpenList();
        return this.decodeText();
    }

    protected void setTokenizer(CrsWktTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.currentToken = null;
    }

    protected String decodeText() {
        if (this.currentToken instanceof WktTextToken) {
            String text = ((WktTextToken)this.currentToken).getText();
            this.nextToken();
            return text;
        }
        throw new WktDecodeException("Expected text token, received " + this.currentToken.toString());
    }

    protected int decodeInt() {
        if (this.currentToken instanceof WktNumberToken) {
            double num = ((WktNumberToken)this.currentToken).getNumber();
            this.nextToken();
            try {
                return (int)num;
            }
            catch (Exception e) {
                throw new WktDecodeException("Expected Integer, received " + this.currentToken.toString());
            }
        }
        if (this.currentToken instanceof WktTextToken) {
            String text = ((WktTextToken)this.currentToken).getText();
            this.nextToken();
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                throw new WktDecodeException("Expected Integer, received " + this.currentToken.toString());
            }
        }
        throw new WktDecodeException("Expected text token, received " + this.currentToken.toString());
    }

    protected void nextToken() {
        this.currentToken = this.tokenizer.nextToken();
    }

    protected boolean matchesOpenList() {
        if (this.currentToken == this.getWktVariant().getOpenList()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean matchesCloseList() {
        if (this.currentToken == this.getWktVariant().getCloseList()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean matchesElementSeparator() {
        if (this.currentToken == this.getWktVariant().getElementSeparator()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected double decodeNumber() {
        if (this.currentToken instanceof WktNumberToken) {
            double value = ((WktNumberToken)this.currentToken).getNumber();
            this.nextToken();
            return value;
        }
        throw new WktDecodeException("Expected a number ; received " + this.currentToken.toString());
    }

    protected WktVariant getWktVariant() {
        return this.wktVariant;
    }

    protected int getTokenizerPosition() {
        return this.tokenizer.position();
    }
}

