/*
 * Decompiled with CFR 0.152.
 */
package org.n52.jackson.datatype.jts;

import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import org.n52.jackson.datatype.jts.GeometryType;

public final class IncludeBoundingBox
implements Serializable {
    private static final long serialVersionUID = 204690259235746434L;
    private final int mask;

    private IncludeBoundingBox(int mask) {
        this.mask = mask;
    }

    private IncludeBoundingBox include(GeometryType type) {
        return new IncludeBoundingBox(this.mask | type.mask());
    }

    public IncludeBoundingBox forPoint() {
        return this.include(GeometryType.POINT);
    }

    public IncludeBoundingBox forLineString() {
        return this.include(GeometryType.LINE_STRING);
    }

    public IncludeBoundingBox forPolygon() {
        return this.include(GeometryType.POLYGON);
    }

    public IncludeBoundingBox forMultiPoint() {
        return this.include(GeometryType.MULTI_POINT);
    }

    public IncludeBoundingBox forMultiLineString() {
        return this.include(GeometryType.MULTI_LINE_STRING);
    }

    public IncludeBoundingBox forMultiPolygon() {
        return this.include(GeometryType.MULTI_POLYGON);
    }

    public IncludeBoundingBox forGeometryCollection() {
        return this.include(GeometryType.GEOMETRY_COLLECTION);
    }

    public IncludeBoundingBox forMultiGeometry() {
        return this.include(GeometryType.MULTI_POINT).include(GeometryType.MULTI_LINE_STRING).include(GeometryType.MULTI_POLYGON).include(GeometryType.GEOMETRY_COLLECTION);
    }

    public boolean shouldIncludeBoundingBoxFor(Geometry geometry) {
        return GeometryType.forGeometry(geometry).map(this::shouldIncludeBoundingBoxFor).orElse(false);
    }

    public boolean shouldIncludeBoundingBoxFor(GeometryType type) {
        return (this.mask & type.mask()) != 0;
    }

    public static IncludeBoundingBox never() {
        return new IncludeBoundingBox(0);
    }

    public static IncludeBoundingBox always() {
        return IncludeBoundingBox.never().forGeometryCollection().forMultiPolygon().forMultiLineString().forMultiPoint().forPolygon().forLineString().forPoint();
    }

    public static IncludeBoundingBox exceptPoints() {
        return IncludeBoundingBox.never().forGeometryCollection().forMultiPolygon().forMultiLineString().forMultiPoint().forPolygon().forLineString();
    }
}

