/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.gem.EnumMappingGem;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.spi.EnumTransformationStrategy;

public class EnumMappingOptions
extends DelegatingOptions {
    private final EnumMappingGem enumMapping;
    private final boolean inverse;
    private final boolean valid;

    private EnumMappingOptions(EnumMappingGem enumMapping, boolean inverse, boolean valid, DelegatingOptions next) {
        super(next);
        this.enumMapping = enumMapping;
        this.inverse = inverse;
        this.valid = valid;
    }

    @Override
    public boolean hasAnnotation() {
        return this.enumMapping != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasNameTransformationStrategy() {
        return this.hasAnnotation() && Strings.isNotEmpty(this.getNameTransformationStrategy());
    }

    public String getNameTransformationStrategy() {
        return this.enumMapping.nameTransformationStrategy().getValue();
    }

    public String getNameTransformationConfiguration() {
        return this.enumMapping.configuration().getValue();
    }

    @Override
    public TypeMirror getUnexpectedValueMappingException() {
        if (this.enumMapping != null && this.enumMapping.unexpectedValueMappingException().hasValue()) {
            return this.enumMapping.unexpectedValueMappingException().getValue();
        }
        return this.next().getUnexpectedValueMappingException();
    }

    public AnnotationMirror getMirror() {
        return Optional.ofNullable(this.enumMapping).map(EnumMappingGem::mirror).orElse(null);
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public EnumMappingOptions inverse() {
        return new EnumMappingOptions(this.enumMapping, true, this.valid, this.next());
    }

    public static EnumMappingOptions getInstanceOn(ExecutableElement method, MapperOptions mapperOptions, Map<String, EnumTransformationStrategy> enumTransformationStrategies, FormattingMessager messager) {
        EnumMappingGem enumMapping = EnumMappingGem.instanceOn(method);
        if (enumMapping == null) {
            return new EnumMappingOptions(null, false, true, mapperOptions);
        }
        if (!EnumMappingOptions.isConsistent(enumMapping, method, enumTransformationStrategies, messager)) {
            return new EnumMappingOptions(null, false, false, mapperOptions);
        }
        return new EnumMappingOptions(enumMapping, false, true, mapperOptions);
    }

    private static boolean isConsistent(EnumMappingGem gem, ExecutableElement method, Map<String, EnumTransformationStrategy> enumTransformationStrategies, FormattingMessager messager) {
        String strategy = gem.nameTransformationStrategy().getValue();
        String configuration = gem.configuration().getValue();
        boolean isConsistent = false;
        if (Strings.isNotEmpty(strategy) || Strings.isNotEmpty(configuration)) {
            if (!enumTransformationStrategies.containsKey(strategy)) {
                String registeredStrategies = Strings.join(enumTransformationStrategies.keySet(), ", ");
                messager.printMessage((Element)method, gem.mirror(), gem.nameTransformationStrategy().getAnnotationValue(), Message.ENUMMAPPING_INCORRECT_TRANSFORMATION_STRATEGY, strategy, registeredStrategies);
                return false;
            }
            if (Strings.isEmpty(configuration)) {
                messager.printMessage((Element)method, gem.mirror(), gem.configuration().getAnnotationValue(), Message.ENUMMAPPING_MISSING_CONFIGURATION, new Object[0]);
                return false;
            }
            isConsistent = true;
        }
        boolean bl = isConsistent = isConsistent || gem.unexpectedValueMappingException().hasValue();
        if (!isConsistent) {
            messager.printMessage((Element)method, gem.mirror(), Message.ENUMMAPPING_NO_ELEMENTS, new Object[0]);
        }
        return isConsistent;
    }
}

