/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WkbDecodeException;

class WkbDialect {
    private final Map<Long, GeometryType> typemap = new HashMap<Long, GeometryType>();
    public static final Long WKB_POINT = 1L;
    public static final Long WKB_LINESTRING = 2L;
    public static final Long WKB_POLYGON = 3L;
    public static final Long WKB_MULTIPOINT = 4L;
    public static final Long WKB_MULTILINESTRING = 5L;
    public static final Long WKB_MULTIPOLYGON = 6L;
    public static final Long WKB_GEOMETRYCOLLECTION = 7L;

    protected WkbDialect() {
        this.typemap.put(WKB_POINT, GeometryType.POINT);
        this.typemap.put(WKB_LINESTRING, GeometryType.LINESTRING);
        this.typemap.put(WKB_POLYGON, GeometryType.POLYGON);
        this.typemap.put(WKB_MULTIPOINT, GeometryType.MULTIPOINT);
        this.typemap.put(WKB_MULTILINESTRING, GeometryType.MULTILINESTRING);
        this.typemap.put(WKB_MULTIPOLYGON, GeometryType.MULTIPOLYGON);
        this.typemap.put(WKB_GEOMETRYCOLLECTION, GeometryType.GEOMETRYCOLLECTION);
    }

    GeometryType parseType(long tpe) {
        GeometryType gt = this.typemap.get(tpe);
        if (gt == null) {
            throw new WkbDecodeException("Unsupported WKB type code: " + tpe);
        }
        return gt;
    }

    boolean hasZ(long tpe) {
        return false;
    }

    boolean hasM(long tpe) {
        return false;
    }

    <P extends Position> BaseWkbVisitor<P> mkVisitor(Geometry<P> geom, ByteOrder bo) {
        ByteBuffer buffer = this.mkByteBuffer(geom, bo);
        return new BaseWkbVisitor(buffer, this);
    }

    protected <P extends Position> ByteBuffer mkByteBuffer(Geometry<P> geom, ByteOrder bo) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateSize(geom, true));
        if (bo != null) {
            buffer.setByteOrder(bo);
        }
        return buffer;
    }

    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean topLevel) {
        int size = 5;
        if (topLevel) {
            size += this.extraHeaderSize(geom);
        }
        if (geom.isEmpty()) {
            return size + this.sizeEmptyGeometry(geom);
        }
        if (geom instanceof AbstractGeometryCollection) {
            size += this.sizeOfGeometryCollection((AbstractGeometryCollection)geom);
        } else if (geom instanceof Polygon) {
            size += this.getPolygonSize((Polygon)geom);
        } else if (geom instanceof Point) {
            size += this.getPositionSize(geom);
        } else {
            size += 4;
            size += this.getPositionSize(geom) * geom.getNumPositions();
        }
        return size;
    }

    protected <P extends Position> int extraHeaderSize(Geometry<P> geom) {
        return 0;
    }

    protected <P extends Position> int sizeEmptyGeometry(Geometry<P> geometry) {
        if (geometry.getGeometryType() == GeometryType.POINT) {
            return this.emptyPointAsNaN() ? this.getPositionSize(geometry) : 4;
        }
        return 4;
    }

    protected <P extends Position> int getPositionSize(Geometry<P> geom) {
        return geom.getCoordinateDimension() * 8;
    }

    protected <P extends Position> int getPolygonSize(Polygon<P> geom) {
        int size = 4;
        size += geom.isEmpty() ? 0 : 4 * (geom.getNumInteriorRing() + 1);
        return size += this.getPositionSize(geom) * geom.getNumPositions();
    }

    protected <P extends Position, G extends Geometry<P>> int sizeOfGeometryCollection(AbstractGeometryCollection<P, G> collection) {
        int size = 4;
        for (Geometry g : collection) {
            size += this.calculateSize(g, false);
        }
        return size;
    }

    boolean emptyPointAsNaN() {
        return true;
    }

    protected <P extends Position> Long geometryTypeCode(Geometry<P> geometry) {
        for (Map.Entry<Long, GeometryType> tpe : this.typemap.entrySet()) {
            if (tpe.getValue() != geometry.getGeometryType()) continue;
            return tpe.getKey();
        }
        throw new UnsupportedConversionException(String.format("Can't convert geometries of type %s", geometry.getClass().getCanonicalName()));
    }
}

